/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.grpc;

import io.grpc.BinaryLog;
import io.grpc.ClientInterceptor;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.NameResolver;
import io.grpc.ProxyDetector;
import io.grpc.internal.GrpcUtil;
import io.grpc.netty.NettyChannelBuilder;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLEngine;
import org.apache.kyuubi.shade.io.netty.handler.ssl.DelegatingSslContext;
import org.apache.kyuubi.shade.io.netty.handler.ssl.SslContext;
import org.apache.kyuubi.shade.io.vertx.core.Context;
import org.apache.kyuubi.shade.io.vertx.core.Handler;
import org.apache.kyuubi.shade.io.vertx.core.Vertx;
import org.apache.kyuubi.shade.io.vertx.core.http.HttpClientOptions;
import org.apache.kyuubi.shade.io.vertx.core.http.HttpVersion;
import org.apache.kyuubi.shade.io.vertx.core.impl.ContextInternal;
import org.apache.kyuubi.shade.io.vertx.core.impl.VertxInternal;
import org.apache.kyuubi.shade.io.vertx.core.net.ClientOptionsBase;
import org.apache.kyuubi.shade.io.vertx.core.net.impl.SSLHelper;
import org.apache.kyuubi.shade.io.vertx.core.net.impl.transport.Transport;

public class VertxChannelBuilder
extends ManagedChannelBuilder<VertxChannelBuilder> {
    private final Vertx vertx;
    private final NettyChannelBuilder builder;
    private final ContextInternal context;
    private final HttpClientOptions options = new HttpClientOptions();

    public static VertxChannelBuilder forTarget(Vertx vertx, String target) {
        return new VertxChannelBuilder(vertx, target);
    }

    public static VertxChannelBuilder forAddress(Vertx vertx, String host, int port) {
        return new VertxChannelBuilder(vertx, host, port);
    }

    public static VertxChannelBuilder forAddress(Vertx vertx, SocketAddress address) {
        return new VertxChannelBuilder(vertx, address);
    }

    private VertxChannelBuilder(Vertx vertx, String host, int port) {
        this(vertx, GrpcUtil.authorityFromHostAndPort(host, port));
    }

    private VertxChannelBuilder(Vertx vertx, String target) {
        this.vertx = vertx;
        this.builder = NettyChannelBuilder.forTarget(target);
        this.context = (ContextInternal)vertx.getOrCreateContext();
    }

    private VertxChannelBuilder(Vertx vertx, SocketAddress address) {
        this.vertx = vertx;
        this.builder = NettyChannelBuilder.forAddress(address);
        this.context = (ContextInternal)vertx.getOrCreateContext();
    }

    public NettyChannelBuilder nettyBuilder() {
        return this.builder;
    }

    @Override
    public VertxChannelBuilder directExecutor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public VertxChannelBuilder executor(Executor executor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VertxChannelBuilder intercept(List<ClientInterceptor> interceptors) {
        this.builder.intercept((List)interceptors);
        return this;
    }

    @Override
    public VertxChannelBuilder intercept(ClientInterceptor ... interceptors) {
        this.builder.intercept(interceptors);
        return this;
    }

    @Override
    public VertxChannelBuilder userAgent(String userAgent) {
        this.builder.userAgent(userAgent);
        return this;
    }

    @Override
    public VertxChannelBuilder overrideAuthority(String authority) {
        this.builder.overrideAuthority(authority);
        return this;
    }

    @Override
    @Deprecated
    public VertxChannelBuilder nameResolverFactory(NameResolver.Factory resolverFactory) {
        this.builder.nameResolverFactory(resolverFactory);
        return this;
    }

    @Override
    public VertxChannelBuilder offloadExecutor(Executor executor) {
        this.builder.offloadExecutor(executor);
        return this;
    }

    @Override
    public VertxChannelBuilder defaultLoadBalancingPolicy(String policy) {
        this.builder.defaultLoadBalancingPolicy(policy);
        return this;
    }

    @Override
    public VertxChannelBuilder maxInboundMetadataSize(int bytes) {
        this.builder.maxInboundMetadataSize(bytes);
        return this;
    }

    @Override
    public VertxChannelBuilder proxyDetector(ProxyDetector proxyDetector) {
        this.builder.proxyDetector(proxyDetector);
        return this;
    }

    @Override
    public VertxChannelBuilder defaultServiceConfig(@Nullable Map<String, ?> serviceConfig) {
        this.builder.defaultServiceConfig((Map)serviceConfig);
        return this;
    }

    @Override
    public VertxChannelBuilder disableServiceConfigLookUp() {
        this.builder.disableServiceConfigLookUp();
        return this;
    }

    @Override
    public VertxChannelBuilder decompressorRegistry(DecompressorRegistry registry) {
        this.builder.decompressorRegistry(registry);
        return this;
    }

    @Override
    public VertxChannelBuilder compressorRegistry(CompressorRegistry registry) {
        this.builder.compressorRegistry(registry);
        return this;
    }

    @Override
    public VertxChannelBuilder idleTimeout(long value, TimeUnit unit) {
        this.builder.idleTimeout(value, unit);
        return this;
    }

    @Override
    public VertxChannelBuilder maxInboundMessageSize(int max) {
        this.builder.maxInboundMessageSize(max);
        return this;
    }

    @Override
    public VertxChannelBuilder usePlaintext() {
        this.builder.usePlaintext();
        return this;
    }

    @Override
    public VertxChannelBuilder useTransportSecurity() {
        this.builder.useTransportSecurity();
        return this;
    }

    @Override
    public VertxChannelBuilder enableFullStreamDecompression() {
        this.builder.enableFullStreamDecompression();
        return this;
    }

    @Override
    public VertxChannelBuilder keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        this.builder.keepAliveTime(keepAliveTime, timeUnit);
        return this;
    }

    @Override
    public VertxChannelBuilder keepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        this.builder.keepAliveTimeout(keepAliveTimeout, timeUnit);
        return this;
    }

    @Override
    public VertxChannelBuilder keepAliveWithoutCalls(boolean enable) {
        this.builder.keepAliveWithoutCalls(enable);
        return this;
    }

    @Override
    public VertxChannelBuilder maxRetryAttempts(int maxRetryAttempts) {
        this.builder.maxRetryAttempts(maxRetryAttempts);
        return this;
    }

    @Override
    public VertxChannelBuilder maxHedgedAttempts(int maxHedgedAttempts) {
        this.builder.maxHedgedAttempts(maxHedgedAttempts);
        return this;
    }

    @Override
    public VertxChannelBuilder retryBufferSize(long bytes) {
        this.builder.retryBufferSize(bytes);
        return this;
    }

    @Override
    public VertxChannelBuilder perRpcBufferLimit(long bytes) {
        this.builder.perRpcBufferLimit(bytes);
        return this;
    }

    @Override
    public VertxChannelBuilder disableRetry() {
        this.builder.disableRetry();
        return this;
    }

    @Override
    public VertxChannelBuilder enableRetry() {
        this.builder.enableRetry();
        return this;
    }

    @Override
    public VertxChannelBuilder setBinaryLog(BinaryLog binaryLog) {
        this.builder.setBinaryLog(binaryLog);
        return this;
    }

    @Override
    public VertxChannelBuilder maxTraceEvents(int maxTraceEvents) {
        this.builder.maxTraceEvents(maxTraceEvents);
        return this;
    }

    public VertxChannelBuilder useSsl(Handler<ClientOptionsBase> handler) {
        handler.handle(this.options);
        return this;
    }

    @Override
    public ManagedChannel build() {
        if (this.options.isSsl()) {
            final SSLHelper helper = new SSLHelper(this.options, this.options.getKeyCertOptions(), this.options.getTrustOptions());
            helper.setApplicationProtocols(Collections.singletonList(HttpVersion.HTTP_2.alpnName()));
            SslContext ctx = helper.getContext((VertxInternal)this.vertx);
            this.builder.sslContext(new DelegatingSslContext(ctx){

                @Override
                protected void initEngine(SSLEngine engine) {
                    helper.configureEngine(engine, null);
                }
            });
        }
        Transport transport = ((VertxInternal)this.vertx).transport();
        return ((NettyChannelBuilder)this.builder.eventLoopGroup(this.context.nettyEventLoop()).channelFactory(transport.channelFactory(false)).executor(command -> {
            if (Context.isOnEventLoopThread()) {
                this.context.dispatch(event -> command.run());
            } else {
                command.run();
            }
        })).build();
    }
}

