/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.op;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Txn;
import io.etcd.jetcd.api.TxnRequest;
import io.etcd.jetcd.kv.TxnResponse;
import io.etcd.jetcd.op.Cmp;
import io.etcd.jetcd.op.Op;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.kyuubi.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.kyuubi.shade.com.google.common.collect.ImmutableList;

public class TxnImpl
implements Txn {
    private final ByteSequence namespace;
    private final List<Cmp> cmpList = new ArrayList<Cmp>();
    private final List<Op> successOpList = new ArrayList<Op>();
    private final List<Op> failureOpList = new ArrayList<Op>();
    private final Function<TxnRequest, CompletableFuture<TxnResponse>> requestF;
    private boolean seenThen = false;
    private boolean seenElse = false;

    public static TxnImpl newTxn(Function<TxnRequest, CompletableFuture<TxnResponse>> f, ByteSequence namespace) {
        return new TxnImpl(f, namespace);
    }

    @VisibleForTesting
    static TxnImpl newTxn(Function<TxnRequest, CompletableFuture<TxnResponse>> f) {
        return TxnImpl.newTxn(f, ByteSequence.EMPTY);
    }

    private TxnImpl(Function<TxnRequest, CompletableFuture<TxnResponse>> f, ByteSequence namespace) {
        this.requestF = f;
        this.namespace = namespace;
    }

    @Override
    public TxnImpl If(Cmp ... cmps) {
        return this.If(ImmutableList.copyOf(cmps));
    }

    TxnImpl If(List<Cmp> cmps) {
        if (this.seenThen) {
            throw new IllegalArgumentException("cannot call If after Then!");
        }
        if (this.seenElse) {
            throw new IllegalArgumentException("cannot call If after Else!");
        }
        this.cmpList.addAll(cmps);
        return this;
    }

    @Override
    public TxnImpl Then(Op ... ops) {
        return this.Then(ImmutableList.copyOf(ops));
    }

    TxnImpl Then(List<Op> ops) {
        if (this.seenElse) {
            throw new IllegalArgumentException("cannot call Then after Else!");
        }
        this.seenThen = true;
        this.successOpList.addAll(ops);
        return this;
    }

    @Override
    public TxnImpl Else(Op ... ops) {
        return this.Else(ImmutableList.copyOf(ops));
    }

    TxnImpl Else(List<Op> ops) {
        this.seenElse = true;
        this.failureOpList.addAll(ops);
        return this;
    }

    @Override
    public CompletableFuture<TxnResponse> commit() {
        return this.requestF.apply(this.toTxnRequest());
    }

    private TxnRequest toTxnRequest() {
        TxnRequest.Builder requestBuilder = TxnRequest.newBuilder();
        for (Cmp c : this.cmpList) {
            requestBuilder.addCompare(c.toCompare(this.namespace));
        }
        for (Op o : this.successOpList) {
            requestBuilder.addSuccess(o.toRequestOp(this.namespace));
        }
        for (Op o : this.failureOpList) {
            requestBuilder.addFailure(o.toRequestOp(this.namespace));
        }
        return requestBuilder.build();
    }
}

