/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.jdbc.doris;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.BitSet;
import org.apache.hive.service.rpc.thrift.TBoolColumn;
import org.apache.hive.service.rpc.thrift.TBoolValue;
import org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.hive.service.rpc.thrift.TColumnValue;
import org.apache.hive.service.rpc.thrift.TDoubleColumn;
import org.apache.hive.service.rpc.thrift.TDoubleValue;
import org.apache.hive.service.rpc.thrift.TI32Column;
import org.apache.hive.service.rpc.thrift.TI32Value;
import org.apache.hive.service.rpc.thrift.TI64Column;
import org.apache.hive.service.rpc.thrift.TI64Value;
import org.apache.hive.service.rpc.thrift.TStringColumn;
import org.apache.hive.service.rpc.thrift.TStringValue;
import org.apache.kyuubi.engine.jdbc.schema.Column;
import org.apache.kyuubi.engine.jdbc.schema.RowSetHelper;
import org.apache.kyuubi.util.RowSetUtils$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0002\u0004\u0001'!)!\u0004\u0001C\u00017!)a\u0004\u0001C\t?!)\u0001\n\u0001C\t\u0013\")\u0011\f\u0001C\t5\n\tBi\u001c:jgJ{woU3u\u0011\u0016d\u0007/\u001a:\u000b\u0005\u001dA\u0011!\u00023pe&\u001c(BA\u0005\u000b\u0003\u0011QGMY2\u000b\u0005-a\u0011AB3oO&tWM\u0003\u0002\u000e\u001d\u000511._;vE&T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9\u0002\"\u0001\u0004tG\",W.Y\u0005\u00033Y\u0011ABU8x'\u0016$\b*\u001a7qKJ\fa\u0001P5oSRtD#\u0001\u000f\u0011\u0005u\u0001Q\"\u0001\u0004\u0002\u0013Q|GkQ8mk6tG\u0003\u0002\u0011-\u0003\u001a\u0003\"!\t\u0016\u000e\u0003\tR!a\t\u0013\u0002\rQD'/\u001b4u\u0015\t)c%A\u0002sa\u000eT!a\n\u0015\u0002\u000fM,'O^5dK*\u0011\u0011FD\u0001\u0005Q&4X-\u0003\u0002,E\t9AkQ8mk6t\u0007\"B\u0017\u0003\u0001\u0004q\u0013\u0001\u0002:poN\u00042aL\u001d=\u001d\t\u0001dG\u0004\u00022i5\t!G\u0003\u00024%\u00051AH]8pizJ\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oa\nq\u0001]1dW\u0006<WMC\u00016\u0013\tQ4HA\u0002TKFT!a\u000e\u001d\u0011\u0007=JT\b\u0005\u0002?\u007f5\t\u0001(\u0003\u0002Aq\t\u0019\u0011I\\=\t\u000b\t\u0013\u0001\u0019A\"\u0002\u000f=\u0014H-\u001b8bYB\u0011a\bR\u0005\u0003\u000bb\u00121!\u00138u\u0011\u00159%\u00011\u0001D\u0003\u001d\u0019\u0018\u000f\u001c+za\u0016\fa\u0002^8U\u0007>dW/\u001c8WC2,X\r\u0006\u0003K\u001b:\u001b\u0006CA\u0011L\u0013\ta%E\u0001\u0007U\u0007>dW/\u001c8WC2,X\rC\u0003C\u0007\u0001\u00071\tC\u0003P\u0007\u0001\u0007\u0001+A\u0002s_^\u00042aL)>\u0013\t\u00116H\u0001\u0003MSN$\b\"\u0002+\u0004\u0001\u0004)\u0016!\u0002;za\u0016\u001c\bcA\u0018R-B\u0011QcV\u0005\u00031Z\u0011aaQ8mk6t\u0017\u0001\u0004;p\u0011&4Xm\u0015;sS:<GcA.dKB\u0011A\f\u0019\b\u0003;z\u0003\"!\r\u001d\n\u0005}C\u0014A\u0002)sK\u0012,g-\u0003\u0002bE\n11\u000b\u001e:j]\u001eT!a\u0018\u001d\t\u000b\u0011$\u0001\u0019A\u001f\u0002\t\u0011\fG/\u0019\u0005\u0006\u000f\u0012\u0001\ra\u0011")
public class DorisRowSetHelper
extends RowSetHelper {
    @Override
    public TColumn toTColumn(Seq<Seq<Object>> rows, int ordinal, int sqlType) {
        TColumn tColumn;
        BitSet nulls = new BitSet();
        int n2 = sqlType;
        switch (n2) {
            case -7: {
                java.util.List<Boolean> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.boolean2Boolean(true));
                tColumn = TColumn.boolVal((TBoolColumn)new TBoolColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                java.util.List<Integer> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.int2Integer(0));
                tColumn = TColumn.i32Val((TI32Column)new TI32Column(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
                break;
            }
            case -5: {
                java.util.List<Long> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.long2Long(0L));
                tColumn = TColumn.i64Val((TI64Column)new TI64Column(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
                break;
            }
            case 7: {
                java.util.List values = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.float2Float(0.0f))).asScala()).map((Function1 & Serializable & scala.Serializable)n -> Double.valueOf(n.toString()), Buffer$.MODULE$.canBuildFrom())).asJava();
                tColumn = TColumn.doubleVal((TDoubleColumn)new TDoubleColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
                break;
            }
            case 8: {
                java.util.List<Double> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.double2Double(0.0));
                tColumn = TColumn.doubleVal((TDoubleColumn)new TDoubleColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
                break;
            }
            case 1: 
            case 12: {
                java.util.List<String> values = this.getOrSetAsNull(rows, ordinal, nulls, "");
                tColumn = TColumn.stringVal((TStringColumn)new TStringColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
                break;
            }
            default: {
                int rowSize = rows.length();
                ArrayList<String> values = new ArrayList<String>(rowSize);
                for (int i = 0; i < rowSize; ++i) {
                    Seq row = (Seq)rows.apply(i);
                    nulls.set(i, row.apply(ordinal) == null);
                    String value = row.apply(ordinal) == null ? "" : this.toHiveString(row.apply(ordinal), sqlType);
                    values.add(value);
                }
                tColumn = TColumn.stringVal((TStringColumn)new TStringColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
                break;
            }
        }
        return tColumn;
    }

    @Override
    public TColumnValue toTColumnValue(int ordinal, List<Object> row, List<Column> types) {
        TColumnValue tColumnValue;
        int n = ((Column)types.apply(ordinal)).sqlType();
        switch (n) {
            case -7: {
                TBoolValue boolValue = new TBoolValue();
                if (row.apply(ordinal) != null) {
                    boolValue.setValue(BoxesRunTime.unboxToBoolean((Object)row.apply(ordinal)));
                }
                tColumnValue = TColumnValue.boolVal((TBoolValue)boolValue);
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                TI32Value tI32Value = new TI32Value();
                if (row.apply(ordinal) != null) {
                    tI32Value.setValue(BoxesRunTime.unboxToInt((Object)row.apply(ordinal)));
                }
                tColumnValue = TColumnValue.i32Val((TI32Value)tI32Value);
                break;
            }
            case -5: {
                TI64Value tI64Value = new TI64Value();
                if (row.apply(ordinal) != null) {
                    tI64Value.setValue(BoxesRunTime.unboxToLong((Object)row.apply(ordinal)));
                }
                tColumnValue = TColumnValue.i64Val((TI64Value)tI64Value);
                break;
            }
            case 7: {
                TDoubleValue tDoubleValue = new TDoubleValue();
                if (row.apply(ordinal) != null) {
                    Double doubleValue = Double.valueOf(Float.toString(BoxesRunTime.unboxToFloat((Object)row.apply(ordinal))));
                    tDoubleValue.setValue(Predef$.MODULE$.Double2double(doubleValue));
                }
                tColumnValue = TColumnValue.doubleVal((TDoubleValue)tDoubleValue);
                break;
            }
            case 8: {
                TDoubleValue tDoubleValue = new TDoubleValue();
                if (row.apply(ordinal) != null) {
                    tDoubleValue.setValue(BoxesRunTime.unboxToDouble((Object)row.apply(ordinal)));
                }
                tColumnValue = TColumnValue.doubleVal((TDoubleValue)tDoubleValue);
                break;
            }
            case 1: 
            case 12: {
                TStringValue tStringValue = new TStringValue();
                if (row.apply(ordinal) != null) {
                    tStringValue.setValue((String)row.apply(ordinal));
                }
                tColumnValue = TColumnValue.stringVal((TStringValue)tStringValue);
                break;
            }
            default: {
                TStringValue tStrValue = new TStringValue();
                if (row.apply(ordinal) != null) {
                    tStrValue.setValue(this.toHiveString(row.apply(ordinal), ((Column)types.apply(ordinal)).sqlType()));
                }
                tColumnValue = TColumnValue.stringVal((TStringValue)tStrValue);
                break;
            }
        }
        return tColumnValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toHiveString(Object data, int sqlType) {
        Tuple2 tuple2 = new Tuple2(data, (Object)BoxesRunTime.boxToInteger((int)sqlType));
        if (tuple2 != null) {
            Object date = tuple2._1();
            int n = tuple2._2$mcI$sp();
            if (date instanceof Date) {
                Date date2 = (Date)date;
                if (91 == n) {
                    return RowSetUtils$.MODULE$.formatDate((java.util.Date)date2);
                }
            }
        }
        if (tuple2 != null) {
            Object dateTime = tuple2._1();
            int n = tuple2._2$mcI$sp();
            if (dateTime instanceof LocalDateTime) {
                LocalDateTime localDateTime = (LocalDateTime)dateTime;
                if (93 == n) {
                    return RowSetUtils$.MODULE$.formatLocalDateTime(localDateTime);
                }
            }
        }
        if (tuple2 != null) {
            Object decimal = tuple2._1();
            int n = tuple2._2$mcI$sp();
            if (decimal instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)decimal;
                if (3 == n) {
                    return bigDecimal.toPlainString();
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Object other = tuple2._1();
        return other.toString();
    }
}

