/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.jdbc.connection;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.jdbc.connection.JdbcConnectionProvider;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U3Qa\u0002\u0005\u0002\u0002UAQ\u0001\t\u0001\u0005\u0002\u0005Bq\u0001\n\u0001C\u0002\u0013EQ\u0005\u0003\u00046\u0001\u0001\u0006IA\n\u0005\u0006m\u0001!\ta\u000e\u0005\u0006\u0011\u0002!\t!\u0013\u0005\u0006'\u0002!\t\u0001\u0016\u0002\u001b\u0003\n\u001cHO]1di\u000e{gN\\3di&|g\u000e\u0015:pm&$WM\u001d\u0006\u0003\u0013)\t!bY8o]\u0016\u001cG/[8o\u0015\tYA\"\u0001\u0003kI\n\u001c'BA\u0007\u000f\u0003\u0019)gnZ5oK*\u0011q\u0002E\u0001\u0007Wf,XOY5\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0003\b\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005uqR\"\u0001\b\n\u0005}q!a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u0002\"a\t\u0001\u000e\u0003!\t\u0011\u0002\u001d:pm&$WM]:\u0016\u0003\u0019\u00022aJ\u00183\u001d\tASF\u0004\u0002*Y5\t!F\u0003\u0002,)\u00051AH]8pizJ\u0011!G\u0005\u0003]a\tq\u0001]1dW\u0006<W-\u0003\u00021c\t\u00191+Z9\u000b\u00059B\u0002CA\u00124\u0013\t!\u0004B\u0001\fKI\n\u001c7i\u001c8oK\u000e$\u0018n\u001c8Qe>4\u0018\u000eZ3s\u0003)\u0001(o\u001c<jI\u0016\u00148\u000fI\u0001\u0011O\u0016$\bK]8wS\u0012,'o\u00117bgN$\"\u0001\u000f!\u0011\u0005ejdB\u0001\u001e<!\tI\u0003$\u0003\u0002=1\u00051\u0001K]3eK\u001aL!AP \u0003\rM#(/\u001b8h\u0015\ta\u0004\u0004C\u0003B\t\u0001\u0007!)\u0001\u0006lsV,(-[\"p]\u001a\u0004\"a\u0011$\u000e\u0003\u0011S!!\u0012\b\u0002\r\r|gNZ5h\u0013\t9EI\u0001\u0006LsV,(-[\"p]\u001a\faa\u0019:fCR,GC\u0001&S!\tY\u0005+D\u0001M\u0015\tie*A\u0002tc2T\u0011aT\u0001\u0005U\u00064\u0018-\u0003\u0002R\u0019\nQ1i\u001c8oK\u000e$\u0018n\u001c8\t\u000b\u0005+\u0001\u0019\u0001\"\u0002\u001b1|\u0017\r\u001a)s_ZLG-\u001a:t)\u00051\u0003")
public abstract class AbstractConnectionProvider
implements Logging {
    private final Seq<JdbcConnectionProvider> providers;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public Seq<JdbcConnectionProvider> providers() {
        return this.providers;
    }

    public String getProviderClass(KyuubiConf kyuubiConf) {
        Option specifiedDriverClass = (Option)kyuubiConf.get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_JDBC_DRIVER_CLASS());
        specifiedDriverClass.foreach((Function1 & Serializable & scala.Serializable)x$1 -> Class.forName(x$1));
        return (String)specifiedDriverClass.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String url = (String)((Option)kyuubiConf.get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_JDBC_CONNECTION_URL())).get();
            return DriverManager.getDriver(url).getClass().getCanonicalName();
        });
    }

    public Connection create(KyuubiConf kyuubiConf) {
        JdbcConnectionProvider jdbcConnectionProvider;
        Seq filteredProviders = (Seq)this.providers().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.canHandle(this.getProviderClass(kyuubiConf))));
        if (filteredProviders.isEmpty()) {
            throw new IllegalArgumentException("Empty list of JDBC connection providers for the specified driver and options");
        }
        Option connectionProviderName = (Option)kyuubiConf.get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_JDBC_CONNECTION_PROVIDER());
        Option option = connectionProviderName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String providerName = (String)some.value();
            jdbcConnectionProvider = (JdbcConnectionProvider)filteredProviders.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AbstractConnectionProvider.$anonfun$create$2(providerName, x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(129).append("Could not find a JDBC connection provider with name '").append(providerName).append("' ").append("that can handle the specified driver and options. ").append("Available providers are ").append(this.providers().mkString("[", ", ", "]")).toString());
            });
        } else if (None$.MODULE$.equals(option)) {
            if (filteredProviders.size() != 1) {
                throw new IllegalArgumentException(new StringBuilder(141).append("JDBC connection initiated but more than one connection provider was found. Use ").append(KyuubiConf$.MODULE$.ENGINE_JDBC_CONNECTION_PROVIDER().key()).append(" option to select a specific provider. ").append("Found active providers ").append(filteredProviders.mkString("[", ", ", "]")).toString());
            }
            jdbcConnectionProvider = (JdbcConnectionProvider)filteredProviders.head();
        } else {
            throw new MatchError((Object)option);
        }
        JdbcConnectionProvider selectedProvider = jdbcConnectionProvider;
        return selectedProvider.getConnection(kyuubiConf);
    }

    /*
     * WARNING - void declaration
     */
    public Seq<JdbcConnectionProvider> loadProviders() {
        void var2_2;
        ServiceLoader<JdbcConnectionProvider> loader = ServiceLoader.load(JdbcConnectionProvider.class, Thread.currentThread().getContextClassLoader());
        ArrayBuffer providers = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Iterator<JdbcConnectionProvider> iterator = loader.iterator();
        while (iterator.hasNext()) {
            BoxedUnit boxedUnit;
            try {
                JdbcConnectionProvider provider = iterator.next();
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Loaded provider: ").append(provider).toString());
                boxedUnit = providers.$plus$eq((Object)provider);
            }
            catch (Throwable t) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Loaded of the provider failed with the exception", t);
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$create$2(String providerName$1, JdbcConnectionProvider x$2) {
        String string = x$2.name();
        String string2 = providerName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public AbstractConnectionProvider() {
        Logging.$init$((Logging)this);
        this.providers = this.loadProviders();
    }
}

