/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.client;

import java.util.HashMap;
import org.apache.kyuubi.client.IRestClient;
import org.apache.kyuubi.client.KyuubiRestClient;
import org.apache.kyuubi.client.api.v1.dto.Batch;
import org.apache.kyuubi.client.api.v1.dto.BatchRequest;
import org.apache.kyuubi.client.api.v1.dto.CloseBatchResponse;
import org.apache.kyuubi.client.api.v1.dto.GetBatchesResponse;
import org.apache.kyuubi.client.api.v1.dto.OperationLog;
import org.apache.kyuubi.client.util.JsonUtils;

public class BatchRestApi {
    private KyuubiRestClient client;
    private static final String API_BASE_PATH = "batches";

    private BatchRestApi() {
    }

    public BatchRestApi(KyuubiRestClient client) {
        this.client = client;
    }

    public Batch createBatch(BatchRequest request) {
        String requestBody = JsonUtils.toJson(request);
        return this.getClient().post(API_BASE_PATH, requestBody, Batch.class, this.client.getAuthHeader());
    }

    public Batch getBatchById(String batchId) {
        String path = String.format("%s/%s", API_BASE_PATH, batchId);
        return this.getClient().get(path, null, Batch.class, this.client.getAuthHeader());
    }

    public GetBatchesResponse listBatches(String batchType, String batchUser, String batchState, Long createTime, Long endTime, int from, int size) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("batchType", batchType);
        params.put("batchUser", batchUser);
        params.put("batchState", batchState);
        if (null != createTime && createTime > 0L) {
            params.put("createTime", createTime);
        }
        if (null != endTime && endTime > 0L) {
            params.put("endTime", endTime);
        }
        params.put("from", from);
        params.put("size", size);
        return this.getClient().get(API_BASE_PATH, params, GetBatchesResponse.class, this.client.getAuthHeader());
    }

    public OperationLog getBatchLocalLog(String batchId, int from, int size) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("from", from);
        params.put("size", size);
        String path = String.format("%s/%s/localLog", API_BASE_PATH, batchId);
        return this.getClient().get(path, params, OperationLog.class, this.client.getAuthHeader());
    }

    public CloseBatchResponse deleteBatch(String batchId, String hs2ProxyUser) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("hive.server2.proxy.user", hs2ProxyUser);
        String path = String.format("%s/%s", API_BASE_PATH, batchId);
        return this.getClient().delete(path, params, CloseBatchResponse.class, this.client.getAuthHeader());
    }

    private IRestClient getClient() {
        return this.client.getHttpClient();
    }
}

