/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server;

import java.io.Serializable;
import java.net.InetAddress;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.server.api.ApiUtils$;
import org.apache.kyuubi.service.AbstractFrontendService;
import org.apache.kyuubi.service.BackendService;
import org.apache.kyuubi.service.Serverable;
import org.apache.kyuubi.service.Service;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001\u0002\u000e\u001c\u0001\u0011B\u0001b\f\u0001\u0003\u0006\u0004%\t\u0005\r\u0005\ti\u0001\u0011\t\u0011)A\u0005c!)Q\u0007\u0001C\u0001m!I!\b\u0001a\u0001\u0002\u0004%Ia\u000f\u0005\n\t\u0002\u0001\r\u00111A\u0005\n\u0015C\u0011B\u0014\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u001f\t\u0013=\u0003\u0001\u0019!a\u0001\n\u0013\u0001\u0006\"\u0003+\u0001\u0001\u0004\u0005\r\u0011\"\u0003V\u0011%9\u0006\u00011A\u0001B\u0003&\u0011\u000bC\u0005Y\u0001\u0001\u0007\t\u0019!C\u00053\"I1\r\u0001a\u0001\u0002\u0004%I\u0001\u001a\u0005\nM\u0002\u0001\r\u0011!Q!\niC\u0011b\u001a\u0001A\u0002\u0003\u0007I\u0011\u00025\t\u00131\u0004\u0001\u0019!a\u0001\n\u0013i\u0007\"C8\u0001\u0001\u0004\u0005\t\u0015)\u0003j\u0011\u001d\u0001\b\u00011A\u0005\u0012EDq!\u001e\u0001A\u0002\u0013Ea\u000f\u0003\u0004y\u0001\u0001\u0006KA\u001d\u0005\u0006{\u0002!\tE \u0005\b\u0003\u001f\u0001A\u0011IA\t\u0011\u001d\tI\u0003\u0001C!\u0003WAq!!\f\u0001\t\u0003\nY\u0003C\u0004\u00020\u0001!I!a\u000b\t\u0013\u0005E\u0002A1A\u0005B\u0005M\u0002\u0002CA!\u0001\u0001\u0006I!!\u000e\u00033-KX/\u001e2j%\u0016\u001cHO\u0012:p]R,g\u000eZ*feZL7-\u001a\u0006\u00039u\taa]3sm\u0016\u0014(B\u0001\u0010 \u0003\u0019Y\u00170^;cS*\u0011\u0001%I\u0001\u0007CB\f7\r[3\u000b\u0003\t\n1a\u001c:h\u0007\u0001\u00192\u0001A\u0013,!\t1\u0013&D\u0001(\u0015\tAS$A\u0004tKJ4\u0018nY3\n\u0005):#aF!cgR\u0014\u0018m\u0019;Ge>tG/\u001a8e'\u0016\u0014h/[2f!\taS&D\u0001\u001e\u0013\tqSDA\u0004M_\u001e<\u0017N\\4\u0002\u0015M,'O^3sC\ndW-F\u00012!\t1#'\u0003\u00024O\tQ1+\u001a:wKJ\f'\r\\3\u0002\u0017M,'O^3sC\ndW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005]J\u0004C\u0001\u001d\u0001\u001b\u0005Y\u0002\"B\u0018\u0004\u0001\u0004\t\u0014AC:feZ,'/\u00113eeV\tA\b\u0005\u0002>\u00056\taH\u0003\u0002@\u0001\u0006\u0019a.\u001a;\u000b\u0003\u0005\u000bAA[1wC&\u00111I\u0010\u0002\f\u0013:,G/\u00113ee\u0016\u001c8/\u0001\btKJ4XM]!eIJ|F%Z9\u0015\u0005\u0019c\u0005CA$K\u001b\u0005A%\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C%\u0001B+oSRDq!T\u0003\u0002\u0002\u0003\u0007A(A\u0002yIE\n1b]3sm\u0016\u0014\u0018\t\u001a3sA\u00059\u0001o\u001c:u\u001dVlW#A)\u0011\u0005\u001d\u0013\u0016BA*I\u0005\rIe\u000e^\u0001\fa>\u0014HOT;n?\u0012*\u0017\u000f\u0006\u0002G-\"9Q\nCA\u0001\u0002\u0004\t\u0016\u0001\u00039peRtU/\u001c\u0011\u0002\u0017),G\u000f^=TKJ4XM]\u000b\u00025B\u00111,Y\u0007\u00029*\u0011A$\u0018\u0006\u0003=~\u000bQA[3uifT!\u0001Y\u0011\u0002\u000f\u0015\u001cG.\u001b9tK&\u0011!\r\u0018\u0002\u0007'\u0016\u0014h/\u001a:\u0002\u001f),G\u000f^=TKJ4XM]0%KF$\"AR3\t\u000f5[\u0011\u0011!a\u00015\u0006a!.\u001a;usN+'O^3sA\u0005I1m\u001c8oK\u000e$xN]\u000b\u0002SB\u00111L[\u0005\u0003Wr\u0013qbU3sm\u0016\u00148i\u001c8oK\u000e$xN]\u0001\u000eG>tg.Z2u_J|F%Z9\u0015\u0005\u0019s\u0007bB'\u000f\u0003\u0003\u0005\r![\u0001\u000bG>tg.Z2u_J\u0004\u0013!C5t'R\f'\u000f^3e+\u0005\u0011\bCA$t\u0013\t!\bJA\u0004C_>dW-\u00198\u0002\u001b%\u001c8\u000b^1si\u0016$w\fJ3r)\t1u\u000fC\u0004N#\u0005\u0005\t\u0019\u0001:\u0002\u0015%\u001c8\u000b^1si\u0016$\u0007\u0005\u000b\u0002\u0013uB\u0011qi_\u0005\u0003y\"\u0013\u0001B^8mCRLG.Z\u0001\u000bS:LG/[1mSj,GC\u0001$\u0000\u0011\u001d\t\ta\u0005a\u0001\u0003\u0007\tAaY8oMB!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\nu\taaY8oM&<\u0017\u0002BA\u0007\u0003\u000f\u0011!bS=vk\nL7i\u001c8g\u00035\u0019wN\u001c8fGRLwN\\+sYV\u0011\u00111\u0003\t\u0005\u0003+\t\u0019C\u0004\u0003\u0002\u0018\u0005}\u0001cAA\r\u00116\u0011\u00111\u0004\u0006\u0004\u0003;\u0019\u0013A\u0002\u001fs_>$h(C\u0002\u0002\"!\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0013\u0003O\u0011aa\u0015;sS:<'bAA\u0011\u0011\u0006)1\u000f^1siR\ta)\u0001\u0003ti>\u0004\u0018AD:u_BDE\u000f\u001e9TKJ4XM]\u0001\u0011I&\u001c8m\u001c<fef\u001cVM\u001d<jG\u0016,\"!!\u000e\u0011\u000b\u001d\u000b9$a\u000f\n\u0007\u0005e\u0002J\u0001\u0004PaRLwN\u001c\t\u0004M\u0005u\u0012bAA O\t91+\u001a:wS\u000e,\u0017!\u00053jg\u000e|g/\u001a:z'\u0016\u0014h/[2fA\u0001")
public class KyuubiRestFrontendService
extends AbstractFrontendService {
    private final Serverable serverable;
    private InetAddress serverAddr;
    private int portNum;
    private Server jettyServer;
    private ServerConnector connector;
    private volatile boolean isStarted;
    private final Option<Service> discoveryService;

    public Serverable serverable() {
        return this.serverable;
    }

    private InetAddress serverAddr() {
        return this.serverAddr;
    }

    private void serverAddr_$eq(InetAddress x$1) {
        this.serverAddr = x$1;
    }

    private int portNum() {
        return this.portNum;
    }

    private void portNum_$eq(int x$1) {
        this.portNum = x$1;
    }

    private Server jettyServer() {
        return this.jettyServer;
    }

    private void jettyServer_$eq(Server x$1) {
        this.jettyServer = x$1;
    }

    private ServerConnector connector() {
        return this.connector;
    }

    private void connector_$eq(ServerConnector x$1) {
        this.connector = x$1;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void isStarted_$eq(boolean x$1) {
        this.isStarted = x$1;
    }

    public synchronized void initialize(KyuubiConf conf) {
        Option serverHost = (Option)conf.get(KyuubiConf$.MODULE$.FRONTEND_REST_BIND_HOST());
        this.serverAddr_$eq((InetAddress)serverHost.map((Function1 & Serializable & scala.Serializable)x$1 -> InetAddress.getByName(x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Utils$.MODULE$.findLocalInetAddress()));
        this.portNum_$eq(BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_REST_BIND_PORT())));
        this.jettyServer_$eq(new Server());
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setShowStacks(true);
        errorHandler.setServer(this.jettyServer());
        this.jettyServer().addBean((Object)errorHandler);
        this.jettyServer().setHandler((Handler)ApiUtils$.MODULE$.getServletHandler((BackendService)this.serverable().backendService()));
        this.connector_$eq(new ServerConnector(this.jettyServer(), null, (Scheduler)new ScheduledExecutorScheduler(new StringBuilder(15).append(this.getName()).append("-JettyScheduler").toString(), true), null, -1, -1, (ConnectionFactory[])new HttpConnectionFactory[]{new HttpConnectionFactory(new HttpConfiguration())}));
        this.connector().setPort(this.portNum());
        this.connector().setHost(this.serverAddr().getCanonicalHostName());
        this.connector().setReuseAddress(!Utils$.MODULE$.isWindows());
        this.connector().setAcceptQueueSize(package$.MODULE$.min(this.connector().getAcceptors(), 8));
        super.initialize(conf);
    }

    public String connectionUrl() {
        this.checkInitialized();
        return new StringBuilder(1).append(this.serverAddr().getCanonicalHostName()).append(":").append(this.portNum()).toString();
    }

    public void start() {
        if (!this.isStarted()) {
            try {
                this.connector().start();
                this.jettyServer().start();
                this.isStarted_$eq(true);
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Rest frontend service jetty server has started at ").append(this.jettyServer().getURI()).append(".").toString());
            }
            catch (Exception rethrow) {
                this.stopHttpServer();
                throw new KyuubiException("Cannot start rest frontend service jetty server", (Throwable)rethrow);
            }
        }
        super.start();
    }

    public void stop() {
        if (this.isStarted()) {
            this.stopHttpServer();
            this.isStarted_$eq(false);
        }
        super.stop();
    }

    private void stopHttpServer() {
        if (this.jettyServer() != null) {
            try {
                try {
                    this.connector().stop();
                    this.info((Function0 & Serializable & scala.Serializable)() -> "Rest frontend service server connector has stopped.");
                }
                catch (Exception err) {
                    this.error((Function0 & Serializable & scala.Serializable)() -> "Cannot safely stop rest frontend service server connector", err);
                }
            }
            finally {
                this.connector_$eq(null);
            }
            try {
                try {
                    this.jettyServer().stop();
                    this.info((Function0 & Serializable & scala.Serializable)() -> "Rest frontend service jetty server has stopped.");
                }
                catch (Exception err) {
                    this.error((Function0 & Serializable & scala.Serializable)() -> "Cannot safely stop rest frontend service jetty server", err);
                }
            }
            finally {
                this.jettyServer_$eq(null);
            }
        }
    }

    public Option<Service> discoveryService() {
        return this.discoveryService;
    }

    public KyuubiRestFrontendService(Serverable serverable) {
        this.serverable = serverable;
        super("KyuubiRestFrontendService");
        this.isStarted = false;
        this.discoveryService = None$.MODULE$;
    }
}

