/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.hive.service.cli;

import org.apache.kyuubi.shade.org.apache.hive.service.cli.HiveSQLException;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TOperationState;

public enum OperationState {
    INITIALIZED(TOperationState.INITIALIZED_STATE, false),
    RUNNING(TOperationState.RUNNING_STATE, false),
    FINISHED(TOperationState.FINISHED_STATE, true),
    CANCELED(TOperationState.CANCELED_STATE, true),
    CLOSED(TOperationState.CLOSED_STATE, true),
    ERROR(TOperationState.ERROR_STATE, true),
    UNKNOWN(TOperationState.UKNOWN_STATE, false),
    PENDING(TOperationState.PENDING_STATE, false),
    TIMEDOUT(TOperationState.TIMEDOUT_STATE, true);

    private final TOperationState tOperationState;
    private final boolean terminal;

    private OperationState(TOperationState tOperationState, boolean terminal) {
        this.tOperationState = tOperationState;
        this.terminal = terminal;
    }

    public static OperationState getOperationState(TOperationState tOperationState) {
        return OperationState.values()[tOperationState.getValue()];
    }

    public static void validateTransition(OperationState oldState, OperationState newState) throws HiveSQLException {
        switch (oldState) {
            case INITIALIZED: {
                switch (newState) {
                    case PENDING: 
                    case RUNNING: 
                    case CANCELED: 
                    case CLOSED: 
                    case TIMEDOUT: {
                        return;
                    }
                }
                break;
            }
            case PENDING: {
                switch (newState) {
                    case RUNNING: 
                    case CANCELED: 
                    case CLOSED: 
                    case TIMEDOUT: 
                    case FINISHED: 
                    case ERROR: {
                        return;
                    }
                }
                break;
            }
            case RUNNING: {
                switch (newState) {
                    case CANCELED: 
                    case CLOSED: 
                    case TIMEDOUT: 
                    case FINISHED: 
                    case ERROR: {
                        return;
                    }
                }
                break;
            }
            case CANCELED: 
            case TIMEDOUT: 
            case FINISHED: 
            case ERROR: {
                if (!CLOSED.equals((Object)newState)) break;
                return;
            }
        }
        throw new HiveSQLException("Illegal Operation state transition from " + (Object)((Object)oldState) + " to " + (Object)((Object)newState));
    }

    public void validateTransition(OperationState newState) throws HiveSQLException {
        OperationState.validateTransition(this, newState);
    }

    public TOperationState toTOperationState() {
        return this.tOperationState;
    }

    public boolean isTerminal() {
        return this.terminal;
    }
}

