/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark.operation;

import java.io.Serializable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.spark.ArrayFetchIterator;
import org.apache.kyuubi.engine.spark.FetchIterator;
import org.apache.kyuubi.engine.spark.IterableFetchIterator;
import org.apache.kyuubi.engine.spark.KyuubiSparkUtil$;
import org.apache.kyuubi.engine.spark.events.EventLoggingService$;
import org.apache.kyuubi.engine.spark.events.SparkStatementEvent;
import org.apache.kyuubi.engine.spark.events.SparkStatementEvent$;
import org.apache.kyuubi.engine.spark.operation.SparkOperation;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.operation.OperationType$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.operation.log.OperationLog$;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.session.SessionManager;
import org.apache.kyuubi.util.ThreadUtils$;
import org.apache.spark.kyuubi.SQLOperationListener;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-g\u0001\u0002\u0012$\u0001AB\u0001B\n\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"Aa\t\u0001BC\u0002\u0013Es\t\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003I\u0011!1\u0006A!b\u0001\n\u0003:\u0006\u0002\u0003/\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\t\u0011u\u0003!\u0011!Q\u0001\nyC\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\u0006E\u0002!\ta\u0019\u0005\bW\u0002\u0011\r\u0011\"\u0003X\u0011\u0019a\u0007\u0001)A\u00051\"9Q\u000e\u0001b\u0001\n\u0013q\u0007B\u0002:\u0001A\u0003%q\u000eC\u0004t\u0001\u0001\u0007I\u0011\u0002;\t\u0013\u0005\u0005\u0001\u00011A\u0005\n\u0005\r\u0001bBA\b\u0001\u0001\u0006K!\u001e\u0005\n\u0003#\u0001!\u0019!C\u0005\u0003'A\u0001\"a\t\u0001A\u0003%\u0011Q\u0003\u0005\b\u0003K\u0001A\u0011IA\u0014\u0011%\tY\u0003\u0001b\u0001\n\u0013\ti\u0003\u0003\u0005\u0002:\u0001\u0001\u000b\u0011BA\u0018\u0011%\tY\u0004\u0001b\u0001\n\u0003\ti\u0004\u0003\u0005\u0002L\u0001\u0001\u000b\u0011BA \u0011\u001d\ti\u0005\u0001C)\u0003\u001fBq!!\u0018\u0001\t#\ny\u0006C\u0004\u0002b\u0001!\t&a\u0018\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002`!9\u0011Q\r\u0001\u0005R\u0005}\u0003bBA4\u0001\u0011%\u0011\u0011\u000e\u0005\b\u0003\u001b\u0003A\u0011BA0\u0011\u001d\ty\t\u0001C!\u0003#Cq!!.\u0001\t\u0003\n9\fC\u0004\u0002>\u0002!\t%a0\u0003!\u0015CXmY;uKN#\u0018\r^3nK:$(B\u0001\u0013&\u0003%y\u0007/\u001a:bi&|gN\u0003\u0002'O\u0005)1\u000f]1sW*\u0011\u0001&K\u0001\u0007K:<\u0017N\\3\u000b\u0005)Z\u0013AB6zkV\u0014\u0017N\u0003\u0002-[\u00051\u0011\r]1dQ\u0016T\u0011AL\u0001\u0004_J<7\u0001A\n\u0004\u0001E*\u0004C\u0001\u001a4\u001b\u0005\u0019\u0013B\u0001\u001b$\u00059\u0019\u0006/\u0019:l\u001fB,'/\u0019;j_:\u0004\"AN\u001c\u000e\u0003%J!\u0001O\u0015\u0003\u000f1{wmZ5oOB\u0011!HP\u0007\u0002w)\u0011A(P\u0001\u0004gFd'B\u0001\u0014,\u0013\ty4H\u0001\u0007Ta\u0006\u00148nU3tg&|g.A\u0004tKN\u001c\u0018n\u001c8\u0011\u0005\t#U\"A\"\u000b\u0005\u0001K\u0013BA#D\u0005\u001d\u0019Vm]:j_:\f\u0011b\u001d;bi\u0016lWM\u001c;\u0016\u0003!\u0003\"!\u0013*\u000f\u0005)\u0003\u0006CA&O\u001b\u0005a%BA'0\u0003\u0019a$o\\8u})\tq*A\u0003tG\u0006d\u0017-\u0003\u0002R\u001d\u00061\u0001K]3eK\u001aL!a\u0015+\u0003\rM#(/\u001b8h\u0015\t\tf*\u0001\u0006ti\u0006$X-\\3oi\u0002\nab\u001d5pk2$'+\u001e8Bgft7-F\u0001Y!\tI&,D\u0001O\u0013\tYfJA\u0004C_>dW-\u00198\u0002\u001fMDw.\u001e7e%Vt\u0017i]=oG\u0002\nA\"];fef$\u0016.\\3pkR\u0004\"!W0\n\u0005\u0001t%\u0001\u0002'p]\u001e\f!#\u001b8de\u0016lWM\u001c;bY\u000e{G\u000e\\3di\u00061A(\u001b8jiz\"r\u0001Z3gO\"L'\u000e\u0005\u00023\u0001!)a%\u0003a\u0001s!)\u0001)\u0003a\u0001\u0003\")a)\u0003a\u0001\u0011\")a+\u0003a\u00011\")Q,\u0003a\u0001=\")\u0011-\u0003a\u00011\u0006Yam\u001c:dK\u000e\u000bgnY3m\u000311wN]2f\u0007\u0006t7-\u001a7!\u00035\u00198\r[3ek2,'\u000fU8pYV\tq\u000eE\u0002Za\"K!!\u001d(\u0003\r=\u0003H/[8o\u00039\u00198\r[3ek2,'\u000fU8pY\u0002\nqc\u001d;bi\u0016lWM\u001c;US6,w.\u001e;DY\u0016\fg.\u001a:\u0016\u0003U\u00042!\u00179w!\t9h0D\u0001y\u0015\tI(0\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u001f?\u0002\tU$\u0018\u000e\u001c\u0006\u0002{\u0006!!.\u0019<b\u0013\ty\bP\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\f1d\u001d;bi\u0016lWM\u001c;US6,w.\u001e;DY\u0016\fg.\u001a:`I\u0015\fH\u0003BA\u0003\u0003\u0017\u00012!WA\u0004\u0013\r\tIA\u0014\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u000e=\t\t\u00111\u0001v\u0003\rAH%M\u0001\u0019gR\fG/Z7f]R$\u0016.\\3pkR\u001cE.Z1oKJ\u0004\u0013\u0001D8qKJ\fG/[8o\u0019><WCAA\u000b!\u0011\t9\"a\b\u000e\u0005\u0005e!\u0002BA\u000e\u0003;\t1\u0001\\8h\u0015\t!\u0013&\u0003\u0003\u0002\"\u0005e!\u0001D(qKJ\fG/[8o\u0019><\u0017!D8qKJ\fG/[8o\u0019><\u0007%A\bhKR|\u0005/\u001a:bi&|g\u000eT8h+\t\tI\u0003\u0005\u0003Za\u0006U\u0011!E8qKJ\fG/[8o\u0019&\u001cH/\u001a8feV\u0011\u0011q\u0006\t\u0005\u0003c\t)$\u0004\u0002\u00024)\u0011!&P\u0005\u0005\u0003o\t\u0019D\u0001\u000bT#2{\u0005/\u001a:bi&|g\u000eT5ti\u0016tWM]\u0001\u0013_B,'/\u0019;j_:d\u0015n\u001d;f]\u0016\u0014\b%\u0001\bti\u0006$X-\\3oi\u00163XM\u001c;\u0016\u0005\u0005}\u0002\u0003BA!\u0003\u000fj!!a\u0011\u000b\u0007\u0005\u0015S%\u0001\u0004fm\u0016tGo]\u0005\u0005\u0003\u0013\n\u0019EA\nTa\u0006\u00148n\u0015;bi\u0016lWM\u001c;Fm\u0016tG/A\bti\u0006$X-\\3oi\u00163XM\u001c;!\u00031\u0011Xm];miN\u001b\u0007.Z7b+\t\t\t\u0006\u0005\u0003\u0002T\u0005eSBAA+\u0015\r\t9fO\u0001\u0006if\u0004Xm]\u0005\u0005\u00037\n)F\u0001\u0006TiJ,8\r\u001e+za\u0016\f\u0011BY3g_J,'+\u001e8\u0015\u0005\u0005\u0015\u0011\u0001C1gi\u0016\u0014(+\u001e8\u0002!\u0015DXmY;uKN#\u0018\r^3nK:$\u0018a\u0003:v]&sG/\u001a:oC2\f1c^5uQ2{7-\u00197Qe>\u0004XM\u001d;jKN,B!a\u001b\u0002rQ!\u0011QNAB!\u0011\ty'!\u001d\r\u0001\u00119\u00111O\u000fC\u0002\u0005U$!\u0001+\u0012\t\u0005]\u0014Q\u0010\t\u00043\u0006e\u0014bAA>\u001d\n9aj\u001c;iS:<\u0007cA-\u0002\u0000%\u0019\u0011\u0011\u0011(\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002\u0006v!\t\u0019AAD\u0003\u00051\u0007#B-\u0002\n\u00065\u0014bAAF\u001d\nAAHY=oC6,g(A\tbI\u0012$\u0016.\\3pkRluN\\5u_J\fqa\u00197fC:,\b\u000f\u0006\u0003\u0002\u0006\u0005M\u0005bBAK?\u0001\u0007\u0011qS\u0001\fi\u0006\u0014x-\u001a;Ti\u0006$X\r\u0005\u0003\u0002\u001a\u0006=f\u0002BAN\u0003WsA!!(\u0002*:!\u0011qTAT\u001d\u0011\t\t+!*\u000f\u0007-\u000b\u0019+C\u0001/\u0013\taS&\u0003\u0002+W%\u0011A%K\u0005\u0005\u0003[\u000bi\"\u0001\bPa\u0016\u0014\u0018\r^5p]N#\u0018\r^3\n\t\u0005E\u00161\u0017\u0002\u000f\u001fB,'/\u0019;j_:\u001cF/\u0019;f\u0015\u0011\ti+!\b\u0002\u0011M,Go\u0015;bi\u0016$B!!\u0002\u0002:\"9\u00111\u0018\u0011A\u0002\u0005]\u0015\u0001\u00038foN#\u0018\r^3\u0002+M,Go\u00149fe\u0006$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]R!\u0011QAAa\u0011\u001d\t\u0019-\ta\u0001\u0003\u000b\fAa\u001c9FqB\u0019a'a2\n\u0007\u0005%\u0017F\u0001\nLsV,(-[*R\u0019\u0016C8-\u001a9uS>t\u0007")
public class ExecuteStatement
extends SparkOperation {
    private final SparkSession spark;
    private final Session session;
    private final String statement;
    private final boolean shouldRunAsync;
    private final long queryTimeout;
    private final boolean incrementalCollect;
    private final boolean forceCancel;
    private final Option<String> schedulerPool;
    private Option<ScheduledExecutorService> statementTimeoutCleaner;
    private final OperationLog org$apache$kyuubi$engine$spark$operation$ExecuteStatement$$operationLog;
    private final SQLOperationListener operationListener;
    private final SparkStatementEvent statementEvent;

    @Override
    public String statement() {
        return this.statement;
    }

    @Override
    public boolean shouldRunAsync() {
        return this.shouldRunAsync;
    }

    private boolean forceCancel() {
        return this.forceCancel;
    }

    private Option<String> schedulerPool() {
        return this.schedulerPool;
    }

    private Option<ScheduledExecutorService> statementTimeoutCleaner() {
        return this.statementTimeoutCleaner;
    }

    private void statementTimeoutCleaner_$eq(Option<ScheduledExecutorService> x$1) {
        this.statementTimeoutCleaner = x$1;
    }

    public OperationLog org$apache$kyuubi$engine$spark$operation$ExecuteStatement$$operationLog() {
        return this.org$apache$kyuubi$engine$spark$operation$ExecuteStatement$$operationLog;
    }

    @Override
    public Option<OperationLog> getOperationLog() {
        return Option$.MODULE$.apply((Object)this.org$apache$kyuubi$engine$spark$operation$ExecuteStatement$$operationLog());
    }

    private SQLOperationListener operationListener() {
        return this.operationListener;
    }

    public SparkStatementEvent statementEvent() {
        return this.statementEvent;
    }

    @Override
    public StructType resultSchema() {
        return this.result() == null || this.result().schema().isEmpty() ? new StructType().add("Result", "string") : this.result().schema();
    }

    @Override
    public void beforeRun() {
        OperationLog$.MODULE$.setCurrentOperationLog(this.org$apache$kyuubi$engine$spark$operation$ExecuteStatement$$operationLog());
        this.setState(OperationState$.MODULE$.PENDING());
        this.setHasResultSet(true);
    }

    @Override
    public void afterRun() {
        OperationLog$.MODULE$.removeCurrentOperationLog();
    }

    public void org$apache$kyuubi$engine$spark$operation$ExecuteStatement$$executeStatement() {
        this.withLocalProperties((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block8: {
                try {
                    try {
                        FetchIterator fetchIterator;
                        this.setState(OperationState$.MODULE$.RUNNING());
                        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> KyuubiSparkUtil$.MODULE$.diagnostics());
                        Thread.currentThread().setContextClassLoader((ClassLoader)$this.spark.sharedState().jarClassLoader());
                        $this.spark.sparkContext().addSparkListener((SparkListenerInterface)this.operationListener());
                        this.result_$eq((Dataset<Row>)$this.spark.sql(this.statement()));
                        this.statementEvent().queryExecution_$eq(this.result().queryExecution().toString());
                        this.setState(OperationState$.MODULE$.COMPILED());
                        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> this.result().queryExecution());
                        if ($this.incrementalCollect) {
                            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Execute in incremental collect mode");
                            fetchIterator = new IterableFetchIterator(((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(this.result().toLocalIterator()).asScala()).toIterable());
                        } else {
                            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Execute in full collect mode");
                            fetchIterator = new ArrayFetchIterator(this.result().collect());
                        }
                        this.iter_$eq(fetchIterator);
                        this.setState(OperationState$.MODULE$.FINISHED());
                    }
                    catch (Throwable x$1) {
                        PartialFunction<Throwable, BoxedUnit> catchExpr$1 = this.onError(true);
                        if (catchExpr$1.isDefinedAt((Object)x$1)) {
                            catchExpr$1.apply((Object)x$1);
                            break block8;
                        }
                        throw x$1;
                    }
                }
                finally {
                    this.statementTimeoutCleaner().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                        x$2.shutdown();
                        return BoxedUnit.UNIT;
                    });
                }
            }
        });
    }

    @Override
    public void runInternal() {
        this.addTimeoutMonitor();
        if (this.shouldRunAsync()) {
            Runnable asyncOperation = new Runnable(this){
                private final /* synthetic */ ExecuteStatement $outer;

                public void run() {
                    OperationLog$.MODULE$.setCurrentOperationLog(this.$outer.org$apache$kyuubi$engine$spark$operation$ExecuteStatement$$operationLog());
                    this.$outer.org$apache$kyuubi$engine$spark$operation$ExecuteStatement$$executeStatement();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            try {
                SessionManager sparkSQLSessionManager = this.session.sessionManager();
                Future<?> backgroundHandle = sparkSQLSessionManager.submitBackgroundOperation(asyncOperation);
                this.setBackgroundHandle(backgroundHandle);
            }
            catch (RejectedExecutionException rejected) {
                this.setState(OperationState$.MODULE$.ERROR());
                KyuubiSQLException ke = KyuubiSQLException$.MODULE$.apply("Error submitting query in background, query rejected", rejected, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                this.setOperationException(ke);
                throw ke;
            }
        } else {
            this.org$apache$kyuubi$engine$spark$operation$ExecuteStatement$$executeStatement();
        }
    }

    private <T> T withLocalProperties(Function0<T> f) {
        Object object;
        try {
            this.spark.sparkContext().setJobGroup(this.statementId(), this.statement(), this.forceCancel());
            this.spark.sparkContext().setLocalProperty("kyuubi.session.user", this.session.user());
            this.spark.sparkContext().setLocalProperty("kyuubi.statement.id", this.statementId());
            Option<String> option = this.schedulerPool();
            if (option instanceof Some) {
                Some some = (Some)option;
                String pool = (String)some.value();
                this.spark.sparkContext().setLocalProperty("spark.scheduler.pool", pool);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
            object = f.apply();
        }
        finally {
            this.spark.sparkContext().setLocalProperty("spark.scheduler.pool", null);
            this.spark.sparkContext().setLocalProperty("kyuubi.session.user", null);
            this.spark.sparkContext().setLocalProperty("kyuubi.statement.id", null);
            this.spark.sparkContext().clearJobGroup();
        }
        return (T)object;
    }

    private void addTimeoutMonitor() {
        block0: {
            if (this.queryTimeout <= 0L) break block0;
            ScheduledExecutorService timeoutExecutor = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("query-timeout-thread");
            timeoutExecutor.schedule(new Runnable(this){
                private final /* synthetic */ ExecuteStatement $outer;

                public void run() {
                    this.$outer.cleanup(OperationState$.MODULE$.TIMEOUT());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.queryTimeout, TimeUnit.SECONDS);
            this.statementTimeoutCleaner_$eq((Option<ScheduledExecutorService>)new Some((Object)timeoutExecutor));
        }
    }

    @Override
    public void cleanup(Enumeration.Value targetState) {
        this.spark.sparkContext().removeSparkListener((SparkListenerInterface)this.operationListener());
        super.cleanup(targetState);
    }

    @Override
    public void setState(Enumeration.Value newState) {
        block3: {
            block2: {
                super.setState(newState);
                this.statementEvent().state_$eq(newState.toString());
                this.statementEvent().eventTime_$eq(this.lastAccessTime());
                Enumeration.Value value = newState;
                Enumeration.Value value2 = OperationState$.MODULE$.ERROR();
                if (!(value == null ? value2 != null : !value.equals(value2))) break block2;
                Enumeration.Value value3 = newState;
                Enumeration.Value value4 = OperationState$.MODULE$.FINISHED();
                if (value3 != null ? !value3.equals(value4) : value4 != null) break block3;
            }
            this.statementEvent().completeTime_$eq(System.currentTimeMillis());
        }
        EventLoggingService$.MODULE$.onEvent(this.statementEvent());
    }

    @Override
    public void setOperationException(KyuubiSQLException opEx) {
        super.setOperationException(opEx);
        this.statementEvent().exception_$eq(opEx.toString());
        EventLoggingService$.MODULE$.onEvent(this.statementEvent());
    }

    public ExecuteStatement(SparkSession spark, Session session, String statement, boolean shouldRunAsync, long queryTimeout, boolean incrementalCollect) {
        this.spark = spark;
        this.session = session;
        this.statement = statement;
        this.shouldRunAsync = shouldRunAsync;
        this.queryTimeout = queryTimeout;
        this.incrementalCollect = incrementalCollect;
        super(spark, OperationType$.MODULE$.EXECUTE_STATEMENT(), session);
        this.forceCancel = BoxesRunTime.unboxToBoolean((Object)session.sessionManager().getConf().get(KyuubiConf$.MODULE$.OPERATION_FORCE_CANCEL()));
        this.schedulerPool = spark.conf().getOption(KyuubiConf$.MODULE$.OPERATION_SCHEDULER_POOL().key()).orElse((Function0 & Serializable & scala.Serializable)() -> (Option)$this.session.sessionManager().getConf().get(KyuubiConf$.MODULE$.OPERATION_SCHEDULER_POOL()));
        this.statementTimeoutCleaner = None$.MODULE$;
        this.org$apache$kyuubi$engine$spark$operation$ExecuteStatement$$operationLog = OperationLog$.MODULE$.createOperationLog(session, this.getHandle());
        this.operationListener = new SQLOperationListener(this, spark);
        this.statementEvent = new SparkStatementEvent(session.user(), this.statementId(), statement, spark.sparkContext().applicationId(), session.handle().identifier().toString(), this.lastAccessTime(), this.state().toString(), this.lastAccessTime(), SparkStatementEvent$.MODULE$.apply$default$9(), SparkStatementEvent$.MODULE$.apply$default$10(), SparkStatementEvent$.MODULE$.apply$default$11());
        EventLoggingService$.MODULE$.onEvent(this.statementEvent());
    }
}

