/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.metadata.jdbc;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.google.common.annotations.VisibleForTesting;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.server.metadata.MetadataStore;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.metadata.api.Metadata$;
import org.apache.kyuubi.server.metadata.api.MetadataFilter;
import org.apache.kyuubi.server.metadata.jdbc.DatabaseType$;
import org.apache.kyuubi.server.metadata.jdbc.GenericDatabaseDialect;
import org.apache.kyuubi.server.metadata.jdbc.JDBCMetadataStore$;
import org.apache.kyuubi.server.metadata.jdbc.JDBCMetadataStoreConf$;
import org.apache.kyuubi.server.metadata.jdbc.MySQLDatabaseDialect;
import org.apache.kyuubi.server.metadata.jdbc.PostgreSQLDatabaseDialect;
import org.apache.kyuubi.server.metadata.jdbc.SQLiteDatabaseDialect;
import org.apache.kyuubi.session.SessionType$;
import org.apache.kyuubi.util.JdbcUtils$;
import org.apache.kyuubi.util.reflect.ReflectUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\r\u0005d\u0001B\u001d;\u0001\u001dC\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\u0006?\u0002!\t\u0001\u0019\u0005\bI\u0002\u0011\r\u0011\"\u0003f\u0011\u0019\u0001\b\u0001)A\u0005M\"9\u0011\u000f\u0001b\u0001\n\u0013\u0011\bbBA\u0003\u0001\u0001\u0006Ia\u001d\u0005\u000b\u0003\u000f\u0001\u0001R1A\u0005\n\u0005%\u0001\"CA\b\u0001\t\u0007I\u0011BA\t\u0011\u001d\t\u0019\u0002\u0001Q\u0001\n]D\u0011\"!\u0006\u0001\u0005\u0004%I!a\u0006\t\u0011\u0005}\u0001\u0001)A\u0005\u00033A\u0011\"!\t\u0001\u0005\u0004%I!a\t\t\u0011\u0005-\u0002\u0001)A\u0005\u0003KA\u0011\"!\f\u0001\u0005\u0004%I!a\f\t\u0011\u0005u\u0002\u0001)A\u0005\u0003cA\u0011\"a\u0010\u0001\u0005\u0004%I!!\u0011\t\u0011\u0005]\u0003\u0001)A\u0005\u0003\u0007B!\"!\u0017\u0001\u0005\u0004%\u0019\u0001QA.\u0011!\t\u0019\u0007\u0001Q\u0001\n\u0005u\u0003\"CA>\u0001\t\u0007I\u0011BA?\u0011!\t\u0019\n\u0001Q\u0001\n\u0005}\u0004\"CAK\u0001\t\u0007I\u0011BA\t\u0011\u001d\t9\n\u0001Q\u0001\n]Dq!!'\u0001\t\u0013\tY\n\u0003\u0005\u0002$\u0002!\tAOAS\u0011\u001d\tY\r\u0001C\u0001\u0003\u001bDq!a8\u0001\t\u0003\t\t\u000fC\u0004\u0002z\u0002!\t%a'\t\u000f\u0005m\b\u0001\"\u0011\u0002~\"9!Q\u0002\u0001\u0005B\t=\u0001b\u0002B\f\u0001\u0011\u0005#\u0011\u0004\u0005\b\u0005O\u0001A\u0011\tB\u0015\u0011\u001d\u0011i\u0003\u0001C!\u0005_A\u0011B!\u0013\u0001#\u0003%\tAa\u0013\t\u000f\t\u0005\u0004\u0001\"\u0011\u0003d!9!q\r\u0001\u0005\n\t%\u0004b\u0002BD\u0001\u0011\u0005#\u0011\u0012\u0005\b\u0005\u001b\u0003A\u0011\tBH\u0011\u001d\u0011\u0019\n\u0001C!\u0005+CqA!)\u0001\t\u0013\u0011\u0019\u000bC\u0004\u00036\u0002!IAa.\t\u000f\t5\u0007\u0001\"\u0003\u0003P\"9!Q\u001f\u0001\u0005\n\t]\bbBB\u0006\u0001\u0011%1Q\u0002\u0005\b\u00077\u0001A\u0011BB\u000f\u0011\u001d\u0019\u0019\u0003\u0001C\u0005\u0007KAqa!\r\u0001\t\u0013\u0019\u0019dB\u0004\u00048iB\ta!\u000f\u0007\reR\u0004\u0012AB\u001e\u0011\u0019y\u0016\u0007\"\u0001\u0004D!I1QI\u0019C\u0002\u0013%1q\t\u0005\t\u0007/\n\u0004\u0015!\u0003\u0004J!I1\u0011L\u0019C\u0002\u0013%\u0011\u0011\u0002\u0005\t\u00077\n\u0004\u0015!\u0003\u0002\f!I1QL\u0019C\u0002\u0013%\u0011\u0011\u0003\u0005\b\u0007?\n\u0004\u0015!\u0003x\u0005EQEIQ\"NKR\fG-\u0019;b'R|'/\u001a\u0006\u0003wq\nAA\u001b3cG*\u0011QHP\u0001\t[\u0016$\u0018\rZ1uC*\u0011q\bQ\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\u0005\u0013\u0015AB6zkV\u0014\u0017N\u0003\u0002D\t\u00061\u0011\r]1dQ\u0016T\u0011!R\u0001\u0004_J<7\u0001A\n\u0005\u0001!\u0003F\u000b\u0005\u0002J\u001d6\t!J\u0003\u0002L\u0019\u0006!A.\u00198h\u0015\u0005i\u0015\u0001\u00026bm\u0006L!a\u0014&\u0003\r=\u0013'.Z2u!\t\t&+D\u0001=\u0013\t\u0019FHA\u0007NKR\fG-\u0019;b'R|'/\u001a\t\u0003+Zk\u0011\u0001Q\u0005\u0003/\u0002\u0013q\u0001T8hO&tw-\u0001\u0003d_:4\u0007C\u0001.^\u001b\u0005Y&B\u0001/A\u0003\u0019\u0019wN\u001c4jO&\u0011al\u0017\u0002\u000b\u0017f,XOY5D_:4\u0017A\u0002\u001fj]&$h\b\u0006\u0002bGB\u0011!\rA\u0007\u0002u!)\u0001L\u0001a\u00013\u00061AM\u0019+za\u0016,\u0012A\u001a\t\u0003O*t!A\u00195\n\u0005%T\u0014\u0001\u0004#bi\u0006\u0014\u0017m]3UsB,\u0017BA6m\u0005\u00151\u0016\r\\;f\u0013\tigNA\u0006F]VlWM]1uS>t'\"A8\u0002\u000bM\u001c\u0017\r\\1\u0002\u000f\u0011\u0014G+\u001f9fA\u0005qAM]5wKJ\u001cE.Y:t\u001fB$X#A:\u0011\u0007Q,x/D\u0001o\u0013\t1hN\u0001\u0004PaRLwN\u001c\t\u0003q~t!!_?\u0011\u0005itW\"A>\u000b\u0005q4\u0015A\u0002\u001fs_>$h(\u0003\u0002\u007f]\u00061\u0001K]3eK\u001aLA!!\u0001\u0002\u0004\t11\u000b\u001e:j]\u001eT!A 8\u0002\u001f\u0011\u0014\u0018N^3s\u00072\f7o](qi\u0002\n\u0001#\\=tc2$%/\u001b<fe\u000ec\u0017m]:\u0016\u0005\u0005-\u0001cA%\u0002\u000e%\u0019\u0011\u0011\u0001&\u0002\u0017\u0011\u0014\u0018N^3s\u00072\f7o]\u000b\u0002o\u0006aAM]5wKJ\u001cE.Y:tA\u00059A-[1mK\u000e$XCAA\r!\r\u0011\u00171D\u0005\u0004\u0003;Q$AF$f]\u0016\u0014\u0018n\u0019#bi\u0006\u0014\u0017m]3ES\u0006dWm\u0019;\u0002\u0011\u0011L\u0017\r\\3di\u0002\nq\u0002\u001d:j_JLG/_#oC\ndW\rZ\u000b\u0003\u0003K\u00012\u0001^A\u0014\u0013\r\tIC\u001c\u0002\b\u0005>|G.Z1o\u0003A\u0001(/[8sSRLXI\\1cY\u0016$\u0007%\u0001\u000beCR\f7o\\;sG\u0016\u0004&o\u001c9feRLWm]\u000b\u0003\u0003c\u0001B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003oa\u0015\u0001B;uS2LA!a\u000f\u00026\tQ\u0001K]8qKJ$\u0018.Z:\u0002+\u0011\fG/Y:pkJ\u001cW\r\u0015:pa\u0016\u0014H/[3tA\u0005a\u0001.[6be&\u001cuN\u001c4jOV\u0011\u00111\t\t\u0005\u0003\u000b\n\u0019&\u0004\u0002\u0002H)!\u0011\u0011JA&\u0003\u0019A\u0017n[1sS*!\u0011QJA(\u0003\u0019Q\u0018\r\u001f=fe*\u0011\u0011\u0011K\u0001\u0004G>l\u0017\u0002BA+\u0003\u000f\u0012A\u0002S5lCJL7i\u001c8gS\u001e\fQ\u0002[5lCJL7i\u001c8gS\u001e\u0004\u0013\u0001\u00055jW\u0006\u0014\u0018\u000eR1uCN{WO]2f+\t\ti\u0006\u0005\u0003\u0002F\u0005}\u0013\u0002BA1\u0003\u000f\u0012\u0001\u0003S5lCJLG)\u0019;b'>,(oY3\u0002#!L7.\u0019:j\t\u0006$\u0018mU8ve\u000e,\u0007\u0005K\u0002\u0014\u0003O\u0002B!!\u001b\u0002x5\u0011\u00111\u000e\u0006\u0005\u0003[\ny'A\u0006b]:|G/\u0019;j_:\u001c(\u0002BA9\u0003g\naaY8n[>t'\u0002BA;\u0003\u001f\naaZ8pO2,\u0017\u0002BA=\u0003W\u0012\u0011CV5tS\ndWMR8s)\u0016\u001cH/\u001b8h\u0003\u0019i\u0017\r\u001d9feV\u0011\u0011q\u0010\t\u0005\u0003\u0003\u000by)\u0004\u0002\u0002\u0004*!\u0011QQAD\u0003!!\u0017\r^1cS:$'\u0002BAE\u0003\u0017\u000bqA[1dWN|gN\u0003\u0003\u0002\u000e\u0006=\u0013!\u00034bgR,'\u000f_7m\u0013\u0011\t\t*a!\u0003\u0019=\u0013'.Z2u\u001b\u0006\u0004\b/\u001a:\u0002\u000f5\f\u0007\u000f]3sA\u0005qA/\u001a:nS:\fGn\u0015;bi\u0016\u001c\u0018a\u0004;fe6Lg.\u00197Ti\u0006$Xm\u001d\u0011\u0002\u0015%t\u0017\u000e^*dQ\u0016l\u0017\r\u0006\u0002\u0002\u001eB\u0019A/a(\n\u0007\u0005\u0005fN\u0001\u0003V]&$\u0018!D4fi&s\u0017\u000e^*dQ\u0016l\u0017\rF\u0002t\u0003OCa\u0001Z\rA\u0002\u0005%\u0006\u0003BAV\u0003\u000bt1!!,i\u001d\u0011\ty+a1\u000f\t\u0005E\u0016\u0011\u0019\b\u0005\u0003g\u000byL\u0004\u0003\u00026\u0006uf\u0002BA\\\u0003ws1A_A]\u0013\u0005)\u0015BA\"E\u0013\t\t%)\u0003\u0002@\u0001&\u0011QHP\u0005\u0003wqJA!a2\u0002J\naA)\u0019;bE\u0006\u001cX\rV=qK*\u0011\u0011NO\u0001\u0011O\u0016$8k\u00195f[\u00064VM]:j_:$B!a4\u0002\\BIA/!5\u0002V\u0006U\u0017Q[\u0005\u0004\u0003't'A\u0002+va2,7\u0007E\u0002u\u0003/L1!!7o\u0005\rIe\u000e\u001e\u0005\u0007\u0003;T\u0002\u0019A<\u0002\u0013M\u001c\u0007.Z7b+Jd\u0017AE4fi2\u000bG/Z:u'\u000eDW-\\1Ve2$2a]Ar\u0011\u001d\t)o\u0007a\u0001\u0003O\f!b]2iK6\fWK\u001d7t!\u0015\tI/a=x\u001d\u0011\tY/a<\u000f\u0007i\fi/C\u0001p\u0013\r\t\tP\\\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)0a>\u0003\u0007M+\u0017OC\u0002\u0002r:\fQa\u00197pg\u0016\fa\"\u001b8tKJ$X*\u001a;bI\u0006$\u0018\r\u0006\u0003\u0002\u001e\u0006}\bBB\u001f\u001e\u0001\u0004\u0011\t\u0001\u0005\u0003\u0003\u0004\t%QB\u0001B\u0003\u0015\r\u00119\u0001P\u0001\u0004CBL\u0017\u0002\u0002B\u0006\u0005\u000b\u0011\u0001\"T3uC\u0012\fG/Y\u0001\ra&\u001c7.T3uC\u0012\fG/\u0019\u000b\u0005\u0005#\u0011\u0019\u0002\u0005\u0003uk\n\u0005\u0001B\u0002B\u000b=\u0001\u0007q/\u0001\blsV,(-[%ogR\fgnY3\u0002-Q\u0014\u0018M\\:g_JlW*\u001a;bI\u0006$\u0018m\u0015;bi\u0016$\u0002\"!\n\u0003\u001c\t}!1\u0005\u0005\u0007\u0005;y\u0002\u0019A<\u0002\u0015%$WM\u001c;jM&,'\u000f\u0003\u0004\u0003\"}\u0001\ra^\u0001\nMJ|Wn\u0015;bi\u0016DaA!\n \u0001\u00049\u0018a\u0003;be\u001e,Go\u0015;bi\u0016\f1bZ3u\u001b\u0016$\u0018\rZ1uCR!!\u0011\u0001B\u0016\u0011\u0019\u0011i\u0002\ta\u0001o\u0006yq-\u001a;NKR\fG-\u0019;b\u0019&\u001cH\u000f\u0006\u0006\u00032\tM\"Q\bB!\u0005\u000b\u0002b!!;\u0002t\n\u0005\u0001b\u0002B\u001bC\u0001\u0007!qG\u0001\u0007M&dG/\u001a:\u0011\t\t\r!\u0011H\u0005\u0005\u0005w\u0011)A\u0001\bNKR\fG-\u0019;b\r&dG/\u001a:\t\u000f\t}\u0012\u00051\u0001\u0002V\u0006!aM]8n\u0011\u001d\u0011\u0019%\ta\u0001\u0003+\fAa]5{K\"I!qI\u0011\u0011\u0002\u0003\u0007\u0011QE\u0001\u0005I\u0016\u001c8-A\rhKRlU\r^1eCR\fG*[:uI\u0011,g-Y;mi\u0012\"TC\u0001B'U\u0011\t)Ca\u0014,\u0005\tE\u0003\u0003\u0002B*\u0005;j!A!\u0016\u000b\t\t]#\u0011L\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0017o\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005?\u0012)FA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQbY8v]RlU\r^1eCR\fG\u0003BAk\u0005KBqA!\u000e$\u0001\u0004\u00119$A\nbgN,WN\u00197f/\",'/Z\"mCV\u001cX\rF\u0003x\u0005W\u0012i\u0007C\u0004\u00036\u0011\u0002\rAa\u000e\t\u000f\t=D\u00051\u0001\u0003r\u00051\u0001/\u0019:b[N\u0004bAa\u001d\u0003~\t\u0005UB\u0001B;\u0015\u0011\u00119H!\u001f\u0002\u000f5,H/\u00192mK*\u0019!1\u00108\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u0000\tU$A\u0003'jgR\u0014UO\u001a4feB\u0019AOa!\n\u0007\t\u0015eNA\u0002B]f\fa\"\u001e9eCR,W*\u001a;bI\u0006$\u0018\r\u0006\u0003\u0002\u001e\n-\u0005BB\u001f&\u0001\u0004\u0011\t!A\u000edY\u0016\fg.\u001e9NKR\fG-\u0019;b\u0005fLE-\u001a8uS\u001aLWM\u001d\u000b\u0005\u0003;\u0013\t\n\u0003\u0004\u0003\u001e\u0019\u0002\ra^\u0001\u0015G2,\u0017M\\;q\u001b\u0016$\u0018\rZ1uC\nK\u0018iZ3\u0015\t\u0005u%q\u0013\u0005\b\u00053;\u0003\u0019\u0001BN\u0003\u0019i\u0017\r_!hKB\u0019AO!(\n\u0007\t}eN\u0001\u0003M_:<\u0017!\u00042vS2$W*\u001a;bI\u0006$\u0018\r\u0006\u0003\u00032\t\u0015\u0006b\u0002BTQ\u0001\u0007!\u0011V\u0001\ne\u0016\u001cX\u000f\u001c;TKR\u0004BAa+\u000326\u0011!Q\u0016\u0006\u0004\u0005_c\u0015aA:rY&!!1\u0017BW\u0005%\u0011Vm];miN+G/A\u0004fq\u0016\u001cW\u000f^3\u0015\u0011\u0005u%\u0011\u0018Bb\u0005\u000bDqAa/*\u0001\u0004\u0011i,\u0001\u0003d_:t\u0007\u0003\u0002BV\u0005\u007fKAA!1\u0003.\nQ1i\u001c8oK\u000e$\u0018n\u001c8\t\r\t=\u0016\u00061\u0001x\u0011\u001d\u0011y'\u000ba\u0001\u0005\u000f\u0004R\u0001\u001eBe\u0005\u0003K1Aa3o\u0005)a$/\u001a9fCR,GMP\u0001\u000eo&$\bNU3tk2$8+\u001a;\u0016\t\tE'\u0011\u001c\u000b\t\u0005'\u0014yO!=\u0003tR!!Q\u001bBs!\u0011\u00119N!7\r\u0001\u00119!1\u001c\u0016C\u0002\tu'!\u0001+\u0012\t\t}'\u0011\u0011\t\u0004i\n\u0005\u0018b\u0001Br]\n9aj\u001c;iS:<\u0007b\u0002BtU\u0001\u0007!\u0011^\u0001\u0002MB9AOa;\u0003*\nU\u0017b\u0001Bw]\nIa)\u001e8di&|g.\r\u0005\b\u0005wS\u0003\u0019\u0001B_\u0011\u0019\u0011yK\u000ba\u0001o\"9!q\u000e\u0016A\u0002\t\u001d\u0017aD<ji\",\u0006\u000fZ1uK\u000e{WO\u001c;\u0016\t\te(q \u000b\t\u0005w\u001c)aa\u0002\u0004\nQ!!Q`B\u0001!\u0011\u00119Na@\u0005\u000f\tm7F1\u0001\u0003^\"9!q]\u0016A\u0002\r\r\u0001c\u0002;\u0003l\u0006U'Q \u0005\b\u0005w[\u0003\u0019\u0001B_\u0011\u0019\u0011yk\u000ba\u0001o\"9!qN\u0016A\u0002\t\u001d\u0017AE:fiN#\u0018\r^3nK:$\b+\u0019:b[N$b!!(\u0004\u0010\re\u0001bBB\tY\u0001\u000711C\u0001\ngR\fG/Z7f]R\u0004BAa+\u0004\u0016%!1q\u0003BW\u0005E\u0001&/\u001a9be\u0016$7\u000b^1uK6,g\u000e\u001e\u0005\b\u0005_b\u0003\u0019\u0001Bd\u000351\u0018\r\\;f\u0003N\u001cFO]5oOR\u0019qoa\b\t\u000f\r\u0005R\u00061\u0001\u0003\u0002\u0006\u0019qN\u00196\u0002\u0015M$(/\u001b8he5\u000b\u0007\u000f\u0006\u0003\u0004(\r5\u0002#\u0002=\u0004*]<\u0018\u0002BB\u0016\u0003\u0007\u00111!T1q\u0011\u0019\u0019yC\fa\u0001o\u0006\u00191\u000f\u001e:\u0002\u0015M$(/\u001b8heM+\u0017\u000f\u0006\u0003\u0002h\u000eU\u0002BBB\u0018_\u0001\u0007q/A\tK\t\n\u001bU*\u001a;bI\u0006$\u0018m\u0015;pe\u0016\u0004\"AY\u0019\u0014\u0007E\u001ai\u0004E\u0002u\u0007\u007fI1a!\u0011o\u0005\u0019\te.\u001f*fMR\u00111\u0011H\u0001\u0013'\u000eCU)T!`+Jcu\fU!U)\u0016\u0013f*\u0006\u0002\u0004JA!11JB*\u001b\t\u0019iE\u0003\u0003\u0004P\rE\u0013\u0001C7bi\u000eD\u0017N\\4\u000b\u0007\u0005]b.\u0003\u0003\u0004V\r5#!\u0002*fO\u0016D\u0018aE*D\u0011\u0016k\u0015iX+S\u0019~\u0003\u0016\t\u0016+F%:\u0003\u0013AD'F)\u0006#\u0015\tV!`)\u0006\u0013E*R\u0001\u0010\u001b\u0016#\u0016\tR!U\u0003~#\u0016I\u0011'FA\u0005\u0001R*\u0012+B\t\u0006#\u0016iX\"P\u0019VkejU\u0001\u0012\u001b\u0016#\u0016\tR!U\u0003~\u001bu\nT+N\u001dN\u0003\u0003")
public class JDBCMetadataStore
implements MetadataStore,
Logging {
    private String mysqlDriverClass;
    private final Enumeration.Value dbType;
    private final Option<String> driverClassOpt;
    private final String driverClass;
    private final GenericDatabaseDialect dialect;
    private final boolean priorityEnabled;
    private final Properties datasourceProperties;
    private final HikariConfig hikariConfig;
    @VisibleForTesting
    private final HikariDataSource hikariDataSource;
    private final ObjectMapper mapper;
    private final String terminalStates;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private Enumeration.Value dbType() {
        return this.dbType;
    }

    private Option<String> driverClassOpt() {
        return this.driverClassOpt;
    }

    private String mysqlDriverClass$lzycompute() {
        JDBCMetadataStore jDBCMetadataStore = this;
        synchronized (jDBCMetadataStore) {
            if (!this.bitmap$0) {
                this.mysqlDriverClass = ReflectUtils$.MODULE$.isClassLoadable("com.mysql.cj.jdbc.Driver", ReflectUtils$.MODULE$.isClassLoadable$default$2()) ? "com.mysql.cj.jdbc.Driver" : "com.mysql.jdbc.Driver";
                this.bitmap$0 = true;
            }
        }
        return this.mysqlDriverClass;
    }

    private String mysqlDriverClass() {
        if (!this.bitmap$0) {
            return this.mysqlDriverClass$lzycompute();
        }
        return this.mysqlDriverClass;
    }

    private String driverClass() {
        return this.driverClass;
    }

    private GenericDatabaseDialect dialect() {
        return this.dialect;
    }

    private boolean priorityEnabled() {
        return this.priorityEnabled;
    }

    private Properties datasourceProperties() {
        return this.datasourceProperties;
    }

    private HikariConfig hikariConfig() {
        return this.hikariConfig;
    }

    public HikariDataSource hikariDataSource() {
        return this.hikariDataSource;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    private String terminalStates() {
        return this.terminalStates;
    }

    private void initSchema() {
        this.getInitSchema(this.dbType()).foreach((Function1 & Serializable & scala.Serializable)schema -> {
            JDBCMetadataStore.$anonfun$initSchema$1(this, schema);
            return BoxedUnit.UNIT;
        });
    }

    public Option<String> getInitSchema(Enumeration.Value dbType) {
        ClassLoader classLoader = Utils$.MODULE$.getContextOrKyuubiClassLoader();
        String schemaPackage = new java.lang.StringBuilder(4).append("sql/").append(dbType.toString().toLowerCase()).toString();
        return Option$.MODULE$.apply((Object)classLoader.getResource(schemaPackage)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toURI()).flatMap((Function1 & Serializable & scala.Serializable)uri -> {
            String[] stringArray;
            String string = uri.getScheme();
            String string2 = "jar";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                try (FileSystem fs = FileSystems.newFileSystem(uri, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava());){
                    stringArray = (String[])((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(fs.getPath(schemaPackage, new String[0]), 1, new FileVisitOption[0]).iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> ((Object)x$3.getFileName()).toString()).filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$getInitSchema$4(name))).toArray(ClassTag$.MODULE$.apply(String.class));
                }
            } else {
                stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Paths.get(uri).toFile().listFiles((x$4, name) -> JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$SCHEMA_URL_PATTERN().findFirstMatchIn((CharSequence)name).isDefined()))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            }
            String[] pathNames = stringArray;
            return this.getLatestSchemaUrl((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])pathNames)).map((Function1 & Serializable & scala.Serializable)name -> new java.lang.StringBuilder(1).append(schemaPackage).append("/").append((String)name).toString()).map((Function1 & Serializable & scala.Serializable)schemaUrl -> {
                String string;
                try (InputStream inputStream = classLoader.getResourceAsStream((String)schemaUrl);){
                    string = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
                }
                return string;
            });
        });
    }

    public Tuple3<Object, Object, Object> getSchemaVersion(String schemaUrl) {
        Option option = JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$SCHEMA_URL_PATTERN().findFirstMatchIn((CharSequence)schemaUrl);
        if (option instanceof Some) {
            Some some = (Some)option;
            Regex.Match m = (Regex.Match)some.value();
            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(m.group(1))).toInt()), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(m.group(2))).toInt()), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(m.group(3))).toInt()));
        }
        throw new KyuubiException(new java.lang.StringBuilder(20).append("Invalid schema url: ").append(schemaUrl).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
    }

    public Option<String> getLatestSchemaUrl(Seq<String> schemaUrls) {
        return ((TraversableLike)schemaUrls.sortWith((Function2 & Serializable & scala.Serializable)(u1, u2) -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$getLatestSchemaUrl$1(this, u1, u2)))).headOption();
    }

    @Override
    public void close() {
        this.hikariDataSource().close();
    }

    @Override
    public void insertMetadata(Metadata metadata) {
        String query = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(472).append("\n         |INSERT INTO ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append("(\n         |identifier,\n         |session_type,\n         |real_user,\n         |user_name,\n         |ip_address,\n         |kyuubi_instance,\n         |state,\n         |resource,\n         |class_name,\n         |request_name,\n         |request_conf,\n         |request_args,\n         |create_time,\n         |engine_type,\n         |cluster_manager,\n         |priority\n         |)\n         |VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n         |").toString())).stripMargin();
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            this.execute(connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metadata.identifier(), metadata.sessionType().toString(), metadata.realUser(), metadata.username(), metadata.ipAddress(), metadata.kyuubiInstance(), metadata.state(), metadata.resource(), metadata.className(), metadata.requestName(), this.valueAsString(metadata.requestConf()), this.valueAsString(metadata.requestArgs()), BoxesRunTime.boxToLong((long)metadata.createTime()), Option$.MODULE$.apply((Object)metadata.engineType()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toUpperCase(Locale.ROOT)).orNull(Predef$.MODULE$.$conforms()), metadata.clusterManager().orNull(Predef$.MODULE$.$conforms()), BoxesRunTime.boxToInteger((int)metadata.priority())}));
            return BoxedUnit.UNIT;
        }, (DataSource)this.hikariDataSource());
    }

    @Override
    public synchronized Option<Metadata> pickMetadata(String kyuubiInstance) {
        return JdbcUtils$.MODULE$.executeQueryWithRowMapper(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(101).append("SELECT identifier FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append("\n         |WHERE state=?\n         |ORDER BY ").append((Object)(this.priorityEnabled() ? "priority DESC, " : "")).append("create_time ASC LIMIT 1\n         |").toString())).stripMargin(), (Function1 & Serializable & scala.Serializable)stmt -> {
            stmt.setString(1, OperationState$.MODULE$.INITIALIZED().toString());
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)resultSet -> resultSet.getString(1), (DataSource)this.hikariDataSource()).headOption().filter((Function1 & Serializable & scala.Serializable)preSelectedBatchId -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$pickMetadata$3(this, kyuubiInstance, preSelectedBatchId))).map((Function1 & Serializable & scala.Serializable)pickedBatchId -> this.getMetadata((String)pickedBatchId));
    }

    @Override
    public boolean transformMetadataState(String identifier, String fromState, String targetState) {
        String query = new java.lang.StringBuilder(56).append("UPDATE ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" SET state = ? WHERE identifier = ? AND state = ?").toString();
        return BoxesRunTime.unboxToBoolean((Object)JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$transformMetadataState$1(this, query, fromState, identifier, targetState, connection)), (DataSource)this.hikariDataSource()));
    }

    @Override
    public Metadata getMetadata(String identifier) {
        String query = new java.lang.StringBuilder(34).append("SELECT ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_COLUMNS()).append(" FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" WHERE identifier = ?").toString();
        return (Metadata)JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> (Metadata)this.withResultSet((Connection)connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{identifier}), (Function1 & Serializable & scala.Serializable)rs -> (Metadata)this.buildMetadata((ResultSet)rs).headOption().orNull(Predef$.MODULE$.$conforms())), (DataSource)this.hikariDataSource());
    }

    @Override
    public Seq<Metadata> getMetadataList(MetadataFilter filter, int from, int size, boolean desc) {
        StringBuilder queryBuilder = new StringBuilder();
        ListBuffer params = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        queryBuilder.append("SELECT ");
        queryBuilder.append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_COLUMNS());
        queryBuilder.append(new java.lang.StringBuilder(6).append(" FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).toString());
        queryBuilder.append(new java.lang.StringBuilder(1).append(" ").append(this.assembleWhereClause(filter, (ListBuffer<Object>)params)).toString());
        queryBuilder.append(" ORDER BY key_id ");
        queryBuilder.append(desc ? "DESC " : "ASC ");
        queryBuilder.append(this.dialect().limitClause(size, from));
        String query = queryBuilder.toString();
        return (Seq)JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> (Seq)this.withResultSet((Connection)connection, query, (Seq<Object>)params.toSeq(), (Function1 & Serializable & scala.Serializable)rs -> this.buildMetadata((ResultSet)rs)), (DataSource)this.hikariDataSource());
    }

    @Override
    public boolean getMetadataList$default$4() {
        return false;
    }

    @Override
    public int countMetadata(MetadataFilter filter) {
        StringBuilder queryBuilder = new StringBuilder();
        ListBuffer params = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        queryBuilder.append(new java.lang.StringBuilder(21).append("SELECT COUNT(1) FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).toString());
        queryBuilder.append(new java.lang.StringBuilder(1).append(" ").append(this.assembleWhereClause(filter, (ListBuffer<Object>)params)).toString());
        String query = queryBuilder.toString();
        return BoxesRunTime.unboxToInt((Object)JdbcUtils$.MODULE$.executeQueryWithRowMapper(query, (Function1 & Serializable & scala.Serializable)stmt -> {
            this.setStatementParams(stmt, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params}));
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)resultSet -> BoxesRunTime.boxToInteger((int)resultSet.getInt(1)), (DataSource)this.hikariDataSource()).head());
    }

    private String assembleWhereClause(MetadataFilter filter, ListBuffer<Object> params) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        ListBuffer whereConditions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1 = 1"}));
        Option$.MODULE$.apply((Object)filter.sessionType()).foreach((Function1 & Serializable & scala.Serializable)sessionType -> {
            whereConditions.$plus$eq((Object)"session_type = ?");
            return params.$plus$eq((Object)sessionType.toString());
        });
        Option$.MODULE$.apply((Object)filter.engineType()).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$assembleWhereClause$2(x$7))).foreach((Function1 & Serializable & scala.Serializable)engineType -> {
            whereConditions.$plus$eq((Object)"UPPER(engine_type) = ?");
            return params.$plus$eq((Object)engineType.toUpperCase(Locale.ROOT));
        });
        Option$.MODULE$.apply((Object)filter.username()).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$assembleWhereClause$4(x$8))).foreach((Function1 & Serializable & scala.Serializable)username -> {
            whereConditions.$plus$eq((Object)"user_name = ?");
            return params.$plus$eq(username);
        });
        Option$.MODULE$.apply((Object)filter.state()).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$assembleWhereClause$6(x$9))).foreach((Function1 & Serializable & scala.Serializable)state -> {
            whereConditions.$plus$eq((Object)"state = ?");
            return params.$plus$eq((Object)state.toUpperCase(Locale.ROOT));
        });
        Option$.MODULE$.apply((Object)filter.requestName()).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$assembleWhereClause$8(x$10))).foreach((Function1 & Serializable & scala.Serializable)requestName -> {
            whereConditions.$plus$eq((Object)"request_name = ?");
            return params.$plus$eq(requestName);
        });
        Option$.MODULE$.apply((Object)filter.kyuubiInstance()).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$assembleWhereClause$10(x$11))).foreach((Function1 & Serializable & scala.Serializable)kyuubiInstance -> {
            whereConditions.$plus$eq((Object)"kyuubi_instance = ?");
            return params.$plus$eq(kyuubiInstance);
        });
        if (filter.createTime() > 0L) {
            whereConditions.$plus$eq((Object)"create_time >= ?");
            boxedUnit3 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)filter.createTime()));
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (filter.endTime() > 0L) {
            whereConditions.$plus$eq((Object)"end_time > 0");
            whereConditions.$plus$eq((Object)"end_time <= ?");
            boxedUnit2 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)filter.endTime()));
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (filter.peerInstanceClosed()) {
            whereConditions.$plus$eq((Object)"peer_instance_closed = ?");
            boxedUnit = params.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)filter.peerInstanceClosed()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return whereConditions.mkString("WHERE ", " AND ", "");
    }

    @Override
    public void updateMetadata(Metadata metadata) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        StringBuilder queryBuilder = new StringBuilder();
        ListBuffer params = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        queryBuilder.append(new java.lang.StringBuilder(7).append("UPDATE ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).toString());
        ListBuffer setClauses = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Option$.MODULE$.apply((Object)metadata.kyuubiInstance()).foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            setClauses.$plus$eq((Object)"kyuubi_instance = ?");
            return params.$plus$eq((Object)metadata.kyuubiInstance());
        });
        Option$.MODULE$.apply((Object)metadata.state()).foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            setClauses.$plus$eq((Object)"state = ?");
            return params.$plus$eq((Object)metadata.state());
        });
        Option$.MODULE$.apply(metadata.requestConf()).filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.nonEmpty())).foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            setClauses.$plus$eq((Object)"request_conf =?");
            return params.$plus$eq((Object)this.valueAsString(metadata.requestConf()));
        });
        metadata.clusterManager().foreach((Function1 & Serializable & scala.Serializable)cm -> {
            setClauses.$plus$eq((Object)"cluster_manager = ?");
            return params.$plus$eq(cm);
        });
        if (metadata.endTime() > 0L) {
            setClauses.$plus$eq((Object)"end_time = ?");
            boxedUnit3 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)metadata.endTime()));
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (metadata.engineOpenTime() > 0L) {
            setClauses.$plus$eq((Object)"engine_open_time = ?");
            boxedUnit2 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)metadata.engineOpenTime()));
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Option$.MODULE$.apply((Object)metadata.engineId()).foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
            setClauses.$plus$eq((Object)"engine_id = ?");
            return params.$plus$eq((Object)metadata.engineId());
        });
        Option$.MODULE$.apply((Object)metadata.engineName()).foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
            setClauses.$plus$eq((Object)"engine_name = ?");
            return params.$plus$eq((Object)metadata.engineName());
        });
        Option$.MODULE$.apply((Object)metadata.engineUrl()).foreach((Function1 & Serializable & scala.Serializable)x$18 -> {
            setClauses.$plus$eq((Object)"engine_url = ?");
            return params.$plus$eq((Object)metadata.engineUrl());
        });
        Option$.MODULE$.apply((Object)metadata.engineState()).foreach((Function1 & Serializable & scala.Serializable)x$19 -> {
            setClauses.$plus$eq((Object)"engine_state = ?");
            return params.$plus$eq((Object)metadata.engineState());
        });
        metadata.engineError().foreach((Function1 & Serializable & scala.Serializable)error -> {
            setClauses.$plus$eq((Object)"engine_error = ?");
            return params.$plus$eq(error);
        });
        if (metadata.peerInstanceClosed()) {
            setClauses.$plus$eq((Object)"peer_instance_closed = ?");
            boxedUnit = params.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)metadata.peerInstanceClosed()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object = setClauses.nonEmpty() ? queryBuilder.append(setClauses.mkString(" SET ", ", ", "")) : BoxedUnit.UNIT;
        queryBuilder.append(" WHERE identifier = ?");
        params.$plus$eq((Object)metadata.identifier());
        String query = queryBuilder.toString();
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            this.withUpdateCount(connection, query, (Seq<Object>)params.toSeq(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)updateCount -> {
                if (updateCount == 0) {
                    throw new KyuubiException(new java.lang.StringBuilder(52).append("Error updating metadata for ").append(metadata$2.identifier()).append(" by SQL: ").append(query$5).append(", ").append("with params: ").append(params$4.mkString(", ")).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
                }
            });
            return BoxedUnit.UNIT;
        }, (DataSource)this.hikariDataSource());
    }

    @Override
    public void cleanupMetadataByIdentifier(String identifier) {
        String query = new java.lang.StringBuilder(33).append("DELETE FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" WHERE identifier = ?").toString();
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            this.execute(connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{identifier}));
            return BoxedUnit.UNIT;
        }, (DataSource)this.hikariDataSource());
    }

    @Override
    public void cleanupMetadataByAge(long maxAge) {
        long minEndTime = System.currentTimeMillis() - maxAge;
        String query = new java.lang.StringBuilder(47).append("DELETE FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" WHERE state IN (").append(this.terminalStates()).append(") AND end_time < ?").toString();
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            this.execute(connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)minEndTime)}));
            return BoxedUnit.UNIT;
        }, (DataSource)this.hikariDataSource());
    }

    private Seq<Metadata> buildMetadata(ResultSet resultSet) {
        Seq seq;
        try {
            ListBuffer metadataList = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            while (resultSet.next()) {
                String identifier = resultSet.getString("identifier");
                Enumeration.Value sessionType = SessionType$.MODULE$.withName(resultSet.getString("session_type"));
                String realUser = resultSet.getString("real_user");
                String userName = resultSet.getString("user_name");
                String ipAddress = resultSet.getString("ip_address");
                String kyuubiInstance = resultSet.getString("kyuubi_instance");
                String state = resultSet.getString("state");
                String resource = resultSet.getString("resource");
                String className = resultSet.getString("class_name");
                String requestName = resultSet.getString("request_name");
                scala.collection.immutable.Map<String, String> requestConf = this.string2Map(resultSet.getString("request_conf"));
                Seq<String> requestArgs = this.string2Seq(resultSet.getString("request_args"));
                long createTime = resultSet.getLong("create_time");
                String engineType = resultSet.getString("engine_type");
                Option clusterManager = Option$.MODULE$.apply((Object)resultSet.getString("cluster_manager"));
                long engineOpenTime = resultSet.getLong("engine_open_time");
                String engineId = resultSet.getString("engine_id");
                String engineName = resultSet.getString("engine_name");
                String engineUrl = resultSet.getString("engine_url");
                String engineState = resultSet.getString("engine_state");
                Option engineError = Option$.MODULE$.apply((Object)resultSet.getString("engine_error"));
                long endTime = resultSet.getLong("end_time");
                boolean peerInstanceClosed = resultSet.getBoolean("peer_instance_closed");
                String x$1 = identifier;
                Enumeration.Value x$2 = sessionType;
                String x$3 = realUser;
                String x$4 = userName;
                String x$5 = ipAddress;
                String x$6 = kyuubiInstance;
                String x$7 = state;
                String x$8 = resource;
                String x$9 = className;
                String x$10 = requestName;
                scala.collection.immutable.Map<String, String> x$11 = requestConf;
                Seq<String> x$12 = requestArgs;
                long x$13 = createTime;
                String x$14 = engineType;
                Option x$15 = clusterManager;
                long x$16 = engineOpenTime;
                String x$17 = engineId;
                String x$18 = engineName;
                String x$19 = engineUrl;
                String x$20 = engineState;
                Option x$21 = engineError;
                long x$22 = endTime;
                boolean x$23 = peerInstanceClosed;
                int x$24 = Metadata$.MODULE$.apply$default$23();
                Metadata metadata = new Metadata(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20, (Option<String>)x$21, x$22, x$24, x$23);
                metadataList.$plus$eq((Object)metadata);
            }
            seq = metadataList.toSeq();
        }
        finally {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> resultSet.close());
        }
        return seq;
    }

    private void execute(Connection conn, String sql, Seq<Object> params) {
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(28).append("execute sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).toString());
        ObjectRef statement = ObjectRef.create(null);
        try {
            try {
                statement.elem = conn.prepareStatement(sql);
                this.setStatementParams((PreparedStatement)statement.elem, params);
                ((PreparedStatement)statement.elem).execute();
            }
            catch (SQLException e) {
                throw new KyuubiException(new java.lang.StringBuilder(38).append("Error executing sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).append(". ").append(e.getMessage()).toString(), (Throwable)e);
            }
        }
        finally {
            if ((PreparedStatement)statement.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((PreparedStatement)statement$1.elem).close());
            }
        }
    }

    private <T> T withResultSet(Connection conn, String sql, Seq<Object> params, Function1<ResultSet, T> f) {
        Object object;
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(33).append("executeQuery sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).toString());
        ObjectRef statement = ObjectRef.create(null);
        ObjectRef resultSet = ObjectRef.create(null);
        try {
            try {
                statement.elem = conn.prepareStatement(sql);
                this.setStatementParams((PreparedStatement)statement.elem, params);
                resultSet.elem = ((PreparedStatement)statement.elem).executeQuery();
                object = f.apply((Object)((ResultSet)resultSet.elem));
            }
            catch (SQLException e) {
                throw new KyuubiException(new java.lang.StringBuilder(38).append("Error executing sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).append(". ").append(e.getMessage()).toString(), (Throwable)e);
            }
        }
        finally {
            if ((ResultSet)resultSet.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((ResultSet)resultSet$2.elem).close());
            }
            if ((PreparedStatement)statement.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((PreparedStatement)statement$2.elem).close());
            }
        }
        return (T)object;
    }

    private <T> T withUpdateCount(Connection conn, String sql, Seq<Object> params, Function1<Object, T> f) {
        Object object;
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(34).append("executeUpdate sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).toString());
        ObjectRef statement = ObjectRef.create(null);
        try {
            try {
                statement.elem = conn.prepareStatement(sql);
                this.setStatementParams((PreparedStatement)statement.elem, params);
                object = f.apply((Object)BoxesRunTime.boxToInteger((int)((PreparedStatement)statement.elem).executeUpdate()));
            }
            catch (SQLException e) {
                throw new KyuubiException(new java.lang.StringBuilder(38).append("Error executing sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).append(". ").append(e.getMessage()).toString(), (Throwable)e);
            }
        }
        finally {
            if ((PreparedStatement)statement.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((PreparedStatement)statement$3.elem).close());
            }
        }
        return (T)object;
    }

    private void setStatementParams(PreparedStatement statement, Seq<Object> params) {
        ((IterableLike)params.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            JDBCMetadataStore.$anonfun$setStatementParams$1(statement, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private String valueAsString(Object obj) {
        return this.mapper().writeValueAsString(obj);
    }

    private scala.collection.immutable.Map<String, String> string2Map(String str) {
        if (str == null || str.isEmpty()) {
            return Predef$.MODULE$.Map().empty();
        }
        return (scala.collection.immutable.Map)this.mapper().readValue(str, scala.collection.immutable.Map.class);
    }

    private Seq<String> string2Seq(String str) {
        if (str == null || str.isEmpty()) {
            return (Seq)Nil$.MODULE$;
        }
        return (Seq)this.mapper().readValue(str, Seq.class);
    }

    public static final /* synthetic */ void $anonfun$initSchema$5(JDBCMetadataStore $this, Connection connection$1, String ddlStatement) {
        $this.execute(connection$1, ddlStatement, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        $this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(81).append("Execute init schema ddl successfully.\n                    |").append(ddlStatement).append("\n                    |").toString())).stripMargin());
    }

    public static final /* synthetic */ void $anonfun$initSchema$1(JDBCMetadataStore $this, String schema) {
        String[] ddlStatements = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.trim().split(";"))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ddlStatements)).foreach((Function1 & Serializable & scala.Serializable)ddlStatement -> {
                JDBCMetadataStore.$anonfun$initSchema$5($this, connection, ddlStatement);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }, (DataSource)$this.hikariDataSource());
    }

    public static final /* synthetic */ boolean $anonfun$getInitSchema$4(String name) {
        return JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$SCHEMA_URL_PATTERN().findFirstMatchIn((CharSequence)name).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$getLatestSchemaUrl$1(JDBCMetadataStore $this, String u1, String u2) {
        Tuple3<Object, Object, Object> v1 = $this.getSchemaVersion(u1);
        Tuple3<Object, Object, Object> v2 = $this.getSchemaVersion(u2);
        return BoxesRunTime.unboxToInt((Object)v1._1()) > BoxesRunTime.unboxToInt((Object)v2._1()) || BoxesRunTime.unboxToInt((Object)v1._1()) == BoxesRunTime.unboxToInt((Object)v2._1()) && BoxesRunTime.unboxToInt((Object)v1._2()) > BoxesRunTime.unboxToInt((Object)v2._2()) || BoxesRunTime.unboxToInt((Object)v1._1()) == BoxesRunTime.unboxToInt((Object)v2._1()) && BoxesRunTime.unboxToInt((Object)v1._2()) == BoxesRunTime.unboxToInt((Object)v2._2()) && BoxesRunTime.unboxToInt((Object)v1._3()) > BoxesRunTime.unboxToInt((Object)v2._3());
    }

    public static final /* synthetic */ void $anonfun$pickMetadata$4(String kyuubiInstance$1, String preSelectedBatchId$1, PreparedStatement stmt) {
        stmt.setString(1, kyuubiInstance$1);
        stmt.setString(2, OperationState$.MODULE$.PENDING().toString());
        stmt.setString(3, preSelectedBatchId$1);
        stmt.setString(4, OperationState$.MODULE$.INITIALIZED().toString());
    }

    public static final /* synthetic */ boolean $anonfun$pickMetadata$3(JDBCMetadataStore $this, String kyuubiInstance$1, String preSelectedBatchId) {
        return JdbcUtils$.MODULE$.executeUpdate(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(106).append("UPDATE ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append("\n           |SET kyuubi_instance=?, state=?\n           |WHERE identifier=? AND state=?\n           |").toString())).stripMargin(), (Function1 & Serializable & scala.Serializable)stmt -> {
            JDBCMetadataStore.$anonfun$pickMetadata$4(kyuubiInstance$1, preSelectedBatchId, stmt);
            return BoxedUnit.UNIT;
        }, (DataSource)$this.hikariDataSource()) == 1;
    }

    public static final /* synthetic */ boolean $anonfun$transformMetadataState$1(JDBCMetadataStore $this, String query$2, String fromState$1, String identifier$1, String targetState$1, Connection connection) {
        return BoxesRunTime.unboxToBoolean($this.withUpdateCount(connection, query$2, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fromState$1, identifier$1, targetState$1}), (Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)updateCount -> updateCount == 1));
    }

    public static final /* synthetic */ boolean $anonfun$assembleWhereClause$2(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$assembleWhereClause$4(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$assembleWhereClause$6(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$assembleWhereClause$8(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$assembleWhereClause$10(String x$11) {
        return new StringOps(Predef$.MODULE$.augmentString(x$11)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$setStatementParams$1(PreparedStatement statement$4, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object param = tuple2._1();
            int index = tuple2._2$mcI$sp();
            Object object = param;
            if (object == null) {
                statement$4.setObject(index + 1, null);
            } else if (object instanceof String) {
                String string = (String)object;
                statement$4.setString(index + 1, string);
            } else if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                statement$4.setInt(index + 1, n);
            } else if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                statement$4.setLong(index + 1, l);
            } else if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                statement$4.setDouble(index + 1, d);
            } else if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object);
                statement$4.setFloat(index + 1, f);
            } else if (object instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                statement$4.setBoolean(index + 1, bl);
            } else {
                throw new KyuubiException(new java.lang.StringBuilder(23).append("Unsupported param type ").append(param.getClass().getName()).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public JDBCMetadataStore(KyuubiConf conf) {
        block16: {
            GenericDatabaseDialect genericDatabaseDialect;
            String string;
            Logging.$init$((Logging)this);
            this.dbType = DatabaseType$.MODULE$.withName((String)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_DATABASE_TYPE()));
            this.driverClassOpt = (Option)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_DRIVER());
            Enumeration.Value value = this.dbType();
            Enumeration.Value value2 = DatabaseType$.MODULE$.SQLITE();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                string = (String)this.driverClassOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> "org.sqlite.JDBC");
            } else {
                Enumeration.Value value4 = DatabaseType$.MODULE$.MYSQL();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    string = (String)this.driverClassOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.mysqlDriverClass());
                } else {
                    Enumeration.Value value6 = DatabaseType$.MODULE$.POSTGRESQL();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        string = (String)this.driverClassOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> "org.postgresql.Driver");
                    } else {
                        Enumeration.Value value8 = DatabaseType$.MODULE$.CUSTOM();
                        Enumeration.Value value9 = value;
                        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                            string = (String)this.driverClassOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                                throw new IllegalArgumentException("No jdbc driver defined");
                            });
                        } else {
                            throw new MatchError((Object)value);
                        }
                    }
                }
            }
            this.driverClass = string;
            Enumeration.Value value10 = this.dbType();
            Enumeration.Value value11 = DatabaseType$.MODULE$.SQLITE();
            Enumeration.Value value12 = value10;
            if (!(value11 != null ? !value11.equals(value12) : value12 != null)) {
                genericDatabaseDialect = new SQLiteDatabaseDialect();
            } else {
                Enumeration.Value value13 = DatabaseType$.MODULE$.MYSQL();
                Enumeration.Value value14 = value10;
                if (!(value13 != null ? !value13.equals(value14) : value14 != null)) {
                    genericDatabaseDialect = new MySQLDatabaseDialect();
                } else {
                    Enumeration.Value value15 = DatabaseType$.MODULE$.POSTGRESQL();
                    Enumeration.Value value16 = value10;
                    if (!(value15 != null ? !value15.equals(value16) : value16 != null)) {
                        genericDatabaseDialect = new PostgreSQLDatabaseDialect();
                    } else {
                        Enumeration.Value value17 = DatabaseType$.MODULE$.CUSTOM();
                        Enumeration.Value value18 = value10;
                        if (!(value17 != null ? !value17.equals(value18) : value18 != null)) {
                            genericDatabaseDialect = new GenericDatabaseDialect();
                        } else {
                            throw new MatchError((Object)value10);
                        }
                    }
                }
            }
            this.dialect = genericDatabaseDialect;
            this.priorityEnabled = BoxesRunTime.unboxToBoolean((Object)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_PRIORITY_ENABLED()));
            this.datasourceProperties = JDBCMetadataStoreConf$.MODULE$.getMetadataStoreJDBCDataSourceProperties(conf);
            this.hikariConfig = new HikariConfig(this.datasourceProperties());
            this.hikariConfig().setDriverClassName(this.driverClass());
            this.hikariConfig().setJdbcUrl(JDBCMetadataStoreConf$.MODULE$.getMetadataStoreJdbcUrl(conf));
            this.hikariConfig().setUsername((String)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_USER()));
            this.hikariConfig().setPassword((String)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_PASSWORD()));
            this.hikariConfig().setPoolName("jdbc-metadata-store-pool");
            this.hikariDataSource = new HikariDataSource(this.hikariConfig());
            this.mapper = new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$);
            this.terminalStates = ((TraversableOnce)OperationState$.MODULE$.terminalStates().map((Function1 & Serializable & scala.Serializable)x -> new java.lang.StringBuilder(2).append("'").append(x).append("'").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
            if (!BoxesRunTime.unboxToBoolean((Object)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_DATABASE_SCHEMA_INIT()))) break block16;
            this.initSchema();
        }
    }
}

