/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.kyligence.kap.secondstorage.enums;

import static org.apache.kylin.common.exception.code.ErrorCodeServer.REQUEST_PARAMETER_EMPTY_OR_VALUE_EMPTY;

import org.apache.kylin.common.exception.KylinException;

public enum LockOperateTypeEnum {
    LOCK, UNLOCK;

    public static LockOperateTypeEnum parse(String value) {
        if (value == null) {
            return null;
        }
        for (LockOperateTypeEnum typeEnum : LockOperateTypeEnum.values()) {
            if (typeEnum.name().equals(value)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static void check(String lockOperateType) {
        LockOperateTypeEnum typeEnum = LockOperateTypeEnum.parse(lockOperateType);
        if (typeEnum == null) {
            throw new KylinException(REQUEST_PARAMETER_EMPTY_OR_VALUE_EMPTY, "lockOperateType");
        }
    }
}
