/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.kyligence.kap.query.optrule;

import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Window;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.relnode.OLAPWindowRel;

/**
 */
public class OLAPWindowRule extends ConverterRule {

    public static final OLAPWindowRule INSTANCE = new OLAPWindowRule();

    public OLAPWindowRule() {
        super(Window.class, Convention.NONE, OLAPRel.CONVENTION, "OLAPWindowRule");
    }

    @Override
    public RelNode convert(RelNode rel) {
        final Window window = (Window) rel;
        final RelTraitSet traitSet = window.getTraitSet().replace(OLAPRel.CONVENTION);
        final RelNode input = window.getInput();
        return new OLAPWindowRel(rel.getCluster(), traitSet, convert(input, OLAPRel.CONVENTION), window.constants,
                window.getRowType(), window.groups);
    }
}
