/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.kylin.common.constant;

public class Constants {

    private Constants() {
        throw new IllegalStateException("Utility class");
    }

    public static final String KE_COMMIT = "ke.commit";
    public static final String KE_VERSION = "ke.version";
    public static final String KE_METASTORE = "ke.metastore";
    public static final String KE_DATES = "ke.dates";
    public static final String KE_LICENSE = "ke.license";
    public static final String KE_LICENSE_LEVEL = "ke.license.level";
    public static final String KE_LICENSE_CATEGORY = "ke.license.category";
    public static final String KE_LICENSE_STATEMENT = "ke.license.statement";
    public static final String KE_LICENSE_ISEVALUATION = "ke.license.isEvaluation";
    public static final String KE_LICENSE_ISTEST = "ke.license.isTest";
    public static final String KE_LICENSE_ISENTERPRISE = "ke.license.isEnterprise";
    public static final String KE_LICENSE_SERVICEEND = "ke.license.serviceEnd";
    public static final String KE_LICENSE_NODES = "ke.license.nodes";
    public static final String KE_LICENSE_ISCLOUD = "ke.license.isCloud";
    public static final String KE_LICENSE_INFO = "ke.license.info";
    public static final String KE_LICENSE_VERSION = "ke.license.version";
    public static final String KE_LICENSE_VOLUME = "ke.license.volume";
    public static final String HIDDEN_VALUE = "*****";
    public static final String KYLIN_SOURCE_JDBC_PASS_KEY = "kylin.source.jdbc.pass";
    public static final String KYLIN_SOURCE_JDBC_SOURCE_NAME_KEY = "kylin.source.jdbc.source.name";
    public static final String KYLIN_SOURCE_JDBC_SOURCE_ENABLE_KEY = "kylin.source.jdbc.source.enable";
    public static final String KYLIN_SOURCE_JDBC_CONNECTION_URL_KEY = "kylin.source.jdbc.connection-url";
    public static final String KYLIN_SOURCE_JDBC_USER_KEY = "kylin.source.jdbc.user";
    public static final String KYLIN_SOURCE_JDBC_DRIVER_KEY = "kylin.source.jdbc.driver";

    public static final String UNLIMITED = "Unlimited";

    public static final String SNAPSHOT_AUTO_REFRESH = "snapshot_auto_refresh";
    public static final String VIEW_MAPPING = "view_mapping";
    public static final String SOURCE_TABLE_STATS = "source_table_stats";
    public static final String SNAPSHOT_JOB = "snapshot_job";
    public static final String MARK = "_mark";
    public static final String BACKSLASH = "/";

    public static final String METADATA_FILE = "metadata.zip";
}
