/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.spark.classloader;

import java.io.File;
import java.net.URLClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassLoaderUtils {
    static URLClassLoader originClassLoader = null;
    private static Logger logger = LoggerFactory.getLogger(ClassLoaderUtils.class);

    public static File findFile(String dir, String ptn) {
        File[] files = new File(dir).listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.getName().matches(ptn)) continue;
                return f;
            }
        }
        return null;
    }

    public static ClassLoader getOriginClassLoader() {
        if (originClassLoader == null) {
            logger.error("originClassLoader not init");
            return Thread.currentThread().getContextClassLoader();
        }
        return originClassLoader;
    }

    public static void setOriginClassLoader(URLClassLoader classLoader) {
        if (originClassLoader != null) {
            logger.error("originClassLoader already initialized");
        }
        logger.info("set originClassLoader :" + classLoader);
        originClassLoader = classLoader;
    }
}

