/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.io.IOException;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.core.JsonParseException;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.JsonMappingException;

public class Serializer<T> {
    private final Class<T> type;

    public Serializer(Class<T> type) {
        this.type = type;
    }

    public T deserialize(byte[] value) throws JsonParseException, JsonMappingException, IOException {
        if (null == value) {
            return null;
        }
        return JsonUtil.readValue(value, this.type);
    }

    public byte[] serialize(T obj) throws JsonProcessingException {
        if (null == obj) {
            return null;
        }
        return JsonUtil.writeValueAsBytes(obj);
    }
}

