/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.CuboidModeEnum;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.engine.spark.application.SparkApplication;
import org.apache.kylin.engine.spark.job.LogJobInfoUtils;
import org.apache.kylin.engine.spark.metadata.cube.PathManager;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterRecommendCuboidJob
extends SparkApplication {
    protected static final Logger logger = LoggerFactory.getLogger(FilterRecommendCuboidJob.class);
    private long baseCuboid;
    private Set<Long> recommendCuboids;
    private FileSystem fs = HadoopUtil.getWorkingFileSystem();
    private Configuration conf = HadoopUtil.getCurrentConfiguration();

    public String getCuboidRootPath(CubeSegment segment) {
        return PathManager.getSegmentParquetStoragePath(segment.getCubeInstance(), segment.getName(), segment.getStorageLocationIdentifier());
    }

    @Override
    protected void doExecute() throws Exception {
        this.infos.clearReusedCuboids();
        CubeManager mgr = CubeManager.getInstance(this.config);
        CubeInstance cube = mgr.getCube(CubingExecutableUtil.getCubeName(this.getParams())).latestCopyForWrite();
        CubeSegment optimizeSegment = cube.getSegmentById(CubingExecutableUtil.getSegmentId(this.getParams()));
        CubeSegment oldSegment = optimizeSegment.getCubeInstance().getOriginalSegmentToOptimize(optimizeSegment);
        Preconditions.checkNotNull(oldSegment, "cannot find the original segment to be optimized by " + optimizeSegment);
        this.infos.recordReusedCuboids(Collections.singleton(cube.getCuboidsByMode(CuboidModeEnum.RECOMMEND_EXISTING)));
        this.baseCuboid = cube.getCuboidScheduler().getBaseCuboidId();
        this.recommendCuboids = cube.getCuboidsRecommend();
        Preconditions.checkNotNull(this.recommendCuboids, "The recommend cuboid map could not be null");
        Path originalCuboidPath = new Path(this.getCuboidRootPath(oldSegment));
        try {
            for (FileStatus cuboid : this.fs.listStatus(originalCuboidPath)) {
                String cuboidId = cuboid.getPath().getName();
                if (!cuboidId.equals(String.valueOf(this.baseCuboid)) && !this.recommendCuboids.contains(Long.valueOf(cuboidId))) continue;
                Path optimizeCuboidPath = new Path(this.getCuboidRootPath(optimizeSegment) + "/" + cuboidId);
                FileUtil.copy((FileSystem)this.fs, (Path)cuboid.getPath(), (FileSystem)this.fs, (Path)optimizeCuboidPath, (boolean)false, (boolean)true, (Configuration)this.conf);
                logger.info("Copy cuboid {} storage from original segment to optimized segment", (Object)cuboidId);
            }
        }
        catch (IOException e) {
            logger.error("Failed to filter cuboid", e);
            throw e;
        }
    }

    public static void main(String[] args) {
        FilterRecommendCuboidJob filterRecommendCuboidJob = new FilterRecommendCuboidJob();
        filterRecommendCuboidJob.execute(args);
    }

    @Override
    protected String generateInfo() {
        return LogJobInfoUtils.filterRecommendCuboidJobInfo();
    }
}

