/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.SortedSet;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.shaded.com.google.common.collect.BoundType;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Range;

public class RangeUtil {
    private RangeUtil() {
        throw new IllegalStateException("Class RangeUtil is an utility class !");
    }

    public static <C extends Comparable<?>, V> NavigableMap<C, V> filter(NavigableMap<C, V> values, Range<C> filterRange) {
        if (filterRange == null || filterRange.isEmpty()) {
            return Maps.newTreeMap();
        }
        if (filterRange.equals(Range.all())) {
            return values;
        }
        if (filterRange.hasUpperBound() && !filterRange.hasLowerBound()) {
            return values.headMap(filterRange.upperEndpoint(), RangeUtil.upperBoundInclusive(filterRange));
        }
        if (filterRange.hasLowerBound() && !filterRange.hasUpperBound()) {
            return values.tailMap(filterRange.lowerEndpoint(), RangeUtil.lowerBoundInclusive(filterRange));
        }
        return values.subMap(filterRange.lowerEndpoint(), RangeUtil.lowerBoundInclusive(filterRange), filterRange.upperEndpoint(), RangeUtil.upperBoundInclusive(filterRange));
    }

    public static <C extends Comparable<?>> boolean lowerBoundInclusive(Range<C> range) {
        if (!range.hasLowerBound()) {
            throw new IllegalArgumentException("This range does not have lower bound" + range);
        }
        return range.lowerBoundType() == BoundType.CLOSED;
    }

    public static <C extends Comparable<?>> boolean upperBoundInclusive(Range<C> range) {
        if (!range.hasUpperBound()) {
            throw new IllegalArgumentException("This range does not have upper bound" + range);
        }
        return range.upperBoundType() == BoundType.CLOSED;
    }

    public static <C extends Comparable<?>> Range<C> merge(Range<C> a, Range<C> b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null || b == null) {
            return a == null ? b : a;
        }
        return a.span(b);
    }

    public static <C extends Comparable<?>> List<Range<C>> remove(Range<C> self, Range<C> other) {
        if (other == null || !self.isConnected(other)) {
            return Collections.singletonList(self);
        }
        Range<C> share = self.intersection(other);
        if (share.isEmpty()) {
            return Collections.singletonList(self);
        }
        ArrayList<Range<C>> ret = Lists.newArrayList();
        if (!self.hasLowerBound()) {
            if (share.hasLowerBound()) {
                if (share.lowerBoundType() == BoundType.CLOSED) {
                    ret.add(Range.lessThan(share.lowerEndpoint()));
                } else {
                    ret.add(Range.atMost(share.lowerEndpoint()));
                }
            }
        } else if (self.lowerEndpoint() != share.lowerEndpoint()) {
            if (self.lowerBoundType() == BoundType.CLOSED) {
                if (share.lowerBoundType() == BoundType.CLOSED) {
                    ret.add(Range.closedOpen(self.lowerEndpoint(), share.lowerEndpoint()));
                } else {
                    ret.add(Range.closed(self.lowerEndpoint(), share.lowerEndpoint()));
                }
            } else if (share.lowerBoundType() == BoundType.CLOSED) {
                ret.add(Range.open(self.lowerEndpoint(), share.lowerEndpoint()));
            } else {
                ret.add(Range.openClosed(self.lowerEndpoint(), share.lowerEndpoint()));
            }
        } else if (self.lowerBoundType() == BoundType.CLOSED && share.lowerBoundType() == BoundType.OPEN) {
            ret.add(Range.closed(self.lowerEndpoint(), share.lowerEndpoint()));
        }
        if (!self.hasUpperBound()) {
            if (share.hasUpperBound()) {
                if (share.upperBoundType() == BoundType.CLOSED) {
                    ret.add(Range.greaterThan(share.upperEndpoint()));
                } else {
                    ret.add(Range.atLeast(share.upperEndpoint()));
                }
            }
        } else if (self.upperEndpoint() != share.upperEndpoint()) {
            if (self.upperBoundType() == BoundType.CLOSED) {
                if (share.upperBoundType() == BoundType.CLOSED) {
                    ret.add(Range.openClosed(share.upperEndpoint(), self.upperEndpoint()));
                } else {
                    ret.add(Range.closed(share.upperEndpoint(), self.upperEndpoint()));
                }
            } else if (share.upperBoundType() == BoundType.CLOSED) {
                ret.add(Range.open(share.upperEndpoint(), self.upperEndpoint()));
            } else {
                ret.add(Range.closedOpen(share.upperEndpoint(), self.upperEndpoint()));
            }
        } else if (self.upperBoundType() == BoundType.CLOSED && share.upperBoundType() == BoundType.OPEN) {
            ret.add(Range.closed(self.upperEndpoint(), share.upperEndpoint()));
        }
        return ret;
    }

    public static String formatTsRange(Range<Long> tsRange) {
        if (tsRange == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (tsRange.hasLowerBound()) {
            if (tsRange.lowerBoundType() == BoundType.CLOSED) {
                sb.append("[");
            } else {
                sb.append("(");
            }
            sb.append(DateFormat.formatToTimeStr(tsRange.lowerEndpoint()));
        } else {
            sb.append("(-\u221e");
        }
        sb.append("~");
        if (tsRange.hasUpperBound()) {
            sb.append(DateFormat.formatToTimeStr(tsRange.upperEndpoint()));
            if (tsRange.upperBoundType() == BoundType.CLOSED) {
                sb.append("]");
            } else {
                sb.append(")");
            }
        } else {
            sb.append("+\u221e)");
        }
        return sb.toString();
    }

    public static ArrayList<Range<Integer>> buildRanges(SortedSet<Integer> values) {
        int lastBegin;
        ArrayList<Range<Integer>> ranges = Lists.newArrayList();
        if (values == null || values.isEmpty()) {
            return ranges;
        }
        Iterator iter = values.iterator();
        int lastEnd = lastBegin = ((Integer)iter.next()).intValue();
        int temp = 0;
        for (int index = 1; index < values.size(); ++index) {
            temp = (Integer)iter.next();
            if (temp - lastEnd != 1) {
                ranges.add(Range.closed(lastBegin, lastEnd));
                lastBegin = temp;
            }
            lastEnd = temp;
        }
        ranges.add(Range.closed(lastBegin, lastEnd));
        return ranges;
    }
}

