/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cache.memcached;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import java.util.Map;
import net.spy.memcached.metrics.AbstractMetricCollector;
import org.apache.kylin.metrics.lib.impl.MetricsSystem;
import org.apache.kylin.shaded.com.google.common.collect.Maps;

public final class MemcachedMetrics
extends AbstractMetricCollector {
    private Map<String, Counter> counters = Maps.newConcurrentMap();
    private Map<String, Meter> meters = Maps.newConcurrentMap();
    private Map<String, Histogram> histograms = Maps.newConcurrentMap();

    public void addCounter(String name) {
        if (!this.counters.containsKey(name)) {
            this.counters.put(name, MetricsSystem.Metrics.counter(name));
        }
    }

    public void removeCounter(String name) {
        if (!this.counters.containsKey(name)) {
            MetricsSystem.Metrics.remove(name);
            this.counters.remove(name);
        }
    }

    public void incrementCounter(String name, int amount) {
        if (this.counters.containsKey(name)) {
            this.counters.get(name).inc((long)amount);
        }
    }

    public void decrementCounter(String name, int amount) {
        if (this.counters.containsKey(name)) {
            this.counters.get(name).dec((long)amount);
        }
    }

    public void addMeter(String name) {
        if (!this.meters.containsKey(name)) {
            this.meters.put(name, MetricsSystem.Metrics.meter(name));
        }
    }

    public void removeMeter(String name) {
        if (this.meters.containsKey(name)) {
            this.meters.remove(name);
        }
    }

    public void markMeter(String name) {
        if (this.meters.containsKey(name)) {
            this.meters.get(name).mark();
        }
    }

    public void addHistogram(String name) {
        if (!this.histograms.containsKey(name)) {
            this.histograms.put(name, MetricsSystem.Metrics.histogram(name));
        }
    }

    public void removeHistogram(String name) {
        if (this.histograms.containsKey(name)) {
            this.histograms.remove(name);
        }
    }

    public void updateHistogram(String name, int amount) {
        if (this.histograms.containsKey(name)) {
            this.histograms.get(name).update(amount);
        }
    }
}

