/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.runtime.plans;

import java.io.Serializable;
import java.util.List;
import java.util.TimeZone;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContextFacade;
import org.apache.kylin.common.QueryTrace;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.common.exceptions.KylinTimeoutException;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.query.runtime.plans.QueryToExecutionIDCache$;
import org.apache.kylin.query.runtime.plans.ResultType$;
import org.apache.kylin.query.runtime.plans.TableScanPlan$;
import org.apache.kylin.query.util.AbstractSparkJobTrace;
import org.apache.kylin.query.util.SparkJobTrace;
import org.apache.kylin.query.util.SparkJobTrace$;
import org.apache.kylin.query.util.SparkJobTraceV2;
import org.apache.kylin.query.util.SparkJobTraceV2$;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparderContext$;
import org.apache.spark.sql.hive.utils.QueryMetricUtils$;
import org.apache.spark.sql.utils.SparkTypeUtil$;
import org.apache.spark.utils.SparderUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple5;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;

public final class ResultPlan$
implements Logging {
    public static ResultPlan$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ResultPlan$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Enumerable<Object[]> collectEnumerable(Dataset<Row> df, RelDataType rowType) {
        Object[][] rowsItr = this.collectInternal(df, rowType);
        return Linq4j.asEnumerable((Object[])((Object[])Predef$.MODULE$.wrapRefArray((Object[])rowsItr).array()));
    }

    public Enumerable<Object> collectScalarEnumerable(Dataset<Row> df, RelDataType rowType) {
        Object[][] rowsItr = this.collectInternal(df, rowType);
        java.lang.Iterable x = (java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rowsItr)).toIterable().map((Function1 & Serializable & scala.Serializable)a -> a[0], Iterable$.MODULE$.canBuildFrom())).asJava();
        return Linq4j.asEnumerable((java.lang.Iterable)x);
    }

    private Object[][] collectInternal(Dataset<Row> df, RelDataType rowType) {
        Object[][] objectArray;
        int partitionsNum;
        Buffer resultTypes = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(rowType.getFieldList()).asScala();
        String jobGroup = Thread.currentThread().getName();
        SparkContext sparkContext = SparderContext$.MODULE$.getSparkSession().sparkContext();
        String projectName = QueryContextFacade.current().getProject();
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        if (projectName != null) {
            kylinConfig = ProjectManager.getInstance(kylinConfig).getProject(projectName).getConfig();
        }
        String pool = "heavy_tasks";
        int sparderTotalCores = SparderUtils$.MODULE$.getTotalCore(df.sparkSession().sparkContext().getConf());
        int n = partitionsNum = kylinConfig.getSparkSqlShufflePartitions() != -1 ? kylinConfig.getSparkSqlShufflePartitions() : sparderTotalCores;
        if (QueryContextFacade.current().isHighPriorityQuery()) {
            pool = "vip_tasks";
        } else if (partitionsNum <= sparderTotalCores) {
            pool = "lightweight_tasks";
        }
        if (kylinConfig.getProjectQuerySparkPool() != null) {
            pool = kylinConfig.getProjectQuerySparkPool();
        }
        if (BackdoorToggles.getDebugToggleSparkPool() != null) {
            pool = BackdoorToggles.getDebugToggleSparkPool();
        }
        sparkContext.setLocalProperty("spark.scheduler.pool", pool);
        QueryContextFacade.current().setSparkPool(pool);
        String queryId = QueryContextFacade.current().getQueryId();
        sparkContext.setLocalProperty(QueryToExecutionIDCache$.MODULE$.KYLIN_QUERY_ID_KEY(), queryId);
        df.sparkSession().conf().set("spark.sql.shuffle.partitions", ((Object)BoxesRunTime.boxToInteger((int)partitionsNum)).toString());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Set partition to ").append(partitionsNum).toString());
        QueryContextFacade.current().setDataset(df);
        sparkContext.setJobGroup(jobGroup, new StringBuilder(10).append("Query Id: ").append(QueryContextFacade.current().getQueryId()).toString(), true);
        QueryTrace currentTrace = QueryContextFacade.current().getQueryTrace();
        currentTrace.endLastSpan();
        AbstractSparkJobTrace jobTrace = BoxesRunTime.equalsNumObject((Number)kylinConfig.sparkQueryMetrics(), (Object)BoxesRunTime.boxToInteger((int)2)) ? new SparkJobTraceV2(jobGroup, currentTrace, sparkContext, TimeZone.getTimeZone(kylinConfig.getTimeZone()).toZoneId(), SparkJobTraceV2$.MODULE$.$lessinit$greater$default$5(), SparkJobTraceV2$.MODULE$.$lessinit$greater$default$6()) : (BoxesRunTime.equalsNumObject((Number)kylinConfig.sparkQueryMetrics(), (Object)BoxesRunTime.boxToInteger((int)1)) ? new SparkJobTrace(jobGroup, currentTrace, sparkContext, SparkJobTrace$.MODULE$.$lessinit$greater$default$4()) : new AbstractSparkJobTrace());
        try {
            Object[][] dt;
            Row[] rows = (Row[])df.collect();
            jobTrace.jobFinished();
            Tuple5<List<Long>, List<Long>, List<Long>, List<Long>, List<Long>> tuple5 = QueryMetricUtils$.MODULE$.collectScanMetrics(df.queryExecution().executedPlan());
            if (tuple5 == null) {
                throw new MatchError(tuple5);
            }
            List scanRows = (List)tuple5._1();
            List scanFiles = (List)tuple5._2();
            List metadataTime = (List)tuple5._3();
            List scanTime = (List)tuple5._4();
            List scanBytes = (List)tuple5._5();
            Tuple5 tuple52 = new Tuple5((Object)scanRows, (Object)scanFiles, (Object)metadataTime, (Object)scanTime, (Object)scanBytes);
            Tuple5 tuple53 = tuple52;
            List scanRows2 = (List)tuple53._1();
            List scanFiles2 = (List)tuple53._2();
            List metadataTime2 = (List)tuple53._3();
            List scanTime2 = (List)tuple53._4();
            List scanBytes2 = (List)tuple53._5();
            QueryContextFacade.current().addAndGetScannedRows(BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(scanRows2).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x$2)), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            QueryContextFacade.current().addAndGetScanFiles(BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(scanFiles2).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x$3)), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            QueryContextFacade.current().addAndGetScannedBytes(BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(scanBytes2).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x$4)), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            QueryContextFacade.current().addAndGetMetadataTime(BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(metadataTime2).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x$5)), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            QueryContextFacade.current().addAndGetScanTime(BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(scanTime2).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x$6)), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            objectArray = dt = (Object[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).map((Function1 & Serializable & scala.Serializable)row -> {
                IntRef rowIndex = IntRef.create((int)0);
                return (Object[])((TraversableOnce)row.toSeq().map((Function1 & Serializable & scala.Serializable)cell -> {
                    Object vale = cell;
                    RelDataType rType = ((RelDataTypeField)resultTypes.apply(rowIndex$1.elem)).getType();
                    Object value = SparkTypeUtil$.MODULE$.convertStringToValue(vale, rType, true);
                    ++rowIndex$1.elem;
                    return value;
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Object.class))));
        }
        catch (InterruptedException e) {
            sparkContext.cancelJobGroup(jobGroup);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Query timeouts after: ").append(KylinConfig.getInstanceFromEnv().getQueryTimeoutSeconds()).append("s").toString(), e);
            throw new KylinTimeoutException(new StringBuilder(22).append("Query timeout after: ").append(KylinConfig.getInstanceFromEnv().getQueryTimeoutSeconds()).append("s").toString());
        }
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    public <U> U withScope(Dataset<Row> df, Function0<U> body) {
        void var3_3;
        HadoopUtil.setCurrentConfiguration(df.sparkSession().sparkContext().hadoopConfiguration());
        Object r = body.apply();
        df.sparkSession().sparkContext().setLocalProperty("spark.scheduler.pool", null);
        SparderContext$.MODULE$.setDF(df);
        TableScanPlan$.MODULE$.cacheDf().get().clear();
        HadoopUtil.setCurrentConfiguration(null);
        return var3_3;
    }

    public Either<Enumerable<Object[]>, Enumerable<Object>> getResult(Dataset<Row> df, RelDataType rowType, Enumeration.Value resultType) {
        return (Either)this.withScope(df, (Function0 & Serializable & scala.Serializable)() -> {
            Left left;
            Enumeration.Value value = resultType;
            Enumeration.Value value2 = ResultType$.MODULE$.NORMAL();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                left = Predef$.MODULE$.Boolean2boolean(SparderContext$.MODULE$.needCompute()) ? package$.MODULE$.Left().apply(MODULE$.collectEnumerable(df, rowType)) : package$.MODULE$.Left().apply((Object)Linq4j.asEnumerable((Object[])((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Object.class))))));
            } else {
                Enumeration.Value value4 = ResultType$.MODULE$.SCALA();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    left = Predef$.MODULE$.Boolean2boolean(SparderContext$.MODULE$.needCompute()) ? package$.MODULE$.Right().apply(MODULE$.collectScalarEnumerable(df, rowType)) : package$.MODULE$.Right().apply((Object)Linq4j.asEnumerable(Lists.newArrayList()));
                } else {
                    throw new MatchError((Object)value);
                }
            }
            Left result = left;
            SparderContext$.MODULE$.cleanQueryInfo();
            return result;
        });
    }

    private ResultPlan$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

