/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.spark.job.KylinBuildEnv$;
import org.apache.kylin.engine.spark.metadata.JoinDesc;
import org.apache.kylin.engine.spark.metadata.SegmentInfo;
import org.apache.kylin.engine.spark.metadata.TableDesc;
import org.apache.kylin.engine.spark.utils.FileNames$;
import org.apache.kylin.engine.spark.utils.SparkDataSource$;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hive.utils.ResourceDetectUtils$;
import org.apache.spark.utils.ProxyThreadUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001\u0002\r\u001a\u0001\u0019BQ\u0001\u000e\u0001\u0005\u0002UB\u0011\u0002\u000f\u0001A\u0002\u0003\u0007I\u0011A\u001d\t\u0013\u0001\u0003\u0001\u0019!a\u0001\n\u0003\t\u0005\"C$\u0001\u0001\u0004\u0005\t\u0015)\u0003;\u0011%A\u0005\u00011AA\u0002\u0013\u0005\u0011\nC\u0005Q\u0001\u0001\u0007\t\u0019!C\u0001#\"I1\u000b\u0001a\u0001\u0002\u0003\u0006KA\u0013\u0005\b)\u0002\u0011\r\u0011\"\u0003V\u0011\u0019q\u0006\u0001)A\u0005-\"9q\f\u0001b\u0001\n\u0013)\u0006B\u00021\u0001A\u0003%a\u000bC\u0004b\u0001\t\u0007I\u0011\u00022\t\r\u0019\u0004\u0001\u0015!\u0003d\u0011\u0015!\u0004\u0001\"\u0001h\u0011\u001dQ\u0007A1A\u0005\n-Da\u0001\u001e\u0001!\u0002\u0013a\u0007bB;\u0001\u0005\u0004%Ia\u001b\u0005\u0007m\u0002\u0001\u000b\u0011\u00027\t\u000b]\u0004A\u0011A%\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R!9\u0011Q\f\u0001\u0005\u0002\u0005}\u0003bBA?\u0001\u0011\u0005\u0011q\u0010\u0005\b\u0003\u0003\u0003A\u0011AAB\u0005M\u0019UOY3T]\u0006\u00048\u000f[8u\u0005VLG\u000eZ3s\u0015\tQ2$A\u0004ck&dG-\u001a:\u000b\u0005qi\u0012!B:qCJ\\'B\u0001\u0010 \u0003\u0019)gnZ5oK*\u0011\u0001%I\u0001\u0006Wfd\u0017N\u001c\u0006\u0003E\r\na!\u00199bG\",'\"\u0001\u0013\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u00019S\u0006\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0004B]f\u0014VM\u001a\t\u0003]Ij\u0011a\f\u0006\u0003aE\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u00039\u0005J!aM\u0018\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012A\u000e\t\u0003o\u0001i\u0011!G\u0001\u0003gN,\u0012A\u000f\t\u0003wyj\u0011\u0001\u0010\u0006\u0003{E\n1a]9m\u0013\tyDH\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0004tg~#S-\u001d\u000b\u0003\u0005\u0016\u0003\"\u0001K\"\n\u0005\u0011K#\u0001B+oSRDqAR\u0002\u0002\u0002\u0003\u0007!(A\u0002yIE\n1a]:!\u0003\r\u0019XmZ\u000b\u0002\u0015B\u00111JT\u0007\u0002\u0019*\u0011QjG\u0001\t[\u0016$\u0018\rZ1uC&\u0011q\n\u0014\u0002\f'\u0016<W.\u001a8u\u0013:4w.A\u0004tK\u001e|F%Z9\u0015\u0005\t\u0013\u0006b\u0002$\u0007\u0003\u0003\u0005\rAS\u0001\u0005g\u0016<\u0007%\u0001\u0006N\tVz6+\u0016$G\u0013b+\u0012A\u0016\t\u0003/rk\u0011\u0001\u0017\u0006\u00033j\u000bA\u0001\\1oO*\t1,\u0001\u0003kCZ\f\u0017BA/Y\u0005\u0019\u0019FO]5oO\u0006YQ\nR\u001b`'V3e)\u0013-!\u00039\u0001\u0016IU)V\u000bR{6+\u0016$G\u0013b\u000bq\u0002U!S#V+EkX*V\r\u001aK\u0005\fI\u0001\u0003\u001b\n+\u0012a\u0019\t\u0003Q\u0011L!!Z\u0015\u0003\u0007%sG/A\u0002N\u0005\u0002\"2A\u000e5j\u0011\u0015Ae\u00021\u0001K\u0011\u0015Ad\u00021\u0001;\u0003E\u0001\u0016M]9vKR\u0004\u0016\r\u001e5GS2$XM]\u000b\u0002YB\u0011QN]\u0007\u0002]*\u0011q\u000e]\u0001\u0003MNT!!]\u0011\u0002\r!\fGm\\8q\u0013\t\u0019hN\u0001\u0006QCRDg)\u001b7uKJ\f!\u0003U1scV,G\u000fU1uQ\u001aKG\u000e^3sA\u0005iQ\nZ\u001bQCRDg)\u001b7uKJ\fa\"\u001436!\u0006$\bNR5mi\u0016\u0014\b%A\u0007ck&dGm\u00158baNDw\u000e\u001e\u0015\u0005'e\f)\u0001E\u0002)urL!a_\u0015\u0003\rQD'o\\<t!\ri\u0018\u0011A\u0007\u0002}*\u0011qPW\u0001\u0003S>L1!a\u0001\u007f\u0005-Iu*\u0012=dKB$\u0018n\u001c82\u000fy\t9!a\u0007\u0002NA!\u0011\u0011BA\f\u001d\u0011\tY!a\u0005\u0011\u0007\u00055\u0011&\u0004\u0002\u0002\u0010)\u0019\u0011\u0011C\u0013\u0002\rq\u0012xn\u001c;?\u0013\r\t)\"K\u0001\u0007!J,G-\u001a4\n\u0007u\u000bIBC\u0002\u0002\u0016%\n\u0014bIA\u000f\u0003K\t\u0019%a\n\u0016\t\u0005}\u0011\u0011E\u000b\u0003\u0003\u000f!q!a\t&\u0005\u0004\tiCA\u0001U\u0013\u0011\t9#!\u000b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\r\tY#K\u0001\u0007i\"\u0014xn^:\u0012\t\u0005=\u0012Q\u0007\t\u0004Q\u0005E\u0012bAA\u001aS\t9aj\u001c;iS:<\u0007\u0003BA\u001c\u0003{q1\u0001KA\u001d\u0013\r\tY$K\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty$!\u0011\u0003\u0013QC'o\\<bE2,'bAA\u001eSEJ1%!\u0012\u0002H\u0005%\u00131\u0006\b\u0004Q\u0005\u001d\u0013bAA\u0016SE*!\u0005K\u0015\u0002L\t)1oY1mCF\u0012a\u0005`\u0001\u000bO\u0016$h)\u001b7f\u001b\u0012,D\u0003BA\u0004\u0003'Bq!!\u0016\u0015\u0001\u0004\t9&\u0001\u0003gS2,\u0007cA7\u0002Z%\u0019\u00111\f8\u0003\u0015\u0019KG.Z*uCR,8/A\nck&dGmU5oO2,7K\\1qg\"|G\u000f\u0006\u0005\u0002b\u0005\u001d\u0014\u0011OA;!\u001dA\u00131MA\u0004\u0003\u000fI1!!\u001a*\u0005\u0019!V\u000f\u001d7fe!9\u0011\u0011N\u000bA\u0002\u0005-\u0014!\u0003;bE2,\u0017J\u001c4p!\rY\u0015QN\u0005\u0004\u0003_b%!\u0003+bE2,G)Z:d\u0011\u001d\t\u0019(\u0006a\u0001\u0003\u000f\tqAY1tK\u0012K'\u000f\u0003\u0004p+\u0001\u0007\u0011q\u000f\t\u0004[\u0006e\u0014bAA>]\nQa)\u001b7f'f\u001cH/Z7\u0002\u0017\rDWmY6EkB\\U-\u001f\u000b\u0002\u0005\u00069\"-^5mINs\u0017\r]:i_R<\u0016\u000e\u001e5pkRlE-\u000e\u000b\u0007\u0003C\n))a\"\t\u000f\u0005%t\u00031\u0001\u0002l!9\u00111O\fA\u0002\u0005\u001d\u0001")
public class CubeSnapshotBuilder
implements Logging {
    private SparkSession ss;
    private SegmentInfo seg;
    private final String org$apache$kylin$engine$spark$builder$CubeSnapshotBuilder$$MD5_SUFFIX;
    private final String org$apache$kylin$engine$spark$builder$CubeSnapshotBuilder$$PARQUET_SUFFIX;
    private final int MB;
    private final PathFilter ParquetPathFilter;
    private final PathFilter Md5PathFilter;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkSession ss() {
        return this.ss;
    }

    public void ss_$eq(SparkSession x$1) {
        this.ss = x$1;
    }

    public SegmentInfo seg() {
        return this.seg;
    }

    public void seg_$eq(SegmentInfo x$1) {
        this.seg = x$1;
    }

    public String org$apache$kylin$engine$spark$builder$CubeSnapshotBuilder$$MD5_SUFFIX() {
        return this.org$apache$kylin$engine$spark$builder$CubeSnapshotBuilder$$MD5_SUFFIX;
    }

    public String org$apache$kylin$engine$spark$builder$CubeSnapshotBuilder$$PARQUET_SUFFIX() {
        return this.org$apache$kylin$engine$spark$builder$CubeSnapshotBuilder$$PARQUET_SUFFIX;
    }

    private int MB() {
        return this.MB;
    }

    private PathFilter ParquetPathFilter() {
        return this.ParquetPathFilter;
    }

    private PathFilter Md5PathFilter() {
        return this.Md5PathFilter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SegmentInfo buildSnapshot() throws IOException {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Building snapshots for: ").append(this.seg()).toString());
        HashMap newSnapMap = Maps.newHashMap();
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        KylinConfig kylinConf = this.seg().kylinconf();
        String baseDir = kylinConf.getHdfsWorkingDirectory();
        List<TableDesc> toBuildTableDesc = this.seg().snapshotTables();
        if (kylinConf.isSnapshotParallelBuildEnabled()) {
            ExecutorService service = Executors.newCachedThreadPool();
            ExecutionContextExecutorService executorContext = ExecutionContext$.MODULE$.fromExecutorService(service);
            List futures = (List)toBuildTableDesc.map((Function1 & Serializable & scala.Serializable)tableInfo -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                Tuple2<String, String> tuple2;
                if (kylinConf.isUTEnv()) {
                    Thread.sleep(1000L);
                }
                try {
                    KylinConfig.setAndUnsetThreadLocalConfig(kylinConf);
                    tuple2 = this.buildSnapshotWithoutMd5((TableDesc)tableInfo, baseDir);
                }
                catch (Exception exception) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Error for build snapshot table with ").append(tableInfo.identity()).toString(), exception);
                    throw exception;
                }
                return tuple2;
            }, (ExecutionContext)executorContext), List$.MODULE$.canBuildFrom());
            try {
                Future eventualTuples = Future$.MODULE$.sequence((TraversableOnce)futures.toList(), List$.MODULE$.canBuildFrom(), (ExecutionContext)executorContext);
                List result = (List)ProxyThreadUtils$.MODULE$.awaitResult(eventualTuples, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(kylinConf.snapshotParallelBuildTimeoutSeconds())).seconds());
                if (!result.nonEmpty()) return this.seg();
                this.seg().updateSnapshot((Map<String, String>)result.toMap(Predef$.MODULE$.$conforms()));
                return this.seg();
            }
            catch (Exception e) {
                ProxyThreadUtils$.MODULE$.shutdown(service, ProxyThreadUtils$.MODULE$.shutdown$default$2());
                throw e;
            }
        } else {
            toBuildTableDesc.foreach((Function1 & Serializable & scala.Serializable)tableDesc -> {
                Tuple2<String, String> tuple = this.buildSingleSnapshot((TableDesc)tableDesc, baseDir, fs);
                return (String)newSnapMap.put(tuple._1(), tuple._2());
            });
        }
        return this.seg();
    }

    public String getFileMd5(FileStatus file) {
        FileSystem dfs = HadoopUtil.getWorkingFileSystem();
        FSDataInputStream in = dfs.open(file.getPath());
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> DigestUtils.md5Hex((InputStream)in));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable error = failure.exception();
                in.close();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("building snapshot get file: ").append(file.getPath()).append(" md5 error,msg: ").append(error.getMessage()).toString());
                throw new IOException(new StringBuilder(30).append("Failed to generate file: ").append(file.getPath()).append(" md5 ").toString(), error);
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        String md5 = (String)success.value();
        in.close();
        String string = md5;
        return string;
    }

    public Tuple2<String, String> buildSingleSnapshot(TableDesc tableInfo, String baseDir, FileSystem fs) {
        Dataset<Row> sourceData = SparkDataSource$.MODULE$.SparkSource(this.ss()).table(tableInfo);
        Path tablePath = FileNames$.MODULE$.snapshotFile(tableInfo, this.seg().project());
        ObjectRef snapshotTablePath = ObjectRef.create((Object)new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)tablePath), "/")).append(UUID.randomUUID()).toString());
        String resourcePath = new StringBuilder(1).append(baseDir).append("/").append((String)snapshotTablePath.elem).toString();
        sourceData.coalesce(1).write().parquet(resourcePath);
        FileStatus currSnapFile = (FileStatus)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(new Path(resourcePath), this.ParquetPathFilter()))).head();
        String currSnapMd5 = this.getFileMd5(currSnapFile);
        String md5Path = new StringBuilder(2).append(resourcePath).append("/").append("_").append(currSnapMd5).append(this.org$apache$kylin$engine$spark$builder$CubeSnapshotBuilder$$MD5_SUFFIX()).toString();
        BooleanRef isReuseSnap = BooleanRef.create((boolean)false);
        String existPath = new StringBuilder(1).append(baseDir).append("/").append(tablePath).toString();
        FileStatus[] existSnaps = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(new Path(existPath)))).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CubeSnapshotBuilder.$anonfun$buildSingleSnapshot$1(snapshotTablePath, x$1)));
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existSnaps)).foreach((Function1 & Serializable & scala.Serializable)snap -> {
            CubeSnapshotBuilder.$anonfun$buildSingleSnapshot$3(this, fs, currSnapMd5, snapshotTablePath, tablePath, resourcePath, isReuseSnap, snap);
            return BoxedUnit.UNIT;
        }));
        if (!isReuseSnap.elem) {
            fs.createNewFile(new Path(md5Path));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Create md5 file: ").append(md5Path).append(" for snap: ").append(currSnapFile).toString());
        }
        return new Tuple2((Object)tableInfo.identity(), (Object)((String)snapshotTablePath.elem));
    }

    public void checkDupKey() {
        JoinDesc[] joinDescs = this.seg().joindescs();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])joinDescs)).foreach((Function1 & Serializable & scala.Serializable)joinDesc -> {
            CubeSnapshotBuilder.$anonfun$checkDupKey$1(this, joinDesc);
            return BoxedUnit.UNIT;
        });
    }

    public Tuple2<String, String> buildSnapshotWithoutMd5(TableDesc tableInfo, String baseDir) {
        int n;
        Dataset<Row> sourceData = SparkDataSource$.MODULE$.SparkSource(this.ss()).table(tableInfo);
        Path tablePath = FileNames$.MODULE$.snapshotFile(tableInfo, this.seg().project());
        String snapshotTablePath = new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)tablePath), "/")).append(UUID.randomUUID()).toString();
        String resourcePath = new StringBuilder(1).append(baseDir).append("/").append(snapshotTablePath).toString();
        try {
            double sizeInMB = (double)BoxesRunTime.unboxToLong((Object)((TraversableOnce)ResourceDetectUtils$.MODULE$.getPaths(sourceData.queryExecution().sparkPlan()).map((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToLong((long)CubeSnapshotBuilder.$anonfun$buildSnapshotWithoutMd5$1(path)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) * 1.0 / (double)this.MB();
            int num = Predef$.MODULE$.double2Double(Math.ceil(sizeInMB / (double)KylinBuildEnv$.MODULE$.get().kylinConfig().getSnapshotShardSizeMB())).intValue();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Table size is ").append(sizeInMB).append(" MB, repartition num is set to ").append(num).append(".").toString());
            n = num;
        }
        catch (Throwable t) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred when estimate repartition number.", t);
            n = 0;
        }
        int repartitionNum = n;
        this.ss().sparkContext().setJobDescription(new StringBuilder(22).append("Build table snapshot ").append(tableInfo.identity()).append(".").toString());
        if (repartitionNum == 0) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error may occurred or table size is 0, skip repartition.");
            sourceData.write().parquet(resourcePath);
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Repartition snapshot to ").append(repartitionNum).append(" partition.").toString());
            sourceData.repartition(repartitionNum).write().parquet(resourcePath);
        }
        return new Tuple2((Object)tableInfo.identity(), (Object)snapshotTablePath);
    }

    public static final /* synthetic */ boolean $anonfun$buildSingleSnapshot$1(ObjectRef snapshotTablePath$1, FileStatus x$1) {
        String string = x$1.getPath().getName();
        String string2 = new Path((String)snapshotTablePath$1.elem).getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$buildSingleSnapshot$3(CubeSnapshotBuilder $this, FileSystem fs$2, String currSnapMd5$1, ObjectRef snapshotTablePath$1, Path tablePath$1, String resourcePath$1, BooleanRef isReuseSnap$1, FileStatus snap) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> fs$2.listStatus(snap.getPath(), $this.Md5PathFilter()));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            FileStatus[] list = (FileStatus[])success.value();
            Option option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])list)).headOption();
            if (option instanceof Some) {
                Some some = (Some)option;
                FileStatus file = (FileStatus)some.value();
                String md5Snap = file.getPath().getName().replace($this.org$apache$kylin$engine$spark$builder$CubeSnapshotBuilder$$MD5_SUFFIX(), "").replace("_", "");
                String string = currSnapMd5$1;
                String string2 = md5Snap;
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    snapshotTablePath$1.elem = new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)tablePath$1), "/")).append(snap.getPath().getName()).toString();
                    fs$2.delete(new Path(resourcePath$1), true);
                    isReuseSnap$1.elem = true;
                    throw Breaks$.MODULE$.break();
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Snapshot path: ").append(snap.getPath()).append(" not exists snapshot file").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable error = failure.exception();
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "File not found", error);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkDupKey$2(TableDesc tableInfo$2, TableDesc t) {
        return t.identity().equals(tableInfo$2.identity());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$checkDupKey$1(CubeSnapshotBuilder $this, JoinDesc joinDesc) {
        TableDesc tableInfo = joinDesc.lookupTable();
        if ($this.seg().snapshotTables().exists((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)CubeSnapshotBuilder.$anonfun$checkDupKey$2(tableInfo, t)))) {
            String[] lookupTablePKS;
            long countDistinctColumn;
            String lookupTableName = tableInfo.tableName();
            Dataset<Row> df = SparkDataSource$.MODULE$.SparkSource($this.ss()).table(tableInfo);
            long countColumn = df.count();
            if (countColumn == (countDistinctColumn = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.agg(functions$.MODULE$.countDistinct((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])(lookupTablePKS = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])joinDesc.PKS())).map((Function1 & Serializable & scala.Serializable)lookupTablePK -> lookupTablePK.columnName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))))).head(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lookupTablePKS)).tail())), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).collect())).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.getLong(0)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).head()))) return;
            if (!$this.seg().kylinconf().isIgnoringNullInCheckDupKeyEnabled() || countDistinctColumn + 1L != countColumn) throw new IllegalStateException(new StringBuilder(63).append("Failed to build lookup table ").append(lookupTableName).append(" snapshot for Dup key found, key= ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lookupTablePKS)).mkString(",")).toString());
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Using config: kylin.job.ignoring-null-in-check-dup-key-enabled=true to ignore only one null count.");
            return;
        } else {
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Skip check duplicate primary key on table : ").append(tableInfo.identity()).toString());
        }
    }

    public static final /* synthetic */ long $anonfun$buildSnapshotWithoutMd5$1(Path path) {
        return HadoopUtil.getContentSummary(path.getFileSystem(HadoopUtil.getCurrentConfiguration()), path).getLength();
    }

    public CubeSnapshotBuilder() {
        Logging.$init$((Logging)this);
        this.org$apache$kylin$engine$spark$builder$CubeSnapshotBuilder$$MD5_SUFFIX = ".md5";
        this.org$apache$kylin$engine$spark$builder$CubeSnapshotBuilder$$PARQUET_SUFFIX = ".parquet";
        this.MB = 0x100000;
        this.ParquetPathFilter = new PathFilter(this){
            private final /* synthetic */ CubeSnapshotBuilder $outer;

            public boolean accept(Path path) {
                return path.getName().endsWith(this.$outer.org$apache$kylin$engine$spark$builder$CubeSnapshotBuilder$$PARQUET_SUFFIX());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.Md5PathFilter = new PathFilter(this){
            private final /* synthetic */ CubeSnapshotBuilder $outer;

            public boolean accept(Path path) {
                return path.getName().endsWith(this.$outer.org$apache$kylin$engine$spark$builder$CubeSnapshotBuilder$$MD5_SUFFIX());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public CubeSnapshotBuilder(SegmentInfo seg, SparkSession ss) {
        this();
        this.seg_$eq(seg);
        this.ss_$eq(ss);
    }
}

