/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.util.ClassUtil;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.StringSplitter;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDescTiretreeGlobalDomainDictUtil;
import org.apache.kylin.engine.mr.common.JobRelatedMetaUtil;
import org.apache.kylin.engine.mr.common.SerializableConfiguration;
import org.apache.kylin.job.exception.JobException;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.tool.shaded.org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHadoopJob
extends Configured
implements Tool {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHadoopJob.class);
    protected static final Option OPTION_PROJECT;
    protected static final Option OPTION_JOB_NAME;
    protected static final Option OPTION_CUBE_NAME;
    protected static final Option OPTION_CUBING_JOB_ID;
    protected static final Option OPTION_SEGMENT_NAME;
    protected static final Option OPTION_SEGMENT_ID;
    protected static final Option OPTION_INPUT_PATH;
    protected static final Option OPTION_INPUT_FORMAT;
    protected static final Option OPTION_OUTPUT_PATH;
    protected static final Option OPTION_DICT_PATH;
    protected static final Option OPTION_NCUBOID_LEVEL;
    protected static final Option OPTION_PARTITION_FILE_PATH;
    protected static final Option OPTION_HTABLE_NAME;
    protected static final Option OPTION_DICTIONARY_SHRUNKEN_PATH;
    protected static final Option OPTION_STATISTICS_OUTPUT;
    protected static final Option OPTION_STATISTICS_SAMPLING_PERCENT;
    protected static final Option OPTION_CUBOID_MODE;
    protected static final Option OPTION_NEED_UPDATE_BASE_CUBOID_SHARD;
    protected static final Option OPTION_TABLE_NAME;
    protected static final Option OPTION_LOOKUP_SNAPSHOT_ID;
    protected static final Option OPTION_META_URL;
    public static final Option OPTION_HBASE_CONF_PATH;
    private static final String MAP_REDUCE_CLASSPATH = "mapreduce.application.classpath";
    private static final Map<String, KylinConfig> kylinConfigCache;
    protected String name;
    protected boolean isAsync = false;
    protected OptionsHelper optionsHelper = new OptionsHelper();
    protected Job job;

    protected static void runJob(Tool job, String[] args) {
        try {
            int exitCode = ToolRunner.run((Tool)job, (String[])args);
            System.exit(exitCode);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(5);
        }
    }

    public AbstractHadoopJob() {
        super(HadoopUtil.getCurrentConfiguration());
    }

    protected void parseOptions(Options options, String[] args) throws ParseException {
        this.optionsHelper.parseOptions(options, args);
    }

    public void printUsage(Options options) {
        this.optionsHelper.printUsage(((Object)((Object)this)).getClass().getSimpleName(), options);
    }

    public Option[] getOptions() {
        return this.optionsHelper.getOptions();
    }

    public String getOptionsAsString() {
        return this.optionsHelper.getOptionsAsString();
    }

    protected String getOptionValue(Option option) {
        return this.optionsHelper.getOptionValue(option);
    }

    protected boolean hasOption(Option option) {
        return this.optionsHelper.hasOption(option);
    }

    protected int waitForCompletion(Job job) throws IOException, InterruptedException, ClassNotFoundException {
        int retVal = 0;
        long start = System.nanoTime();
        if (this.isAsync) {
            job.submit();
        } else {
            job.waitForCompletion(true);
            retVal = job.isSuccessful() ? 0 : 1;
            logger.debug("Job '" + job.getJobName() + "' finished " + (job.isSuccessful() ? "successfully in " : "with failures.  Time taken ") + StringUtils.formatTime((long)((System.nanoTime() - start) / 1000000L)));
        }
        return retVal;
    }

    protected void setJobClasspath(Job job, KylinConfig kylinConf) {
        String jarPath = kylinConf.getKylinJobJarPath();
        File jarFile = new File(jarPath);
        if (jarFile.exists()) {
            job.setJar(jarPath);
            logger.trace("append job jar: " + jarPath);
        } else {
            job.setJarByClass(((Object)((Object)this)).getClass());
        }
        String kylinHiveDependency = System.getProperty("kylin.hive.dependency");
        String kylinKafkaDependency = System.getProperty("kylin.kafka.dependency");
        Configuration jobConf = job.getConfiguration();
        if (kylinConf.isUseLocalClasspathEnabled()) {
            String classpath = jobConf.get(MAP_REDUCE_CLASSPATH);
            if (classpath == null || classpath.length() == 0) {
                logger.info("Didn't find mapreduce.application.classpath in job configuration, will run 'mapred classpath' to get the default value.");
                classpath = this.getDefaultMapRedClasspath();
                logger.info("The default mapred classpath is: " + classpath);
            }
            jobConf.set(MAP_REDUCE_CLASSPATH, classpath);
        }
        logger.trace("Hadoop job classpath is: " + job.getConfiguration().get(MAP_REDUCE_CLASSPATH));
        StringBuilder kylinDependency = new StringBuilder();
        if (kylinHiveDependency != null) {
            kylinHiveDependency = kylinHiveDependency.replace(":", ",");
            logger.trace("Hive Dependencies Before Filtered: " + kylinHiveDependency);
            String filteredHive = this.filterKylinHiveDependency(kylinHiveDependency, kylinConf);
            logger.trace("Hive Dependencies After Filtered: " + filteredHive);
            StringUtil.appendWithSeparator(kylinDependency, filteredHive);
        } else {
            logger.debug("No hive dependency jars set in the environment, will find them from classpath:");
            try {
                String hiveExecJarPath = ClassUtil.findContainingJar(Class.forName("org.apache.hadoop.hive.ql.Driver"));
                StringUtil.appendWithSeparator(kylinDependency, hiveExecJarPath);
                logger.debug("hive-exec jar file: " + hiveExecJarPath);
                String hiveHCatJarPath = ClassUtil.findContainingJar(Class.forName("org.apache.hive.hcatalog.mapreduce.HCatInputFormat"));
                StringUtil.appendWithSeparator(kylinDependency, hiveHCatJarPath);
                logger.debug("hive-catalog jar file: " + hiveHCatJarPath);
                String hiveMetaStoreJarPath = ClassUtil.findContainingJar(Class.forName("org.apache.hadoop.hive.metastore.api.Table"));
                StringUtil.appendWithSeparator(kylinDependency, hiveMetaStoreJarPath);
                logger.debug("hive-metastore jar file: " + hiveMetaStoreJarPath);
            }
            catch (ClassNotFoundException e) {
                logger.error("Cannot found hive dependency jars: " + e);
            }
        }
        if (kylinKafkaDependency != null) {
            kylinKafkaDependency = kylinKafkaDependency.replace(":", ",");
            logger.trace("Kafka Dependencies: " + kylinKafkaDependency);
            StringUtil.appendWithSeparator(kylinDependency, kylinKafkaDependency);
        } else {
            logger.debug("No Kafka dependency jar set in the environment, will find them from classpath:");
            try {
                String kafkaClientJarPath = ClassUtil.findContainingJar(Class.forName("org.apache.kafka.clients.consumer.KafkaConsumer"));
                StringUtil.appendWithSeparator(kylinDependency, kafkaClientJarPath);
                logger.debug("kafka jar file: " + kafkaClientJarPath);
            }
            catch (ClassNotFoundException e) {
                logger.debug("Not found kafka client jar from classpath, it is optional for normal build: " + e);
            }
        }
        String mrLibDir = kylinConf.getKylinJobMRLibDir();
        logger.trace("MR additional lib dir: " + mrLibDir);
        StringUtil.appendWithSeparator(kylinDependency, mrLibDir);
        this.setJobTmpJarsAndFiles(job, kylinDependency.toString());
    }

    private String filterKylinHiveDependency(String kylinHiveDependency, KylinConfig config) {
        if (org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils.isBlank(kylinHiveDependency)) {
            return "";
        }
        StringBuilder jarList = new StringBuilder();
        Pattern hivePattern = Pattern.compile(config.getHiveDependencyFilterList());
        Matcher matcher = hivePattern.matcher(kylinHiveDependency);
        while (matcher.find()) {
            if (jarList.length() > 0) {
                jarList.append(",");
            }
            jarList.append(matcher.group());
        }
        return jarList.toString();
    }

    private void setJobTmpJarsAndFiles(Job job, String kylinDependency) {
        if (org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils.isBlank(kylinDependency)) {
            return;
        }
        logger.trace("setJobTmpJarsAndFiles: " + kylinDependency);
        try {
            Configuration jobConf = job.getConfiguration();
            LocalFileSystem localfs = FileSystem.getLocal((Configuration)jobConf);
            FileSystem hdfs = HadoopUtil.getWorkingFileSystem(jobConf);
            StringBuilder jarList = new StringBuilder();
            StringBuilder fileList = new StringBuilder();
            for (String fileName : StringUtil.splitAndTrim(kylinDependency, ",")) {
                StringBuilder list;
                FileSystem fs;
                Path p = new Path(fileName);
                if (!p.isAbsolute()) {
                    logger.warn("The directory of kylin dependency '" + fileName + "' is not absolute, skip");
                    continue;
                }
                if (AbstractHadoopJob.exists(hdfs, p)) {
                    fs = hdfs;
                } else if (AbstractHadoopJob.exists((FileSystem)localfs, p)) {
                    fs = localfs;
                } else {
                    logger.warn("The directory of kylin dependency '" + fileName + "' does not exist, skip");
                    continue;
                }
                if (fs.getFileStatus(p).isDirectory()) {
                    logger.trace("Expanding depedency directory: " + p);
                    this.appendTmpDir(job, fs, p, jarList, fileList);
                    continue;
                }
                StringBuilder stringBuilder = list = p.getName().endsWith(".jar") ? jarList : fileList;
                if (list.length() > 0) {
                    list.append(",");
                }
                list.append(fs.getFileStatus(p).getPath());
            }
            this.appendTmpFiles(fileList.toString(), jobConf);
            this.appendTmpJars(jarList.toString(), jobConf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void appendTmpDir(Job job, FileSystem fs, Path tmpDir, StringBuilder jarList, StringBuilder fileList) {
        try {
            FileStatus[] fList;
            for (FileStatus file : fList = fs.listStatus(tmpDir)) {
                StringBuilder list;
                Path p = file.getPath();
                if (fs.getFileStatus(p).isDirectory()) {
                    this.appendTmpDir(job, fs, p, jarList, fileList);
                    continue;
                }
                StringBuilder stringBuilder = list = p.getName().endsWith(".jar") ? jarList : fileList;
                if (list.length() > 0) {
                    list.append(",");
                }
                list.append(fs.getFileStatus(p).getPath().toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void appendTmpJars(String jarList, Configuration conf) {
        if (org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils.isBlank(jarList)) {
            return;
        }
        String tmpJars = conf.get("tmpjars", null);
        tmpJars = tmpJars == null ? jarList : tmpJars + "," + jarList;
        conf.set("tmpjars", tmpJars);
        logger.trace("Job 'tmpjars' updated -- " + tmpJars);
    }

    private void appendTmpFiles(String fileList, Configuration conf) {
        if (org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils.isBlank(fileList)) {
            return;
        }
        String tmpFiles = conf.get("tmpfiles", null);
        tmpFiles = tmpFiles == null ? fileList : tmpFiles + "," + fileList;
        conf.set("tmpfiles", tmpFiles);
        logger.trace("Job 'tmpfiles' updated -- " + tmpFiles);
    }

    private String getDefaultMapRedClasspath() {
        String classpath = "";
        try {
            CliCommandExecutor executor = KylinConfig.getInstanceFromEnv().getCliCommandExecutor();
            String output = executor.execute("mapred classpath").getSecond();
            classpath = output.trim().replace(':', ',');
        }
        catch (IOException e) {
            logger.error("Failed to run: 'mapred classpath'.", e);
        }
        return classpath;
    }

    private static boolean exists(FileSystem fs, Path p) throws IOException {
        try {
            return fs.exists(p);
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static int addInputDirs(String input, Job job) throws IOException {
        int folderNum = AbstractHadoopJob.addInputDirs(StringSplitter.split(input, ","), job);
        logger.info("Number of added folders:" + folderNum);
        return folderNum;
    }

    public static int addInputDirs(String[] inputs, Job job) throws IOException {
        int ret = 0;
        for (String inp : inputs) {
            if ((inp = inp.trim()).endsWith("/*")) {
                Path path;
                inp = inp.substring(0, inp.length() - 2);
                FileSystem fs = HadoopUtil.getWorkingFileSystem(job.getConfiguration());
                if (!AbstractHadoopJob.exists(fs, path = new Path(inp))) {
                    logger.warn("Path not exist:" + path.toString());
                    continue;
                }
                FileStatus[] fileStatuses = fs.listStatus(path);
                boolean hasDir = false;
                for (FileStatus stat : fileStatuses) {
                    if (!stat.isDirectory() || stat.getPath().getName().startsWith("_")) continue;
                    hasDir = true;
                    ret += AbstractHadoopJob.addInputDirs(new String[]{stat.getPath().toString()}, job);
                }
                if (fileStatuses.length <= 0 || hasDir) continue;
                ret += AbstractHadoopJob.addInputDirs(new String[]{path.toString()}, job);
                continue;
            }
            logger.trace("Add input " + inp);
            FileInputFormat.addInputPath((Job)job, (Path)new Path(inp));
            ++ret;
        }
        return ret;
    }

    public static KylinConfig loadKylinPropsAndMetadata() throws IOException {
        File metaDir = new File("meta");
        if (!metaDir.getAbsolutePath().equals(System.getProperty("KYLIN_CONF"))) {
            System.setProperty("KYLIN_CONF", metaDir.getAbsolutePath());
            logger.info("The absolute path for meta dir is " + metaDir.getAbsolutePath());
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            paramsMap.put("path", metaDir.getAbsolutePath());
            StorageURL storageURL = new StorageURL(kylinConfig.getMetadataUrl().getIdentifier(), "ifile", paramsMap);
            kylinConfig.setMetadataUrl(storageURL.toString());
            return kylinConfig;
        }
        return KylinConfig.getInstanceFromEnv();
    }

    public static KylinConfig loadKylinConfigFromHdfs(SerializableConfiguration conf, String uri) {
        HadoopUtil.setCurrentConfiguration(conf.get());
        KylinConfig config = AbstractHadoopJob.loadKylinConfigFromHdfs(uri);
        KylinConfig.SetAndUnsetThreadLocalConfig shouldAutoClose = KylinConfig.setAndUnsetThreadLocalConfig(config);
        return config;
    }

    public static KylinConfig loadKylinConfigFromHdfs(String uri) {
        KylinConfig config;
        if (uri == null) {
            throw new IllegalArgumentException("meta url should not be null");
        }
        if (!uri.contains("@hdfs")) {
            throw new IllegalArgumentException("meta url should like @hdfs schema");
        }
        if (kylinConfigCache.get(uri) != null) {
            logger.info("KylinConfig cached for : {}", (Object)uri);
            return kylinConfigCache.get(uri);
        }
        logger.info("Ready to load KylinConfig from uri: {}", (Object)uri);
        String realHdfsPath = StorageURL.valueOf(uri).getParameter("path") + "/" + "kylin.properties";
        try {
            FileSystem fs = HadoopUtil.getFileSystem(realHdfsPath);
            FSDataInputStream is = fs.open(new Path(realHdfsPath));
            Properties prop = KylinConfig.streamToProps((InputStream)is);
            config = KylinConfig.createKylinConfig(prop);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        kylinConfigCache.put(uri, config);
        return config;
    }

    protected void attachTableMetadata(TableDesc table, Configuration conf) throws IOException {
        LinkedHashSet<String> dumpList = new LinkedHashSet<String>();
        dumpList.add(table.getResourcePath());
        this.dumpKylinPropsAndMetadata(table.getProject(), dumpList, KylinConfig.getInstanceFromEnv(), conf);
    }

    protected void attachCubeMetadata(CubeInstance cube, Configuration conf) throws IOException {
        this.dumpKylinPropsAndMetadata(cube.getProject(), JobRelatedMetaUtil.collectCubeMetadata(cube), cube.getConfig(), conf);
    }

    protected void attachCubeMetadataWithDict(CubeInstance cube, Configuration conf) throws IOException {
        LinkedHashSet<String> dumpList = new LinkedHashSet<String>(JobRelatedMetaUtil.collectCubeMetadata(cube));
        for (CubeSegment segment : cube.getSegments()) {
            dumpList.addAll(segment.getDictionaryPaths());
        }
        this.dumpKylinPropsAndMetadata(cube.getProject(), dumpList, cube.getConfig(), conf);
    }

    protected void attachSegmentsMetadataWithDict(List<CubeSegment> segments, Configuration conf) throws IOException {
        CubeInstance cube = segments.get(0).getCubeInstance();
        LinkedHashSet<String> dumpList = new LinkedHashSet<String>(JobRelatedMetaUtil.collectCubeMetadata(cube));
        for (CubeSegment segment : segments) {
            dumpList.addAll(segment.getDictionaryPaths());
        }
        this.dumpKylinPropsAndMetadata(cube.getProject(), dumpList, cube.getConfig(), conf);
    }

    protected void attachSegmentsMetadataWithDict(List<CubeSegment> segments, String metaUrl) throws IOException {
        LinkedHashSet<String> dumpList = new LinkedHashSet<String>(JobRelatedMetaUtil.collectCubeMetadata(segments.get(0).getCubeInstance()));
        for (CubeSegment segment : segments) {
            dumpList.addAll(segment.getDictionaryPaths());
            dumpList.add(segment.getStatisticsResourcePath());
        }
        JobRelatedMetaUtil.dumpAndUploadKylinPropsAndMetadata(dumpList, (KylinConfigExt)segments.get(0).getConfig(), metaUrl);
    }

    protected void attachSegmentMetadataWithDict(CubeSegment segment, Configuration conf) throws IOException {
        this.attachSegmentMetadata(segment, conf, true, false);
    }

    protected void attachSegmentMetadataWithAll(CubeSegment segment, Configuration conf) throws IOException {
        this.attachSegmentMetadata(segment, conf, true, true);
    }

    protected void attachSegmentMetadata(CubeSegment segment, Configuration conf, boolean ifDictIncluded, boolean ifStatsIncluded) throws IOException {
        LinkedHashSet<String> dumpList = new LinkedHashSet<String>(JobRelatedMetaUtil.collectCubeMetadata(segment.getCubeInstance()));
        if (ifDictIncluded) {
            dumpList.addAll(segment.getDictionaryPaths());
        }
        if (ifStatsIncluded) {
            dumpList.add(segment.getStatisticsResourcePath());
        }
        CubeDescTiretreeGlobalDomainDictUtil.cuboidJob(segment.getCubeDesc(), dumpList);
        this.dumpKylinPropsAndMetadata(segment.getProject(), dumpList, segment.getConfig(), conf);
    }

    protected void dumpKylinPropsAndMetadata(String prj, Set<String> dumpList, KylinConfig kylinConfig, Configuration conf) throws IOException {
        File tmp = Files.createTempFile("kylin_job_meta", "", new FileAttribute[0]).toFile();
        FileUtils.forceDelete(tmp);
        File metaDir = new File(tmp, "meta");
        metaDir.mkdirs();
        File kylinPropsFile = new File(metaDir, "kylin.properties");
        kylinConfig.exportToFile(kylinPropsFile);
        if (prj != null) {
            dumpList.add(ProjectManager.getInstance(kylinConfig).getProject(prj).getResourcePath());
        }
        if (prj != null) {
            dumpList.add(ProjectManager.getInstance(kylinConfig).getProject(prj).getResourcePath());
        }
        JobRelatedMetaUtil.dumpResources(kylinConfig, metaDir, dumpList);
        String hdfsMetaDir = OptionsHelper.convertToFileURL(metaDir.getAbsolutePath());
        hdfsMetaDir = hdfsMetaDir.startsWith("/") ? "file://" + hdfsMetaDir : "file:///" + hdfsMetaDir;
        logger.info("HDFS meta dir is: " + hdfsMetaDir);
        this.appendTmpFiles(hdfsMetaDir, conf);
    }

    protected void cleanupTempConfFile(Configuration conf) {
        String[] tempfiles = org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils.split(conf.get("tmpfiles"), ",");
        if (tempfiles == null) {
            return;
        }
        for (String tempMetaFileString : tempfiles) {
            logger.trace("tempMetaFileString is : " + tempMetaFileString);
            if (tempMetaFileString == null) continue;
            if (tempMetaFileString.startsWith("file://")) {
                File tempMetaFile = new File(tempMetaFileString = tempMetaFileString.substring("file://".length()));
                if (tempMetaFile.exists()) {
                    try {
                        FileUtils.forceDelete(tempMetaFile.getParentFile());
                    }
                    catch (IOException e) {
                        logger.warn("error when deleting " + tempMetaFile, e);
                    }
                    continue;
                }
                logger.info("" + tempMetaFileString + " does not exist");
                continue;
            }
            logger.info("tempMetaFileString is not starting with file:// :" + tempMetaFileString);
        }
    }

    protected void deletePath(Configuration conf, Path path) throws IOException {
        HadoopUtil.deletePath(conf, path);
    }

    public static double getTotalMapInputMB(Job job) throws ClassNotFoundException, IOException, InterruptedException, JobException {
        if (job == null) {
            throw new JobException("Job is null");
        }
        long mapInputBytes = 0L;
        InputFormat input = (InputFormat)ReflectionUtils.newInstance((Class)job.getInputFormatClass(), (Configuration)job.getConfiguration());
        for (InputSplit split : input.getSplits((JobContext)job)) {
            mapInputBytes += split.getLength();
        }
        if (mapInputBytes == 0L) {
            logger.warn("Map input splits are 0 bytes, something is wrong?");
        }
        double totalMapInputMB = (double)mapInputBytes / 1024.0 / 1024.0;
        return totalMapInputMB;
    }

    protected double getTotalMapInputMB() throws ClassNotFoundException, IOException, InterruptedException, JobException {
        return AbstractHadoopJob.getTotalMapInputMB(this.job);
    }

    protected int getMapInputSplitCount() throws ClassNotFoundException, JobException, IOException, InterruptedException {
        if (this.job == null) {
            throw new JobException("Job is null");
        }
        InputFormat input = (InputFormat)ReflectionUtils.newInstance((Class)this.job.getInputFormatClass(), (Configuration)this.job.getConfiguration());
        return input.getSplits((JobContext)this.job).size();
    }

    public void kill() throws JobException {
        if (this.job != null) {
            try {
                this.job.killJob();
            }
            catch (IOException e) {
                throw new JobException(e);
            }
        }
    }

    public Map<String, String> getInfo() throws JobException {
        if (this.job != null) {
            HashMap<String, String> status = new HashMap<String, String>();
            if (null != this.job.getJobID()) {
                status.put("mr_job_id", this.job.getJobID().toString());
            }
            if (null != this.job.getTrackingURL()) {
                status.put("yarn_application_tracking_url", this.job.getTrackingURL().toString());
            }
            return status;
        }
        throw new JobException("Job is null");
    }

    public Counters getCounters() throws JobException {
        if (this.job != null) {
            try {
                return this.job.getCounters();
            }
            catch (IOException e) {
                throw new JobException(e);
            }
        }
        throw new JobException("Job is null");
    }

    public void setAsync(boolean isAsync) {
        this.isAsync = isAsync;
    }

    public Job getJob() {
        return this.job;
    }

    public boolean isSkipped() {
        return false;
    }

    public void setConf(Configuration conf) {
        Configuration healSickConf = HadoopUtil.healSickConfig(conf);
        super.setConf(healSickConf);
    }

    static {
        OptionBuilder.withArgName((String)"project");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Project name.");
        OPTION_PROJECT = OptionBuilder.create((String)"project");
        OptionBuilder.withArgName((String)"jobname");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Job name. For example, Kylin_Cuboid_Builder-clsfd_v2_Step_22-D)");
        OPTION_JOB_NAME = OptionBuilder.create((String)"jobname");
        OptionBuilder.withArgName((String)"cubename");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube name. For exmaple, flat_item_cube");
        OPTION_CUBE_NAME = OptionBuilder.create((String)"cubename");
        OptionBuilder.withArgName((String)"cubingJobId");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"ID of cubing job executable");
        OPTION_CUBING_JOB_ID = OptionBuilder.create((String)"cubingJobId");
        OptionBuilder.withArgName((String)"segmentname");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube segment name");
        OPTION_SEGMENT_NAME = OptionBuilder.create((String)"segmentname");
        OptionBuilder.withArgName((String)"segmentid");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube segment id");
        OPTION_SEGMENT_ID = OptionBuilder.create((String)"segmentid");
        OptionBuilder.withArgName((String)"input");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Input path");
        OPTION_INPUT_PATH = OptionBuilder.create((String)"input");
        OptionBuilder.withArgName((String)"inputformat");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Input format");
        OPTION_INPUT_FORMAT = OptionBuilder.create((String)"inputformat");
        OptionBuilder.withArgName((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Output path");
        OPTION_OUTPUT_PATH = OptionBuilder.create((String)"output");
        OptionBuilder.withArgName((String)"dictPath");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Dict path");
        OPTION_DICT_PATH = OptionBuilder.create((String)"dictPath");
        OptionBuilder.withArgName((String)"level");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"N-Cuboid build level, e.g. 1, 2, 3...");
        OPTION_NCUBOID_LEVEL = OptionBuilder.create((String)"level");
        OptionBuilder.withArgName((String)"partitions");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Partition file path.");
        OPTION_PARTITION_FILE_PATH = OptionBuilder.create((String)"partitions");
        OptionBuilder.withArgName((String)"htablename");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"HTable name");
        OPTION_HTABLE_NAME = OptionBuilder.create((String)"htablename");
        OptionBuilder.withArgName((String)"shrunkenDictPath");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Dictionary shrunken path");
        OPTION_DICTIONARY_SHRUNKEN_PATH = OptionBuilder.create((String)"shrunkenDictPath");
        OptionBuilder.withArgName((String)"statisticsoutput");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Statistics output");
        OPTION_STATISTICS_OUTPUT = OptionBuilder.create((String)"statisticsoutput");
        OptionBuilder.withArgName((String)"statisticssamplingpercent");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Statistics sampling percentage");
        OPTION_STATISTICS_SAMPLING_PERCENT = OptionBuilder.create((String)"statisticssamplingpercent");
        OptionBuilder.withArgName((String)"cuboidMode");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Cuboid Mode");
        OPTION_CUBOID_MODE = OptionBuilder.create((String)"cuboidMode");
        OptionBuilder.withArgName((String)"updateShard");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"If need to update base cuboid shard");
        OPTION_NEED_UPDATE_BASE_CUBOID_SHARD = OptionBuilder.create((String)"updateShard");
        OptionBuilder.withArgName((String)"tableName");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Table name. For exmaple, default.table1");
        OPTION_TABLE_NAME = OptionBuilder.create((String)"tableName");
        OptionBuilder.withArgName((String)"snapshotID");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Lookup table snapshotID");
        OPTION_LOOKUP_SNAPSHOT_ID = OptionBuilder.create((String)"snapshotID");
        OptionBuilder.withArgName((String)"metadataUrl");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"HDFS metadata url");
        OPTION_META_URL = OptionBuilder.create((String)"metadataUrl");
        OptionBuilder.withArgName((String)"hbaseConfPath");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"HBase config file path");
        OPTION_HBASE_CONF_PATH = OptionBuilder.create((String)"hbaseConfPath");
        kylinConfigCache = Maps.newConcurrentMap();
    }
}

