/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kylin.common.Closeable;
import org.apache.kylin.common.KylinConfigBase;
import org.apache.kylin.common.KylinConfigCannotInitException;
import org.apache.kylin.common.restclient.RestClient;
import org.apache.kylin.common.threadlocal.InternalThreadLocal;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.OrderedProperties;
import org.apache.kylin.common.util.VersionUtil;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.base.Strings;
import org.apache.kylin.tool.shaded.org.apache.commons.io.IOUtils;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.apache.zookeeper.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinConfig
extends KylinConfigBase {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(KylinConfig.class);
    private static final String METADATA_URI_PREFIX = "Metadata uri : ";
    public static final String KYLIN_CONF_PROPERTIES_FILE = "kylin.properties";
    public static final String KYLIN_DEFAULT_CONF_PROPERTIES_FILE = "kylin-defaults.properties";
    public static final String KYLIN_CONF = "KYLIN_CONF";
    private static volatile KylinConfig SYS_ENV_INSTANCE = null;
    private static OrderedProperties defaultOrderedProperties = new OrderedProperties();
    private static transient InternalThreadLocal<KylinConfig> THREAD_ENV_INSTANCE = new InternalThreadLocal();
    transient Map<Class, Object> managersCache = new ConcurrentHashMap<Class, Object>();

    public static File getKylinHomeAtBestEffort() {
        String kylinHome = KylinConfig.getKylinHome();
        if (kylinHome != null) {
            return new File(kylinHome).getAbsoluteFile();
        }
        File confFile = KylinConfig.getSitePropertiesFile();
        return confFile.getAbsoluteFile().getParentFile().getParentFile();
    }

    private static void buildDefaultOrderedProperties() {
        try {
            URL resource = Thread.currentThread().getContextClassLoader().getResource(KYLIN_DEFAULT_CONF_PROPERTIES_FILE);
            Preconditions.checkNotNull(resource);
            logger.info("Loading kylin-defaults.properties from {}", (Object)resource.getPath());
            KylinConfig.loadPropertiesFromInputStream(resource.openStream(), defaultOrderedProperties);
            for (int i = 0; i < 10; ++i) {
                String fileName = "kylin-defaults" + i + ".properties";
                URL additionalResource = Thread.currentThread().getContextClassLoader().getResource(fileName);
                if (additionalResource == null) continue;
                logger.info("Loading {} from {} ", (Object)fileName, (Object)additionalResource.getPath());
                KylinConfig.loadPropertiesFromInputStream(additionalResource.openStream(), defaultOrderedProperties);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KylinConfig getInstanceFromEnv(boolean allowConfigFileNoExist) {
        KylinConfig config = THREAD_ENV_INSTANCE.get();
        if (config != null) {
            return config;
        }
        if (SYS_ENV_INSTANCE != null) return SYS_ENV_INSTANCE;
        Class<KylinConfig> clazz = KylinConfig.class;
        synchronized (KylinConfig.class) {
            if (SYS_ENV_INSTANCE != null) return SYS_ENV_INSTANCE;
            try {
                block8: {
                    KylinConfig.buildDefaultOrderedProperties();
                    config = new KylinConfig();
                    try {
                        config.reloadKylinConfig(KylinConfig.buildSiteProperties());
                    }
                    catch (KylinConfigCannotInitException e) {
                        logger.info("Kylin Config Can not Init Exception");
                        if (allowConfigFileNoExist) break block8;
                        throw e;
                    }
                }
                VersionUtil.loadKylinVersion();
                logger.info("Initialized a new KylinConfig from getInstanceFromEnv : " + System.identityHashCode(config));
                SYS_ENV_INSTANCE = config;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Failed to find KylinConfig ", e);
            }
            return SYS_ENV_INSTANCE;
        }
    }

    public static KylinConfig getInstanceFromEnv() {
        return KylinConfig.getInstanceFromEnv(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyInstance() {
        Class<KylinConfig> clazz = KylinConfig.class;
        synchronized (KylinConfig.class) {
            logger.info("Destroy KylinConfig");
            KylinConfig.dumpStackTrace();
            SYS_ENV_INSTANCE = null;
            THREAD_ENV_INSTANCE = new InternalThreadLocal();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void dumpStackTrace() {
    }

    private static UriType decideUriType(String metaUri) {
        try {
            File file = new File(metaUri);
            if (file.exists() || metaUri.contains("/") || Shell.WINDOWS) {
                if (!file.exists()) {
                    file.mkdirs();
                }
                if (file.isDirectory()) {
                    return UriType.LOCAL_FOLDER;
                }
                if (file.isFile()) {
                    if (file.getName().equalsIgnoreCase(KYLIN_CONF_PROPERTIES_FILE)) {
                        return UriType.PROPERTIES_FILE;
                    }
                    throw new IllegalStateException(METADATA_URI_PREFIX + metaUri + " is a local file but not kylin.properties");
                }
                throw new IllegalStateException(METADATA_URI_PREFIX + metaUri + " looks like a file but it's neither a file nor a directory");
            }
            if (RestClient.matchFullRestPattern(metaUri)) {
                return UriType.REST_ADDR;
            }
            throw new IllegalStateException(METADATA_URI_PREFIX + metaUri + " is not a valid REST URI address");
        }
        catch (Exception e) {
            throw new IllegalStateException(METADATA_URI_PREFIX + metaUri + " is not recognized", e);
        }
    }

    public static KylinConfig createInstanceFromUri(String uri) {
        UriType uriType = KylinConfig.decideUriType(uri);
        if (uriType == UriType.LOCAL_FOLDER) {
            KylinConfig config = new KylinConfig();
            config.setMetadataUrl(uri);
            return config;
        }
        if (uriType == UriType.PROPERTIES_FILE) {
            KylinConfig config;
            try {
                config = new KylinConfig();
                FileInputStream is = new FileInputStream(uri);
                Properties prop = KylinConfig.streamToProps(is);
                config.reloadKylinConfig(prop);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return config;
        }
        try {
            KylinConfig config = new KylinConfig();
            RestClient client = new RestClient(uri);
            String propertyText = client.getKylinProperties();
            InputStream is = IOUtils.toInputStream(propertyText, Charset.defaultCharset());
            Properties prop = KylinConfig.streamToProps(is);
            config.reloadKylinConfig(prop);
            return config;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Properties streamToProps(InputStream is) throws IOException {
        Properties prop = new Properties();
        prop.load(is);
        IOUtils.closeQuietly(is);
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setKylinConfigInEnvIfMissing(Properties prop) {
        Class<KylinConfig> clazz = KylinConfig.class;
        synchronized (KylinConfig.class) {
            if (SYS_ENV_INSTANCE == null) {
                try {
                    KylinConfig config = new KylinConfig();
                    config.reloadKylinConfig(prop);
                    logger.info("Resetting SYS_ENV_INSTANCE by a input stream: {}", (Object)System.identityHashCode(config));
                    SYS_ENV_INSTANCE = config;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Failed to find KylinConfig ", e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void setKylinConfigInEnvIfMissing(String propsInStr) throws IOException {
        Properties props = new Properties();
        props.load(new StringReader(propsInStr));
        KylinConfig.setKylinConfigInEnvIfMissing(props);
    }

    public static SetAndUnsetThreadLocalConfig setAndUnsetThreadLocalConfig(KylinConfig config) {
        return new SetAndUnsetThreadLocalConfig(config);
    }

    public static KylinConfig createKylinConfig(String propsInStr) {
        try {
            Properties props = new Properties();
            props.load(new StringReader(propsInStr));
            return KylinConfig.createKylinConfig(props);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create KylinConfig from string: " + propsInStr, e);
        }
    }

    public static KylinConfig createKylinConfig(KylinConfig another) {
        return KylinConfig.createKylinConfig(another.getRawAllProperties());
    }

    public static KylinConfig createKylinConfig(Properties prop) {
        KylinConfig kylinConfig = new KylinConfig();
        kylinConfig.reloadKylinConfig(prop);
        return kylinConfig;
    }

    public static File getKylinConfDir() {
        return KylinConfig.getSitePropertiesFile().getParentFile();
    }

    static File getSitePropertiesFile() {
        String kylinConfHome = KylinConfig.getKylinConfHome();
        if (!StringUtils.isEmpty(kylinConfHome)) {
            logger.info("Use KYLIN_CONF={}", (Object)kylinConfHome);
            return KylinConfig.existFile(kylinConfHome);
        }
        logger.debug("KYLIN_CONF property was not set, will seek KYLIN_HOME env variable");
        String kylinHome = KylinConfig.getKylinHome();
        if (StringUtils.isEmpty(kylinHome)) {
            throw new KylinConfigCannotInitException("Didn't find KYLIN_CONF or KYLIN_HOME, please set one of them");
        }
        logger.info("Use KYLIN_HOME={}", (Object)kylinHome);
        String path = kylinHome + File.separator + "conf";
        return KylinConfig.existFile(path);
    }

    private static File existFile(String path) {
        if (path == null) {
            return null;
        }
        return new File(path, KYLIN_CONF_PROPERTIES_FILE);
    }

    private static Properties buildSiteProperties() {
        Properties conf = new Properties();
        OrderedProperties orderedProperties = KylinConfig.buildSiteOrderedProps();
        for (Map.Entry<String, String> each : orderedProperties.entrySet()) {
            conf.put(each.getKey(), each.getValue().trim());
        }
        return conf;
    }

    private static OrderedProperties buildSiteOrderedProps() {
        try {
            OrderedProperties orderedProperties = new OrderedProperties();
            orderedProperties.putAll(defaultOrderedProperties);
            File propFile = KylinConfig.getSitePropertiesFile();
            if (propFile == null || !propFile.exists()) {
                logger.error("fail to locate kylin.properties at '" + (propFile != null ? propFile.getAbsolutePath() : "") + "'");
                throw new RuntimeException("fail to locate kylin.properties");
            }
            KylinConfig.loadPropertiesFromInputStream(new FileInputStream(propFile), orderedProperties);
            File propOverrideFile = new File(propFile.getParentFile(), propFile.getName() + ".override");
            if (propOverrideFile.exists()) {
                KylinConfig.loadPropertiesFromInputStream(new FileInputStream(propOverrideFile), orderedProperties);
            }
            return orderedProperties;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void loadPropertiesFromInputStream(InputStream inputStream, OrderedProperties properties) {
        Preconditions.checkNotNull(properties);
        try (BufferedReader confReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            OrderedProperties temp = new OrderedProperties();
            temp.load(confReader);
            temp = BCC.check(temp);
            properties.putAll(temp);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setSandboxEnvIfPossible() {
        File dir1 = new File("../examples/test_case_data/sandbox");
        File dir2 = new File("../../kylin/examples/test_case_data/sandbox");
        if (dir1.exists()) {
            logger.info("Setting sandbox env, KYLIN_CONF=" + dir1.getAbsolutePath());
            ClassUtil.addClasspath(dir1.getAbsolutePath());
            System.setProperty(KYLIN_CONF, dir1.getAbsolutePath());
        } else if (dir2.exists()) {
            logger.info("Setting sandbox env, KYLIN_CONF=" + dir2.getAbsolutePath());
            ClassUtil.addClasspath(dir2.getAbsolutePath());
            System.setProperty(KYLIN_CONF, dir2.getAbsolutePath());
        }
    }

    private KylinConfig() {
    }

    protected KylinConfig(Properties props, boolean force) {
        super(props, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getManager(Class<T> clz) {
        Object mgr;
        KylinConfig base = this.base();
        if (base != this) {
            return base.getManager(clz);
        }
        if (this.managersCache == null) {
            this.managersCache = new ConcurrentHashMap<Class, Object>();
        }
        if ((mgr = this.managersCache.get(clz)) != null) {
            return (T)mgr;
        }
        Class<T> clazz = clz;
        synchronized (clazz) {
            mgr = this.managersCache.get(clz);
            if (mgr != null) {
                return (T)mgr;
            }
            try {
                logger.info("Creating new manager instance of {}", (Object)clz);
                Method method = clz.getDeclaredMethod("newInstance", KylinConfig.class);
                method.setAccessible(true);
                mgr = method.invoke(null, this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.managersCache.put(clz, mgr);
        }
        return (T)mgr;
    }

    public void clearManagers() {
        KylinConfig base = this.base();
        if (base != this) {
            base.clearManagers();
            return;
        }
        ConcurrentHashMap<Class, Closeable> closableManagers = new ConcurrentHashMap<Class, Closeable>();
        this.managersCache.forEach((key, value) -> {
            if (value instanceof Closeable) {
                closableManagers.put((Class)key, (Closeable)value);
            }
        });
        this.managersCache.clear();
        if (closableManagers.size() > 0) {
            closableManagers.forEach((key, value) -> {
                logger.info("Close manager {}", (Object)key.getSimpleName());
                value.close();
            });
        }
    }

    public Properties exportToProperties() {
        Properties all = this.getAllProperties();
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)all);
        return copy;
    }

    public String exportAllToString() {
        String[] systemProps;
        Properties allProps = this.getProperties(null);
        OrderedProperties orderedProperties = KylinConfig.buildSiteOrderedProps();
        for (Map.Entry<Object, Object> entry : allProps.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            orderedProperties.setProperty(key, value);
        }
        for (String sysProp : systemProps = new String[]{"kylin.server.cluster-servers", "kylin.server.cluster-servers-with-mode"}) {
            String sysPropValue = System.getProperty(sysProp);
            if (Strings.isNullOrEmpty(sysPropValue)) continue;
            orderedProperties.setProperty(sysProp, sysPropValue);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : orderedProperties.entrySet()) {
            stringBuilder.append(entry.getKey() + "=" + entry.getValue()).append('\n');
        }
        return stringBuilder.toString();
    }

    public String exportToString(Collection<String> propertyKeys) {
        Properties filteredProps = this.getProperties(propertyKeys);
        OrderedProperties orderedProperties = KylinConfig.buildSiteOrderedProps();
        for (String key : propertyKeys) {
            if (filteredProps.containsKey(key)) continue;
            filteredProps.put(key, orderedProperties.getProperty(key, ""));
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Object, Object> entry : filteredProps.entrySet()) {
            sb.append(entry.getKey() + "=" + entry.getValue()).append('\n');
        }
        return sb.toString();
    }

    public void exportToFile(File file) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            this.getAllProperties().store(fos, file.getAbsolutePath());
        }
    }

    public synchronized void reloadFromSiteProperties() {
        this.reloadKylinConfig(KylinConfig.buildSiteProperties());
    }

    public KylinConfig base() {
        return this;
    }

    private int superHashCode() {
        return super.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setKylinConfigForLocalTest(String localMetaDir) {
        Class<KylinConfig> clazz = KylinConfig.class;
        synchronized (KylinConfig.class) {
            if (!new File(localMetaDir, KYLIN_CONF_PROPERTIES_FILE).exists()) {
                throw new IllegalArgumentException(localMetaDir + " is not a valid local meta dir");
            }
            KylinConfig.destroyInstance();
            logger.info("Setting KylinConfig to {} in UT.", (Object)localMetaDir);
            System.setProperty(KYLIN_CONF, localMetaDir);
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            config.setMetadataUrl(localMetaDir);
            File workingDir = new File(localMetaDir, "working-dir");
            workingDir.mkdirs();
            String path = "";
            try {
                path = workingDir.getCanonicalPath();
            }
            catch (IOException e) {
                throw new IllegalStateException("");
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            path = path.replace("\\", "/");
            config.setProperty("kylin.env.hdfs-working-dir", "file:" + path);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public int hashCode() {
        return this.base().superHashCode();
    }

    public boolean equals(Object another) {
        if (!(another instanceof KylinConfig)) {
            return false;
        }
        return this.base() == ((KylinConfig)another).base();
    }

    static {
        String NATIVE_UTF16_CHARSET_NAME = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? "UTF-16BE" : "UTF-16LE";
        System.setProperty("saffron.default.charset", NATIVE_UTF16_CHARSET_NAME);
        System.setProperty("saffron.default.nationalcharset", NATIVE_UTF16_CHARSET_NAME);
        System.setProperty("saffron.default.collation.name", NATIVE_UTF16_CHARSET_NAME + "$en_US");
    }

    public static class SetAndUnsetThreadLocalConfig
    implements AutoCloseable {
        public SetAndUnsetThreadLocalConfig(KylinConfig config) {
            THREAD_ENV_INSTANCE.set(config);
        }

        public KylinConfig get() {
            Preconditions.checkNotNull(THREAD_ENV_INSTANCE.get(), "KylinConfig thread local instance is already closed");
            return (KylinConfig)THREAD_ENV_INSTANCE.get();
        }

        @Override
        public void close() {
            THREAD_ENV_INSTANCE.remove();
        }
    }

    public static enum UriType {
        PROPERTIES_FILE,
        REST_ADDR,
        LOCAL_FOLDER,
        HDFS_FILE;

    }
}

