/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.io.Serializable;
import java.util.Date;
import org.apache.kylin.common.QueryTrace;
import org.apache.kylin.query.util.AbstractSparkJobTrace;
import org.apache.kylin.query.util.SparkJobTrace$;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkStageInfo;
import org.apache.spark.sql.metrics.AppStatus;
import org.apache.spark.status.api.v1.JobData;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000154Aa\u0004\t\u00017!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u0011!)\u0004A!A!\u0002\u00131\u0004\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u000b\u0005\u0003A\u0011\u0001\"\t\u000f!\u0003!\u0019!C\u0001\u0013\"1!\u000b\u0001Q\u0001\n)CQa\u0015\u0001\u0005BQCQ\u0001\u0017\u0001\u0005\u0002QCQ!\u0017\u0001\u0005\u0002Q;qA\u0017\t\u0002\u0002#\u00051LB\u0004\u0010!\u0005\u0005\t\u0012\u0001/\t\u000b\u0005cA\u0011\u00011\t\u000f\u0005d\u0011\u0013!C\u0001E\ni1\u000b]1sW*{'\r\u0016:bG\u0016T!!\u0005\n\u0002\tU$\u0018\u000e\u001c\u0006\u0003'Q\tQ!];fefT!!\u0006\f\u0002\u000b-LH.\u001b8\u000b\u0005]A\u0012AB1qC\u000eDWMC\u0001\u001a\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0004\u0005\u0002\u001e=5\t\u0001#\u0003\u0002 !\t)\u0012IY:ue\u0006\u001cGo\u00159be.TuN\u0019+sC\u000e,\u0017\u0001\u00036pE\u001e\u0013x.\u001e9\u0011\u0005\tZcBA\u0012*!\t!s%D\u0001&\u0015\t1#$\u0001\u0004=e>|GO\u0010\u0006\u0002Q\u0005)1oY1mC&\u0011!fJ\u0001\u0007!J,G-\u001a4\n\u00051j#AB*ue&twM\u0003\u0002+O\u0005Q\u0011/^3ssR\u0013\u0018mY3\u0011\u0005A\u001aT\"A\u0019\u000b\u0005I\"\u0012AB2p[6|g.\u0003\u00025c\tQ\u0011+^3ssR\u0013\u0018mY3\u0002\u0019M\u0004\u0018M]6D_:$X\r\u001f;\u0011\u0005]RT\"\u0001\u001d\u000b\u0005e2\u0012!B:qCJ\\\u0017BA\u001e9\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0003\u001d\u0019H/\u0019:u\u0003R\u0004\"AP \u000e\u0003\u001dJ!\u0001Q\u0014\u0003\t1{gnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\r#UIR$\u0011\u0005u\u0001\u0001\"\u0002\u0011\u0006\u0001\u0004\t\u0003\"\u0002\u0018\u0006\u0001\u0004y\u0003\"B\u001b\u0006\u0001\u00041\u0004b\u0002\u001f\u0006!\u0003\u0005\r!P\u0001\nCB\u00048\u000b^1ukN,\u0012A\u0013\t\u0003\u0017Bk\u0011\u0001\u0014\u0006\u0003\u001b:\u000bq!\\3ue&\u001c7O\u0003\u0002Pq\u0005\u00191/\u001d7\n\u0005Ec%!C!qaN#\u0018\r^;t\u0003)\t\u0007\u000f]*uCR,8\u000fI\u0001\fU>\u0014g)\u001b8jg\",G\rF\u0001V!\tqd+\u0003\u0002XO\t!QK\\5u\u0003=\u0011Xm];mi\u000e{gN^3si\u0016$\u0017!G3oI\u0006\u0013gn\u001c:nC2,\u00050Z2vi&|g\u000e\u0016:bG\u0016\fQb\u00159be.TuN\u0019+sC\u000e,\u0007CA\u000f\r'\taQ\f\u0005\u0002?=&\u0011ql\n\u0002\u0007\u0003:L(+\u001a4\u0015\u0003m\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"T#A2+\u0005u\"7&A3\u0011\u0005\u0019\\W\"A4\u000b\u0005!L\u0017!C;oG\",7m[3e\u0015\tQw%\u0001\u0006b]:|G/\u0019;j_:L!\u0001\\4\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class SparkJobTrace
extends AbstractSparkJobTrace {
    private final String jobGroup;
    private final QueryTrace queryTrace;
    private final long startAt;
    private final AppStatus appStatus;

    public static long $lessinit$greater$default$4() {
        return SparkJobTrace$.MODULE$.$lessinit$greater$default$4();
    }

    public AppStatus appStatus() {
        return this.appStatus;
    }

    @Override
    public void jobFinished() {
        try {
            Seq<JobData> jobDataSeq = this.appStatus().getJobData(this.jobGroup);
            if (jobDataSeq.isEmpty()) {
                this.endAbnormalExecutionTrace();
                return;
            }
            long jobExecutionTime = System.currentTimeMillis() - this.startAt;
            Option submissionTime = (Option)((TraversableOnce)jobDataSeq.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.submissionTime(), Seq$.MODULE$.canBuildFrom())).min(Ordering$.MODULE$.Option(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
            if (submissionTime.isDefined()) {
                this.queryTrace.amendLast("PREPARE_AND_SUBMIT_JOB", ((Date)submissionTime.get()).getTime());
            }
            Option completionTime = (Option)((TraversableOnce)jobDataSeq.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.completionTime(), Seq$.MODULE$.canBuildFrom())).max(Ordering$.MODULE$.Option(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
            if (submissionTime.isDefined() && completionTime.isDefined()) {
                jobExecutionTime = ((Date)completionTime.get()).getTime() - ((Date)submissionTime.get()).getTime();
            }
            Tuple2 jobMetrics = (Tuple2)((TraversableOnce)((TraversableLike)jobDataSeq.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.jobId()), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> SparkJobTrace.$anonfun$jobFinished$4(this, BoxesRunTime.unboxToInt((Object)x$4)), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)new Tuple2.mcDD.sp(0.0, 0.0), (Function2 & Serializable & scala.Serializable)(acc, taskMetrics) -> new Tuple2.mcDD.sp(acc._1$mcD$sp() + BoxesRunTime.unboxToDouble((Object)taskMetrics.executorRunTime().head()) + BoxesRunTime.unboxToDouble((Object)taskMetrics.executorDeserializeTime().head()), acc._2$mcD$sp() + BoxesRunTime.unboxToDouble((Object)taskMetrics.gettingResultTime().head())));
            double launchDelayTimeSum = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)((TraversableLike)jobDataSeq.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.stageIds(), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)stageId -> Option$.MODULE$.option2Iterable(this.appStatus().getStage(BoxesRunTime.unboxToInt((Object)stageId))), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)stage -> BoxesRunTime.boxToDouble((double)SparkJobTrace.$anonfun$jobFinished$8(this, stage)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double sum = jobMetrics._1$mcD$sp() + jobMetrics._2$mcD$sp() + launchDelayTimeSum;
            double computingTime = jobMetrics._1$mcD$sp() * (double)jobExecutionTime / sum;
            double getResultTime = jobMetrics._2$mcD$sp() * (double)jobExecutionTime / sum;
            double launchDelayTime = launchDelayTimeSum * (double)jobExecutionTime / sum;
            this.queryTrace.appendSpan("WAIT_FOR_EXECUTION", Predef$.MODULE$.double2Double(launchDelayTime).longValue());
            this.queryTrace.appendSpan("EXECUTION", Predef$.MODULE$.double2Double(computingTime).longValue());
            this.queryTrace.appendSpan("FETCH_RESULT", Predef$.MODULE$.double2Double(getResultTime).longValue());
        }
        catch (Throwable e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Failed trace spark job execution for ").append($this.jobGroup).toString(), e);
            this.endAbnormalExecutionTrace();
        }
    }

    public void resultConverted() {
        this.queryTrace.amendLast("FETCH_RESULT", System.currentTimeMillis());
    }

    public void endAbnormalExecutionTrace() {
        this.queryTrace.appendSpan("WAIT_FOR_EXECUTION", 0L);
        this.queryTrace.appendSpan("EXECUTION", System.currentTimeMillis() - this.startAt);
        this.queryTrace.appendSpan("FETCH_RESULT", 0L);
    }

    public static final /* synthetic */ Seq $anonfun$jobFinished$4(SparkJobTrace $this, int x$4) {
        return $this.appStatus().getJobStagesSummary(x$4, 0.5);
    }

    public static final /* synthetic */ double $anonfun$jobFinished$8(SparkJobTrace $this, SparkStageInfo stage) {
        return $this.appStatus().getTaskLaunchTime(stage.stageId(), 0.5) - (double)stage.submissionTime();
    }

    public SparkJobTrace(String jobGroup, QueryTrace queryTrace, SparkContext sparkContext, long startAt) {
        this.jobGroup = jobGroup;
        this.queryTrace = queryTrace;
        this.startAt = startAt;
        this.appStatus = new AppStatus(sparkContext);
    }
}

