/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.jackson2;

import java.io.IOException;
import java.util.List;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.node.MissingNode;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;

class UsernamePasswordAuthenticationTokenDeserializer
extends JsonDeserializer<UsernamePasswordAuthenticationToken> {
    UsernamePasswordAuthenticationTokenDeserializer() {
    }

    @Override
    public UsernamePasswordAuthenticationToken deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        UsernamePasswordAuthenticationToken token = null;
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode jsonNode = (JsonNode)mapper.readTree(jp);
        Boolean authenticated = this.readJsonNode(jsonNode, "authenticated").asBoolean();
        JsonNode principalNode = this.readJsonNode(jsonNode, "principal");
        Object principal = null;
        principal = principalNode.isObject() ? mapper.readValue(principalNode.toString(), new TypeReference<User>(){}) : principalNode.asText();
        String credentials = this.readJsonNode(jsonNode, "credentials").asText();
        List<GrantedAuthority> authorities = mapper.readValue(this.readJsonNode(jsonNode, "authorities").toString(), new TypeReference<List<GrantedAuthority>>(){});
        token = authenticated != false ? new UsernamePasswordAuthenticationToken(principal, credentials, authorities) : new UsernamePasswordAuthenticationToken(principal, credentials);
        token.setDetails(this.readJsonNode(jsonNode, "details"));
        return token;
    }

    private JsonNode readJsonNode(JsonNode jsonNode, String field) {
        return jsonNode.has(field) ? jsonNode.get(field) : MissingNode.getInstance();
    }
}

