/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.utils;

import java.io.Serializable;
import java.util.Map;
import org.apache.kylin.cluster.AvailableResource;
import org.apache.kylin.cluster.ClusterInfoFetcher;
import org.apache.kylin.cluster.ResourceInfo;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.hive.utils.DetectItem$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class ResourceUtils$
implements Logging {
    public static ResourceUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ResourceUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String caculateRequiredCores(String sampSplitThreshold, Map<String, String> detectItems, long rowCount) throws Exception {
        String string;
        Object object = new Object();
        try {
            String partitionNum;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                String lineCount;
                String string = lineCount = (String)detectItems.get(DetectItem$.MODULE$.ESTIMATED_LINE_COUNT());
                String string2 = "0";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("the lineCount is ").append(lineCount).toString());
                    throw new NonLocalReturnControl(object, (Object)"1");
                }
                String estimatedSize = (String)detectItems.get(DetectItem$.MODULE$.ESTIMATED_SIZE());
                long splitThreshold = Utils$.MODULE$.byteStringAsBytes(sampSplitThreshold);
                double aveBytesSingleLine = new StringOps(Predef$.MODULE$.augmentString(estimatedSize)).toDouble() / new StringOps(Predef$.MODULE$.augmentString(lineCount)).toDouble();
                Predef$.MODULE$.assert((double)splitThreshold > aveBytesSingleLine);
                double linesPerPartition = (double)splitThreshold / aveBytesSingleLine;
                String partitions = linesPerPartition >= (double)rowCount ? "1" : BoxesRunTime.boxToInteger((int)((int)package$.MODULE$.ceil((double)rowCount / linesPerPartition)));
                MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("linecount is ").append(lineCount).append(", estimatedSize is ").append(estimatedSize).append(", splitThreshold is ").append(splitThreshold).toString());
                MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("aveBytesSingleLine is ").append(aveBytesSingleLine).append(", linesPerPartition is ").append(linesPerPartition).append(", partitions is ").append((Object)partitions).toString());
                return partitions.toString();
            });
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable throwable = failure.exception();
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("caculate required cores failed ").append(MODULE$.getClass().getName()).toString(), throwable);
                    return "1";
                }
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            String string2 = partitionNum = (String)success.value();
            string = string2;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                string = (String)ex.value();
            }
            throw ex;
        }
        return string;
    }

    public boolean checkResource(SparkConf sparkConf, ClusterInfoFetcher clusterInfo) {
        String queue = sparkConf.get("spark.yarn.queue", "default");
        int driverMemory = (int)Utils$.MODULE$.byteStringAsMb(sparkConf.get("spark.driver.memory"));
        if (sparkConf.contains("spark.driver.memoryOverhead")) {
            driverMemory += (int)Utils$.MODULE$.byteStringAsMb(sparkConf.get("spark.driver.memoryOverhead"));
        }
        int driverCores = new StringOps(Predef$.MODULE$.augmentString(sparkConf.get("spark.driver.cores", "1"))).toInt();
        AvailableResource queueAvailable = this.minusDriverResource(clusterInfo.fetchQueueAvailableResource(queue), driverMemory, driverCores);
        int instances = new StringOps(Predef$.MODULE$.augmentString(sparkConf.get("spark.executor.instances"))).toInt();
        long executorMemory = (Utils$.MODULE$.byteStringAsMb(sparkConf.get("spark.executor.memory")) + Utils$.MODULE$.byteStringAsMb(sparkConf.get("spark.executor.memoryOverhead"))) * (long)instances;
        int executorCores = new StringOps(Predef$.MODULE$.augmentString(sparkConf.get("spark.executor.cores"))).toInt() * instances;
        if (!this.verify(queueAvailable.max(), executorMemory, executorCores, instances)) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Require resource (").append(executorMemory).append(" MB, ").append(executorCores).append(" vCores),").append(" queue max resource (").append(queueAvailable.max().memory()).append(" MB, ").append(queueAvailable.max().vCores()).append(" vCores)").toString());
            throw new RuntimeException("Total queue resource does not meet requirement");
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Require resource (").append(executorMemory).append(" MB, ").append(executorCores).append(" vCores),").append(" available resource (").append(queueAvailable.available().memory()).append(" MB, ").append(queueAvailable.available().vCores()).append(" vCores)").toString());
        return this.verify(queueAvailable.available(), executorMemory, executorCores, instances);
    }

    private boolean verify(ResourceInfo resource, long memory, long vCores, int instances) {
        return instances == 1 ? (long)resource.memory() >= memory && (long)resource.vCores() >= vCores : (double)resource.memory() * 1.0 / (double)memory >= 0.5 && (double)resource.vCores() * 1.0 / (double)vCores >= 0.5;
    }

    private AvailableResource minusDriverResource(AvailableResource queueAvailable, int memory, int vCores) {
        int am = queueAvailable.available().memory() - memory;
        int av = queueAvailable.available().vCores() - vCores;
        int mm = queueAvailable.max().memory() - memory;
        int mv = queueAvailable.max().vCores() - vCores;
        return new AvailableResource(new ResourceInfo(am, av), new ResourceInfo(mm, mv));
    }

    private ResourceUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

