/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.metrics;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkStageInfo;
import org.apache.spark.status.TaskDataWrapper;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.status.api.v1.TaskMetricDistributions;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.kvstore.KVStoreIterator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q4A!\u0003\u0006\u0001+!AA\u0004\u0001B\u0001B\u0003%Q\u0004C\u0003\"\u0001\u0011\u0005!\u0005C\u0003'\u0001\u0011\u0005q\u0005C\u00033\u0001\u0011\u00051\u0007C\u0003S\u0001\u0011\u00051\u000bC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0003r\u0001\u0011\u0005!\u000fC\u0003r\u0001\u0011\u0005\u0011PA\u0005BaB\u001cF/\u0019;vg*\u00111\u0002D\u0001\b[\u0016$(/[2t\u0015\tia\"A\u0002tc2T!a\u0004\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VMZ\u0001\rgB\f'o[\"p]R,\u0007\u0010\u001e\t\u0003=}i\u0011AD\u0005\u0003A9\u0011Ab\u00159be.\u001cuN\u001c;fqR\fa\u0001P5oSRtDCA\u0012&!\t!\u0003!D\u0001\u000b\u0011\u0015a\"\u00011\u0001\u001e\u0003E9W\r\u001e+bg.d\u0015-\u001e8dQRKW.\u001a\u000b\u0004Q-\u0002\u0004CA\f*\u0013\tQ\u0003D\u0001\u0004E_V\u0014G.\u001a\u0005\u0006Y\r\u0001\r!L\u0001\bgR\fw-Z%e!\t9b&\u0003\u000201\t\u0019\u0011J\u001c;\t\u000bE\u001a\u0001\u0019\u0001\u0015\u0002\u0011E,\u0018M\u001c;jY\u0016\f\u0011b]2b]R\u000b7o[:\u0015\tQ\u001aE)\u0015\u000b\u0003QUBQA\u000e\u0003A\u0002]\n!A\u001a8\u0011\t]A$\bQ\u0005\u0003sa\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0005mrT\"\u0001\u001f\u000b\u0005ur\u0011AB:uCR,8/\u0003\u0002@y\tyA+Y:l\t\u0006$\u0018m\u0016:baB,'\u000f\u0005\u0002\u0018\u0003&\u0011!\t\u0007\u0002\u0005\u0019>tw\rC\u0003-\t\u0001\u0007Q\u0006C\u0003F\t\u0001\u0007a)A\u0003j]\u0012,\u0007\u0010\u0005\u0002H\u001d:\u0011\u0001\n\u0014\t\u0003\u0013bi\u0011A\u0013\u0006\u0003\u0017R\ta\u0001\u0010:p_Rt\u0014BA'\u0019\u0003\u0019\u0001&/\u001a3fM&\u0011q\n\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055C\u0002\"B\u0019\u0005\u0001\u0004A\u0013aE4fi*{'m\u0015;bO\u0016\u001c8+^7nCJLHc\u0001+fOB\u0019QKW/\u000f\u0005YCfBA%X\u0013\u0005I\u0012BA-\u0019\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0017/\u0003\u0007M+\u0017O\u0003\u0002Z1A\u0011alY\u0007\u0002?*\u0011\u0001-Y\u0001\u0003mFR!A\u0019\u001f\u0002\u0007\u0005\u0004\u0018.\u0003\u0002e?\n9B+Y:l\u001b\u0016$(/[2ESN$(/\u001b2vi&|gn\u001d\u0005\u0006M\u0016\u0001\r!L\u0001\u0006U>\u0014\u0017\n\u001a\u0005\u0006c\u0015\u0001\r\u0001K\u0001\tO\u0016$8\u000b^1hKR\u0011!\u000e\u001d\t\u0004/-l\u0017B\u00017\u0019\u0005\u0019y\u0005\u000f^5p]B\u0011aD\\\u0005\u0003_:\u0011ab\u00159be.\u001cF/Y4f\u0013:4w\u000eC\u0003-\r\u0001\u0007Q&\u0001\u0006hKRTuN\u0019#bi\u0006$\"a]<\u0011\u0007USF\u000f\u0005\u0002_k&\u0011ao\u0018\u0002\b\u0015>\u0014G)\u0019;b\u0011\u0015Ax\u00011\u0001G\u0003!QwNY$s_V\u0004HC\u0001>|!\r92\u000e\u001e\u0005\u0006M\"\u0001\r!\f")
public class AppStatus {
    private final SparkContext sparkContext;

    public double getTaskLaunchTime(int stageId, double quantile) {
        return this.scanTasks(stageId, "lt", quantile, (Function1<TaskDataWrapper, Object>)(Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.launchTime()));
    }

    public double scanTasks(int stageId, String index, double quantile, Function1<TaskDataWrapper, Object> fn) {
        int[] stageKey = new int[]{stageId, 0};
        long count = BoxesRunTime.unboxToLong((Object)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> $this.sparkContext.statusStore().store().view(TaskDataWrapper.class).parent((Object)stageKey).index("ert").first((Object)BoxesRunTime.boxToLong((long)0L)).closeableIterator(), (Function1 & Serializable & scala.Serializable)it -> BoxesRunTime.boxToLong((long)AppStatus.$anonfun$scanTasks$2(it))));
        long idx = package$.MODULE$.min((long)(quantile * (double)count), count - 1L);
        return BoxesRunTime.unboxToDouble((Object)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> $this.sparkContext.statusStore().store().view(TaskDataWrapper.class).parent((Object)stageKey).index(index).first((Object)BoxesRunTime.boxToLong((long)0L)).closeableIterator(), (Function1 & Serializable & scala.Serializable)it -> BoxesRunTime.boxToDouble((double)AppStatus.$anonfun$scanTasks$4(idx, fn, it))));
    }

    public Seq<TaskMetricDistributions> getJobStagesSummary(int jobId, double quantile) {
        return (Seq)this.getJobData(jobId).map((Function1 & Serializable & scala.Serializable)jobData -> (Seq)jobData.stageIds().flatMap((Function1 & Serializable & scala.Serializable)stageId -> Option$.MODULE$.option2Iterable(this.sparkContext.statusStore().taskSummary(BoxesRunTime.unboxToInt((Object)stageId), 0, new double[]{quantile})), Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
    }

    public Option<SparkStageInfo> getStage(int stageId) {
        return this.sparkContext.statusTracker().getStageInfo(stageId);
    }

    public Seq<JobData> getJobData(String jobGroup) {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.sparkContext.statusTracker().getJobIdsForGroup(jobGroup))).map((Function1 & Serializable & scala.Serializable)jobId -> this.getJobData(BoxesRunTime.unboxToInt((Object)jobId)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Option.class))))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDefined())))).map((Function1 & Serializable & scala.Serializable)x$2 -> (JobData)x$2.get(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Option<JobData> getJobData(int jobId) {
        Some some;
        try {
            some = new Some((Object)this.sparkContext.statusStore().job(jobId));
        }
        catch (NoSuchElementException noSuchElementException) {
            some = None$.MODULE$;
        }
        return some;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long $anonfun$scanTasks$2(KVStoreIterator it) {
        void var1_1;
        long _count = 0L;
        while (it.hasNext()) {
            ++_count;
            it.skip(1L);
        }
        return (long)var1_1;
    }

    public static final /* synthetic */ double $anonfun$scanTasks$4(long idx$1, Function1 fn$1, KVStoreIterator it) {
        double d;
        double last = Double.NaN;
        long currentIdx = -1L;
        if (idx$1 == currentIdx) {
            d = last;
        } else {
            long diff = idx$1 - currentIdx;
            currentIdx = idx$1;
            d = it.skip(diff - 1L) ? (last = (double)BoxesRunTime.unboxToLong((Object)fn$1.apply(it.next()))) : Double.NaN;
        }
        return d;
    }

    public AppStatus(SparkContext sparkContext) {
        this.sparkContext = sparkContext;
    }
}

