/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.job;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.job.dao.ExecutableDao;
import org.apache.kylin.job.dao.ExecutableOutputPO;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.exception.PersistentException;
import org.apache.kylin.job.execution.CardinalityExecutable;
import org.apache.kylin.job.execution.CheckpointExecutable;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataCleanupJob {
    private static final Logger logger = LoggerFactory.getLogger(MetadataCleanupJob.class);
    final KylinConfig config;
    private Map<String, Long> garbageResources = Maps.newHashMap();
    private ResourceStore store;

    public MetadataCleanupJob() {
        this(KylinConfig.getInstanceFromEnv());
    }

    public MetadataCleanupJob(KylinConfig config) {
        this.config = config;
        this.store = ResourceStore.getStore(config);
    }

    public Map<String, Long> getGarbageResources() {
        return this.garbageResources;
    }

    public Map<String, Long> cleanup(boolean delete, int jobOutdatedDays) throws Exception {
        HashMap<String, Long> toDeleteCandidates = Maps.newHashMap();
        long outdatedJobTimeCut = System.currentTimeMillis() - (long)(jobOutdatedDays * 24 * 3600) * 1000L;
        ExecutableDao executableDao = ExecutableDao.getInstance(this.config);
        List<ExecutablePO> allExecutable = executableDao.getJobs();
        for (ExecutablePO executable : allExecutable) {
            long lastModified = executable.getLastModified();
            if (lastModified >= outdatedJobTimeCut || !this.isJobComplete(executableDao, executable)) continue;
            String jobResPath = "/execute/" + executable.getUuid();
            String jobOutputResPath = "/execute_output/" + executable.getUuid();
            long outputLastModified = this.getTimestamp(jobOutputResPath);
            toDeleteCandidates.put(jobResPath, lastModified);
            toDeleteCandidates.put(jobOutputResPath, outputLastModified);
            List<ExecutablePO> tasks = executable.getTasks();
            if (tasks == null || tasks.isEmpty()) continue;
            for (ExecutablePO task : executable.getTasks()) {
                String taskId = task.getUuid();
                if (!StringUtils.isNotBlank(taskId)) continue;
                String resPath = "/execute_output/" + task.getUuid();
                long timestamp = this.getTimestamp(resPath);
                toDeleteCandidates.put(resPath, timestamp);
            }
        }
        this.garbageResources = this.cleanupConclude(delete, toDeleteCandidates);
        return this.garbageResources;
    }

    private boolean isJobComplete(ExecutableDao executableDao, ExecutablePO job) {
        String jobId = job.getUuid();
        boolean isComplete = false;
        try {
            ExecutableOutputPO output = executableDao.getJobOutput(jobId);
            String status = output.getStatus();
            String jobType = job.getType();
            if (jobType.equals(CubingJob.class.getName()) || jobType.equals(CheckpointExecutable.class.getName())) {
                if (StringUtils.equals(status, ExecutableState.SUCCEED.toString()) || StringUtils.equals(status, ExecutableState.DISCARDED.toString())) {
                    isComplete = true;
                }
            } else if (jobType.equals(CardinalityExecutable.class.getName())) {
                isComplete = true;
            }
        }
        catch (PersistentException e) {
            logger.error("Get job output failed for job uuid: {}", (Object)jobId, (Object)e);
            isComplete = true;
        }
        return isComplete;
    }

    private Map<String, Long> cleanupConclude(boolean delete, Map<String, Long> toDeleteResources) throws IOException {
        if (toDeleteResources.isEmpty()) {
            logger.info("No metadata resource to clean up");
            return toDeleteResources;
        }
        logger.info("{} metadata resource to clean up", (Object)toDeleteResources.size());
        if (delete) {
            ResourceStore store = ResourceStore.getStore(this.config);
            FileSystem fs = HadoopUtil.getWorkingFileSystem(HadoopUtil.getCurrentConfiguration());
            for (String res : toDeleteResources.keySet()) {
                long timestamp = toDeleteResources.get(res);
                logger.info("Deleting metadata=[resource_path: {}, timestamp: {}]", (Object)res, (Object)timestamp);
                try {
                    if (res.startsWith(KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory())) {
                        fs.delete(new Path(res), true);
                        continue;
                    }
                    store.deleteResource(res, timestamp);
                }
                catch (IOException e) {
                    logger.error("Failed to delete metadata=[resource_path: {}, timestamp: {}] ", res, timestamp, e);
                }
            }
        } else {
            for (String res : toDeleteResources.keySet()) {
                long timestamp = toDeleteResources.get(res);
                logger.info("Dry run, pending delete metadata=[resource_path: {}, timestamp: {}] ", (Object)res, (Object)timestamp);
            }
        }
        return toDeleteResources;
    }

    private long getTimestamp(String resPath) {
        long timestamp = Long.MAX_VALUE;
        try {
            timestamp = this.store.getResourceTimestamp(resPath);
        }
        catch (IOException e) {
            logger.warn("Failed to get resource timestamp from remote resource store, details:{}", e);
        }
        return timestamp;
    }
}

