/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.io.Serializable;
import java.util.Date;
import org.apache.kylin.common.QueryTrace;
import org.apache.kylin.query.util.SparkJobTrace$;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkStageInfo;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.metrics.AppStatus;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.utils.LogEx;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001A4Aa\u0004\t\u00017!A!\u0006\u0001B\u0001B\u0003%1\u0006\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011!i\u0004A!A!\u0002\u0013q\u0004\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u000b\u0019\u0003A\u0011A$\t\u000f9\u0003!\u0019!C\u0001\u001f\"1\u0001\f\u0001Q\u0001\nACQ!\u0017\u0001\u0005\u0002iCQA\u0018\u0001\u0005\u0002iCQa\u0018\u0001\u0005\u0002i;q\u0001\u0019\t\u0002\u0002#\u0005\u0011MB\u0004\u0010!\u0005\u0005\t\u0012\u00012\t\u000b\u0019cA\u0011A2\t\u000f\u0011d\u0011\u0013!C\u0001K\ni1\u000b]1sW*{'\r\u0016:bG\u0016T!!\u0005\n\u0002\tU$\u0018\u000e\u001c\u0006\u0003'Q\tQ!];fefT!!\u0006\f\u0002\u000b-LH.\u001b8\u000b\u0005]A\u0012AB1qC\u000eDWMC\u0001\u001a\u0003\ry'oZ\u0002\u0001'\r\u0001AD\t\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\rBS\"\u0001\u0013\u000b\u0005\u00152\u0013!B;uS2\u001c(BA\u0014\u0017\u0003\u0015\u0019\b/\u0019:l\u0013\tICEA\u0003M_\u001e,\u00050\u0001\u0005k_\n<%o\\;q!\ta3G\u0004\u0002.cA\u0011aFH\u0007\u0002_)\u0011\u0001GG\u0001\u0007yI|w\u000e\u001e \n\u0005Ir\u0012A\u0002)sK\u0012,g-\u0003\u00025k\t11\u000b\u001e:j]\u001eT!A\r\u0010\u0002\u0015E,XM]=Ue\u0006\u001cW\r\u0005\u00029w5\t\u0011H\u0003\u0002;)\u000511m\\7n_:L!\u0001P\u001d\u0003\u0015E+XM]=Ue\u0006\u001cW-\u0001\u0007ta\u0006\u00148nQ8oi\u0016DH\u000f\u0005\u0002@\u00016\ta%\u0003\u0002BM\ta1\u000b]1sW\u000e{g\u000e^3yi\u000691\u000f^1si\u0006#\bCA\u000fE\u0013\t)eD\u0001\u0003M_:<\u0017A\u0002\u001fj]&$h\bF\u0003I\u0015.cU\n\u0005\u0002J\u00015\t\u0001\u0003C\u0003+\u000b\u0001\u00071\u0006C\u00037\u000b\u0001\u0007q\u0007C\u0003>\u000b\u0001\u0007a\bC\u0004C\u000bA\u0005\t\u0019A\"\u0002\u0013\u0005\u0004\bo\u0015;biV\u001cX#\u0001)\u0011\u0005E3V\"\u0001*\u000b\u0005M#\u0016aB7fiJL7m\u001d\u0006\u0003+\u001a\n1a]9m\u0013\t9&KA\u0005BaB\u001cF/\u0019;vg\u0006Q\u0011\r\u001d9Ti\u0006$Xo\u001d\u0011\u0002\u0017)|'MR5oSNDW\r\u001a\u000b\u00027B\u0011Q\u0004X\u0005\u0003;z\u0011A!\u00168ji\u0006y!/Z:vYR\u001cuN\u001c<feR,G-A\rf]\u0012\f%M\\8s[\u0006dW\t_3dkRLwN\u001c+sC\u000e,\u0017!D*qCJ\\'j\u001c2Ue\u0006\u001cW\r\u0005\u0002J\u0019M\u0011A\u0002\b\u000b\u0002C\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\u0012A\u001a\u0016\u0003\u0007\u001e\\\u0013\u0001\u001b\t\u0003S:l\u0011A\u001b\u0006\u0003W2\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u00055t\u0012AC1o]>$\u0018\r^5p]&\u0011qN\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class SparkJobTrace
implements LogEx {
    private final String jobGroup;
    private final QueryTrace queryTrace;
    private final long startAt;
    private final AppStatus appStatus;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static long $lessinit$greater$default$4() {
        return SparkJobTrace$.MODULE$.$lessinit$greater$default$4();
    }

    @Override
    public <U> U logTime(String action, boolean info, Function0<U> body) {
        return (U)LogEx.logTime$(this, action, info, body);
    }

    @Override
    public <U> boolean logTime$default$2() {
        return LogEx.logTime$default$2$(this);
    }

    @Override
    public void logInfoIf(Function0<Object> filter, Function0<String> msg) {
        LogEx.logInfoIf$(this, filter, msg);
    }

    @Override
    public void logWarningIf(Function0<Object> filter, Function0<String> msg) {
        LogEx.logWarningIf$(this, filter, msg);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public AppStatus appStatus() {
        return this.appStatus;
    }

    public void jobFinished() {
        try {
            Seq<JobData> jobDataSeq = this.appStatus().getJobData(this.jobGroup);
            if (jobDataSeq.isEmpty()) {
                this.endAbnormalExecutionTrace();
                return;
            }
            long jobExecutionTime = System.currentTimeMillis() - this.startAt;
            Option submissionTime = (Option)((TraversableOnce)jobDataSeq.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.submissionTime(), Seq$.MODULE$.canBuildFrom())).min(Ordering$.MODULE$.Option(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
            if (submissionTime.isDefined()) {
                this.queryTrace.amendLast("PREPARE_AND_SUBMIT_JOB", ((Date)submissionTime.get()).getTime());
            }
            Option completionTime = (Option)((TraversableOnce)jobDataSeq.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.completionTime(), Seq$.MODULE$.canBuildFrom())).max(Ordering$.MODULE$.Option(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
            if (submissionTime.isDefined() && completionTime.isDefined()) {
                jobExecutionTime = ((Date)completionTime.get()).getTime() - ((Date)submissionTime.get()).getTime();
            }
            Tuple2 jobMetrics = (Tuple2)((TraversableOnce)((TraversableLike)jobDataSeq.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.jobId()), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> SparkJobTrace.$anonfun$jobFinished$4(this, BoxesRunTime.unboxToInt((Object)x$4)), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)new Tuple2.mcDD.sp(0.0, 0.0), (Function2 & Serializable & scala.Serializable)(acc, taskMetrics) -> new Tuple2.mcDD.sp(acc._1$mcD$sp() + BoxesRunTime.unboxToDouble((Object)taskMetrics.executorRunTime().head()) + BoxesRunTime.unboxToDouble((Object)taskMetrics.executorDeserializeTime().head()), acc._2$mcD$sp() + BoxesRunTime.unboxToDouble((Object)taskMetrics.gettingResultTime().head())));
            double launchDelayTimeSum = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)((TraversableLike)jobDataSeq.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.stageIds(), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)stageId -> Option$.MODULE$.option2Iterable(this.appStatus().getStage(BoxesRunTime.unboxToInt((Object)stageId))), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)stage -> BoxesRunTime.boxToDouble((double)SparkJobTrace.$anonfun$jobFinished$8(this, stage)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double sum = jobMetrics._1$mcD$sp() + jobMetrics._2$mcD$sp() + launchDelayTimeSum;
            double computingTime = jobMetrics._1$mcD$sp() * (double)jobExecutionTime / sum;
            double getResultTime = jobMetrics._2$mcD$sp() * (double)jobExecutionTime / sum;
            double launchDelayTime = launchDelayTimeSum * (double)jobExecutionTime / sum;
            this.queryTrace.appendSpan("WAIT_FOR_EXECUTION", Predef$.MODULE$.double2Double(launchDelayTime).longValue());
            this.queryTrace.appendSpan("EXECUTION", Predef$.MODULE$.double2Double(computingTime).longValue());
            this.queryTrace.appendSpan("FETCH_RESULT", Predef$.MODULE$.double2Double(getResultTime).longValue());
        }
        catch (Throwable e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Failed trace spark job execution for ").append($this.jobGroup).toString(), e);
            this.endAbnormalExecutionTrace();
        }
    }

    public void resultConverted() {
        this.queryTrace.amendLast("FETCH_RESULT", System.currentTimeMillis());
    }

    public void endAbnormalExecutionTrace() {
        this.queryTrace.appendSpan("WAIT_FOR_EXECUTION", 0L);
        this.queryTrace.appendSpan("EXECUTION", System.currentTimeMillis() - this.startAt);
        this.queryTrace.appendSpan("FETCH_RESULT", 0L);
    }

    public static final /* synthetic */ Seq $anonfun$jobFinished$4(SparkJobTrace $this, int x$4) {
        return $this.appStatus().getJobStagesSummary(x$4, 0.5);
    }

    public static final /* synthetic */ double $anonfun$jobFinished$8(SparkJobTrace $this, SparkStageInfo stage) {
        return $this.appStatus().getTaskLaunchTime(stage.stageId(), 0.5) - (double)stage.submissionTime();
    }

    public SparkJobTrace(String jobGroup, QueryTrace queryTrace, SparkContext sparkContext, long startAt) {
        this.jobGroup = jobGroup;
        this.queryTrace = queryTrace;
        this.startAt = startAt;
        Logging.$init$((Logging)this);
        LogEx.$init$(this);
        this.appStatus = new AppStatus(sparkContext);
    }
}

