/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.runtime;

import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.kylin.common.QueryContextFacade;
import org.apache.kylin.query.exec.QueryEngine;
import org.apache.kylin.query.runtime.CalciteToSparkPlaner;
import org.apache.kylin.query.runtime.plans.ResultPlan;
import org.apache.kylin.query.runtime.plans.ResultType;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkEngine
implements QueryEngine {
    private static final Logger log = LoggerFactory.getLogger(SparkEngine.class);

    @Override
    public Enumerable<Object> computeSCALA(DataContext dataContext, RelNode relNode, RelDataType resultType) {
        Dataset<Row> sparkPlan = this.toSparkPlan(dataContext, relNode);
        if (System.getProperty("calcite.debug") != null) {
            log.debug("SPARK LOGICAL PLAN {}", (Object)sparkPlan.queryExecution());
        }
        return (Enumerable)ResultPlan.getResult(sparkPlan, resultType, ResultType.SCALA()).right().get();
    }

    @Override
    public Enumerable<Object[]> compute(DataContext dataContext, RelNode relNode, RelDataType resultType) {
        Dataset<Row> sparkPlan = this.toSparkPlan(dataContext, relNode);
        if (System.getProperty("calcite.debug") != null) {
            log.info("SPARK LOGICAL PLAN {}", (Object)sparkPlan.queryExecution());
        }
        return (Enumerable)ResultPlan.getResult(sparkPlan, resultType, ResultType.NORMAL()).left().get();
    }

    private Dataset<Row> toSparkPlan(DataContext dataContext, RelNode relNode) {
        log.trace("Begin planning spark plan.");
        QueryContextFacade.current().getQueryTrace().startSpan("PREPARE_AND_SUBMIT_JOB");
        long start = System.currentTimeMillis();
        CalciteToSparkPlaner calciteToSparkPlaner = new CalciteToSparkPlaner(dataContext);
        calciteToSparkPlaner.go(relNode);
        long takeTime = System.currentTimeMillis() - start;
        log.trace("Plan take {} ms", (Object)takeTime);
        return calciteToSparkPlaner.getResult();
    }
}

