/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.execution;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.MailService;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeBuildTypeEnum;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.exception.JobStoppedException;
import org.apache.kylin.job.exception.PersistentException;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.Executable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.execution.Idempotent;
import org.apache.kylin.job.execution.Output;
import org.apache.kylin.job.impl.threadpool.DefaultContext;
import org.apache.kylin.job.util.MailNotificationUtil;
import org.apache.kylin.shaded.com.google.common.base.MoreObjects;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.ArrayUtils;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExecutable
implements Executable,
Idempotent {
    public static final Integer DEFAULT_PRIORITY = 10;
    public static final String CUBE_NAME = "cubeName";
    protected static final String SUBMITTER = "submitter";
    protected static final String NOTIFY_LIST = "notify_list";
    protected static final String PARENT_ID = "parentId";
    protected static final String START_TIME = "startTime";
    protected static final String END_TIME = "endTime";
    protected static final String INTERRUPT_TIME = "interruptTime";
    protected static final String BUILD_INSTANCE = "buildInstance";
    protected static final String PROJECT_INSTANCE_NAME = "projectName";
    protected static final Logger logger = LoggerFactory.getLogger(AbstractExecutable.class);
    public static final String NO_NEED_TO_SEND_EMAIL_USER_LIST_IS_EMPTY = "no need to send email, user list is empty";
    protected int retry = 0;
    private KylinConfig config;
    private String name;
    private String id;
    private AbstractExecutable parentExecutable = null;
    private Map<String, String> params = Maps.newHashMap();
    protected Integer priority;
    private CubeBuildTypeEnum jobType;
    private String logPath;
    protected String project;
    private String targetSubject;
    private List<String> targetSegments = Lists.newArrayList();

    public AbstractExecutable() {
        this.setId(RandomUtil.randomUUID().toString());
    }

    protected void initConfig(KylinConfig config) {
        Preconditions.checkState(this.config == null || this.config == config);
        this.config = config;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public String getLogPath() {
        return this.logPath;
    }

    protected KylinConfig getConfig() {
        return this.config;
    }

    protected ExecutableManager getManager() {
        return ExecutableManager.getInstance(this.config);
    }

    protected void onExecuteStart(ExecutableContext executableContext) {
        this.checkJobPaused();
        HashMap<String, String> info = Maps.newHashMap();
        info.put(START_TIME, Long.toString(System.currentTimeMillis()));
        this.getManager().updateJobOutput(this.getParam("project"), this.getId(), ExecutableState.RUNNING, info, null, this.getLogPath());
    }

    public KylinConfig getCubeSpecificConfig() {
        String cubeName = this.getCubeName();
        CubeManager manager = CubeManager.getInstance(KylinConfig.getInstanceFromEnv());
        CubeInstance cube = manager.getCube(cubeName);
        return cube.getConfig();
    }

    private void onExecuteFinishedWithRetry(ExecuteResult result, ExecutableContext executableContext) throws ExecuteException {
        Exception exception;
        int nRetry = 0;
        do {
            ++nRetry;
            exception = null;
            try {
                this.onExecuteFinished(result, executableContext);
            }
            catch (Exception e) {
                logger.error(nRetry + "th retries for onExecuteFinished fails due to {}", e);
                if (AbstractExecutable.isMetaDataPersistException(e, 5)) {
                    exception = e;
                    try {
                        Thread.sleep(1000L * (long)Math.pow(4.0, nRetry));
                        continue;
                    }
                    catch (InterruptedException e1) {
                        throw new IllegalStateException(e1);
                    }
                }
                throw e;
            }
        } while (exception != null && nRetry <= executableContext.getConfig().getJobMetadataPersistRetry());
        if (exception != null) {
            this.handleMetadataPersistException(executableContext, exception);
            throw new ExecuteException(exception);
        }
    }

    protected void onExecuteFinished(ExecuteResult result, ExecutableContext executableContext) {
        this.setEndTime(System.currentTimeMillis());
        if (!this.isDiscarded() && !this.isRunnable()) {
            if (result.succeed()) {
                this.getManager().updateJobOutput(this.getParam("project"), this.getId(), ExecutableState.SUCCEED, null, result.output(), this.getLogPath());
            } else {
                this.getManager().updateJobOutput(this.getParam("project"), this.getId(), ExecutableState.ERROR, null, result.output(), this.getLogPath());
            }
        }
    }

    protected void onExecuteError(Throwable exception, ExecutableContext executableContext) {
        this.checkJobPaused();
        if (!this.isDiscarded()) {
            this.getManager().addJobInfo(this.getId(), END_TIME, Long.toString(System.currentTimeMillis()));
            String output = null;
            if (exception != null) {
                StringWriter out = new StringWriter();
                exception.printStackTrace(new PrintWriter(out));
                output = out.toString();
            }
            this.getManager().updateJobOutput(this.getParam("project"), this.getId(), ExecutableState.ERROR, null, output, this.getLogPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ExecuteResult execute(ExecutableContext executableContext) throws ExecuteException {
        logger.info("Executing AbstractExecutable ({})", (Object)this.getName());
        Preconditions.checkArgument(executableContext instanceof DefaultContext);
        ExecuteResult result = null;
        try {
            Throwable catchedException;
            Throwable realException;
            this.onExecuteStart(executableContext);
            do {
                if (this.retry > 0) {
                    this.pauseOnRetry();
                    logger.info("Begin to retry, retry time: {}", (Object)this.retry);
                }
                this.checkJobPaused();
                catchedException = null;
                result = null;
                try {
                    result = this.doWork(executableContext);
                }
                catch (JobStoppedException e) {
                    logger.debug("The job be paused, ignore it: {}", (Object)this.toString());
                }
                catch (Throwable e) {
                    logger.error("error running Executable: {}", (Object)this.toString());
                    catchedException = e;
                }
                finally {
                    this.cleanup(result);
                }
                ++this.retry;
            } while (this.needRetry(this.retry, realException = catchedException != null ? catchedException : (result.getThrowable() != null ? result.getThrowable() : null)));
            if (realException != null) {
                this.onExecuteError(realException, executableContext);
                throw new ExecuteException(realException);
            }
            this.onExecuteFinishedWithRetry(result, executableContext);
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (JobStoppedException e) {
            result = ExecuteResult.createSucceed();
        }
        catch (Exception e) {
            throw new ExecuteException(e);
        }
        return result;
    }

    protected void handleMetadataPersistException(ExecutableContext context, Throwable exception) {
        String[] adminDls = context.getConfig().getAdminDls();
        if (adminDls == null || adminDls.length < 1) {
            logger.warn(NO_NEED_TO_SEND_EMAIL_USER_LIST_IS_EMPTY);
            return;
        }
        ArrayList<String> users = Lists.newArrayList(adminDls);
        HashMap<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("job_name", this.getName());
        dataMap.put("env_name", context.getConfig().getDeployEnv());
        dataMap.put(SUBMITTER, StringUtil.noBlank(this.getSubmitter(), "missing submitter"));
        dataMap.put("job_engine", MailNotificationUtil.getLocalHostName());
        dataMap.put("error_log", Matcher.quoteReplacement(StringUtil.noBlank(exception.getMessage(), "no error message")));
        String content = MailNotificationUtil.getMailContent("METADATA_PERSIST_FAIL", dataMap);
        String title = MailNotificationUtil.getMailTitle("METADATA PERSIST", "FAIL", context.getConfig().getDeployEnv());
        new MailService(context.getConfig()).sendMail(users, title, content);
    }

    protected abstract ExecuteResult doWork(ExecutableContext var1) throws ExecuteException, PersistentException;

    @Override
    public void cleanup(ExecuteResult result) throws ExecuteException {
    }

    public static boolean isMetaDataPersistException(Exception e, int maxDepth) {
        if (e instanceof PersistentException) {
            return true;
        }
        Throwable t = e.getCause();
        for (int depth = 0; t != null && depth < maxDepth; ++depth, t = t.getCause()) {
            if (!(t instanceof PersistentException)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRunnable() {
        return this.getStatus() == ExecutableState.READY;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public final void setId(String id) {
        this.id = id;
    }

    @Override
    public ExecutableState getStatus() {
        ExecutableManager manager = this.getManager();
        return manager.getOutput(this.getId()).getState();
    }

    @Override
    public final Map<String, String> getParams() {
        return this.params;
    }

    public final String getParam(String key) {
        return this.params.get(key);
    }

    public final void setParam(String key, String value) {
        this.params.put(key, value);
    }

    public final void setParams(Map<String, String> params) {
        this.params.putAll(params);
    }

    public final long getLastModified() {
        return this.getOutput().getLastModified();
    }

    public final void setSubmitter(String submitter) {
        this.setParam(SUBMITTER, submitter);
    }

    public final List<String> getNotifyList() {
        String str = this.getParam(NOTIFY_LIST);
        if (str != null) {
            return Lists.newArrayList(org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils.split(str, ","));
        }
        return Collections.emptyList();
    }

    public final void setNotifyList(String notifications) {
        this.setParam(NOTIFY_LIST, notifications);
    }

    public final void setNotifyList(List<String> notifications) {
        this.setNotifyList(org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils.join(notifications, ","));
    }

    protected Pair<String, String> formatNotifications(ExecutableContext executableContext, ExecutableState state) {
        return null;
    }

    protected final void notifyUserStatusChange(ExecutableContext context, ExecutableState state) {
        try {
            List<String> users = this.getAllNofifyUsers(this.config);
            if (users.isEmpty()) {
                logger.debug(NO_NEED_TO_SEND_EMAIL_USER_LIST_IS_EMPTY);
                return;
            }
            Pair<String, String> email = this.formatNotifications(context, state);
            this.doSendMail(this.config, users, email);
        }
        catch (Exception e) {
            logger.error("error send email", e);
        }
    }

    private List<String> getAllNofifyUsers(KylinConfig kylinConfig) {
        ArrayList<String> users = Lists.newArrayList();
        users.addAll(this.getNotifyList());
        String[] adminDls = kylinConfig.getAdminDls();
        if (null != adminDls) {
            for (String adminDl : adminDls) {
                users.add(adminDl);
            }
        }
        return users;
    }

    private void doSendMail(KylinConfig kylinConfig, List<String> users, Pair<String, String> email) {
        if (email == null) {
            logger.warn("no need to send email, content is null");
            return;
        }
        logger.info("prepare to send email to:{}", (Object)users);
        logger.info("job name:{}", (Object)this.getName());
        logger.info("submitter:{}", (Object)this.getSubmitter());
        logger.info("notify list:{}", (Object)users);
        new MailService(kylinConfig).sendMail(users, email.getFirst(), email.getSecond());
    }

    protected void sendMail(Pair<String, String> email) {
        try {
            List<String> users = this.getAllNofifyUsers(this.config);
            if (users.isEmpty()) {
                logger.debug(NO_NEED_TO_SEND_EMAIL_USER_LIST_IS_EMPTY);
                return;
            }
            this.doSendMail(this.config, users, email);
        }
        catch (Exception e) {
            logger.error("error send email", e);
        }
    }

    public void checkJobPaused() {
        AbstractExecutable job = this;
        if (this.getParentId() != null) {
            job = this.getParent();
        }
        logger.info("The state of job is:" + (Object)((Object)job.getStatus()));
        if (ExecutableState.STOPPED.equals((Object)job.getStatus()) || ExecutableState.DISCARDED.equals((Object)job.getStatus())) {
            throw new JobStoppedException();
        }
    }

    public final String getSubmitter() {
        return this.getParam(SUBMITTER);
    }

    public final String getCubeName() {
        return this.getParam(CUBE_NAME);
    }

    @Override
    public final Output getOutput() {
        return this.getManager().getOutput(this.getId());
    }

    protected long getExtraInfoAsLong(String key, long defaultValue) {
        return AbstractExecutable.getExtraInfoAsLong(this.getOutput(), key, defaultValue);
    }

    public static String getBuildInstance(Output output) {
        String str = output.getExtra().get(BUILD_INSTANCE);
        if (str != null) {
            return str;
        }
        return "unknown";
    }

    public static long getStartTime(Output output) {
        return AbstractExecutable.getExtraInfoAsLong(output, START_TIME, 0L);
    }

    public static long getEndTime(Output output) {
        return AbstractExecutable.getExtraInfoAsLong(output, END_TIME, 0L);
    }

    public static long getInterruptTime(Output output) {
        return AbstractExecutable.getExtraInfoAsLong(output, INTERRUPT_TIME, 0L);
    }

    public static long getDuration(long startTime, long endTime, long interruptTime) {
        if (startTime == 0L) {
            return 0L;
        }
        if (endTime == 0L) {
            return System.currentTimeMillis() - startTime - interruptTime;
        }
        return endTime - startTime - interruptTime;
    }

    public AbstractExecutable getParentExecutable() {
        return this.parentExecutable;
    }

    public void setParentExecutable(AbstractExecutable parentExecutable) {
        this.parentExecutable = parentExecutable;
    }

    public static long getExtraInfoAsLong(Output output, String key, long defaultValue) {
        String str = output.getExtra().get(key);
        if (str != null) {
            return Long.parseLong(str);
        }
        return defaultValue;
    }

    public final void addExtraInfo(String key, String value) {
        this.getManager().addJobInfo(this.getId(), key, value);
    }

    public final String getExtraInfo(String key) {
        return this.getExtraInfo().get(key);
    }

    protected final Map<String, String> getExtraInfo() {
        return this.getOutput().getExtra();
    }

    public final void setStartTime(long time) {
        this.addExtraInfo(START_TIME, time + "");
    }

    public final void setEndTime(long time) {
        this.addExtraInfo(END_TIME, time + "");
    }

    public final void setInterruptTime(long time) {
        this.addExtraInfo(INTERRUPT_TIME, time + "");
    }

    public final long getStartTime() {
        return this.getExtraInfoAsLong(START_TIME, 0L);
    }

    public final long getEndTime() {
        return this.getExtraInfoAsLong(END_TIME, 0L);
    }

    public final long getInterruptTime() {
        return this.getExtraInfoAsLong(INTERRUPT_TIME, 0L);
    }

    public final long getDuration() {
        return AbstractExecutable.getDuration(this.getStartTime(), this.getEndTime(), this.getInterruptTime());
    }

    public boolean isReady() {
        Output output = this.getManager().getOutput(this.id);
        return output.getState() == ExecutableState.READY;
    }

    public int getDefaultPriority() {
        return DEFAULT_PRIORITY;
    }

    public Integer getPriority() {
        return this.priority == null ? this.getDefaultPriority() : this.priority.intValue();
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public void setPriorityBasedOnPriorityOffset(Integer priorityOffset) {
        this.priority = this.getDefaultPriority() + (priorityOffset == null ? 0 : priorityOffset);
    }

    protected final boolean isDiscarded() {
        ExecutableState status = this.getOutput().getState();
        return status == ExecutableState.DISCARDED;
    }

    protected final boolean isPaused() {
        ExecutableState status = this.getOutput().getState();
        return status == ExecutableState.STOPPED;
    }

    public boolean needRetry(int retry, Throwable t) {
        if (retry > KylinConfig.getInstanceFromEnv().getJobRetry() || t == null || this instanceof DefaultChainedExecutable) {
            return false;
        }
        return AbstractExecutable.isRetryableException(t.getClass().getName());
    }

    public void pauseOnRetry() {
        int interval = KylinConfig.getInstanceFromEnv().getJobRetryInterval();
        logger.info("Pause {} milliseconds before retry", (Object)interval);
        try {
            TimeUnit.MILLISECONDS.sleep(interval);
        }
        catch (InterruptedException e) {
            logger.error("Job retry was interrupted, details: {}", e);
            Thread.currentThread().interrupt();
        }
    }

    private static boolean isRetryableException(String exceptionName) {
        Object[] jobRetryExceptions = KylinConfig.getInstanceFromEnv().getJobRetryExceptions();
        return ArrayUtils.isEmpty(jobRetryExceptions) || ArrayUtils.contains(jobRetryExceptions, exceptionName);
    }

    public final String getProject() {
        if (this.project == null) {
            throw new IllegalStateException("project is not set for abstract executable " + this.getId());
        }
        return this.project;
    }

    public final void setProject(String project) {
        this.project = project;
    }

    public void setJobType(CubeBuildTypeEnum jobType) {
        this.jobType = jobType;
    }

    public String getTargetSubject() {
        return this.targetSubject;
    }

    public void setTargetSubject(String targetSubject) {
        this.targetSubject = targetSubject;
    }

    public List<String> getTargetSegments() {
        return this.targetSegments;
    }

    public void setTargetSegments(List<String> targetSegments) {
        this.targetSegments = targetSegments;
    }

    public String toString() {
        ExecutableState state = null;
        try {
            state = this.getStatus();
        }
        catch (RuntimeException e) {
            logger.error("failed to get job status:" + this.getId(), e);
        }
        return MoreObjects.toStringHelper(this).add("id", this.getId()).add("name", this.getName()).add("state", (Object)state).toString();
    }

    public String getProjectName() {
        return this.getParam(PROJECT_INSTANCE_NAME);
    }

    public void setProjectName(String name) {
        this.setParam(PROJECT_INSTANCE_NAME, name);
    }

    public final String getParentId() {
        return this.getParam(PARENT_ID);
    }

    public final AbstractExecutable getParent() {
        return this.getManager().getJob(this.getParam(PARENT_ID));
    }

    public final void setParentId(String parentId) {
        this.setParam(PARENT_ID, parentId);
    }

    public final void setParent(AbstractExecutable parent) {
        this.setParentId(parent.getId());
    }

    public Map<String, String> makeExtraInfo(Map<String, String> info) {
        String jobId;
        if (info == null) {
            return Maps.newHashMap();
        }
        if (info.containsKey("mr_job_id") && !info.containsKey("yarn_application_id") && (jobId = info.get("mr_job_id")).startsWith("job_")) {
            info.put("yarn_application_id", jobId.replace("job_", "application_"));
        }
        if (info.containsKey("yarn_application_id") && !StringUtils.isEmpty(this.getConfig().getJobTrackingURLPattern())) {
            String pattern = this.getConfig().getJobTrackingURLPattern();
            try {
                String newTrackingURL = String.format(Locale.ROOT, pattern, info.get("yarn_application_id"));
                info.put("yarn_application_tracking_url", newTrackingURL);
            }
            catch (IllegalFormatException ife) {
                logger.error("Illegal tracking url pattern: {}", (Object)this.getConfig().getJobTrackingURLPattern());
            }
        }
        return info;
    }

    public int computeStepDriverMemory() {
        String cuboidsNum = this.getParam("cuboidsNum");
        if (cuboidsNum != null) {
            return AbstractExecutable.computeDriverMemory(Integer.valueOf(cuboidsNum));
        }
        return 1024;
    }

    public static Integer computeDriverMemory(Integer cuboidNum) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        int[] driverMemoryStrategy = config.getSparkEngineDriverMemoryStrategy();
        ArrayList<Integer> strategy = Lists.newArrayList(cuboidNum);
        Arrays.stream(driverMemoryStrategy).forEach(x -> strategy.add(x));
        Collections.sort(strategy);
        int index = strategy.indexOf(cuboidNum);
        int driverMemoryMaximum = config.getSparkEngineDriverMemoryMaximum();
        int driverMemoryBase = config.getSparkEngineDriverMemoryBase();
        driverMemoryBase += driverMemoryBase * index;
        return Math.min(driverMemoryBase, driverMemoryMaximum);
    }
}

