/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.CubeUpdate;
import org.apache.kylin.cube.cuboid.CuboidModeEnum;
import org.apache.kylin.cube.model.CubeBuildTypeEnum;
import org.apache.kylin.engine.mr.common.CubeStatsReader;
import org.apache.kylin.engine.mr.common.CubeStatsWriter;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.engine.spark.utils.MetaDumpUtil;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateMetadataUtil {
    protected static final Logger logger = LoggerFactory.getLogger(UpdateMetadataUtil.class);

    public static void syncLocalMetadataToRemote(KylinConfig config, NSparkExecutable nsparkExecutable) throws IOException {
        KylinConfig kylinDistConfig;
        CubeInstance distCube;
        CubeSegment toUpdateSeg;
        String cubeId = nsparkExecutable.getParam("cubeId");
        HashSet segmentIds = Sets.newHashSet((Object[])StringUtils.split(nsparkExecutable.getParam("segmentId"), " "));
        String segmentId = (String)segmentIds.iterator().next();
        String remoteResourceStore = nsparkExecutable.getDistMetaUrl();
        String jobType = nsparkExecutable.getParam("jobType");
        CubeManager cubeManager = CubeManager.getInstance(config);
        CubeInstance currentInstanceCopy = cubeManager.getCubeByUuid(cubeId).latestCopyForWrite();
        Segments tobeSegments = currentInstanceCopy.calculateToBeSegments(toUpdateSeg = (distCube = CubeManager.getInstance(kylinDistConfig = MetaDumpUtil.loadKylinConfigFromHdfs(remoteResourceStore)).getCubeByUuid(cubeId)).getSegmentById(segmentId));
        if (!tobeSegments.contains(toUpdateSeg)) {
            throw new IllegalStateException(String.format(Locale.ROOT, "For cube %s, segment %s is expected but not in the tobe %s", currentInstanceCopy.toString(), toUpdateSeg.toString(), ((Object)tobeSegments).toString()));
        }
        String resKey = toUpdateSeg.getStatisticsResourcePath();
        String statisticsDir = config.getJobTmpDir(currentInstanceCopy.getProject()) + "/" + nsparkExecutable.getParam("jobId") + "/" + "/cube_statistics" + "/" + cubeId + "/" + segmentId + "/";
        Path statisticsFile = new Path(statisticsDir, "cuboid_statistics.seq");
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        if (fs.exists(statisticsFile)) {
            FSDataInputStream is = fs.open(statisticsFile);
            ResourceStore.getStore(config).putBigResource(resKey, (InputStream)is, System.currentTimeMillis());
        }
        CubeUpdate update = new CubeUpdate(currentInstanceCopy);
        update.setCuboids(distCube.getCuboids());
        ArrayList toRemoveSegs = Lists.newArrayList();
        if (String.valueOf((Object)CubeBuildTypeEnum.MERGE).equals(jobType)) {
            toUpdateSeg.getSnapshots().clear();
            for (Map.Entry<String, String> entry : currentInstanceCopy.getLatestReadySegment().getSnapshots().entrySet()) {
                toUpdateSeg.putSnapshotResPath(entry.getKey(), entry.getValue());
            }
        } else if (String.valueOf((Object)CubeBuildTypeEnum.OPTIMIZE).equals(jobType)) {
            CubeSegment origSeg = currentInstanceCopy.getOriginalSegmentToOptimize(toUpdateSeg);
            toUpdateSeg.getDictionaries().putAll(origSeg.getDictionaries());
            toUpdateSeg.getSnapshots().putAll(origSeg.getSnapshots());
            toUpdateSeg.getRowkeyStats().addAll(origSeg.getRowkeyStats());
            CubeStatsReader optSegStatsReader = new CubeStatsReader(toUpdateSeg, config);
            CubeStatsReader origSegStatsReader = new CubeStatsReader(origSeg, config);
            HashMap<Long, HLLCounter> cuboidHLLMap = Maps.newHashMap();
            if (origSegStatsReader.getCuboidRowHLLCounters() == null) {
                logger.warn("Cuboid statistics of original segment do not exist. Please check the config of kylin.engine.segment-statistics-enabled.");
            } else {
                UpdateMetadataUtil.addFromCubeStatsReader(origSegStatsReader, cuboidHLLMap);
                UpdateMetadataUtil.addFromCubeStatsReader(optSegStatsReader, cuboidHLLMap);
                Set<Long> recommendCuboids = currentInstanceCopy.getCuboidsByMode(CuboidModeEnum.RECOMMEND);
                HashMap<Long, HLLCounter> resultCuboidHLLMap = Maps.newHashMapWithExpectedSize(recommendCuboids.size());
                for (long cuboid : recommendCuboids) {
                    HLLCounter hll = (HLLCounter)cuboidHLLMap.get(cuboid);
                    if (hll == null) {
                        logger.warn("Cannot get the row count stats for cuboid " + cuboid);
                        continue;
                    }
                    resultCuboidHLLMap.put(cuboid, hll);
                }
                if (fs.exists(statisticsFile)) {
                    fs.delete(statisticsFile, false);
                }
                CubeStatsWriter.writeCuboidStatistics(HadoopUtil.getCurrentConfiguration(), new Path(statisticsDir), resultCuboidHLLMap, 1, origSegStatsReader.getSourceRowCount());
                FSDataInputStream is = fs.open(statisticsFile);
                ResourceStore.getStore(config).putBigResource(resKey, (InputStream)is, System.currentTimeMillis());
            }
            toUpdateSeg.setStatus(SegmentStatusEnum.READY_PENDING);
        } else {
            toUpdateSeg.setStatus(SegmentStatusEnum.READY);
            for (CubeSegment segment : currentInstanceCopy.getSegments()) {
                if (tobeSegments.contains(segment)) continue;
                toRemoveSegs.add(segment);
            }
            Collections.sort(toRemoveSegs);
            if (currentInstanceCopy.getConfig().isJobAutoReadyCubeEnabled()) {
                update.setStatus(RealizationStatusEnum.READY);
            }
        }
        logger.info("Promoting cube {}, new segment {}, to remove segments {}", currentInstanceCopy, toUpdateSeg, toRemoveSegs);
        toUpdateSeg.setLastBuildTime(System.currentTimeMillis());
        update.setToRemoveSegs(toRemoveSegs.toArray(new CubeSegment[0])).setToUpdateSegs(toUpdateSeg);
        cubeManager.updateCube(update);
    }

    public static void updateMetadataAfterMerge(String cubeId, String segmentId, KylinConfig config) throws IOException {
        CubeSegment toUpdateSegs;
        CubeManager cubeManager = CubeManager.getInstance(config);
        CubeInstance currentInstanceCopy = cubeManager.getCubeByUuid(cubeId).latestCopyForWrite();
        Segments tobeSegments = currentInstanceCopy.calculateToBeSegments(toUpdateSegs = currentInstanceCopy.getSegmentById(segmentId));
        if (!tobeSegments.contains(toUpdateSegs)) {
            throw new IllegalStateException(String.format(Locale.ROOT, "For cube %s, segment %s is expected but not in the tobe %s", currentInstanceCopy.toString(), toUpdateSegs.toString(), ((Object)tobeSegments).toString()));
        }
        CubeUpdate update = new CubeUpdate(currentInstanceCopy);
        ArrayList toRemoveSegs = Lists.newArrayList();
        toUpdateSegs.setStatus(SegmentStatusEnum.READY);
        for (CubeSegment segment : currentInstanceCopy.getSegments()) {
            if (tobeSegments.contains(segment)) continue;
            toRemoveSegs.add(segment);
        }
        Collections.sort(toRemoveSegs);
        if (currentInstanceCopy.getConfig().isJobAutoReadyCubeEnabled()) {
            update.setStatus(RealizationStatusEnum.READY);
        }
        logger.info("Promoting cube {}, new segment {}, to remove segments {}", currentInstanceCopy, toUpdateSegs, toRemoveSegs);
        toUpdateSegs.setLastBuildTime(System.currentTimeMillis());
        update.setToRemoveSegs(toRemoveSegs.toArray(new CubeSegment[0])).setToUpdateSegs(toUpdateSegs);
        cubeManager.updateCube(update);
    }

    private static void addFromCubeStatsReader(CubeStatsReader cubeStatsReader, Map<Long, HLLCounter> cuboidHLLMap) {
        for (Map.Entry<Long, HLLCounter> entry : cubeStatsReader.getCuboidRowHLLCounters().entrySet()) {
            if (cuboidHLLMap.get(entry.getKey()) != null) {
                cuboidHLLMap.get(entry.getKey()).merge(entry.getValue());
                continue;
            }
            cuboidHLLMap.put(entry.getKey(), entry.getValue());
        }
    }
}

