/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.Serializable;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.spark.builder.CreateFlatTable;
import org.apache.kylin.engine.spark.builder.CubeSnapshotBuilder;
import org.apache.kylin.engine.spark.builder.NBuildSourceInfo;
import org.apache.kylin.engine.spark.job.AggInfo;
import org.apache.kylin.engine.spark.job.CuboidStatisticsJob$;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.engine.spark.job.ParentSourceChooser$;
import org.apache.kylin.engine.spark.metadata.ColumnDesc;
import org.apache.kylin.engine.spark.metadata.FunctionDesc;
import org.apache.kylin.engine.spark.metadata.SegmentInfo;
import org.apache.kylin.engine.spark.metadata.cube.model.LayoutEntity;
import org.apache.kylin.engine.spark.metadata.cube.model.SpanningTree;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.utils.CuboidLayoutChooser$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005%g\u0001\u0002\u0014(\u0001QB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\u001b\u0002\u0011\t\u0019!C\u0001\u001d\"A1\u000b\u0001BA\u0002\u0013\u0005A\u000b\u0003\u0005[\u0001\t\u0005\t\u0015)\u0003P\u0011!Y\u0006A!a\u0001\n\u0003a\u0006\u0002\u00032\u0001\u0005\u0003\u0007I\u0011A2\t\u0011\u0015\u0004!\u0011!Q!\nuC\u0001B\u001a\u0001\u0003\u0002\u0003\u0006Ia\u001a\u0005\te\u0002\u0011\t\u0011)A\u0005g\"A\u0011\u0010\u0001B\u0001B\u0003%!\u0010\u0003\u0006\u0002\u0002\u0001\u0011\t\u0011)A\u0005\u0003\u0007Aq!!\u0003\u0001\t\u0003\tY\u0001C\u0006\u0002 \u0001\u0001\r\u00111A\u0005\u0002\u0005\u0005\u0002bCA\u001e\u0001\u0001\u0007\t\u0019!C\u0001\u0003{A1\"!\u0011\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002$!I\u00111\t\u0001A\u0002\u0013\u0005\u0011Q\t\u0005\n\u0003[\u0002\u0001\u0019!C\u0001\u0003_B\u0001\"a\u001d\u0001A\u0003&\u0011q\t\u0005\f\u0003k\u0002\u0001\u0019!a\u0001\n\u0003\t9\bC\u0006\u0002z\u0001\u0001\r\u00111A\u0005\u0002\u0005m\u0004bCA@\u0001\u0001\u0007\t\u0011)Q\u0005\u0003CB\u0011\"!!\u0001\u0001\u0004%I!a!\t\u0013\u0005\u0015\u0005\u00011A\u0005\n\u0005\u001d\u0005\u0002CAF\u0001\u0001\u0006K!a\u0001\t\u000f\u00055\u0005\u0001\"\u0001\u0002\u0010\"9\u0011\u0011\u0013\u0001\u0005\u0002\u0005\u0005\u0002bBAJ\u0001\u0011\u0005\u0011q\u0012\u0005\b\u0003+\u0003A\u0011AAL\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003KCq!!,\u0001\t\u0003\ty\u000bC\u0004\u00022\u0002!I!a-\t\u000f\u0005e\u0006\u0001\"\u0003\u0002x\u001d9\u00111X\u0014\t\u0002\u0005ufA\u0002\u0014(\u0011\u0003\ty\fC\u0004\u0002\n\t\"\t!!1\t\u0013\u0005\r'E1A\u0005\u0002\u0005\u0015\u0007\u0002CAdE\u0001\u0006I!a\f\u0003'A\u000b'/\u001a8u'>,(oY3DQ>|7/\u001a:\u000b\u0005!J\u0013a\u00016pE*\u0011!fK\u0001\u0006gB\f'o\u001b\u0006\u0003Y5\na!\u001a8hS:,'B\u0001\u00180\u0003\u0015Y\u0017\u0010\\5o\u0015\t\u0001\u0014'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002e\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!N\u001e\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\r\u0005s\u0017PU3g!\ta\u0004)D\u0001>\u0015\tqt(\u0001\u0005j]R,'O\\1m\u0015\tQs&\u0003\u0002B{\t9Aj\\4hS:<\u0017a\u0003;p\u0005VLG\u000e\u001a+sK\u0016\u0004\"\u0001R&\u000e\u0003\u0015S!AR$\u0002\u000b5|G-\u001a7\u000b\u0005!K\u0015\u0001B2vE\u0016T!AS\u0015\u0002\u00115,G/\u00193bi\u0006L!\u0001T#\u0003\u0019M\u0003\u0018M\u001c8j]\u001e$&/Z3\u0002\u000fM,w-\u00138g_V\tq\n\u0005\u0002Q#6\t\u0011*\u0003\u0002S\u0013\nY1+Z4nK:$\u0018J\u001c4p\u0003-\u0019XmZ%oM>|F%Z9\u0015\u0005UC\u0006C\u0001\u001cW\u0013\t9vG\u0001\u0003V]&$\bbB-\u0004\u0003\u0003\u0005\raT\u0001\u0004q\u0012\n\u0014\u0001C:fO&sgm\u001c\u0011\u0002\u000fM,w-\\3oiV\tQ\f\u0005\u0002_A6\tqL\u0003\u0002I[%\u0011\u0011m\u0018\u0002\f\u0007V\u0014WmU3h[\u0016tG/A\u0006tK\u001elWM\u001c;`I\u0015\fHCA+e\u0011\u001dIf!!AA\u0002u\u000b\u0001b]3h[\u0016tG\u000fI\u0001\u0006U>\u0014\u0017\n\u001a\t\u0003Q>t!![7\u0011\u0005)<T\"A6\u000b\u00051\u001c\u0014A\u0002\u001fs_>$h(\u0003\u0002oo\u00051\u0001K]3eK\u001aL!\u0001]9\u0003\rM#(/\u001b8h\u0015\tqw'\u0001\u0002tgB\u0011Ao^\u0007\u0002k*\u0011aoP\u0001\u0004gFd\u0017B\u0001=v\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0019\u0019wN\u001c4jOB\u00111P`\u0007\u0002y*\u0011Q0L\u0001\u0007G>lWn\u001c8\n\u0005}d(aC&zY&t7i\u001c8gS\u001e\fAB\\3fI\u0016s7m\u001c3j]\u001e\u00042ANA\u0003\u0013\r\t9a\u000e\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q\u0001\u0012QBA\t\u0003'\t)\"a\u0006\u0002\u001a\u0005m\u0011Q\u0004\t\u0004\u0003\u001f\u0001Q\"A\u0014\t\u000b\tc\u0001\u0019A\"\t\u000b5c\u0001\u0019A(\t\u000bmc\u0001\u0019A/\t\u000b\u0019d\u0001\u0019A4\t\u000bId\u0001\u0019A:\t\u000bed\u0001\u0019\u0001>\t\u000f\u0005\u0005A\u00021\u0001\u0002\u0004\u00059\u0011mZ4J]\u001a|WCAA\u0012!\u00151\u0014QEA\u0015\u0013\r\t9c\u000e\u0002\u0006\u0003J\u0014\u0018-\u001f\t\bm\u0005-\u0012qFA\u001b\u0013\r\tic\u000e\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007Y\n\t$C\u0002\u00024]\u0012A\u0001T8oOB!\u0011qBA\u001c\u0013\r\tId\n\u0002\b\u0003\u001e<\u0017J\u001c4p\u0003-\twmZ%oM>|F%Z9\u0015\u0007U\u000by\u0004\u0003\u0005Z\u001d\u0005\u0005\t\u0019AA\u0012\u0003!\twmZ%oM>\u0004\u0013\u0001\u0004:fkN,7k\\;sG\u0016\u001cXCAA$!!\tI%a\u0015\u0002X\u0005\u0005TBAA&\u0015\u0011\ti%a\u0014\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003#\nAA[1wC&!\u0011QKA&\u0005\ri\u0015\r\u001d\t\u0005\u00033\ny&\u0004\u0002\u0002\\)!\u0011QLA(\u0003\u0011a\u0017M\\4\n\t\u0005M\u00121\f\t\u0005\u0003G\nI'\u0004\u0002\u0002f)\u0019\u0011qM\u0015\u0002\u000f\t,\u0018\u000e\u001c3fe&!\u00111NA3\u0005Aq%)^5mIN{WO]2f\u0013:4w.\u0001\tsKV\u001cXmU8ve\u000e,7o\u0018\u0013fcR\u0019Q+!\u001d\t\u0011e\u000b\u0012\u0011!a\u0001\u0003\u000f\nQB]3vg\u0016\u001cv.\u001e:dKN\u0004\u0013a\u00044mCR$\u0016M\u00197f'>,(oY3\u0016\u0005\u0005\u0005\u0014a\u00054mCR$\u0016M\u00197f'>,(oY3`I\u0015\fHcA+\u0002~!A\u0011\fFA\u0001\u0002\u0004\t\t'\u0001\tgY\u0006$H+\u00192mKN{WO]2fA\u0005qa.Z3e'R\fG/[:uS\u000e\u001cXCAA\u0002\u0003IqW-\u001a3Ti\u0006$\u0018n\u001d;jGN|F%Z9\u0015\u0007U\u000bI\t\u0003\u0005Z/\u0005\u0005\t\u0019AA\u0002\u0003=qW-\u001a3Ti\u0006$\u0018n\u001d;jGN\u0004\u0013!E:fi:+W\rZ*uCRL7\u000f^5dgR\tQ+\u0001\u0006hKR\fumZ%oM>\fQ\u0002Z3dS\u0012,7k\\;sG\u0016\u001c\u0018!\u00063fG&$WM\u00127biR\u000b'\r\\3T_V\u00148-\u001a\u000b\u0004+\u0006e\u0005bBAN9\u0001\u0007\u0011QT\u0001\u0007K:$\u0018\u000e^=\u0011\u0007\u0011\u000by*C\u0002\u0002\"\u0016\u0013A\u0002T1z_V$XI\u001c;jif\f\u0001\u0004Z3dS\u0012,\u0007+\u0019:f]Rd\u0015-_8viN{WO]2f)\u0015)\u0016qUAU\u0011\u001d\tY*\ba\u0001\u0003;Cq!a+\u001e\u0001\u0004\ti*\u0001\u0007qCJ,g\u000e\u001e'bs>,H/A\u000eqKJ\u001c\u0018n\u001d;GY\u0006$H+\u00192mK&3g*Z2fgN\f'/\u001f\u000b\u0002O\u0006\u0019r-\u001a;T_V\u00148-\u001a$s_6d\u0015-_8viR!\u0011\u0011MA[\u0011\u001d\t9l\ba\u0001\u0003;\u000ba\u0001\\1z_V$\u0018\u0001D4fi\u001ac\u0017\r\u001e+bE2,\u0017a\u0005)be\u0016tGoU8ve\u000e,7\t[8pg\u0016\u0014\bcAA\bEM\u0011!%\u000e\u000b\u0003\u0003{\u000bqB\u0012'B)~#\u0016I\u0011'F?\u001ac\u0015iR\u000b\u0003\u0003_\t\u0001C\u0012'B)~#\u0016I\u0011'F?\u001ac\u0015i\u0012\u0011")
public class ParentSourceChooser
implements Logging {
    private final SpanningTree toBuildTree;
    private SegmentInfo segInfo;
    private CubeSegment segment;
    private final String jobId;
    private final SparkSession ss;
    private final KylinConfig config;
    private final boolean needEncoding;
    private Tuple2<Object, AggInfo>[] aggInfo;
    private Map<Long, NBuildSourceInfo> reuseSources;
    private NBuildSourceInfo flatTableSource;
    private boolean needStatistics;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static long FLAT_TABLE_FLAG() {
        return ParentSourceChooser$.MODULE$.FLAT_TABLE_FLAG();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SegmentInfo segInfo() {
        return this.segInfo;
    }

    public void segInfo_$eq(SegmentInfo x$1) {
        this.segInfo = x$1;
    }

    public CubeSegment segment() {
        return this.segment;
    }

    public void segment_$eq(CubeSegment x$1) {
        this.segment = x$1;
    }

    public Tuple2<Object, AggInfo>[] aggInfo() {
        return this.aggInfo;
    }

    public void aggInfo_$eq(Tuple2<Object, AggInfo>[] x$1) {
        this.aggInfo = x$1;
    }

    public Map<Long, NBuildSourceInfo> reuseSources() {
        return this.reuseSources;
    }

    public void reuseSources_$eq(Map<Long, NBuildSourceInfo> x$1) {
        this.reuseSources = x$1;
    }

    public NBuildSourceInfo flatTableSource() {
        return this.flatTableSource;
    }

    public void flatTableSource_$eq(NBuildSourceInfo x$1) {
        this.flatTableSource = x$1;
    }

    private boolean needStatistics() {
        return this.needStatistics;
    }

    private void needStatistics_$eq(boolean x$1) {
        this.needStatistics = x$1;
    }

    public void setNeedStatistics() {
        this.needStatistics_$eq(true);
    }

    public Tuple2<Object, AggInfo>[] getAggInfo() {
        return this.aggInfo();
    }

    public void decideSources() {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.toBuildTree.getRootIndexEntities()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entity -> {
            ParentSourceChooser.$anonfun$decideSources$1(this, entity);
            return BoxedUnit.UNIT;
        });
    }

    public void decideFlatTableSource(LayoutEntity entity) {
        block4: {
            if (this.flatTableSource() == null) {
                if (this.segInfo().snapshotTables().nonEmpty() && this.needEncoding) {
                    CubeSnapshotBuilder builder = new CubeSnapshotBuilder(this.segInfo(), this.ss);
                    builder.checkDupKey();
                    this.segInfo_$eq(builder.buildSnapshot());
                }
                this.flatTableSource_$eq(this.getFlatTable());
                Seq rowKeyColumns = (Seq)((List)this.segInfo().allColumns().filter((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.rowKey()))).map((Function1 & Serializable & scala.Serializable)c -> ((Object)BoxesRunTime.boxToInteger((int)c.id())).toString(), List$.MODULE$.canBuildFrom());
                if (this.aggInfo() == null && this.needStatistics()) {
                    long startMs = System.currentTimeMillis();
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Sampling start ...");
                    Dataset coreDs = this.flatTableSource().getFlatTableDS().select((String)rowKeyColumns.head(), (Seq)rowKeyColumns.tail());
                    this.aggInfo_$eq(CuboidStatisticsJob$.MODULE$.statistics((Dataset<Row>)coreDs, this.segInfo()));
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Sampling finished and cost ").append((System.currentTimeMillis() - startMs) / 1000L).append(" s .").toString());
                    String statisticsStr = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.aggInfo())).sortBy((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToLong((long)x._1$mcJ$sp()), (Ordering)Ordering.Long$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x -> new StringBuilder(1).append(x._1$mcJ$sp()).append(":").append(((AggInfo)x._2()).cuboid().counter().getCountEstimate()).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ");
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Cuboid Statistics results : \t").append(statisticsStr).toString());
                } else {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Skip sampling ...");
                }
            }
            if (entity == null) break block4;
            this.flatTableSource().addCuboid(entity);
        }
    }

    private void decideParentLayoutSource(LayoutEntity entity, LayoutEntity parentLayout) {
        long id = parentLayout.getId();
        if (this.reuseSources().containsKey(BoxesRunTime.boxToLong((long)id))) {
            this.reuseSources().get(BoxesRunTime.boxToLong((long)id)).addCuboid(entity);
        } else {
            NBuildSourceInfo source = this.getSourceFromLayout(parentLayout);
            this.reuseSources().put(Predef$.MODULE$.long2Long(id), source);
        }
    }

    public String persistFlatTableIfNecessary() {
        ObjectRef path;
        block0: {
            Dataset<Row> df;
            path = ObjectRef.create((Object)"");
            if (this.flatTableSource() == null || this.flatTableSource().getToBuildCuboids().size() <= this.config.getPersistFlatTableThreshold() || !(df = this.flatTableSource().getFlatTableDS()).schema().nonEmpty()) break block0;
            Seq allUsedCols = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.flatTableSource().getToBuildCuboids()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)c -> {
                Set dims = (Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(c.getOrderedDimensions().keySet()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), Set$.MODULE$.canBuildFrom());
                Iterable measureUsedCols = (Iterable)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(c.getOrderedMeasures()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)mea -> {
                    List<ColumnDesc> parameters = ((FunctionDesc)mea._2()).pra();
                    return ((ColumnDesc)parameters.head()).isColumnType() ? (List)parameters.map((Function1 & Serializable & scala.Serializable)p -> ((Object)BoxesRunTime.boxToInteger((int)p.id())).toString(), List$.MODULE$.canBuildFrom()) : Nil$.MODULE$;
                }, Iterable$.MODULE$.canBuildFrom());
                return dims.$plus$plus((GenTraversableOnce)measureUsedCols);
            }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toSeq();
            df.select((Seq)allUsedCols.map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(colName), Seq$.MODULE$.canBuildFrom()));
            path.elem = String.valueOf(this.config.getJobTmpFlatTableDir(this.segInfo().project(), this.jobId));
            this.ss.sparkContext().setJobDescription("Persist flat table.");
            df.write().mode(SaveMode.Overwrite).parquet((String)path.elem);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Persist flat table into:").append((String)path$1.elem).append(". Selected cols in table are ").append(allUsedCols).append(".").toString());
            this.flatTableSource().setParentStoragePath((String)path.elem);
        }
        return (String)path.elem;
    }

    /*
     * WARNING - void declaration
     */
    private NBuildSourceInfo getSourceFromLayout(LayoutEntity layout) {
        void var2_2;
        NBuildSourceInfo buildSource = new NBuildSourceInfo();
        buildSource.setParentStoragePath(NSparkCubingUtil.getStoragePath(this.segment(), Predef$.MODULE$.long2Long(layout.getId())));
        buildSource.setSparkSession(this.ss);
        buildSource.setLayoutId(layout.getId());
        buildSource.setLayout(layout);
        buildSource.setByteSize(layout.getByteSize());
        buildSource.addCuboid(layout);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Reuse a suitable layout: ").append(layout.getId()).append(" for building cuboid: ").append(layout.getId()).toString());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private NBuildSourceInfo getFlatTable() {
        void var1_1;
        NBuildSourceInfo sourceInfo = new NBuildSourceInfo();
        sourceInfo.setSparkSession(this.ss);
        sourceInfo.setLayoutId(ParentSourceChooser$.MODULE$.FLAT_TABLE_FLAG());
        CreateFlatTable flatTable = new CreateFlatTable(this.segInfo(), this.toBuildTree, this.ss, sourceInfo, this.jobId);
        Dataset<Row> afterJoin = flatTable.generateDataset(this.needEncoding, true);
        sourceInfo.setFlatTableDS(afterJoin);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No suitable ready layouts could be reused, generate dataset from flat table.");
        return var1_1;
    }

    public static final /* synthetic */ void $anonfun$decideSources$1(ParentSourceChooser $this, LayoutEntity entity) {
        LayoutEntity parentLayout = CuboidLayoutChooser$.MODULE$.selectLayoutForBuild($this.segInfo(), entity);
        if (parentLayout != null) {
            $this.decideParentLayoutSource(entity, parentLayout);
        } else {
            $this.decideFlatTableSource(entity);
        }
    }

    public ParentSourceChooser(SpanningTree toBuildTree, SegmentInfo segInfo, CubeSegment segment, String jobId, SparkSession ss, KylinConfig config, boolean needEncoding) {
        this.toBuildTree = toBuildTree;
        this.segInfo = segInfo;
        this.segment = segment;
        this.jobId = jobId;
        this.ss = ss;
        this.config = config;
        this.needEncoding = needEncoding;
        Logging.$init$((Logging)this);
        this.reuseSources = Maps.newHashMap();
        this.needStatistics = false;
    }
}

