/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.spark;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.RawQueryLastHacker;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.storage.StorageContext;
import org.apache.kylin.storage.gtrecord.GTCubeStorageQueryBase;
import org.apache.kylin.storage.gtrecord.GTCubeStorageQueryRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopFileStorageQuery
extends GTCubeStorageQueryBase {
    private static final Logger log = LoggerFactory.getLogger(HadoopFileStorageQuery.class);

    public HadoopFileStorageQuery(CubeInstance cube) {
        super(cube);
    }

    @Override
    protected String getGTStorage() {
        throw new UnsupportedOperationException("Unsupported getGTStorage.");
    }

    public GTCubeStorageQueryRequest getStorageQueryRequest(OLAPContext olapContext, TupleInfo returnTupleInfo) {
        StorageContext context = olapContext.storageContext;
        SQLDigest sqlDigest = olapContext.getSQLDigest();
        context.setStorageQuery(this);
        RawQueryLastHacker.hackNoAggregations(sqlDigest, this.cubeDesc, returnTupleInfo);
        this.notifyBeforeStorageQuery(sqlDigest);
        List<TblColRef> groups = sqlDigest.groupbyColumns;
        TupleFilter filter = sqlDigest.filter;
        LinkedHashSet<TblColRef> dimensions = new LinkedHashSet<TblColRef>();
        LinkedHashSet<FunctionDesc> metrics = new LinkedHashSet<FunctionDesc>();
        this.buildDimensionsAndMetrics(sqlDigest, dimensions, metrics);
        HashSet<TblColRef> otherDims = Sets.newHashSet(dimensions);
        otherDims.removeAll(groups);
        HashSet<TblColRef> derivedPostAggregation = Sets.newHashSet();
        Set<TblColRef> groupsD = this.expandDerived(groups, derivedPostAggregation);
        Set<TblColRef> otherDimsD = this.expandDerived(otherDims, derivedPostAggregation);
        otherDimsD.removeAll(groupsD);
        LinkedHashSet<TblColRef> dimensionsD = new LinkedHashSet<TblColRef>();
        dimensionsD.addAll(groupsD);
        dimensionsD.addAll(otherDimsD);
        Cuboid cuboid = this.findCuboid(this.cubeInstance, dimensionsD, metrics);
        context.setCuboid(cuboid);
        return new GTCubeStorageQueryRequest(cuboid, dimensionsD, groupsD, null, null, null, metrics, null, null, null, context);
    }
}

