/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.gtrecord;

import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.storage.gtrecord.PeekingImpl;

public class SortedIteratorMerger<E> {
    private Iterator<Iterator<E>> shardSubsets;
    protected Comparator<E> comparator;

    SortedIteratorMerger(Iterator<Iterator<E>> shardSubsets, Comparator<E> comparator) {
        this.shardSubsets = shardSubsets;
        this.comparator = comparator;
    }

    PriorityQueue<PeekingImpl<E>> getHeap() {
        PriorityQueue<PeekingImpl<PeekingImpl<E>>> heap = new PriorityQueue<PeekingImpl<PeekingImpl<E>>>(11, new Comparator<PeekingImpl<E>>(){

            @Override
            public int compare(PeekingImpl<E> o1, PeekingImpl<E> o2) {
                return SortedIteratorMerger.this.comparator.compare(o1.peek(), o2.peek());
            }
        });
        while (this.shardSubsets.hasNext()) {
            Iterator<E> iterator = this.shardSubsets.next();
            PeekingImpl<E> peekingIterator = new PeekingImpl<E>(iterator);
            if (!peekingIterator.hasNext()) continue;
            heap.offer(peekingIterator);
        }
        return heap;
    }

    public Iterator<E> getIterator() {
        return new MergedIterator(this.comparator);
    }

    private class MergedIterator
    implements Iterator<E> {
        private PriorityQueue<PeekingImpl<E>> heap;
        private final Comparator<E> comparator;

        public MergedIterator(Comparator<E> comparator) {
            this.comparator = comparator;
        }

        @Override
        public boolean hasNext() {
            if (this.heap == null) {
                this.heap = SortedIteratorMerger.this.getHeap();
            }
            return !this.heap.isEmpty();
        }

        @Override
        public E next() {
            PeekingImpl poll = this.heap.poll();
            Object current = poll.next();
            if (poll.hasNext()) {
                Preconditions.checkState(this.comparator.compare(current, poll.peek()) < 0, "Not sorted! current: " + current + " Next: " + poll.peek());
                this.heap.offer(poll);
            }
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

