/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.kylin.common.util.DBUtils;
import org.apache.kylin.common.util.SourceConfigurationUtil;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.source.hive.HiveTableMeta;
import org.apache.kylin.source.hive.HiveTableMetaBuilder;
import org.apache.kylin.source.hive.IHiveClient;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.StringUtils;

public class BeelineHiveClient
implements IHiveClient {
    private static final String HIVE_AUTH_USER = "user";
    private static final String HIVE_AUTH_PASSWD = "password";
    private Connection cnct;
    private Statement stmt;
    private DatabaseMetaData metaData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeelineHiveClient(String beelineParams) {
        if (StringUtils.isEmpty(beelineParams)) {
            throw new IllegalArgumentException("BeelineParames cannot be empty");
        }
        String[] splits = StringUtils.split(beelineParams);
        String url = "";
        String username = "";
        String password = "";
        for (int i = 0; i < splits.length - 1; ++i) {
            if ("-u".equals(splits[i])) {
                url = this.stripQuotes(splits[i + 1]);
            }
            if ("-n".equals(splits[i])) {
                username = this.stripQuotes(splits[i + 1]);
            }
            if ("-p".equals(splits[i])) {
                password = this.stripQuotes(splits[i + 1]);
            }
            if (!"-w".equals(splits[i])) continue;
            File file = new File(splits[i + 1]);
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
                try {
                    password = br.readLine();
                    continue;
                }
                finally {
                    if (null != br) {
                        br.close();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Properties jdbcProperties = SourceConfigurationUtil.loadHiveJDBCProperties();
        jdbcProperties.put(HIVE_AUTH_PASSWD, password);
        jdbcProperties.put(HIVE_AUTH_USER, username);
        this.init(url, jdbcProperties);
    }

    private void init(String url, Properties hiveProperties) {
        try {
            Class.forName("org.apache.hive.jdbc.HiveDriver");
            this.cnct = DriverManager.getConnection(url, hiveProperties);
            this.stmt = this.cnct.createStatement();
            this.metaData = this.cnct.getMetaData();
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private String stripQuotes(String input) {
        if (input.startsWith("'") && input.endsWith("'")) {
            return StringUtils.strip(input, "'");
        }
        if (input.startsWith("\"") && input.endsWith("\"")) {
            return StringUtils.strip(input, "\"");
        }
        return input;
    }

    @Override
    public List<String> getHiveDbNames() throws Exception {
        ArrayList<String> ret = Lists.newArrayList();
        ResultSet schemas = this.metaData.getSchemas();
        while (schemas.next()) {
            ret.add(String.valueOf(schemas.getObject(1)));
        }
        DBUtils.closeQuietly(schemas);
        return ret;
    }

    @Override
    public List<String> getHiveTableNames(String database) throws Exception {
        ArrayList<String> ret = Lists.newArrayList();
        ResultSet tables = this.metaData.getTables(null, database, null, null);
        while (tables.next()) {
            ret.add(String.valueOf(tables.getObject(3)));
        }
        DBUtils.closeQuietly(tables);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getHiveTableRows(String database, String tableName) throws Exception {
        ResultSet resultSet = null;
        long count = 0L;
        try {
            String query = "select count(*) from ";
            resultSet = this.stmt.executeQuery(query.concat(database + "." + tableName));
            if (resultSet.next()) {
                count = resultSet.getLong(1);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeQuietly(resultSet);
            throw throwable;
        }
        DBUtils.closeQuietly(resultSet);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object[]> getHiveResult(String hql) throws Exception {
        ResultSet resultSet = null;
        ArrayList<Object[]> datas = new ArrayList<Object[]>();
        try {
            resultSet = this.stmt.executeQuery(hql);
            int columnCtn = resultSet.getMetaData().getColumnCount();
            while (resultSet.next()) {
                Object[] data = new Object[columnCtn];
                for (int i = 0; i < columnCtn; ++i) {
                    data[i] = resultSet.getObject(i + 1);
                }
                datas.add(data);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeQuietly(resultSet);
            throw throwable;
        }
        DBUtils.closeQuietly(resultSet);
        return datas;
    }

    @Override
    public void executeHQL(String hql) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void executeHQL(String[] hqls) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public HiveTableMeta getHiveTableMeta(String database, String tableName) throws SQLException {
        ResultSet columns = this.metaData.getColumns(null, database, tableName, null);
        HiveTableMetaBuilder builder = new HiveTableMetaBuilder();
        builder.setTableName(tableName);
        ArrayList<HiveTableMeta.HiveTableColumnMeta> allColumns = Lists.newArrayList();
        while (columns.next()) {
            String columnName = columns.getString(4);
            String dataType = columns.getString(6);
            String comment = columns.getString(12);
            dataType = BeelineHiveClient.considerDataTypePrecision(dataType, columns.getString(7), columns.getString(9));
            allColumns.add(new HiveTableMeta.HiveTableColumnMeta(columnName, dataType, comment));
        }
        builder.setAllColumns(allColumns);
        DBUtils.closeQuietly(columns);
        String exe = "use ";
        this.stmt.execute(exe.concat(database));
        String des = "describe formatted ";
        ResultSet resultSet = this.stmt.executeQuery(des.concat(tableName));
        this.extractHiveTableMeta(resultSet, builder);
        DBUtils.closeQuietly(resultSet);
        return builder.createHiveTableMeta();
    }

    public static String considerDataTypePrecision(String dataType, String precision, String scale) {
        if (("VARCHAR".equalsIgnoreCase(dataType) || "CHAR".equalsIgnoreCase(dataType)) && null != precision) {
            dataType = dataType + "(" + precision + ")";
        }
        if (("DECIMAL".equalsIgnoreCase(dataType) || "NUMERIC".equalsIgnoreCase(dataType)) && precision != null && scale != null) {
            dataType = dataType + "(" + precision + "," + scale + ")";
        }
        return dataType;
    }

    private void extractHiveTableMeta(ResultSet resultSet, HiveTableMetaBuilder builder) throws SQLException {
        while (resultSet.next()) {
            this.parseResultEntry(resultSet, builder);
        }
    }

    private void parseResultEntry(ResultSet resultSet, HiveTableMetaBuilder builder) throws SQLException {
        ArrayList<HiveTableMeta.HiveTableColumnMeta> partitionColumns = Lists.newArrayList();
        if ("# Partition Information".equals(resultSet.getString(1).trim())) {
            resultSet.next();
            Preconditions.checkArgument("# col_name".equals(resultSet.getString(1).trim()));
            resultSet.next();
            Preconditions.checkArgument("".equals(resultSet.getString(1).trim()));
            while (resultSet.next() && !"".equals(resultSet.getString(1).trim())) {
                partitionColumns.add(new HiveTableMeta.HiveTableColumnMeta(resultSet.getString(1).trim(), resultSet.getString(2).trim(), resultSet.getString(3).trim()));
            }
            builder.setPartitionColumns(partitionColumns);
        }
        if ("Owner:".equals(resultSet.getString(1).trim())) {
            builder.setOwner(resultSet.getString(2).trim());
        }
        if ("LastAccessTime:".equals(resultSet.getString(1).trim())) {
            try {
                int i = Integer.parseInt(resultSet.getString(2).trim());
                builder.setLastAccessTime(i);
            }
            catch (NumberFormatException e) {
                builder.setLastAccessTime(0);
            }
        }
        if ("Location:".equals(resultSet.getString(1).trim())) {
            builder.setSdLocation(resultSet.getString(2).trim());
        }
        if ("Table Type:".equals(resultSet.getString(1).trim())) {
            builder.setTableType(resultSet.getString(2).trim());
        }
        if ("Table Parameters:".equals(resultSet.getString(1).trim())) {
            this.extractTableParam(resultSet, builder);
        }
        if ("InputFormat:".equals(resultSet.getString(1).trim())) {
            builder.setSdInputFormat(resultSet.getString(2).trim());
        }
        if ("OutputFormat:".equals(resultSet.getString(1).trim())) {
            builder.setSdOutputFormat(resultSet.getString(2).trim());
        }
    }

    private void extractTableParam(ResultSet resultSet, HiveTableMetaBuilder builder) throws SQLException {
        while (resultSet.next() && resultSet.getString(2) != null) {
            if ("storage_handler".equals(resultSet.getString(2).trim())) {
                builder.setIsNative(false);
            }
            if ("totalSize".equals(resultSet.getString(2).trim())) {
                builder.setFileSize(Long.parseLong(resultSet.getString(3).trim()));
            }
            if ("numFiles".equals(resultSet.getString(2).trim())) {
                builder.setFileNum(Long.parseLong(resultSet.getString(3).trim()));
            }
            if (!"skip.header.line.count".equals(resultSet.getString(2).trim())) continue;
            builder.setSkipHeaderLineCount(resultSet.getString(3).trim());
        }
    }

    public void close() {
        DBUtils.closeQuietly(this.stmt);
        DBUtils.closeQuietly(this.cnct);
    }

    public static void main(String[] args) throws SQLException {
        BeelineHiveClient loader = new BeelineHiveClient("-n root --hiveconf hive.security.authorization.sqlstd.confwhitelist.append='mapreduce.job.*|dfs.*' -u 'jdbc:hive2://sandbox:10000'");
        HiveTableMeta hiveTableMeta = loader.getHiveTableMeta("default", "test_kylin_fact_part");
        System.out.println(hiveTableMeta);
        loader.close();
    }
}

