/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.acl.TableACLManager;
import org.apache.kylin.metadata.badquery.BadQueryHistoryManager;
import org.apache.kylin.metadata.draft.DraftManager;
import org.apache.kylin.metadata.model.DataModelManager;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.streaming.StreamingManager;
import org.apache.kylin.metrics.MetricsManager;
import org.apache.kylin.storage.hybrid.HybridManager;

public abstract class BasicService {
    public KylinConfig getConfig() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        if (kylinConfig == null) {
            throw new IllegalArgumentException("Failed to load kylin config instance");
        }
        return kylinConfig;
    }

    public TableMetadataManager getTableManager() {
        return TableMetadataManager.getInstance(this.getConfig());
    }

    public DataModelManager getDataModelManager() {
        return DataModelManager.getInstance(this.getConfig());
    }

    public CubeManager getCubeManager() {
        return CubeManager.getInstance(this.getConfig());
    }

    public StreamingManager getStreamingManager() {
        return StreamingManager.getInstance(this.getConfig());
    }

    public CubeDescManager getCubeDescManager() {
        return CubeDescManager.getInstance(this.getConfig());
    }

    public ProjectManager getProjectManager() {
        return ProjectManager.getInstance(this.getConfig());
    }

    public HybridManager getHybridManager() {
        return HybridManager.getInstance(this.getConfig());
    }

    public ExecutableManager getExecutableManager() {
        return ExecutableManager.getInstance(this.getConfig());
    }

    public BadQueryHistoryManager getBadQueryHistoryManager() {
        return BadQueryHistoryManager.getInstance(this.getConfig());
    }

    public DraftManager getDraftManager() {
        return DraftManager.getInstance(this.getConfig());
    }

    public TableACLManager getTableACLManager() {
        return TableACLManager.getInstance(this.getConfig());
    }

    public MetricsManager getMetricsManager() {
        return MetricsManager.getInstance();
    }
}

