/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.metadata.realization.SQLDigest;

public class Candidate
implements Comparable<Candidate> {
    static Map<RealizationType, Integer> DEFAULT_PRIORITIES = Maps.newHashMap();
    static Map<RealizationType, Integer> PRIORITIES = DEFAULT_PRIORITIES;
    IRealization realization;
    SQLDigest sqlDigest;
    int priority;
    CapabilityResult capability;

    public static void setPriorities(Map<RealizationType, Integer> priorities) {
        PRIORITIES = Collections.unmodifiableMap(priorities);
    }

    public static void restorePriorities() {
        PRIORITIES = Collections.unmodifiableMap(DEFAULT_PRIORITIES);
    }

    public Candidate(IRealization realization, SQLDigest sqlDigest) {
        this.realization = realization;
        this.sqlDigest = sqlDigest;
        this.priority = PRIORITIES.get((Object)realization.getType());
    }

    public IRealization getRealization() {
        return this.realization;
    }

    public SQLDigest getSqlDigest() {
        return this.sqlDigest;
    }

    public int getPriority() {
        return this.priority;
    }

    public CapabilityResult getCapability() {
        return this.capability;
    }

    public void setCapability(CapabilityResult capability) {
        this.capability = capability;
    }

    @Override
    public int compareTo(Candidate o) {
        int comp = this.priority - o.priority;
        if (comp != 0) {
            return comp;
        }
        comp = this.capability.cost - o.capability.cost;
        if (comp != 0) {
            return comp;
        }
        return 0;
    }

    public String toString() {
        return this.realization.toString();
    }

    static {
        DEFAULT_PRIORITIES.put(RealizationType.HYBRID, 0);
        DEFAULT_PRIORITIES.put(RealizationType.CUBE, 1);
    }
}

