/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.kylin.common.JobProcessContext;
import org.apache.kylin.common.util.Logger;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.SSHClient;
import org.apache.kylin.common.util.SSHClientOutput;
import org.apache.kylin.common.util.SoutLogger;
import org.apache.kylin.tool.shaded.org.apache.commons.io.FileUtils;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;

public class CliCommandExecutor {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(CliCommandExecutor.class);
    private String remoteHost;
    private int port;
    private String remoteUser;
    private String remotePwd;
    private int remoteTimeoutSeconds = 3600;
    public static final String COMMAND_BLOCK_LIST = "[ &`>|{}()$;\\-#~!+*\\\\]+";
    public static final String COMMAND_WHITE_LIST = "[^\\w%,@/:=?.\"\\[\\]]";
    public static final String HIVE_BLOCK_LIST = "[ <>()$;\\-#!+*\"'/=%@]+";

    public void setRunAtRemote(String host, int port, String user, String pwd) {
        this.remoteHost = host;
        this.port = port;
        this.remoteUser = user;
        this.remotePwd = pwd;
    }

    public void setRunAtLocal() {
        this.remoteHost = null;
        this.remoteUser = null;
        this.remotePwd = null;
    }

    public void copyFile(String localFile, String destDir) throws IOException {
        if (this.remoteHost == null) {
            this.copyNative(localFile, destDir);
        } else {
            this.copyRemote(localFile, destDir);
        }
    }

    private void copyNative(String localFile, String destDir) throws IOException {
        File src = new File(localFile);
        File dest = new File(destDir, src.getName());
        FileUtils.copyFile(src, dest);
    }

    private void copyRemote(String localFile, String destDir) throws IOException {
        SSHClient ssh = new SSHClient(this.remoteHost, this.port, this.remoteUser, this.remotePwd);
        try {
            ssh.scpFileToRemote(localFile, destDir);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public Pair<Integer, String> execute(String command) throws IOException {
        return this.execute(command, new SoutLogger(), null);
    }

    public Pair<Integer, String> execute(String command, Logger logAppender, String jobId) throws IOException {
        Pair<Integer, String> r = this.remoteHost == null ? this.runNativeCommand(command, logAppender, jobId) : this.runRemoteCommand(command, logAppender);
        if (r.getFirst() != 0) {
            throw new IOException("OS command error exit with return code: " + r.getFirst() + ", error message: " + r.getSecond() + "The command is: \n" + command + (this.remoteHost == null ? "" : " (remoteHost:" + this.remoteHost + ")"));
        }
        return r;
    }

    private Pair<Integer, String> runRemoteCommand(String command, Logger logAppender) throws IOException {
        SSHClient ssh = new SSHClient(this.remoteHost, this.port, this.remoteUser, this.remotePwd);
        try {
            SSHClientOutput sshOutput = ssh.execCommand(command, this.remoteTimeoutSeconds, logAppender);
            int exitCode = sshOutput.getExitCode();
            String output = sshOutput.getText();
            return Pair.newPair(exitCode, output);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private Pair<Integer, String> runNativeCommand(String command, Logger logAppender, String jobId) throws IOException {
        try {
            String line;
            String[] cmd = new String[3];
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Windows")) {
                cmd[0] = "cmd.exe";
                cmd[1] = "/C";
            } else {
                cmd[0] = "/bin/bash";
                cmd[1] = "-c";
            }
            cmd[2] = command;
            ProcessBuilder builder = new ProcessBuilder(cmd);
            builder.redirectErrorStream(true);
            Process proc = builder.start();
            if (StringUtils.isNotBlank(jobId)) {
                logger.info("Register process {} to {}", (Object)proc.toString(), (Object)jobId);
                JobProcessContext.registerProcess(jobId, proc);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder result = new StringBuilder();
            while ((line = reader.readLine()) != null && !Thread.currentThread().isInterrupted()) {
                result.append(line).append('\n');
                if (logAppender == null) continue;
                logAppender.log(line);
            }
            if (Thread.interrupted()) {
                logger.info("CliCommandExecutor is interrupted by other, kill the sub process: " + command);
                proc.destroy();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Pair<Integer, String> pair = Pair.newPair(1, "Killed");
                return pair;
            }
            int exitCode = proc.waitFor();
            Pair<Integer, String> pair = Pair.newPair(exitCode, result.toString());
            return pair;
        }
        finally {
            if (StringUtils.isNotBlank(jobId)) {
                JobProcessContext.removeProcess(jobId);
            }
        }
    }

    public static String checkParameter(String commandParameter) {
        return CliCommandExecutor.checkParameter(commandParameter, COMMAND_BLOCK_LIST);
    }

    public static String checkParameterWhiteList(String commandParameter) {
        return CliCommandExecutor.checkParameter(commandParameter, COMMAND_WHITE_LIST);
    }

    public static String checkHiveProperty(String hiveProperty) {
        return CliCommandExecutor.checkParameter(hiveProperty, HIVE_BLOCK_LIST);
    }

    private static String checkParameter(String commandParameter, String rex) {
        String repaired = commandParameter.replaceAll(rex, "");
        if (repaired.length() != commandParameter.length()) {
            logger.warn("Detected illegal character in command {} by {} , replace it to {}.", commandParameter, rex, repaired);
        }
        return repaired;
    }
}

