/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.jackson2;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.node.ArrayNode;

class UnmodifiableSetDeserializer
extends JsonDeserializer<Set> {
    UnmodifiableSetDeserializer() {
    }

    @Override
    public Set deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)mapper.readTree(jp);
        HashSet<Object> resultSet = new HashSet<Object>();
        if (node != null) {
            if (node instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)node;
                for (JsonNode elementNode : arrayNode) {
                    resultSet.add(mapper.readValue(elementNode.toString(), Object.class));
                }
            } else {
                resultSet.add(mapper.readValue(node.toString(), Object.class));
            }
        }
        return Collections.unmodifiableSet(resultSet);
    }
}

