/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.expression.method;

import org.springframework.expression.Expression;
import org.springframework.expression.ParseException;
import org.springframework.security.access.expression.method.AbstractExpressionBasedMethodConfigAttribute;
import org.springframework.security.access.prepost.PreInvocationAttribute;

class PreInvocationExpressionAttribute
extends AbstractExpressionBasedMethodConfigAttribute
implements PreInvocationAttribute {
    private final String filterTarget;

    PreInvocationExpressionAttribute(String filterExpression, String filterTarget, String authorizeExpression) throws ParseException {
        super(filterExpression, authorizeExpression);
        this.filterTarget = filterTarget;
    }

    PreInvocationExpressionAttribute(Expression filterExpression, String filterTarget, Expression authorizeExpression) throws ParseException {
        super(filterExpression, authorizeExpression);
        this.filterTarget = filterTarget;
    }

    String getFilterTarget() {
        return this.filterTarget;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Expression authorize = this.getAuthorizeExpression();
        Expression filter2 = this.getFilterExpression();
        sb.append("[authorize: '").append(authorize == null ? "null" : authorize.getExpressionString());
        sb.append("', filter: '").append(filter2 == null ? "null" : filter2.getExpressionString());
        sb.append("', filterTarget: '").append(this.filterTarget).append("']");
        return sb.toString();
    }
}

