/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.utils;

import java.util.Map;
import org.apache.kylin.cluster.AvailableResource;
import org.apache.kylin.cluster.ClusterInfoFetcher;
import org.apache.kylin.cluster.ResourceInfo;
import org.apache.kylin.engine.spark.job.SparkJobConstants;
import org.apache.kylin.engine.spark.utils.SparkConfHelper;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.hive.utils.DetectItem$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class ResourceUtils$
implements Logging {
    public static final ResourceUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ResourceUtils$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public String caculateRequiredCores(String sampSplitThreshold, Map<String, String> detectItems, long rowCount) throws Exception {
        NonLocalReturnControl nonLocalReturnControl2;
        block4: {
            String string;
            Object object = new Object();
            try {
                String partitionNum;
                String string2;
                Try try_ = Try$.MODULE$.apply((Function0)new Serializable(sampSplitThreshold, detectItems, rowCount, object){
                    public static final long serialVersionUID = 0L;
                    private final String sampSplitThreshold$1;
                    private final Map detectItems$1;
                    private final long rowCount$1;
                    private final Object nonLocalReturnKey1$1;

                    public final String apply() {
                        String lineCount;
                        String string = lineCount = (String)this.detectItems$1.get(DetectItem$.MODULE$.ESTIMATED_LINE_COUNT());
                        String string2 = "0";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            ResourceUtils$.MODULE$.logInfo((Function0<String>)new Serializable(this, lineCount){
                                public static final long serialVersionUID = 0L;
                                private final String lineCount$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the lineCount is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.lineCount$1}));
                                }
                                {
                                    this.lineCount$1 = lineCount$1;
                                }
                            });
                            throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)SparkJobConstants.DEFAULT_REQUIRED_CORES);
                        }
                        String estimatedSize = (String)this.detectItems$1.get(DetectItem$.MODULE$.ESTIMATED_SIZE());
                        long splitThreshold = Utils$.MODULE$.byteStringAsBytes(this.sampSplitThreshold$1);
                        double aveBytesSingleLine = new StringOps(Predef$.MODULE$.augmentString(estimatedSize)).toDouble() / new StringOps(Predef$.MODULE$.augmentString(lineCount)).toDouble();
                        Predef$.MODULE$.assert((double)splitThreshold > aveBytesSingleLine);
                        double linesPerPartition = (double)splitThreshold / aveBytesSingleLine;
                        String partitions = linesPerPartition >= (double)this.rowCount$1 ? SparkJobConstants.DEFAULT_REQUIRED_CORES : BoxesRunTime.boxToInteger((int)((int)package$.MODULE$.ceil((double)this.rowCount$1 / linesPerPartition)));
                        ResourceUtils$.MODULE$.logInfo((Function0<String>)new Serializable(this, lineCount, estimatedSize, splitThreshold){
                            public static final long serialVersionUID = 0L;
                            private final String lineCount$1;
                            private final String estimatedSize$1;
                            private final long splitThreshold$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"linecount is ", ", estimatedSize is ", ", splitThreshold is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.lineCount$1, this.estimatedSize$1, BoxesRunTime.boxToLong((long)this.splitThreshold$1)}));
                            }
                            {
                                this.lineCount$1 = lineCount$1;
                                this.estimatedSize$1 = estimatedSize$1;
                                this.splitThreshold$1 = splitThreshold$1;
                            }
                        });
                        ResourceUtils$.MODULE$.logInfo((Function0<String>)new Serializable(this, aveBytesSingleLine, linesPerPartition, partitions){
                            public static final long serialVersionUID = 0L;
                            private final double aveBytesSingleLine$1;
                            private final double linesPerPartition$1;
                            private final Object partitions$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aveBytesSingleLine is ", ", linesPerPartition is ", ", partitions is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.aveBytesSingleLine$1), BoxesRunTime.boxToDouble((double)this.linesPerPartition$1), this.partitions$1}));
                            }
                            {
                                this.aveBytesSingleLine$1 = aveBytesSingleLine$1;
                                this.linesPerPartition$1 = linesPerPartition$1;
                                this.partitions$1 = partitions$1;
                            }
                        });
                        return partitions.toString();
                    }
                    {
                        this.sampSplitThreshold$1 = sampSplitThreshold$1;
                        this.detectItems$1 = detectItems$1;
                        this.rowCount$1 = rowCount$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                if (!(try_ instanceof Success)) {
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable throwable = failure.exception();
                        this.logWarning((Function0<String>)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"caculate required cores failed ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ResourceUtils$.MODULE$.getClass().getName()}));
                            }
                        }, throwable);
                        return SparkJobConstants.DEFAULT_REQUIRED_CORES;
                    }
                    throw new MatchError((Object)try_);
                }
                Success success = (Success)try_;
                string = string2 = (partitionNum = (String)success.value());
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block4;
                string = (String)nonLocalReturnControl2.value();
            }
            return string;
        }
        throw nonLocalReturnControl2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkResource(SparkConf sparkConf, ClusterInfoFetcher clusterInfo) {
        void var10_9;
        void var8_8;
        void var6_6;
        String queue = sparkConf.get("spark.yarn.queue", "default");
        int driverMemory = (int)Utils$.MODULE$.byteStringAsMb(sparkConf.get(SparkConfHelper.DRIVER_MEMORY));
        if (sparkConf.contains(SparkConfHelper.DRIVER_OVERHEAD)) {
            driverMemory += (int)Utils$.MODULE$.byteStringAsMb(sparkConf.get(SparkConfHelper.DRIVER_OVERHEAD));
        }
        int driverCores = new StringOps(Predef$.MODULE$.augmentString(sparkConf.get(SparkConfHelper.DRIVER_CORES, "1"))).toInt();
        AvailableResource queueAvailable = this.minusDriverResource(clusterInfo.fetchQueueAvailableResource(queue), driverMemory, driverCores);
        int instances = new StringOps(Predef$.MODULE$.augmentString(sparkConf.get(SparkConfHelper.EXECUTOR_INSTANCES))).toInt();
        long executorMemory = (Utils$.MODULE$.byteStringAsMb(sparkConf.get(SparkConfHelper.EXECUTOR_MEMORY)) + Utils$.MODULE$.byteStringAsMb(sparkConf.get(SparkConfHelper.EXECUTOR_OVERHEAD))) * (long)instances;
        int executorCores = new StringOps(Predef$.MODULE$.augmentString(sparkConf.get(SparkConfHelper.EXECUTOR_CORES))).toInt() * instances;
        if (this.verify(queueAvailable.max(), executorMemory, executorCores, instances)) {
            this.logInfo((Function0<String>)new Serializable(queueAvailable, executorMemory, executorCores){
                public static final long serialVersionUID = 0L;
                private final AvailableResource queueAvailable$1;
                private final long executorMemory$1;
                private final int executorCores$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Require resource (", " MB, ", " vCores),"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.executorMemory$1), BoxesRunTime.boxToInteger((int)this.executorCores$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" available resource (", " MB, ", " vCores)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.queueAvailable$1.available().memory()), BoxesRunTime.boxToInteger((int)this.queueAvailable$1.available().vCores())}))).toString();
                }
                {
                    this.queueAvailable$1 = queueAvailable$1;
                    this.executorMemory$1 = executorMemory$1;
                    this.executorCores$1 = executorCores$1;
                }
            });
            return this.verify(queueAvailable.available(), executorMemory, executorCores, instances);
        }
        this.logInfo((Function0<String>)new Serializable((AvailableResource)var6_6, (long)var8_8, (int)var10_9){
            public static final long serialVersionUID = 0L;
            private final AvailableResource queueAvailable$1;
            private final long executorMemory$1;
            private final int executorCores$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Require resource (", " MB, ", " vCores),"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.executorMemory$1), BoxesRunTime.boxToInteger((int)this.executorCores$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" queue max resource (", " MB, ", " vCores)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.queueAvailable$1.max().memory()), BoxesRunTime.boxToInteger((int)this.queueAvailable$1.max().vCores())}))).toString();
            }
            {
                this.queueAvailable$1 = queueAvailable$1;
                this.executorMemory$1 = executorMemory$1;
                this.executorCores$1 = executorCores$1;
            }
        });
        throw new RuntimeException("Total queue resource does not meet requirement");
    }

    private boolean verify(ResourceInfo resource, long memory, long vCores, int instances) {
        return instances == 1 ? (long)resource.memory() >= memory && (long)resource.vCores() >= vCores : (double)resource.memory() * 1.0 / (double)memory >= 0.5 && (double)resource.vCores() * 1.0 / (double)vCores >= 0.5;
    }

    private AvailableResource minusDriverResource(AvailableResource queueAvailable, int memory, int vCores) {
        int am = queueAvailable.available().memory() - memory;
        int av = queueAvailable.available().vCores() - vCores;
        int mm = queueAvailable.max().memory() - memory;
        int mv = queueAvailable.max().vCores() - vCores;
        return new AvailableResource(new ResourceInfo(am, av), new ResourceInfo(mm, mv));
    }

    private ResourceUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

