/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.utils;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.NlsString;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.engine.spark.cross.CrossDateTimeUtils$;
import org.apache.kylin.engine.spark.metadata.ColumnDesc;
import org.apache.kylin.engine.spark.metadata.FunctionDesc;
import org.apache.kylin.engine.spark.metadata.cube.StructField;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SparkTypeUtil$
implements Logging {
    public static final SparkTypeUtil$ MODULE$;
    private final List<String> DATETIME_FAMILY;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparkTypeUtil$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private ZoneId defaultZoneId() {
        return ZoneId.systemDefault();
    }

    private ZoneId UTC() {
        return ZoneId.of("UTC");
    }

    public List<String> DATETIME_FAMILY() {
        return this.DATETIME_FAMILY;
    }

    public boolean isDateTimeFamilyType(String dataType) {
        return this.DATETIME_FAMILY().contains((Object)dataType.toLowerCase(Locale.ROOT));
    }

    public boolean isDateType(String dataType) {
        return "date".equalsIgnoreCase(dataType);
    }

    public boolean isDateTime(SqlTypeName sqlTypeName) {
        return SqlTypeName.DATETIME_TYPES.contains(sqlTypeName);
    }

    public DataType kylinTypeToSparkResultType(org.apache.kylin.metadata.datatype.DataType dataTp) {
        block23: {
            LongType$ longType$;
            block3: {
                String string;
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        block16: {
                                            block15: {
                                                block14: {
                                                    block13: {
                                                        block12: {
                                                            block11: {
                                                                block10: {
                                                                    block9: {
                                                                        block8: {
                                                                            block7: {
                                                                                block6: {
                                                                                    block5: {
                                                                                        block4: {
                                                                                            block2: {
                                                                                                string = dataTp.getName();
                                                                                                if (!string.startsWith("hllc")) break block2;
                                                                                                longType$ = LongType$.MODULE$;
                                                                                                break block3;
                                                                                            }
                                                                                            if (!string.startsWith("percentile")) break block4;
                                                                                            longType$ = DoubleType$.MODULE$;
                                                                                            break block3;
                                                                                        }
                                                                                        if (!string.startsWith("bitmap")) break block5;
                                                                                        longType$ = LongType$.MODULE$;
                                                                                        break block3;
                                                                                    }
                                                                                    if (!"decimal".equals(string)) break block6;
                                                                                    longType$ = new DecimalType(dataTp.getPrecision(), dataTp.getScale());
                                                                                    break block3;
                                                                                }
                                                                                if (!"date".equals(string)) break block7;
                                                                                longType$ = IntegerType$.MODULE$;
                                                                                break block3;
                                                                            }
                                                                            if (!"time".equals(string)) break block8;
                                                                            longType$ = LongType$.MODULE$;
                                                                            break block3;
                                                                        }
                                                                        if (!"timestamp".equals(string)) break block9;
                                                                        longType$ = LongType$.MODULE$;
                                                                        break block3;
                                                                    }
                                                                    if (!"datetime".equals(string)) break block10;
                                                                    longType$ = LongType$.MODULE$;
                                                                    break block3;
                                                                }
                                                                if (!"tinyint".equals(string)) break block11;
                                                                longType$ = ByteType$.MODULE$;
                                                                break block3;
                                                            }
                                                            if (!"smallint".equals(string)) break block12;
                                                            longType$ = ShortType$.MODULE$;
                                                            break block3;
                                                        }
                                                        if (!"integer".equals(string)) break block13;
                                                        longType$ = IntegerType$.MODULE$;
                                                        break block3;
                                                    }
                                                    if (!"int4".equals(string)) break block14;
                                                    longType$ = IntegerType$.MODULE$;
                                                    break block3;
                                                }
                                                if (!"bigint".equals(string)) break block15;
                                                longType$ = LongType$.MODULE$;
                                                break block3;
                                            }
                                            if (!"long8".equals(string)) break block16;
                                            longType$ = LongType$.MODULE$;
                                            break block3;
                                        }
                                        if (!"float".equals(string)) break block17;
                                        longType$ = FloatType$.MODULE$;
                                        break block3;
                                    }
                                    if (!"double".equals(string)) break block18;
                                    longType$ = DoubleType$.MODULE$;
                                    break block3;
                                }
                                if (!string.startsWith("varchar")) break block19;
                                longType$ = StringType$.MODULE$;
                                break block3;
                            }
                            if (!string.startsWith("char")) break block20;
                            longType$ = StringType$.MODULE$;
                            break block3;
                        }
                        if (!"bitmap".equals(string)) break block21;
                        longType$ = LongType$.MODULE$;
                        break block3;
                    }
                    if (!"dim_dc".equals(string)) break block22;
                    longType$ = LongType$.MODULE$;
                    break block3;
                }
                if (!"boolean".equals(string)) break block23;
                longType$ = BooleanType$.MODULE$;
            }
            return longType$;
        }
        throw new IllegalArgumentException();
    }

    public DataType toSparkType(org.apache.kylin.metadata.datatype.DataType dataTp, boolean isSum) {
        block27: {
            DateType$ dateType$;
            block6: {
                String string;
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    block21: {
                                        block20: {
                                            block19: {
                                                block18: {
                                                    block17: {
                                                        block16: {
                                                            block15: {
                                                                block14: {
                                                                    block13: {
                                                                        block12: {
                                                                            block11: {
                                                                                block10: {
                                                                                    block9: {
                                                                                        block8: {
                                                                                            block7: {
                                                                                                block5: {
                                                                                                    DecimalType decimalType;
                                                                                                    string = dataTp.getName();
                                                                                                    if (!"decimal".equals(string)) break block5;
                                                                                                    if (isSum) {
                                                                                                        int i = dataTp.getPrecision() + 10;
                                                                                                        decimalType = new DecimalType(Math.min(DecimalType$.MODULE$.MAX_PRECISION(), i), dataTp.getScale());
                                                                                                    } else {
                                                                                                        decimalType = new DecimalType(dataTp.getPrecision(), dataTp.getScale());
                                                                                                    }
                                                                                                    dateType$ = decimalType;
                                                                                                    break block6;
                                                                                                }
                                                                                                if (!"date".equals(string)) break block7;
                                                                                                dateType$ = DateType$.MODULE$;
                                                                                                break block6;
                                                                                            }
                                                                                            if (!"time".equals(string)) break block8;
                                                                                            dateType$ = DateType$.MODULE$;
                                                                                            break block6;
                                                                                        }
                                                                                        if (!"timestamp".equals(string)) break block9;
                                                                                        dateType$ = TimestampType$.MODULE$;
                                                                                        break block6;
                                                                                    }
                                                                                    if (!"datetime".equals(string)) break block10;
                                                                                    dateType$ = DateType$.MODULE$;
                                                                                    break block6;
                                                                                }
                                                                                if (!"tinyint".equals(string)) break block11;
                                                                                dateType$ = isSum ? LongType$.MODULE$ : ByteType$.MODULE$;
                                                                                break block6;
                                                                            }
                                                                            if (!"smallint".equals(string)) break block12;
                                                                            dateType$ = isSum ? LongType$.MODULE$ : ShortType$.MODULE$;
                                                                            break block6;
                                                                        }
                                                                        if (!"integer".equals(string)) break block13;
                                                                        dateType$ = isSum ? LongType$.MODULE$ : IntegerType$.MODULE$;
                                                                        break block6;
                                                                    }
                                                                    if (!"int4".equals(string)) break block14;
                                                                    dateType$ = isSum ? LongType$.MODULE$ : IntegerType$.MODULE$;
                                                                    break block6;
                                                                }
                                                                if (!"bigint".equals(string)) break block15;
                                                                dateType$ = LongType$.MODULE$;
                                                                break block6;
                                                            }
                                                            if (!"long8".equals(string)) break block16;
                                                            dateType$ = LongType$.MODULE$;
                                                            break block6;
                                                        }
                                                        if (!"float".equals(string)) break block17;
                                                        dateType$ = isSum ? DoubleType$.MODULE$ : FloatType$.MODULE$;
                                                        break block6;
                                                    }
                                                    if (!"double".equals(string)) break block18;
                                                    dateType$ = DoubleType$.MODULE$;
                                                    break block6;
                                                }
                                                if (!string.startsWith("varchar")) break block19;
                                                dateType$ = StringType$.MODULE$;
                                                break block6;
                                            }
                                            if (!string.startsWith("char")) break block20;
                                            dateType$ = StringType$.MODULE$;
                                            break block6;
                                        }
                                        if (!"dim_dc".equals(string)) break block21;
                                        dateType$ = LongType$.MODULE$;
                                        break block6;
                                    }
                                    if (!"boolean".equals(string)) break block22;
                                    dateType$ = BooleanType$.MODULE$;
                                    break block6;
                                }
                                if (!string.startsWith("hllc")) break block23;
                                dateType$ = BinaryType$.MODULE$;
                                break block6;
                            }
                            if (!string.startsWith("bitmap")) break block24;
                            dateType$ = BinaryType$.MODULE$;
                            break block6;
                        }
                        if (!string.startsWith("extendedcolumn")) break block25;
                        dateType$ = BinaryType$.MODULE$;
                        break block6;
                    }
                    if (!string.startsWith("percentile")) break block26;
                    dateType$ = BinaryType$.MODULE$;
                    break block6;
                }
                if (!string.startsWith("raw")) break block27;
                dateType$ = BinaryType$.MODULE$;
            }
            return dateType$;
        }
        throw new IllegalArgumentException(dataTp.toString());
    }

    public boolean toSparkType$default$2() {
        return false;
    }

    public DataType convertSqlTypeToSparkType(RelDataType dt) {
        block15: {
            StringType$ stringType$;
            block3: {
                SqlTypeName sqlTypeName;
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block8: {
                                            block7: {
                                                block6: {
                                                    block5: {
                                                        block4: {
                                                            block2: {
                                                                sqlTypeName = dt.getSqlTypeName();
                                                                if (!SqlTypeName.DECIMAL.equals(sqlTypeName)) break block2;
                                                                stringType$ = new DecimalType(dt.getPrecision(), dt.getScale());
                                                                break block3;
                                                            }
                                                            if (!SqlTypeName.CHAR.equals(sqlTypeName)) break block4;
                                                            stringType$ = StringType$.MODULE$;
                                                            break block3;
                                                        }
                                                        if (!SqlTypeName.VARCHAR.equals(sqlTypeName)) break block5;
                                                        stringType$ = StringType$.MODULE$;
                                                        break block3;
                                                    }
                                                    if (!SqlTypeName.INTEGER.equals(sqlTypeName)) break block6;
                                                    stringType$ = IntegerType$.MODULE$;
                                                    break block3;
                                                }
                                                if (!SqlTypeName.TINYINT.equals(sqlTypeName)) break block7;
                                                stringType$ = ByteType$.MODULE$;
                                                break block3;
                                            }
                                            if (!SqlTypeName.SMALLINT.equals(sqlTypeName)) break block8;
                                            stringType$ = ShortType$.MODULE$;
                                            break block3;
                                        }
                                        if (!SqlTypeName.BIGINT.equals(sqlTypeName)) break block9;
                                        stringType$ = LongType$.MODULE$;
                                        break block3;
                                    }
                                    if (!SqlTypeName.FLOAT.equals(sqlTypeName)) break block10;
                                    stringType$ = FloatType$.MODULE$;
                                    break block3;
                                }
                                if (!SqlTypeName.DOUBLE.equals(sqlTypeName)) break block11;
                                stringType$ = DoubleType$.MODULE$;
                                break block3;
                            }
                            if (!SqlTypeName.DATE.equals(sqlTypeName)) break block12;
                            stringType$ = DateType$.MODULE$;
                            break block3;
                        }
                        if (!SqlTypeName.TIMESTAMP.equals(sqlTypeName)) break block13;
                        stringType$ = TimestampType$.MODULE$;
                        break block3;
                    }
                    if (!SqlTypeName.BOOLEAN.equals(sqlTypeName)) break block14;
                    stringType$ = BooleanType$.MODULE$;
                    break block3;
                }
                if (!SqlTypeName.ANY.equals(sqlTypeName)) break block15;
                stringType$ = StringType$.MODULE$;
            }
            return stringType$;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unsupported SqlTypeName ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dt})));
    }

    public String convertSparkTypeToSqlType(DataType dt) {
        block13: {
            String string;
            block3: {
                block12: {
                    DataType dataType;
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block7: {
                                        block6: {
                                            block5: {
                                                block4: {
                                                    block2: {
                                                        dataType = dt;
                                                        if (!StringType$.MODULE$.equals(dataType)) break block2;
                                                        string = SqlTypeName.VARCHAR.getName();
                                                        break block3;
                                                    }
                                                    if (!IntegerType$.MODULE$.equals(dataType)) break block4;
                                                    string = SqlTypeName.INTEGER.getName();
                                                    break block3;
                                                }
                                                if (!ByteType$.MODULE$.equals(dataType)) break block5;
                                                string = SqlTypeName.TINYINT.getName();
                                                break block3;
                                            }
                                            if (!ShortType$.MODULE$.equals(dataType)) break block6;
                                            string = SqlTypeName.SMALLINT.getName();
                                            break block3;
                                        }
                                        if (!LongType$.MODULE$.equals(dataType)) break block7;
                                        string = SqlTypeName.BIGINT.getName();
                                        break block3;
                                    }
                                    if (!FloatType$.MODULE$.equals(dataType)) break block8;
                                    string = SqlTypeName.FLOAT.getName();
                                    break block3;
                                }
                                if (!DoubleType$.MODULE$.equals(dataType)) break block9;
                                string = SqlTypeName.DOUBLE.getName();
                                break block3;
                            }
                            if (!DateType$.MODULE$.equals(dataType)) break block10;
                            string = SqlTypeName.DATE.getName();
                            break block3;
                        }
                        if (!TimestampType$.MODULE$.equals(dataType)) break block11;
                        string = SqlTypeName.TIMESTAMP.getName();
                        break block3;
                    }
                    if (!BooleanType$.MODULE$.equals(dataType)) break block12;
                    string = SqlTypeName.BOOLEAN.getName();
                    break block3;
                }
                if (!(dt instanceof DecimalType)) break block13;
                DecimalType decimalType = (DecimalType)dt;
                string = new StringBuilder().append((Object)SqlTypeName.DECIMAL.getName()).append((Object)"(").append((Object)BoxesRunTime.boxToInteger((int)decimalType.precision())).append((Object)",").append((Object)BoxesRunTime.boxToInteger((int)decimalType.scale())).append((Object)")").toString();
            }
            return string;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unsupported SqlTypeName ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dt})));
    }

    /*
     * WARNING - void declaration
     */
    public Object getValueFromRexLit(RexLiteral literal) {
        void var2_16;
        Object object;
        Comparable comparable = literal.getValue();
        if (comparable instanceof NlsString) {
            NlsString nlsString = (NlsString)comparable;
            object = nlsString.getValue();
        } else if (comparable instanceof GregorianCalendar) {
            object = literal.getTypeName().getName().equals("DATE") ? new Date(BoxesRunTime.unboxToLong((Object)CrossDateTimeUtils$.MODULE$.stringToTimestamp(literal).get()) / 1000L) : new Timestamp(BoxesRunTime.unboxToLong((Object)CrossDateTimeUtils$.MODULE$.stringToTimestamp(literal).get()) / 1000L);
        } else if (comparable instanceof TimeUnitRange) {
            TimeUnitRange timeUnitRange = (TimeUnitRange)comparable;
            object = timeUnitRange.name();
        } else if (comparable instanceof Boolean) {
            Boolean bl = (Boolean)comparable;
            object = bl;
        } else if (comparable instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)comparable;
            SqlTypeName sqlTypeName = literal.getType().getSqlTypeName();
            Number number = SqlTypeName.BIGINT.equals(sqlTypeName) ? (Number)BoxesRunTime.boxToLong((long)bigDecimal.longValue()) : (Number)(SqlTypeName.INTEGER.equals(sqlTypeName) ? (Number)BoxesRunTime.boxToInteger((int)bigDecimal.intValue()) : (Number)(SqlTypeName.DOUBLE.equals(sqlTypeName) ? (Number)BoxesRunTime.boxToDouble((double)bigDecimal.doubleValue()) : (Number)(SqlTypeName.FLOAT.equals(sqlTypeName) ? (Number)BoxesRunTime.boxToFloat((float)bigDecimal.floatValue()) : (Number)(SqlTypeName.SMALLINT.equals(sqlTypeName) ? BoxesRunTime.boxToShort((short)bigDecimal.shortValue()) : bigDecimal))));
            object = number;
        } else if (comparable instanceof Float) {
            Float f = (Float)comparable;
            object = f;
        } else if (comparable instanceof Double) {
            Double d = (Double)comparable;
            object = d;
        } else if (comparable instanceof Integer) {
            Integer n = (Integer)comparable;
            object = n;
        } else if (comparable instanceof Byte) {
            Byte by = (Byte)comparable;
            object = by;
        } else if (comparable instanceof Short) {
            Short s = (Short)comparable;
            object = s;
        } else if (comparable instanceof Long) {
            Long l = (Long)comparable;
            object = l;
        } else {
            object = literal.getValue().toString();
        }
        String ret = object;
        return var2_16;
    }

    public Object convertStringToValue(Object s, RelDataType rowType, boolean toCalcite) {
        Object object;
        SqlTypeName sqlTypeName = rowType.getSqlTypeName();
        if (s == null) {
            object = null;
        } else if (s.toString().isEmpty()) {
            SqlTypeName sqlTypeName2 = sqlTypeName;
            Object object2 = SqlTypeName.DECIMAL.equals(sqlTypeName2) ? new BigDecimal(0) : (SqlTypeName.CHAR.equals(sqlTypeName2) ? s.toString() : (SqlTypeName.VARCHAR.equals(sqlTypeName2) ? s.toString() : (SqlTypeName.INTEGER.equals(sqlTypeName2) ? (Number)BoxesRunTime.boxToInteger((int)0) : (Number)(SqlTypeName.TINYINT.equals(sqlTypeName2) ? (Number)BoxesRunTime.boxToByte((byte)((byte)0)) : (Number)(SqlTypeName.SMALLINT.equals(sqlTypeName2) ? (Number)BoxesRunTime.boxToShort((short)((short)0)) : (Number)(SqlTypeName.BIGINT.equals(sqlTypeName2) ? (Number)BoxesRunTime.boxToLong((long)0L) : (Number)(SqlTypeName.FLOAT.equals(sqlTypeName2) ? (Number)BoxesRunTime.boxToFloat((float)0.0f) : (Number)(SqlTypeName.REAL.equals(sqlTypeName2) ? (Number)BoxesRunTime.boxToFloat((float)0.0f) : (Number)(SqlTypeName.DOUBLE.equals(sqlTypeName2) ? (Number)BoxesRunTime.boxToDouble((double)0.0) : (Number)(SqlTypeName.DATE.equals(sqlTypeName2) ? (Number)BoxesRunTime.boxToInteger((int)0) : (Number)(SqlTypeName.TIMESTAMP.equals(sqlTypeName2) ? BoxesRunTime.boxToLong((long)0L) : (SqlTypeName.TIME.equals(sqlTypeName2) ? BoxesRunTime.boxToLong((long)0L) : (SqlTypeName.BOOLEAN.equals(sqlTypeName2) ? null : (sqlTypeName2 == null ? null : null))))))))))))));
            object = object2;
        } else {
            try {
                Object object3;
                SqlTypeName sqlTypeName3 = sqlTypeName;
                if (SqlTypeName.DECIMAL.equals(sqlTypeName3)) {
                    object3 = s instanceof Double || s instanceof Float || s.toString().contains(".") ? new BigDecimal(s.toString()).setScale(rowType.getScale(), 6) : new BigDecimal(s.toString());
                } else if (SqlTypeName.CHAR.equals(sqlTypeName3)) {
                    object3 = s.toString();
                } else if (SqlTypeName.VARCHAR.equals(sqlTypeName3)) {
                    object3 = s.toString();
                } else if (SqlTypeName.INTEGER.equals(sqlTypeName3)) {
                    object3 = BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toInt());
                } else if (SqlTypeName.TINYINT.equals(sqlTypeName3)) {
                    object3 = BoxesRunTime.boxToByte((byte)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toByte());
                } else if (SqlTypeName.SMALLINT.equals(sqlTypeName3)) {
                    object3 = BoxesRunTime.boxToShort((short)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toShort());
                } else if (SqlTypeName.BIGINT.equals(sqlTypeName3)) {
                    object3 = BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toLong());
                } else if (SqlTypeName.FLOAT.equals(sqlTypeName3)) {
                    object3 = BoxesRunTime.boxToDouble((double)Double.parseDouble(s.toString()));
                } else if (SqlTypeName.DOUBLE.equals(sqlTypeName3)) {
                    object3 = BoxesRunTime.boxToDouble((double)Double.parseDouble(s.toString()));
                } else if (SqlTypeName.DATE.equals(sqlTypeName3)) {
                    Object object4;
                    String string = s.toString();
                    if (string.contains("-")) {
                        long time2 = DateFormat.stringToDate(string).getTime();
                        object4 = toCalcite ? CrossDateTimeUtils$.MODULE$.stringToDate(string).get() : BoxesRunTime.boxToLong((long)(time2 / 1000L));
                    } else {
                        object4 = toCalcite ? (Number)BoxesRunTime.boxToInteger((int)((int)(this.toCalciteTimestamp(DateFormat.stringToMillis(string)) / 86400000L))) : (Number)BoxesRunTime.boxToLong((long)(DateFormat.stringToMillis(string) / 1000L));
                    }
                    object3 = object4;
                } else {
                    boolean bl = SqlTypeName.TIMESTAMP.equals(sqlTypeName3) ? true : SqlTypeName.TIME.equals(sqlTypeName3);
                    if (bl) {
                        String ts = ((Timestamp)s).toString();
                        object3 = toCalcite ? BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)CrossDateTimeUtils$.MODULE$.stringToTimestamp(ts, this.UTC()).get()) / 1000L)) : BoxesRunTime.boxToLong((long)(((Timestamp)s).getTime() / 1000L));
                    } else {
                        object3 = SqlTypeName.BOOLEAN.equals(sqlTypeName3) ? s : s.toString();
                    }
                }
                String a = object3;
                object = a;
            }
            catch (Throwable throwable) {
                this.logError((Function0<String>)new Serializable(s){
                    public static final long serialVersionUID = 0L;
                    private final Object s$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error for convert value : ", " , class: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.s$1, this.s$1.getClass()}));
                    }
                    {
                        this.s$1 = s$1;
                    }
                }, throwable);
                object = this.safetyConvertStringToValue(s, rowType, toCalcite);
            }
        }
        return object;
    }

    public DataType kylinRawTableSQLTypeToSparkType(org.apache.kylin.metadata.datatype.DataType dataTp) {
        String string;
        block21: {
            DateType$ dateType$;
            block3: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    block15: {
                                        block14: {
                                            block13: {
                                                block12: {
                                                    block11: {
                                                        block10: {
                                                            block9: {
                                                                block8: {
                                                                    block7: {
                                                                        block6: {
                                                                            block5: {
                                                                                block4: {
                                                                                    block2: {
                                                                                        string = dataTp.getName();
                                                                                        if (!"decimal".equals(string)) break block2;
                                                                                        dateType$ = new DecimalType(dataTp.getPrecision(), dataTp.getScale());
                                                                                        break block3;
                                                                                    }
                                                                                    if (!"date".equals(string)) break block4;
                                                                                    dateType$ = DateType$.MODULE$;
                                                                                    break block3;
                                                                                }
                                                                                if (!"time".equals(string)) break block5;
                                                                                dateType$ = DateType$.MODULE$;
                                                                                break block3;
                                                                            }
                                                                            if (!"timestamp".equals(string)) break block6;
                                                                            dateType$ = TimestampType$.MODULE$;
                                                                            break block3;
                                                                        }
                                                                        if (!"datetime".equals(string)) break block7;
                                                                        dateType$ = DateType$.MODULE$;
                                                                        break block3;
                                                                    }
                                                                    if (!"tinyint".equals(string)) break block8;
                                                                    dateType$ = ByteType$.MODULE$;
                                                                    break block3;
                                                                }
                                                                if (!"smallint".equals(string)) break block9;
                                                                dateType$ = ShortType$.MODULE$;
                                                                break block3;
                                                            }
                                                            if (!"integer".equals(string)) break block10;
                                                            dateType$ = IntegerType$.MODULE$;
                                                            break block3;
                                                        }
                                                        if (!"int4".equals(string)) break block11;
                                                        dateType$ = IntegerType$.MODULE$;
                                                        break block3;
                                                    }
                                                    if (!"bigint".equals(string)) break block12;
                                                    dateType$ = LongType$.MODULE$;
                                                    break block3;
                                                }
                                                if (!"long8".equals(string)) break block13;
                                                dateType$ = LongType$.MODULE$;
                                                break block3;
                                            }
                                            if (!"float".equals(string)) break block14;
                                            dateType$ = FloatType$.MODULE$;
                                            break block3;
                                        }
                                        if (!"double".equals(string)) break block15;
                                        dateType$ = DoubleType$.MODULE$;
                                        break block3;
                                    }
                                    if (!"real".equals(string)) break block16;
                                    dateType$ = DoubleType$.MODULE$;
                                    break block3;
                                }
                                if (!string.startsWith("char")) break block17;
                                dateType$ = StringType$.MODULE$;
                                break block3;
                            }
                            if (!string.startsWith("varchar")) break block18;
                            dateType$ = StringType$.MODULE$;
                            break block3;
                        }
                        if (!"bitmap".equals(string)) break block19;
                        dateType$ = LongType$.MODULE$;
                        break block3;
                    }
                    if (!"dim_dc".equals(string)) break block20;
                    dateType$ = LongType$.MODULE$;
                    break block3;
                }
                if (!"boolean".equals(string)) break block21;
                dateType$ = BooleanType$.MODULE$;
            }
            return dateType$;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No supported data type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    public Object safetyConvertStringToValue(Object s, RelDataType rowType, boolean toCalcite) {
        try {
            Object object;
            SqlTypeName sqlTypeName = rowType.getSqlTypeName();
            if (SqlTypeName.DECIMAL.equals(sqlTypeName)) {
                object = s instanceof Double || s instanceof Float || s.toString().contains(".") ? new BigDecimal(s.toString()).setScale(rowType.getScale(), 6) : new BigDecimal(s.toString());
            } else if (SqlTypeName.CHAR.equals(sqlTypeName)) {
                object = s.toString();
            } else if (SqlTypeName.VARCHAR.equals(sqlTypeName)) {
                object = s.toString();
            } else if (SqlTypeName.INTEGER.equals(sqlTypeName)) {
                object = BoxesRunTime.boxToInteger((int)((int)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toDouble()));
            } else if (SqlTypeName.TINYINT.equals(sqlTypeName)) {
                object = BoxesRunTime.boxToByte((byte)((byte)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toDouble()));
            } else if (SqlTypeName.SMALLINT.equals(sqlTypeName)) {
                object = BoxesRunTime.boxToShort((short)((short)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toDouble()));
            } else if (SqlTypeName.BIGINT.equals(sqlTypeName)) {
                object = BoxesRunTime.boxToLong((long)((long)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toDouble()));
            } else if (SqlTypeName.FLOAT.equals(sqlTypeName)) {
                object = BoxesRunTime.boxToFloat((float)Float.parseFloat(s.toString()));
            } else if (SqlTypeName.DOUBLE.equals(sqlTypeName)) {
                object = BoxesRunTime.boxToDouble((double)Double.parseDouble(s.toString()));
            } else if (SqlTypeName.DATE.equals(sqlTypeName)) {
                Number number;
                String string = s.toString();
                if (string.contains("-")) {
                    long time2 = DateFormat.stringToDate(string).getTime();
                    number = toCalcite ? (Number)BoxesRunTime.boxToInteger((int)((int)(time2 / 86400000L))) : (Number)BoxesRunTime.boxToLong((long)(time2 / 1000L));
                } else {
                    number = toCalcite ? (Number)BoxesRunTime.boxToInteger((int)((int)(this.toCalciteTimestamp(DateFormat.stringToMillis(string)) / 86400000L))) : (Number)BoxesRunTime.boxToLong((long)DateFormat.stringToMillis(string));
                }
                object = number;
            } else {
                boolean bl = SqlTypeName.TIMESTAMP.equals(sqlTypeName) ? true : SqlTypeName.TIME.equals(sqlTypeName);
                if (bl) {
                    long ts = ((Timestamp)s).getTime();
                    object = toCalcite ? BoxesRunTime.boxToLong((long)ts) : BoxesRunTime.boxToLong((long)(ts / 1000L));
                } else {
                    object = SqlTypeName.BOOLEAN.equals(sqlTypeName) ? s : s.toString();
                }
            }
            return object;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error for convert value : ", " , class: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s, s.getClass()})), throwable);
        }
    }

    public Long toSparkTimestamp(long calciteTimestamp) {
        return Predef$.MODULE$.long2Long(calciteTimestamp / 1000L);
    }

    public long toCalciteTimestamp(long sparkTimestamp) {
        return sparkTimestamp * 1000L;
    }

    /*
     * WARNING - void declaration
     */
    public Column[] alignDataType(StructType origin, StructType goal) {
        void var3_3;
        Column[] columns = (Column[])((TraversableOnce)((TraversableLike)origin.zip((GenIterable)goal, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(Tuple2<StructField, StructField> x0$1) {
                Tuple2<StructField, StructField> tuple2 = x0$1;
                if (tuple2 != null) {
                    Column column;
                    DataType goalDataType;
                    StructField sparkField = (StructField)tuple2._1();
                    StructField goalField = (StructField)tuple2._2();
                    DataType sparkDataType = sparkField.dataType();
                    if (sparkDataType.sameType(goalDataType = goalField.dataType())) {
                        column = functions$.MODULE$.col(sparkField.name());
                    } else if (Cast$.MODULE$.canCast(sparkDataType, goalDataType)) {
                        column = functions$.MODULE$.col(sparkField.name()).cast(goalDataType);
                    } else {
                        SparkTypeUtil$.MODULE$.logError((Function0<String>)new Serializable(this, sparkField, sparkDataType, goalDataType){
                            public static final long serialVersionUID = 0L;
                            private final StructField sparkField$1;
                            private final DataType sparkDataType$1;
                            private final DataType goalDataType$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error for cast datatype from  ", " to ", " with column name is : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sparkDataType$1, this.goalDataType$1, this.sparkField$1.name()}));
                            }
                            {
                                this.sparkField$1 = sparkField$1;
                                this.sparkDataType$1 = sparkDataType$1;
                                this.goalDataType$1 = goalDataType$1;
                            }
                        });
                        column = functions$.MODULE$.col(sparkField.name());
                    }
                    Column column2 = column;
                    return column2;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Column.class));
        this.logInfo((Function0<String>)new Serializable(columns){
            public static final long serialVersionUID = 0L;
            private final Column[] columns$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Align data type is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.columns$1).mkString(",")}));
            }
            {
                this.columns$1 = columns$1;
            }
        });
        return var3_3;
    }

    public DataType generateFunctionReturnDataType(FunctionDesc function) {
        LongType$ longType$;
        String string = function.expression().toUpperCase(Locale.ROOT);
        if ("SUM".equals(string)) {
            longType$ = this.toSparkType(function.returnType().toKylinDataType(), true);
        } else if ("COUNT".equals(string)) {
            longType$ = LongType$.MODULE$;
        } else if (string.startsWith("TOP_N")) {
            List fields2 = (List)function.pra().drop(1).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final StructField apply(ColumnDesc p) {
                    return new StructField(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DIMENSION_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p.columnName()})), p.dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                }
            }, List$.MODULE$.canBuildFrom());
            longType$ = DataTypes.createArrayType((DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("measure", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("dim", (DataType)StructType$.MODULE$.apply((Seq)fields2), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))));
        } else {
            boolean bl = "MAX".equals(string) ? true : "MIN".equals(string);
            longType$ = bl ? ((ColumnDesc)function.pra().head()).dataType() : this.toSparkType(function.returnType().toKylinDataType(), this.toSparkType$default$2());
        }
        return longType$;
    }

    public org.apache.kylin.engine.spark.metadata.cube.StructField convertSparkFieldToJavaField(StructField field) {
        int n;
        String typeName;
        StructField.StructFieldBuilder builder = new StructField.StructFieldBuilder();
        builder.setName(field.name());
        String string = typeName = field.dataType().sql().startsWith("DECIMAL") ? "DECIMAL" : field.dataType().sql();
        if ("BINARY".equals(string)) {
            n = -2;
        } else if ("BOOLEAN".equals(string)) {
            n = 16;
        } else if ("DATE".equals(string)) {
            n = 91;
        } else if ("DOUBLE".equals(string)) {
            n = 8;
        } else if ("FLOAT".equals(string)) {
            n = 6;
        } else if ("INT".equals(string)) {
            n = 4;
        } else if ("BIGINT".equals(string)) {
            n = -5;
        } else if ("NUMERIC".equals(string)) {
            n = 2;
        } else if ("SMALLINT".equals(string)) {
            n = 5;
        } else if ("TIMESTAMP".equals(string)) {
            n = 93;
        } else if ("STRING".equals(string)) {
            n = 12;
        } else if ("DECIMAL".equals(string)) {
            Object object;
            Tuple2<Object, Object> precisionAndScalePair = this.getDecimalPrecisionAndScale(typeName);
            if (precisionAndScalePair == null) {
                object = BoxedUnit.UNIT;
            } else {
                builder.setPrecision(precisionAndScalePair._1$mcI$sp());
                object = builder.setScale(precisionAndScalePair._2$mcI$sp());
            }
            n = 3;
        } else {
            n = 1111;
        }
        int javaType = n;
        builder.setDataType(javaType);
        builder.setDataTypeName(typeName);
        builder.setNullable(field.nullable());
        return builder.createStructField();
    }

    private Tuple2<Object, Object> getDecimalPrecisionAndScale(String javaType) {
        Pattern DECIMAL_PATTERN = Pattern.compile("DECIMAL\\(([0-9]+),([0-9]+)\\)", 2);
        Matcher decimalMatcher = DECIMAL_PATTERN.matcher(javaType);
        return decimalMatcher.find() ? new Tuple2.mcII.sp(Predef$.MODULE$.Integer2int(Integer.valueOf(decimalMatcher.group(1))), Predef$.MODULE$.Integer2int(Integer.valueOf(decimalMatcher.group(2)))) : null;
    }

    private SparkTypeUtil$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.DATETIME_FAMILY = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"time", "date", "timestamp", "datetime"}));
    }
}

