/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.autoheal;

import java.util.HashMap;
import org.apache.kylin.engine.spark.job.KylinBuildEnv;
import org.apache.kylin.engine.spark.job.KylinBuildEnv$;
import org.apache.kylin.engine.spark.scheduler.JobFailed;
import org.apache.kylin.engine.spark.scheduler.ResourceLack;
import org.apache.kylin.engine.spark.scheduler.RunJob;
import org.apache.kylin.engine.spark.utils.SparkConfHelper;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.spark.SparkConf;
import org.apache.spark.application.RetryInfo;
import org.apache.spark.autoheal.Failed;
import org.apache.spark.autoheal.ResolverResult;
import org.apache.spark.autoheal.Success;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.KylinJobEventLoop;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ExceptionTerminator$
implements Logging {
    public static final ExceptionTerminator$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ExceptionTerminator$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public void resolveException(ResourceLack rl, KylinJobEventLoop eventLoop) {
        ResolverResult resolverResult;
        block9: {
            block8: {
                block7: {
                    ResolverResult result;
                    ResolverResult resolverResult2;
                    KylinBuildEnv env = KylinBuildEnv$.MODULE$.get();
                    Throwable throwable = rl.throwable();
                    if (throwable instanceof OutOfMemoryError) {
                        resolverResult2 = this.resolveOutOfMemoryError(env, rl.throwable());
                    } else if (throwable instanceof ClassNotFoundException) {
                        ClassNotFoundException classNotFoundException = (ClassNotFoundException)throwable;
                        resolverResult2 = new Failed(classNotFoundException.getMessage(), classNotFoundException);
                    } else {
                        resolverResult2 = this.incMemory(env);
                    }
                    resolverResult = result = resolverResult2;
                    if (!(resolverResult instanceof Success)) break block7;
                    Success success = (Success)resolverResult;
                    HashMap<String, String> conf = success.conf();
                    KylinBuildEnv$.MODULE$.get().buildJobInfos().recordJobRetryInfos(new RetryInfo(conf, rl.throwable()));
                    eventLoop.post(new RunJob());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block8;
                }
                if (!(resolverResult instanceof Failed)) break block9;
                Failed failed = (Failed)resolverResult;
                String message = failed.message();
                Throwable throwable = failed.throwable();
                eventLoop.post(new JobFailed(message, throwable));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)resolverResult);
    }

    private ResolverResult resolveOutOfMemoryError(KylinBuildEnv env, Throwable throwable) {
        ResolverResult resolverResult;
        if (throwable.getMessage().contains(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key())) {
            this.logInfo((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Resolve out of memory error with broadcast.";
                }
            });
            this.overrideSparkConf(env.sparkConf(), SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key(), "-1");
            HashMap<String, String> overrideConf = Maps.newHashMap();
            overrideConf.put(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key(), "-1");
            resolverResult = new Success(overrideConf);
        } else {
            resolverResult = this.incMemory(env);
        }
        return resolverResult;
    }

    private ResolverResult incMemory(KylinBuildEnv env) {
        ResolverResult resolverResult;
        SparkConf conf = env.sparkConf();
        double gradient = env.kylinConfig().getSparkEngineRetryMemoryGradient();
        long prevMemory = Utils$.MODULE$.byteStringAsMb(conf.get(SparkConfHelper.EXECUTOR_MEMORY));
        int retryMemory = (int)Math.ceil((double)prevMemory * gradient);
        double overheadGradient = env.kylinConfig().getSparkEngineRetryOverheadMemoryGradient();
        int retryOverhead = (int)Math.ceil((double)retryMemory * overheadGradient);
        Double proportion = KylinBuildEnv$.MODULE$.get().kylinConfig().getMaxAllocationResourceProportion();
        int maxResourceMemory = (int)((double)env.clusterInfoFetcher().fetchMaximumResourceAllocation().memory() * Predef$.MODULE$.Double2double(proportion));
        long overheadMem = Utils$.MODULE$.byteStringAsMb(conf.get(SparkConfHelper.EXECUTOR_OVERHEAD));
        long maxMemory = (long)maxResourceMemory - overheadMem;
        int maxOverheadMem = (int)((double)maxMemory * overheadGradient);
        if (prevMemory == maxMemory) {
            int retryCore = new StringOps(Predef$.MODULE$.augmentString(conf.get(SparkConfHelper.EXECUTOR_CORES))).toInt() - 1;
            if (retryCore > 0) {
                conf.set(SparkConfHelper.EXECUTOR_CORES, ((Object)BoxesRunTime.boxToInteger((int)retryCore)).toString());
                this.logInfo((Function0<String>)new Serializable(retryCore){
                    public static final long serialVersionUID = 0L;
                    private final int retryCore$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reset ", "=", " when retry."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SparkConfHelper.EXECUTOR_CORES, BoxesRunTime.boxToInteger((int)this.retryCore$1)}));
                    }
                    {
                        this.retryCore$1 = retryCore$1;
                    }
                });
                HashMap<String, String> overrideConf = Maps.newHashMap();
                overrideConf.put(SparkConfHelper.EXECUTOR_CORES, ((Object)BoxesRunTime.boxToInteger((int)retryCore)).toString());
                resolverResult = new Success(overrideConf);
            } else {
                resolverResult = new Failed(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retry configuration is invalid."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", "=", ", ", "=", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SparkConfHelper.EXECUTOR_CORES, BoxesRunTime.boxToInteger((int)retryCore), SparkConfHelper.EXECUTOR_MEMORY, BoxesRunTime.boxToLong((long)prevMemory)}))).toString(), new RuntimeException());
            }
        } else if ((long)retryMemory > maxMemory) {
            conf.set(SparkConfHelper.EXECUTOR_MEMORY, new StringBuilder().append(maxMemory).append((Object)"MB").toString());
            conf.set(SparkConfHelper.EXECUTOR_OVERHEAD, new StringBuilder().append(maxOverheadMem).append((Object)"MB").toString());
            this.logInfo((Function0<String>)new Serializable(conf){
                public static final long serialVersionUID = 0L;
                private final SparkConf conf$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reset ", "=", " when retry."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SparkConfHelper.EXECUTOR_MEMORY, this.conf$1.get(SparkConfHelper.EXECUTOR_MEMORY)}));
                }
                {
                    this.conf$1 = conf$1;
                }
            });
            this.logInfo((Function0<String>)new Serializable(conf){
                public static final long serialVersionUID = 0L;
                private final SparkConf conf$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reset ", "=", " when retry."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SparkConfHelper.EXECUTOR_OVERHEAD, this.conf$1.get(SparkConfHelper.EXECUTOR_OVERHEAD)}));
                }
                {
                    this.conf$1 = conf$1;
                }
            });
            HashMap<String, String> overrideConf = Maps.newHashMap();
            overrideConf.put(SparkConfHelper.EXECUTOR_MEMORY, new StringBuilder().append(maxMemory).append((Object)"MB").toString());
            overrideConf.put(SparkConfHelper.EXECUTOR_OVERHEAD, new StringBuilder().append(maxOverheadMem).append((Object)"MB").toString());
            resolverResult = new Success(overrideConf);
        } else {
            conf.set(SparkConfHelper.EXECUTOR_MEMORY, new StringBuilder().append(retryMemory).append((Object)"MB").toString());
            conf.set(SparkConfHelper.EXECUTOR_OVERHEAD, new StringBuilder().append(retryOverhead).append((Object)"MB").toString());
            this.logInfo((Function0<String>)new Serializable(conf){
                public static final long serialVersionUID = 0L;
                private final SparkConf conf$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reset ", "=", " when retry."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SparkConfHelper.EXECUTOR_MEMORY, this.conf$1.get(SparkConfHelper.EXECUTOR_MEMORY)}));
                }
                {
                    this.conf$1 = conf$1;
                }
            });
            this.logInfo((Function0<String>)new Serializable(conf){
                public static final long serialVersionUID = 0L;
                private final SparkConf conf$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reset ", "=", " when retry."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SparkConfHelper.EXECUTOR_OVERHEAD, this.conf$1.get(SparkConfHelper.EXECUTOR_OVERHEAD)}));
                }
                {
                    this.conf$1 = conf$1;
                }
            });
            HashMap<String, String> overrideConf = Maps.newHashMap();
            overrideConf.put(SparkConfHelper.EXECUTOR_MEMORY, new StringBuilder().append(retryMemory).append((Object)"MB").toString());
            overrideConf.put(SparkConfHelper.EXECUTOR_OVERHEAD, new StringBuilder().append(retryOverhead).append((Object)"MB").toString());
            resolverResult = new Success(overrideConf);
        }
        return resolverResult;
    }

    public void overrideSparkConf(SparkConf sparkConf, String key, String value) {
        this.logInfo((Function0<String>)new Serializable(key, value){
            public static final long serialVersionUID = 0L;
            private final String key$1;
            private final String value$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Override spark conf ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$1, this.value$1}));
            }
            {
                this.key$1 = key$1;
                this.value$1 = value$1;
            }
        });
        sparkConf.set(key, value);
    }

    private ExceptionTerminator$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

