/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.metrics.systemcube.def;

import java.util.Map;
import org.apache.kylin.metrics.lib.impl.hive.HiveReservoirReporter;
import org.apache.kylin.metrics.lib.impl.kafka.KafkaReservoirReporter;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonProperty;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class MetricsSinkDesc {
    @JsonProperty(value="sink")
    private String sinkType;
    @JsonProperty(value="storage_type")
    protected int storageType = 2;
    @JsonProperty(value="cube_desc_override_properties")
    protected Map<String, String> cubeDescOverrideProperties = Maps.newHashMap();
    @JsonProperty(value="table_properties")
    protected Map<String, String> tableProperties = Maps.newHashMap();

    public int getStorageType() {
        return this.storageType;
    }

    public int getSourceType() {
        if (this.sinkType.equalsIgnoreCase("hive")) {
            return 0;
        }
        if (this.sinkType.equalsIgnoreCase("kafka")) {
            return 20;
        }
        return 0;
    }

    public String getTableNameForMetrics(String subject) {
        if (this.sinkType.equalsIgnoreCase("hive")) {
            return HiveReservoirReporter.getTableFromSubject(subject);
        }
        if (this.sinkType.equalsIgnoreCase("kafka")) {
            return KafkaReservoirReporter.getTableFromSubject(subject);
        }
        return HiveReservoirReporter.getTableFromSubject(subject);
    }

    public Map<String, String> getCubeDescOverrideProperties() {
        return this.cubeDescOverrideProperties;
    }

    public void setCubeDescOverrideProperties(Map<String, String> cubeDescOverrideProperties) {
        this.cubeDescOverrideProperties = cubeDescOverrideProperties;
    }

    public String getSinkType() {
        return this.sinkType;
    }

    public boolean useKafka() {
        return this.sinkType.equalsIgnoreCase("kafka");
    }

    public boolean useHive() {
        return this.sinkType.equalsIgnoreCase("hive");
    }

    public Map<String, String> getTableProperties() {
        return this.tableProperties;
    }
}

