/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.gtrecord;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.kylin.common.QueryContextFacade;
import org.apache.kylin.common.annotation.Clarification;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.metadata.tuple.ITuple;
import org.apache.kylin.metadata.tuple.ITupleIterator;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Iterators;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.storage.StorageContext;
import org.apache.kylin.storage.gtrecord.CubeSegmentScanner;
import org.apache.kylin.storage.gtrecord.SegmentCubeTupleIterator;
import org.apache.kylin.storage.gtrecord.SortedIteratorMergerWithLimit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Clarification(deprecated=true, msg="Only for HBase storage")
public class SequentialCubeTupleIterator
implements ITupleIterator {
    private static final Logger logger = LoggerFactory.getLogger(SequentialCubeTupleIterator.class);
    protected List<CubeSegmentScanner> scanners;
    protected List<SegmentCubeTupleIterator> segmentCubeTupleIterators;
    protected Iterator<ITuple> tupleIterator;
    protected StorageContext context;
    private int scanCount;
    private int scanCountDelta;

    public SequentialCubeTupleIterator(List<CubeSegmentScanner> scanners, Cuboid cuboid, Set<TblColRef> selectedDimensions, List<TblColRef> rtGroups, Set<TblColRef> groups, Set<FunctionDesc> selectedMetrics, TupleInfo returnTupleInfo, StorageContext context, SQLDigest sqlDigest) {
        this.context = context;
        this.scanners = scanners;
        HashSet<TblColRef> selectedDims = Sets.newHashSet(selectedDimensions);
        selectedDims.addAll(rtGroups);
        this.segmentCubeTupleIterators = Lists.newArrayList();
        for (CubeSegmentScanner scanner : scanners) {
            this.segmentCubeTupleIterators.add(new SegmentCubeTupleIterator(scanner, cuboid, selectedDims, selectedMetrics, returnTupleInfo, context));
        }
        if (context.mergeSortPartitionResults() && !sqlDigest.isRawQuery) {
            logger.info("Using SortedIteratorMergerWithLimit to merge segment results");
            Iterator transformed = this.segmentCubeTupleIterators.iterator();
            this.tupleIterator = new SortedIteratorMergerWithLimit<ITuple>(transformed, context.getFinalPushDownLimit(), this.getTupleDimensionComparator(cuboid, groups, returnTupleInfo)).getIterator();
        } else {
            logger.info("Using Iterators.concat to merge segment results");
            this.tupleIterator = Iterators.concat(this.segmentCubeTupleIterators.iterator());
        }
    }

    public Comparator<ITuple> getTupleDimensionComparator(Cuboid cuboid, Set<TblColRef> groups, TupleInfo returnTupleInfo) {
        List<TblColRef> dimColumns = cuboid.getColumns();
        TreeSet<Integer> groupIndexOnDim = new TreeSet<Integer>();
        for (TblColRef tblColRef : groups) {
            groupIndexOnDim.add(dimColumns.indexOf(tblColRef));
        }
        ArrayList<Integer> temp = Lists.newArrayList();
        for (Integer index : groupIndexOnDim) {
            TblColRef dim = dimColumns.get(index);
            if (!returnTupleInfo.hasColumn(dim)) continue;
            temp.add(returnTupleInfo.getColumnIndex(dim));
        }
        final int[] nArray = new int[temp.size()];
        for (int i = 0; i < temp.size(); ++i) {
            nArray[i] = (Integer)temp.get(i);
        }
        return new Comparator<ITuple>(){

            @Override
            public int compare(ITuple o1, ITuple o2) {
                Preconditions.checkNotNull(o1);
                Preconditions.checkNotNull(o2);
                for (int i = 0; i < nArray.length; ++i) {
                    int index = nArray[i];
                    if (index == -1) continue;
                    Comparable a = (Comparable)o1.getAllValues()[index];
                    Comparable b = (Comparable)o2.getAllValues()[index];
                    if (a == null && b == null) continue;
                    if (a == null) {
                        return 1;
                    }
                    if (b == null) {
                        return -1;
                    }
                    int temp = a.compareTo(b);
                    if (temp == 0) continue;
                    return temp;
                }
                return 0;
            }
        };
    }

    @Override
    public boolean hasNext() {
        return this.tupleIterator.hasNext();
    }

    @Override
    public ITuple next() {
        if (this.scanCount++ % 100 == 1) {
            QueryContextFacade.current().checkMillisBeforeDeadline();
        }
        if (++this.scanCountDelta >= 1000) {
            this.flushScanCountDelta();
        }
        return this.tupleIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.flushScanCountDelta();
        for (SegmentCubeTupleIterator iterator : this.segmentCubeTupleIterators) {
            iterator.close();
        }
    }

    protected void close(CubeSegmentScanner scanner) {
        try {
            scanner.close();
        }
        catch (IOException e) {
            logger.error("Exception when close CubeScanner", e);
        }
    }

    private void flushScanCountDelta() {
        this.context.increaseProcessedRowCount(this.scanCountDelta);
        this.scanCountDelta = 0;
    }
}

