/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.gtrecord;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.kylin.common.QueryContextFacade;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.RawQueryLastHacker;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.gridtable.CuboidToGridTableMapping;
import org.apache.kylin.cube.gridtable.CuboidToGridTableMappingExt;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.RowKeyColDesc;
import org.apache.kylin.gridtable.StorageLimitLevel;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.filter.CaseTupleFilter;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.DynamicFunctionDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.metadata.tuple.ITupleIterator;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.storage.IStorageQuery;
import org.apache.kylin.storage.StorageContext;
import org.apache.kylin.storage.gtrecord.CubeTupleConverter;
import org.apache.kylin.storage.gtrecord.GTCubeStorageQueryRequest;
import org.apache.kylin.storage.gtrecord.ITupleConverter;
import org.apache.kylin.storage.translate.DerivedFilterTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GTCubeStorageQueryBase
implements IStorageQuery {
    private static final Logger logger = LoggerFactory.getLogger(GTCubeStorageQueryBase.class);
    protected CubeInstance cubeInstance;
    protected CubeDesc cubeDesc;

    public GTCubeStorageQueryBase(CubeInstance cube) {
        this.cubeInstance = cube;
        this.cubeDesc = cube.getDescriptor();
    }

    @Override
    public ITupleIterator search(StorageContext context, SQLDigest sqlDigest, TupleInfo returnTupleInfo) {
        throw new UnsupportedOperationException("Removed in Kylin 4.0 .");
    }

    public GTCubeStorageQueryRequest getStorageQueryRequest(StorageContext context, SQLDigest sqlDigest, TupleInfo returnTupleInfo) {
        context.setStorageQuery(this);
        RawQueryLastHacker.hackNoAggregations(sqlDigest, this.cubeDesc, returnTupleInfo);
        this.notifyBeforeStorageQuery(sqlDigest);
        List<TblColRef> groups = sqlDigest.groupbyColumns;
        TupleFilter filter2 = sqlDigest.filter;
        LinkedHashSet<TblColRef> dimensions = new LinkedHashSet<TblColRef>();
        LinkedHashSet<FunctionDesc> metrics = new LinkedHashSet<FunctionDesc>();
        this.buildDimensionsAndMetrics(sqlDigest, dimensions, metrics);
        HashSet<TblColRef> otherDims = Sets.newHashSet(dimensions);
        otherDims.removeAll(groups);
        HashSet<TblColRef> derivedPostAggregation = Sets.newHashSet();
        Set<TblColRef> groupsD = this.expandDerived(groups, derivedPostAggregation);
        Set<TblColRef> otherDimsD = this.expandDerived(otherDims, derivedPostAggregation);
        otherDimsD.removeAll(groupsD);
        LinkedHashSet<TblColRef> dimensionsD = new LinkedHashSet<TblColRef>();
        dimensionsD.addAll(groupsD);
        dimensionsD.addAll(otherDimsD);
        Cuboid cuboid = this.findCuboid(this.cubeInstance, dimensionsD, metrics);
        context.setCuboid(cuboid);
        ArrayList<TblColRef> dynGroups = Lists.newArrayList(sqlDigest.dynGroupbyColumns.keySet());
        boolean noDynamicCols = dynGroups.isEmpty();
        ArrayList<TupleExpression> dynGroupExprs = Lists.newArrayListWithExpectedSize(sqlDigest.dynGroupbyColumns.size());
        for (TblColRef dynGroupCol : dynGroups) {
            dynGroupExprs.add(sqlDigest.dynGroupbyColumns.get(dynGroupCol));
        }
        List<DynamicFunctionDesc> dynFuncs = sqlDigest.dynAggregations;
        noDynamicCols = noDynamicCols && dynFuncs.isEmpty();
        CuboidToGridTableMapping mapping = noDynamicCols ? new CuboidToGridTableMapping(cuboid) : new CuboidToGridTableMappingExt(cuboid, dynGroups, dynFuncs);
        context.setMapping(mapping);
        Set<TblColRef> singleValuesD = this.findSingleValueColumns(filter2);
        context.setNeedStorageAggregation(this.isNeedStorageAggregation(cuboid, groupsD, singleValuesD));
        boolean exactAggregation = this.isExactAggregation(context, cuboid, groups, otherDimsD, singleValuesD, derivedPostAggregation, sqlDigest.aggregations, sqlDigest.aggrSqlCalls, sqlDigest.groupByExpression);
        context.setExactAggregation(exactAggregation);
        HashSet<TblColRef> loosenedColumnD = Sets.newHashSet();
        HashSet<TblColRef> filterColumnD = Sets.newHashSet();
        TupleFilter filterD = this.translateDerived(filter2, loosenedColumnD);
        groupsD.addAll(loosenedColumnD);
        TupleFilter.collectColumns(filterD, filterColumnD);
        context.setFilterMask(this.getQueryFilterMask(filterColumnD));
        this.enableStorageLimitIfPossible(cuboid, groups, dynGroups, derivedPostAggregation, groupsD, filterD, loosenedColumnD, sqlDigest, context);
        this.enableStreamAggregateIfBeneficial(cuboid, groupsD, context);
        QueryContextFacade.current().checkMillisBeforeDeadline();
        TupleFilter havingFilter = this.checkHavingCanPushDown(sqlDigest.havingFilter, groupsD, sqlDigest.aggregations, metrics);
        logger.info("Cuboid identified: cube={}, cuboidId={}, groupsD={}, filterD={}, limitPushdown={}, limitLevel={}, storageAggr={}", new Object[]{this.cubeInstance.getName(), cuboid.getId(), groupsD, filterColumnD, context.getFinalPushDownLimit(), context.getStorageLimitLevel(), context.isNeedStorageAggregation()});
        return new GTCubeStorageQueryRequest(cuboid, dimensionsD, groupsD, dynGroups, dynGroupExprs, filterColumnD, metrics, dynFuncs, filterD, havingFilter, context);
    }

    protected abstract String getGTStorage();

    protected Cuboid findCuboid(CubeInstance cubeInstance, Set<TblColRef> dimensionsD, Set<FunctionDesc> metrics) {
        return Cuboid.findCuboid(cubeInstance.getCuboidScheduler(), dimensionsD, metrics);
    }

    protected ITupleConverter newCubeTupleConverter(CubeSegment cubeSeg, Cuboid cuboid, Set<TblColRef> selectedDimensions, Set<FunctionDesc> selectedMetrics, int[] gtColIdx, TupleInfo tupleInfo) {
        return new CubeTupleConverter(cubeSeg, cuboid, selectedDimensions, selectedMetrics, gtColIdx, tupleInfo);
    }

    protected void buildDimensionsAndMetrics(SQLDigest sqlDigest, Collection<TblColRef> dimensions, Collection<FunctionDesc> metrics) {
        for (FunctionDesc func : sqlDigest.aggregations) {
            if (func.isDimensionAsMetric() || "GROUPING".equalsIgnoreCase(func.getExpression())) continue;
            metrics.add(this.findAggrFuncFromCubeDesc(func));
        }
        for (TblColRef column : sqlDigest.allColumns) {
            if ((sqlDigest.metricColumns.contains(column) || sqlDigest.rtMetricColumns.contains(column)) && !sqlDigest.groupbyColumns.contains(column) && !sqlDigest.filterColumns.contains(column) && !sqlDigest.rtDimensionColumns.contains(column)) continue;
            dimensions.add(column);
        }
    }

    private FunctionDesc findAggrFuncFromCubeDesc(FunctionDesc aggrFunc) {
        for (MeasureDesc measure : this.cubeDesc.getMeasures()) {
            if (!measure.getFunction().equals(aggrFunc)) continue;
            return measure.getFunction();
        }
        return aggrFunc;
    }

    protected Set<TblColRef> expandDerived(Collection<TblColRef> cols, Set<TblColRef> derivedPostAggregation) {
        HashSet<TblColRef> expanded = Sets.newHashSet();
        for (TblColRef col : cols) {
            if (this.cubeDesc.hasHostColumn(col)) {
                CubeDesc.DeriveInfo hostInfo = this.cubeDesc.getHostInfo(col);
                for (TblColRef hostCol : hostInfo.columns) {
                    expanded.add(hostCol);
                    if (hostInfo.isOneToOne) continue;
                    derivedPostAggregation.add(hostCol);
                }
                continue;
            }
            expanded.add(col);
        }
        return expanded;
    }

    protected Set<TblColRef> findSingleValueColumns(TupleFilter filter2) {
        Set<CompareTupleFilter> compareTupleFilterSet = this.findSingleValuesCompFilters(filter2);
        HashSet<TblColRef> resultD = Sets.newHashSet();
        for (CompareTupleFilter compFilter : compareTupleFilterSet) {
            TblColRef tblColRef = compFilter.getColumn();
            if (this.cubeDesc.isExtendedColumn(tblColRef)) {
                throw new CubeDesc.CannotFilterExtendedColumnException(tblColRef);
            }
            if (this.cubeDesc.isDerived(compFilter.getColumn())) {
                CubeDesc.DeriveInfo hostInfo = this.cubeDesc.getHostInfo(tblColRef);
                if (!hostInfo.isOneToOne) continue;
                resultD.addAll(Arrays.asList(hostInfo.columns));
                continue;
            }
            resultD.add(compFilter.getColumn());
        }
        return resultD;
    }

    protected Set<CompareTupleFilter> findSingleValuesCompFilters(TupleFilter filter2) {
        Collection<TupleFilter> toCheck;
        if (filter2 instanceof CompareTupleFilter) {
            toCheck = Collections.singleton(filter2);
        } else if (filter2 instanceof LogicalTupleFilter && filter2.getOperator() == TupleFilter.FilterOperatorEnum.AND) {
            toCheck = filter2.getChildren();
        } else {
            return Collections.emptySet();
        }
        HashSet<CompareTupleFilter> result = Sets.newHashSet();
        for (TupleFilter f : toCheck) {
            CompareTupleFilter compFilter;
            if (!(f instanceof CompareTupleFilter) || (compFilter = (CompareTupleFilter)f).getOperator() != TupleFilter.FilterOperatorEnum.EQ || compFilter.getValues().size() != 1 || compFilter.getColumn() == null) continue;
            result.add(compFilter);
        }
        return result;
    }

    private long getQueryFilterMask(Set<TblColRef> filterColumnD) {
        long filterMask = 0L;
        logger.info("Filter column set for query: {}", (Object)filterColumnD);
        if (!filterColumnD.isEmpty()) {
            RowKeyColDesc[] allColumns = this.cubeDesc.getRowkey().getRowKeyColumns();
            for (int i = 0; i < allColumns.length; ++i) {
                if (!filterColumnD.contains(allColumns[i].getColRef())) continue;
                filterMask |= 1L << allColumns[i].getBitIndex();
            }
        }
        logger.info("Filter mask is: {}", (Object)filterMask);
        return filterMask;
    }

    public boolean isNeedStorageAggregation(Cuboid cuboid, Collection<TblColRef> groupD, Collection<TblColRef> singleValueD) {
        HashSet<TblColRef> temp = Sets.newHashSet();
        temp.addAll(groupD);
        temp.addAll(singleValueD);
        if (cuboid.getColumns().size() == temp.size()) {
            logger.debug("Does not need storage aggregation");
            return false;
        }
        logger.debug("Need storage aggregation");
        return true;
    }

    protected TupleFilter translateDerived(TupleFilter filter2, Set<TblColRef> collector) {
        if (filter2 == null) {
            return filter2;
        }
        if (filter2 instanceof CompareTupleFilter) {
            return this.translateDerivedInCompare((CompareTupleFilter)filter2, collector);
        }
        List<? extends TupleFilter> children = filter2.getChildren();
        ArrayList<TupleFilter> newChildren = Lists.newArrayListWithCapacity(children.size());
        boolean modified = false;
        for (TupleFilter tupleFilter : children) {
            TupleFilter translated = this.translateDerived(tupleFilter, collector);
            newChildren.add(translated);
            if (tupleFilter == translated) continue;
            modified = true;
        }
        if (modified) {
            filter2 = this.replaceChildren(filter2, newChildren);
        }
        return filter2;
    }

    private TupleFilter replaceChildren(TupleFilter filter2, List<TupleFilter> newChildren) {
        if (filter2 instanceof LogicalTupleFilter) {
            LogicalTupleFilter r = new LogicalTupleFilter(filter2.getOperator());
            r.addChildren(newChildren);
            return r;
        }
        if (filter2 instanceof CaseTupleFilter) {
            CaseTupleFilter r = new CaseTupleFilter();
            r.addChildren(newChildren);
            return r;
        }
        throw new IllegalStateException("Cannot replaceChildren on " + filter2);
    }

    private TupleFilter translateDerivedInCompare(CompareTupleFilter compf, Set<TblColRef> collector) {
        if (compf.getColumn() == null) {
            return compf;
        }
        TblColRef derived = compf.getColumn();
        if (this.cubeDesc.isExtendedColumn(derived)) {
            throw new CubeDesc.CannotFilterExtendedColumnException(derived);
        }
        if (!this.cubeDesc.isDerived(derived)) {
            return compf;
        }
        CubeDesc.DeriveInfo hostInfo = this.cubeDesc.getHostInfo(derived);
        Pair<TupleFilter, Boolean> translated = DerivedFilterTranslator.translate(hostInfo, compf);
        TupleFilter translatedFilter = translated.getFirst();
        boolean loosened = translated.getSecond();
        if (loosened) {
            this.collectColumnsRecursively(translatedFilter, collector);
        }
        return translatedFilter;
    }

    private void collectColumnsRecursively(TupleFilter filter2, Set<TblColRef> collector) {
        if (filter2 == null) {
            return;
        }
        if (filter2 instanceof ColumnTupleFilter) {
            collector.add(((ColumnTupleFilter)filter2).getColumn());
        }
        for (TupleFilter tupleFilter : filter2.getChildren()) {
            this.collectColumnsRecursively(tupleFilter, collector);
        }
    }

    private void enableStorageLimitIfPossible(Cuboid cuboid, Collection<TblColRef> groups, List<TblColRef> dynGroups, Set<TblColRef> derivedPostAggregation, Collection<TblColRef> groupsD, TupleFilter filter2, Set<TblColRef> loosenedColumnD, SQLDigest sqlDigest, StorageContext context) {
        List<FunctionDesc> functionDescs = sqlDigest.aggregations;
        StorageLimitLevel storageLimitLevel = StorageLimitLevel.LIMIT_ON_SCAN;
        int size = groupsD.size();
        if (!groupsD.containsAll(cuboid.getColumns().subList(0, size))) {
            storageLimitLevel = StorageLimitLevel.LIMIT_ON_RETURN_SIZE;
            logger.debug("storageLimitLevel set to LIMIT_ON_RETURN_SIZE because groupD is not clustered at head, groupsD: {} with cuboid columns: {}", (Object)groupsD, (Object)cuboid.getColumns());
        }
        if (!dynGroups.isEmpty()) {
            storageLimitLevel = StorageLimitLevel.NO_LIMIT;
            logger.debug("Storage limit push down is impossible because the query has dynamic groupby {}", (Object)dynGroups);
        }
        if (!groups.containsAll(derivedPostAggregation)) {
            storageLimitLevel = StorageLimitLevel.NO_LIMIT;
            logger.debug("storageLimitLevel set to NO_LIMIT because derived column require post aggregation: {}", (Object)derivedPostAggregation);
        }
        if (!TupleFilter.isEvaluableRecursively(filter2)) {
            storageLimitLevel = StorageLimitLevel.NO_LIMIT;
            logger.debug("storageLimitLevel set to NO_LIMIT because the filter isn't evaluable");
        }
        if (!loosenedColumnD.isEmpty()) {
            storageLimitLevel = StorageLimitLevel.NO_LIMIT;
            logger.debug("storageLimitLevel set to NO_LIMIT because filter is loosened: {}", (Object)loosenedColumnD);
        }
        if (context.hasSort()) {
            storageLimitLevel = StorageLimitLevel.NO_LIMIT;
            logger.debug("storageLimitLevel set to NO_LIMIT because the query has order by");
        }
        for (FunctionDesc functionDesc : functionDescs) {
            if (!functionDesc.isDimensionAsMetric()) continue;
            storageLimitLevel = StorageLimitLevel.NO_LIMIT;
            logger.debug("storageLimitLevel set to NO_LIMIT because {} isDimensionAsMetric ", (Object)functionDesc);
        }
        if (sqlDigest.groupByExpression) {
            storageLimitLevel = StorageLimitLevel.NO_LIMIT;
            logger.debug("storageLimitLevel set to NO_LIMIT because group by clause is an expression");
        }
        context.applyLimitPushDown(this.cubeInstance, storageLimitLevel);
    }

    private void enableStreamAggregateIfBeneficial(Cuboid cuboid, Set<TblColRef> groupsD, StorageContext context) {
        CubeDesc cubeDesc = cuboid.getCubeDesc();
        boolean enabled = cubeDesc.getConfig().isStreamAggregateEnabled();
        HashSet<TblColRef> shardByInGroups = Sets.newHashSet();
        for (TblColRef col : cubeDesc.getShardByColumns()) {
            if (!groupsD.contains(col)) continue;
            shardByInGroups.add(col);
        }
        if (!shardByInGroups.isEmpty()) {
            enabled = false;
            logger.debug("Aggregate partition results is not beneficial because shard by columns in groupD: {}", (Object)shardByInGroups);
        }
        if (!context.isNeedStorageAggregation()) {
            enabled = false;
            logger.debug("Aggregate partition results is not beneficial because no storage aggregation");
        }
        if (enabled) {
            context.enableStreamAggregate();
        }
    }

    protected void notifyBeforeStorageQuery(SQLDigest sqlDigest) {
        HashMap<String, ArrayList<MeasureDesc>> map = Maps.newHashMap();
        for (MeasureDesc measure : this.cubeDesc.getMeasures()) {
            MeasureType<?> measureType = measure.getFunction().getMeasureType();
            String key = measureType.getClass().getCanonicalName();
            List temp = null;
            temp = (List)map.get(key);
            if (temp != null) {
                temp.add(measure);
                continue;
            }
            map.put(key, Lists.newArrayList(measure));
        }
        for (List sublist : map.values()) {
            ((MeasureDesc)sublist.get(0)).getFunction().getMeasureType().adjustSqlDigest(sublist, sqlDigest);
        }
    }

    private TupleFilter checkHavingCanPushDown(TupleFilter havingFilter, Set<TblColRef> groupsD, List<FunctionDesc> aggregations, Set<FunctionDesc> metrics) {
        Segments<CubeSegment> readySegs = this.cubeInstance.getSegments(SegmentStatusEnum.READY);
        if (readySegs.size() != 1) {
            logger.info("Can not push down having filter, must have only one segment");
            return null;
        }
        CubeDesc desc = this.cubeInstance.getDescriptor();
        Set<TblColRef> shardBy = desc.getShardByColumns();
        if (groupsD == null || shardBy.isEmpty() || !groupsD.containsAll(shardBy)) {
            return null;
        }
        logger.info("Push down having filter {}", (Object)havingFilter);
        HashSet<TblColRef> aggrOutCols = new HashSet<TblColRef>();
        TupleFilter.collectColumns(havingFilter, aggrOutCols);
        for (TblColRef aggrOutCol : aggrOutCols) {
            int aggrIdxOnSql = aggrOutCol.getColumnDesc().getZeroBasedIndex();
            FunctionDesc aggrFunc = aggregations.get(aggrIdxOnSql);
            int aggrIdxAmongMetrics = 0;
            for (MeasureDesc m : this.cubeDesc.getMeasures()) {
                if (aggrFunc.equals(m.getFunction())) break;
                if (!metrics.contains(m.getFunction())) continue;
                ++aggrIdxAmongMetrics;
            }
            aggrOutCol.getColumnDesc().setId("" + (aggrIdxAmongMetrics + 1));
        }
        return havingFilter;
    }

    private boolean isExactAggregation(StorageContext context, Cuboid cuboid, Collection<TblColRef> groups, Set<TblColRef> othersD, Set<TblColRef> singleValuesD, Set<TblColRef> derivedPostAggregation, Collection<FunctionDesc> functionDescs, List<SQLDigest.SQLCall> aggrSQLCalls, boolean groupByExpression) {
        TblColRef col;
        if (context.isNeedStorageAggregation()) {
            logger.info("exactAggregation is false because need storage aggregation");
            return false;
        }
        if (cuboid.requirePostAggregation()) {
            logger.info("exactAggregation is false because cuboid {}=>{}", (Object)cuboid.getInputID(), (Object)cuboid.getId());
            return false;
        }
        if (!groups.containsAll(derivedPostAggregation)) {
            logger.info("exactAggregation is false because derived column require post aggregation: {}", (Object)derivedPostAggregation);
            return false;
        }
        if (!singleValuesD.containsAll(othersD)) {
            logger.info("exactAggregation is false because some column not on group by: {} (single value column: {})", (Object)othersD, (Object)singleValuesD);
            return false;
        }
        for (FunctionDesc functionDesc : functionDescs) {
            if (!functionDesc.isDimensionAsMetric()) continue;
            logger.info("exactAggregation is false because has DimensionAsMetric");
            return false;
        }
        for (SQLDigest.SQLCall aggrSQLCall : aggrSQLCalls) {
            if (!aggrSQLCall.function.equals("INTERSECT_COUNT") && !aggrSQLCall.function.equals("INTERSECT_VALUE")) continue;
            logger.info("exactAggregation is false because has INTERSECT_COUNT OR INTERSECT_VALUE");
            return false;
        }
        PartitionDesc partDesc = cuboid.getCubeDesc().getModel().getPartitionDesc();
        if (partDesc.isPartitioned() && !groups.contains(col = partDesc.getPartitionDateColumnRef()) && !singleValuesD.contains(col)) {
            logger.info("exactAggregation is false because cube is partitioned and {} is not on group by", (Object)col);
            return false;
        }
        if (groupByExpression) {
            logger.info("exactAggregation is false because group by expression");
            return false;
        }
        logger.info("exactAggregation is true, cuboid id is {}", (Object)cuboid.getId());
        return true;
    }
}

