/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc;

import java.io.IOException;
import java.util.Locale;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.job.common.PatternedLogger;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmdStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(CmdStep.class);
    private final PatternedLogger stepLogger = new PatternedLogger(logger);

    public void setCmd(String cmd) {
        this.setParam("cmd", cmd);
    }

    protected void sqoopFlatHiveTable(KylinConfig config) throws IOException {
        String cmd = this.getParam("cmd");
        this.stepLogger.log(String.format(Locale.ROOT, "exe cmd:%s", cmd));
        Pair<Integer, String> response = config.getCliCommandExecutor().execute(cmd, this.stepLogger, null);
        this.getManager().addJobInfo(this.getId(), this.stepLogger.getInfo());
        if (response.getFirst() != 0) {
            throw new RuntimeException("Failed to create flat hive table, error code " + response.getFirst());
        }
    }

    @Override
    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        try {
            this.sqoopFlatHiveTable(config);
            return new ExecuteResult(ExecuteResult.State.SUCCEED, this.stepLogger.getBufferedLog());
        }
        catch (Exception e) {
            logger.error("job:" + this.getId() + " execute finished with exception", e);
            return new ExecuteResult(ExecuteResult.State.ERROR, this.stepLogger.getBufferedLog(), e);
        }
    }
}

