/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.job.common.PatternedLogger;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.shaded.com.google.common.collect.ImmutableList;
import org.apache.kylin.source.hive.HiveClientFactory;
import org.apache.kylin.source.hive.IHiveClient;
import org.apache.kylin.source.hive.MRHiveDictUtil;

public class RedistributeFlatHiveTableByLivyStep
extends AbstractExecutable {
    private final PatternedLogger stepLogger = new PatternedLogger(logger);

    private long computeRowCount(String database, String table) throws Exception {
        IHiveClient hiveClient = HiveClientFactory.getHiveClient();
        return hiveClient.getHiveTableRows(database, table);
    }

    private long getDataSize(String database, String table) throws Exception {
        IHiveClient hiveClient = HiveClientFactory.getHiveClient();
        long size = hiveClient.getHiveTableMeta((String)database, (String)table).fileSize;
        return size;
    }

    private void redistributeTable(KylinConfig config, int numReducers) throws Exception {
        StringBuffer statement = new StringBuffer();
        statement.append(this.getInitStatement());
        statement.append("set mapreduce.job.reduces=" + numReducers + ";\n");
        statement.append("set hive.merge.mapredfiles=false;\n");
        statement.append(this.getRedistributeDataStatement());
        this.stepLogger.log("Redistribute table, cmd: ");
        this.stepLogger.log(statement.toString());
        MRHiveDictUtil.runLivySqlJob(this.stepLogger, config, ImmutableList.of(statement.toString()), this.getManager(), this.getId());
    }

    @Override
    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        String tableName;
        String database;
        KylinConfig config = this.getCubeSpecificConfig();
        String intermediateTable = this.getIntermediateTable();
        if (intermediateTable.indexOf(".") > 0) {
            database = intermediateTable.substring(0, intermediateTable.indexOf("."));
            tableName = intermediateTable.substring(intermediateTable.indexOf(".") + 1);
        } else {
            database = config.getHiveDatabaseForIntermediateTable();
            tableName = intermediateTable;
        }
        try {
            long rowCount = this.computeRowCount(database, tableName);
            logger.debug("Row count of table '" + intermediateTable + "' is " + rowCount);
            if (rowCount == 0L) {
                if (!config.isEmptySegmentAllowed()) {
                    this.stepLogger.log("Detect upstream hive table is empty, fail the job because \"kylin.job.allow-empty-segment\" = \"false\"");
                    return new ExecuteResult(ExecuteResult.State.ERROR, this.stepLogger.getBufferedLog());
                }
                return new ExecuteResult(ExecuteResult.State.SUCCEED, "Row count is 0, no need to redistribute");
            }
            int mapperInputRows = config.getHadoopJobMapperInputRows();
            int numReducers = Math.round((float)rowCount / (float)mapperInputRows);
            numReducers = Math.max(1, numReducers);
            numReducers = Math.min(numReducers, config.getHadoopJobMaxReducerNumber());
            this.stepLogger.log("total input rows = " + rowCount);
            this.stepLogger.log("expected input rows per mapper = " + mapperInputRows);
            this.stepLogger.log("num reducers for RedistributeFlatHiveTableStep = " + numReducers);
            this.redistributeTable(config, numReducers);
            long dataSize = this.getDataSize(database, tableName);
            this.getManager().addJobInfo(this.getId(), "hdfs_bytes_written", "" + dataSize);
            return new ExecuteResult(ExecuteResult.State.SUCCEED, this.stepLogger.getBufferedLog());
        }
        catch (Exception e) {
            logger.error("job:" + this.getId() + " execute finished with exception", e);
            return new ExecuteResult(ExecuteResult.State.ERROR, this.stepLogger.getBufferedLog(), e);
        }
    }

    public void setInitStatement(String sql2) {
        this.setParam("HiveInit", sql2);
    }

    public String getInitStatement() {
        return this.getParam("HiveInit");
    }

    public void setRedistributeDataStatement(String sql2) {
        this.setParam("HiveRedistributeData", sql2);
    }

    public String getRedistributeDataStatement() {
        return this.getParam("HiveRedistributeData");
    }

    public String getIntermediateTable() {
        return this.getParam("intermediateTable");
    }

    public void setIntermediateTable(String intermediateTable) {
        this.setParam("intermediateTable", intermediateTable);
    }
}

