/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.lock.DistributedLock;
import org.apache.kylin.common.util.HiveCmdBuilder;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.common.PatternedLogger;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.shaded.com.google.common.base.Strings;
import org.apache.kylin.shaded.com.google.common.collect.ImmutableList;
import org.apache.kylin.source.hive.HiveClientFactory;
import org.apache.kylin.source.hive.IHiveClient;
import org.apache.kylin.source.hive.MRHiveDictUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateMrHiveDictStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(CreateMrHiveDictStep.class);
    private final PatternedLogger stepLogger = new PatternedLogger(logger);
    private DistributedLock lock = KylinConfig.getInstanceFromEnv().getDistributedLockFactory().lockForCurrentThread();
    private static final String GET_SQL = "\" Get Max Dict Value Sql : \"";

    protected void createMrHiveDict(KylinConfig config) throws Exception {
        try {
            if (this.getIsLock()) {
                String pathName = this.getLockPathName();
                if (Strings.isNullOrEmpty(pathName)) {
                    throw new IllegalArgumentException("create Mr-Hive dict lock path name is null");
                }
                String lockPath = this.getLockPath(pathName);
                boolean isLocked = true;
                long lockStartTime = System.currentTimeMillis();
                while (isLocked) {
                    isLocked = this.lock.isLocked(lockPath);
                    this.stepLogger.log("zookeeper lock path :" + lockPath + ", result is " + isLocked);
                    if (!isLocked) break;
                    Thread.sleep(60000L);
                }
                this.stepLogger.log("zookeeper get lock costTime : " + (System.currentTimeMillis() - lockStartTime) / 1000L + " s");
                this.lock.lock(lockPath);
            }
            HiveCmdBuilder hiveCmdBuilder = new HiveCmdBuilder(this.getName());
            hiveCmdBuilder.overwriteHiveProps(config.getHiveConfigOverride());
            hiveCmdBuilder.addStatement(this.getInitStatement());
            String sql2 = this.getCreateTableStatement();
            if (sql2 != null && sql2.length() > 0) {
                hiveCmdBuilder.addStatement(sql2);
            }
            Map<String, String> maxDictValMap = CreateMrHiveDictStep.deserilizeForMap(this.getMaxDictStatementMap());
            Map<String, String> dictSqlMap = CreateMrHiveDictStep.deserilizeForMap(this.getCreateTableStatementMap());
            if (dictSqlMap != null && dictSqlMap.size() > 0) {
                IHiveClient hiveClient = HiveClientFactory.getHiveClient();
                if (maxDictValMap != null && maxDictValMap.size() > 0) {
                    if (maxDictValMap.size() == dictSqlMap.size()) {
                        maxDictValMap.forEach((columnName, maxDictValSql) -> {
                            int max = 0;
                            List<Object[]> datas = null;
                            try {
                                datas = hiveClient.getHiveResult((String)maxDictValSql);
                                if (!Objects.nonNull(datas) || datas.isEmpty()) {
                                    this.stepLogger.log(columnName + GET_SQL + maxDictValSql);
                                    this.stepLogger.log(columnName + " Get Max Dict Value Of ERROR: hive execute result is null.");
                                    throw new IOException("execute get max dict result fail : " + maxDictValSql);
                                }
                                max = Integer.valueOf(datas.get(0)[0] + "");
                                this.stepLogger.log(columnName + GET_SQL + maxDictValSql);
                                this.stepLogger.log(columnName + " Get Max Dict Value Of : " + max);
                            }
                            catch (Exception e) {
                                this.stepLogger.log(columnName + GET_SQL + maxDictValSql);
                                this.stepLogger.log(columnName + " Get Max Dict Value Of ERROR :" + e.getMessage());
                                logger.error("execute get max dict result fail : " + maxDictValSql, e);
                            }
                            String dictSql = ((String)dictSqlMap.get(columnName)).replace("___maxDictVal___", max + "");
                            hiveCmdBuilder.addStatement(dictSql);
                        });
                    } else {
                        logger.error("Max Dict Value size is not equals Dict Sql size ! ");
                    }
                } else {
                    dictSqlMap.forEach((columnName, dictSql) -> hiveCmdBuilder.addStatement((String)dictSql));
                }
            }
            String cmd = hiveCmdBuilder.toString();
            this.stepLogger.log("MR-Hive dict, cmd: " + cmd);
            CubeManager manager = CubeManager.getInstance(KylinConfig.getInstanceFromEnv());
            CubeInstance cube = manager.getCube(this.getCubeName());
            if (config.isLivyEnabled() && cube.getEngineType() == 4) {
                MRHiveDictUtil.runLivySqlJob(this.stepLogger, config, ImmutableList.copyOf(hiveCmdBuilder.getStatements()), this.getManager(), this.getId());
            } else {
                Pair<Integer, String> response = config.getCliCommandExecutor().execute(cmd, this.stepLogger, null);
                if (response.getFirst() != 0) {
                    throw new RuntimeException("Failed to create mr hive dict, error code " + response.getFirst());
                }
                this.getManager().addJobInfo(this.getId(), this.stepLogger.getInfo());
            }
            if (this.getIsLock()) {
                String pathName = this.getLockPathName();
                if (Strings.isNullOrEmpty(pathName)) {
                    throw new IllegalArgumentException(" create mr hive dict unlock path name is null");
                }
                this.lock.unlock(this.getLockPath(pathName));
                this.stepLogger.log("zookeeper unlock path :" + this.getLockPathName());
            }
        }
        catch (Exception e) {
            if (this.getIsLock()) {
                this.lock.unlock(this.getLockPath(this.getLockPathName()));
                this.stepLogger.log("zookeeper unlock path :" + this.getLockPathName());
            }
            logger.error("", e);
            throw e;
        }
    }

    @Override
    public KylinConfig getCubeSpecificConfig() {
        String cubeName = CubingExecutableUtil.getCubeName(this.getParams());
        CubeManager manager = CubeManager.getInstance(KylinConfig.getInstanceFromEnv());
        CubeInstance cube = manager.getCube(cubeName);
        return cube.getConfig();
    }

    @Override
    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        KylinConfig config = this.getCubeSpecificConfig();
        try {
            String preHdfsShell = this.getPreHdfsShell();
            if (Objects.nonNull(preHdfsShell) && !"".equalsIgnoreCase(preHdfsShell)) {
                this.doRetry(preHdfsShell, config);
            }
            this.createMrHiveDict(config);
            String postfixHdfsCmd = this.getPostfixHdfsShell();
            if (Objects.nonNull(postfixHdfsCmd) && !"".equalsIgnoreCase(postfixHdfsCmd)) {
                this.doRetry(postfixHdfsCmd, config);
            }
            return new ExecuteResult(ExecuteResult.State.SUCCEED, this.stepLogger.getBufferedLog());
        }
        catch (Exception e) {
            logger.error("job:" + this.getId() + " execute finished with exception", e);
            return new ExecuteResult(ExecuteResult.State.ERROR, this.stepLogger.getBufferedLog());
        }
    }

    private void doRetry(String cmd, KylinConfig config) throws Exception {
        if (Objects.nonNull(cmd)) {
            this.stepLogger.log("cmd : " + cmd);
            int currTimes = 0;
            int maxTimes = 360;
            boolean flag = true;
            while (flag && currTimes <= maxTimes) {
                try {
                    Pair<Integer, String> result = config.getCliCommandExecutor().execute(cmd, this.stepLogger, null);
                    this.stepLogger.log(result.toString());
                    flag = false;
                }
                catch (Exception e) {
                    this.stepLogger.log("execute : " + cmd + " Failed && And errLog is " + e.getMessage());
                    Thread.sleep(60000L);
                    currTimes += 60;
                }
            }
        }
    }

    public void setInitStatement(String sql2) {
        this.setParam("HiveInit", sql2);
    }

    public String getInitStatement() {
        return this.getParam("HiveInit");
    }

    public void setCreateTableStatement(String sql2) {
        this.setParam("HiveRedistributeData", sql2);
    }

    public String getCreateTableStatement() {
        return this.getParam("HiveRedistributeData");
    }

    public void setCreateTableStatementMap(Map<String, String> dictSqlMap) {
        this.setParam("HiveRedistributeDataMap", CreateMrHiveDictStep.serilizeToMap(dictSqlMap));
    }

    public String getCreateTableStatementMap() {
        return this.getParam("HiveRedistributeDataMap");
    }

    public void setMaxDictStatementMap(Map<String, String> maxDictValMap) {
        this.setParam("DictMaxMap", CreateMrHiveDictStep.serilizeToMap(maxDictValMap));
    }

    public String getMaxDictStatementMap() {
        return this.getParam("DictMaxMap");
    }

    public String getPreHdfsShell() {
        return this.getParam("preHdfsCmd");
    }

    public void setPrefixHdfsShell(String cmd) {
        this.setParam("preHdfsCmd", cmd);
    }

    public String getPostfixHdfsShell() {
        return this.getParam("postfixHdfsCmd");
    }

    public void setPostfixHdfsShell(String cmd) {
        this.setParam("postfixHdfsCmd", cmd);
    }

    public void setIsLock(Boolean isLock) {
        this.setParam("isLock", String.valueOf(isLock));
    }

    public boolean getIsLock() {
        String isLock = this.getParam("isLock");
        return Strings.isNullOrEmpty(isLock) ? false : Boolean.parseBoolean(isLock);
    }

    public void setIsUnLock(Boolean isUnLock) {
        this.setParam("isUnLock", String.valueOf(isUnLock));
    }

    public boolean getIsUnlock() {
        String isUnLock = this.getParam("isUnLock");
        return Strings.isNullOrEmpty(isUnLock) ? false : Boolean.parseBoolean(isUnLock);
    }

    public void setLockPathName(String pathName) {
        this.setParam("lockPathName", pathName);
    }

    public String getLockPathName() {
        return this.getParam("lockPathName");
    }

    private static String serilizeToMap(Map<String, String> map) {
        JSONArray result = new JSONArray();
        if (map != null && map.size() > 0) {
            map.forEach((key, value) -> {
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put(key, value);
                }
                catch (JSONException e) {
                    logger.error("Json Error", e);
                }
                result.put((Object)jsonObject);
            });
        }
        return result.toString();
    }

    private static Map<String, String> deserilizeForMap(String mapStr) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (mapStr != null) {
            try {
                JSONArray jsonArray2 = new JSONArray(mapStr);
                int size = jsonArray2.length();
                for (int i = 0; i < size; ++i) {
                    JSONObject jsonObject = jsonArray2.getJSONObject(i);
                    Iterator iterator = jsonObject.keys();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        String value = jsonObject.getString(key);
                        result.put(key, value);
                    }
                }
            }
            catch (JSONException e) {
                logger.error("Json Error", e);
            }
        }
        return result;
    }

    private String getLockPath(String pathName) {
        return MRHiveDictUtil.DictHiveType.MrDictLockPath.getName() + pathName;
    }
}

