/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HiveCmdBuilder;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.source.hive.HiveMetaStoreClientFactory;
import org.apache.kylin.source.hive.HiveTableMeta;
import org.apache.kylin.source.hive.HiveTableMetaBuilder;
import org.apache.kylin.source.hive.IHiveClient;

public class CLIHiveClient
implements IHiveClient {
    protected HiveConf hiveConf = new HiveConf(CLIHiveClient.class);
    protected IMetaStoreClient metaStoreClient = null;

    @Override
    public void executeHQL(String hql) throws IOException {
        HiveCmdBuilder hiveCmdBuilder = new HiveCmdBuilder();
        hiveCmdBuilder.addStatement(hql);
        Pair<Integer, String> response = KylinConfig.getInstanceFromEnv().getCliCommandExecutor().execute(hiveCmdBuilder.toString());
        if (response.getFirst() != 0) {
            throw new IllegalArgumentException("Failed to execute hql [" + hql + "], error message is: " + response.getSecond());
        }
    }

    @Override
    public void executeHQL(String[] hqls) throws IOException {
        for (String sql2 : hqls) {
            this.executeHQL(sql2);
        }
    }

    @Override
    public HiveTableMeta getHiveTableMeta(String database, String tableName) throws Exception {
        HiveTableMetaBuilder builder = new HiveTableMetaBuilder();
        org.apache.hadoop.hive.metastore.api.Table table = this.getMetaStoreClient().getTable(database, tableName);
        ArrayList<FieldSchema> allFields = this.getMetaStoreClient().getFields(database, tableName);
        List partitionFields = table.getPartitionKeys();
        if (allFields == null) {
            allFields = Lists.newArrayList();
        }
        if (partitionFields != null && partitionFields.size() > 0) {
            allFields.addAll(partitionFields);
        }
        ArrayList<HiveTableMeta.HiveTableColumnMeta> allColumns = Lists.newArrayList();
        ArrayList<HiveTableMeta.HiveTableColumnMeta> partitionColumns = Lists.newArrayList();
        for (FieldSchema fieldSchema : allFields) {
            allColumns.add(new HiveTableMeta.HiveTableColumnMeta(fieldSchema.getName(), fieldSchema.getType(), fieldSchema.getComment()));
        }
        if (partitionFields != null && partitionFields.size() > 0) {
            for (FieldSchema fieldSchema : partitionFields) {
                partitionColumns.add(new HiveTableMeta.HiveTableColumnMeta(fieldSchema.getName(), fieldSchema.getType(), fieldSchema.getComment()));
            }
        }
        builder.setAllColumns(allColumns);
        builder.setPartitionColumns(partitionColumns);
        builder.setSdLocation(table.getSd().getLocation());
        builder.setFileSize(this.getBasicStatForTable(new Table(table), "totalSize"));
        builder.setFileNum(this.getBasicStatForTable(new Table(table), "numFiles"));
        builder.setIsNative(!MetaStoreUtils.isNonNativeTable((org.apache.hadoop.hive.metastore.api.Table)table));
        builder.setTableName(tableName);
        builder.setSdInputFormat(table.getSd().getInputFormat());
        builder.setSdOutputFormat(table.getSd().getOutputFormat());
        builder.setOwner(table.getOwner());
        builder.setLastAccessTime(table.getLastAccessTime());
        builder.setTableType(table.getTableType());
        builder.setSkipHeaderLineCount((String)table.getParameters().get("skip.header.line.count"));
        return builder.createHiveTableMeta();
    }

    @Override
    public List<String> getHiveDbNames() throws Exception {
        return this.getMetaStoreClient().getAllDatabases();
    }

    @Override
    public List<String> getHiveTableNames(String database) throws Exception {
        return this.getMetaStoreClient().getAllTables(database);
    }

    @Override
    public long getHiveTableRows(String database, String tableName) throws Exception {
        org.apache.hadoop.hive.metastore.api.Table table = this.getMetaStoreClient().getTable(database, tableName);
        return this.getBasicStatForTable(new Table(table), "numRows");
    }

    @Override
    public List<Object[]> getHiveResult(String hql) throws Exception {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        HiveCmdBuilder hiveCmdBuilder = new HiveCmdBuilder();
        hiveCmdBuilder.addStatement(hql);
        Pair<Integer, String> response = KylinConfig.getInstanceFromEnv().getCliCommandExecutor().execute(hiveCmdBuilder.toString());
        String[] respData = response.getSecond().split("\n");
        boolean isData = false;
        for (String item : respData) {
            if (item.trim().equalsIgnoreCase("OK")) {
                isData = true;
                continue;
            }
            if (item.trim().startsWith("Time taken")) {
                isData = false;
            }
            if (!isData) continue;
            String[] arr = item.split("\t");
            data.add(arr);
        }
        return data;
    }

    private IMetaStoreClient getMetaStoreClient() throws Exception {
        if (this.metaStoreClient == null) {
            this.metaStoreClient = HiveMetaStoreClientFactory.getHiveMetaStoreClient(this.hiveConf);
        }
        return this.metaStoreClient;
    }

    private long getBasicStatForTable(Table table, String statType) {
        Map params = table.getParameters();
        long result = 0L;
        if (params != null) {
            try {
                result = Long.parseLong((String)params.get(statType));
            }
            catch (NumberFormatException e) {
                result = 0L;
            }
        }
        return result;
    }
}

