/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.adhocquery;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.source.adhocquery.IPushDownConverter;
import org.apache.kylin.source.adhocquery.IPushDownRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPushdownRunner
implements IPushDownRunner {
    public static final Logger logger = LoggerFactory.getLogger(AbstractPushdownRunner.class);

    @Override
    public String convertSql(KylinConfig kylinConfig, String sql2, String project, String defaultSchema, boolean isPrepare) {
        String converted = sql2;
        for (String converterName : kylinConfig.getPushDownConverterClassNames()) {
            IPushDownConverter converter = (IPushDownConverter)ClassUtil.newInstance(converterName);
            String tmp = converter.convert(converted, project, defaultSchema, isPrepare);
            if (!converted.equals(tmp)) {
                logger.info("the query is converted to {} after applying converter {}", (Object)tmp, (Object)converterName);
            }
            converted = tmp;
        }
        return converted;
    }
}

